﻿Imports System.Data
Imports SP_NameSpace
Imports System.IO
Imports System.Data.SqlClient

Partial Class AR_Acquisti
    Inherits System.Web.UI.Page
    Private oConn As New SqlClient.SqlConnection(ConfigurationManager.ConnectionStrings("db_ncbConnectionString").ConnectionString)
    Public varAbilita As Boolean = True
    '*****************************************************************************************
    'INIZIO CODICE PER FINESTRA MODALE
    '*****************************************************************************************

    Public ClassTitoloModal As String = "modal-header alert alert-success"
    Public Sub showModal(ByVal Classe As String, ByVal corpo As String)
        Select Case Classe
            Case "SALVA"
                ClassTitoloModal = "modal-header alert alert-success"
                lblTitoloModale.Text = "SALVA"
            Case "ATTENZIONE"
                ClassTitoloModal = "modal-header alert alert-danger"
                lblTitoloModale.Text = "ATTENZIONE"
            Case "INFORMAZIONE"
                ClassTitoloModal = "modal-header alert alert-info"
                lblTitoloModale.Text = "INFORMAZIONE"
            Case "ERRORE"
                ClassTitoloModal = "modal-header alert alert-warning"
                lblTitoloModale.Text = "ERRORE"
        End Select

        lblCorpoModale.Text = corpo
        ScriptManager.RegisterStartupScript(Me.Page, Page.GetType, "HideLoginDialog", "<script type=""text/javascript"">$(document).ready(function () { $('#myMessage').modal('show');});</script>", False)
    End Sub

    Protected Sub btnCloseModal_Click(sender As Object, e As EventArgs)
        ScriptManager.RegisterStartupScript(Page, Page.[GetType](), "myModalHide", "$('#myMessage').hide();", True)
        ScriptManager.RegisterStartupScript(Page, Page.[GetType](), "myModalAgainShow", "$('#myMessage').modal();", True)
    End Sub
    '*****************************************************************************************
    'FINE CODICE PER FINESTRA MODALE
    '****************************************************************************************

    ' Popola Ricerca Intestazione
    <System.Web.Script.Services.ScriptMethod(), _
   System.Web.Services.WebMethod()> _
    Public Shared Function SearchEmployees(ByVal prefixText As String, ByVal count As Integer) As List(Of String)
        Dim conn As SqlConnection = New SqlConnection
        conn.ConnectionString = ConfigurationManager.ConnectionStrings("db_ncbConnectionString").ConnectionString
        Dim cmd As SqlCommand = New SqlCommand
        cmd.CommandText = "select idAnagrafica, Denominazione, TipoAnagrafica from " & _
        " Anagrafica where TipoAnagrafica='FORNITORE' and Denominazione like @SearchText + '%'"
        cmd.Parameters.AddWithValue("@SearchText", prefixText)
        cmd.Connection = conn
        conn.Open()
        Dim employees As List(Of String) = New List(Of String)
        Dim sdr As SqlDataReader = cmd.ExecuteReader
        While sdr.Read
            'employees.Add(AjaxControlToolkit.AutoCompleteExtender _
            '.CreateAutoCompleteItem(String.Format("{0} {1}", _
            ' sdr("Denominazione"), sdr("TipoAnagrafica")), sdr("idAnagrafica").ToString()))
            employees.Add(AjaxControlToolkit.AutoCompleteExtender.CreateAutoCompleteItem(String.Format("{0} ", sdr("Denominazione")), sdr("idAnagrafica").ToString()))
        End While
        conn.Close()
        Return employees
    End Function

    Protected Sub btnRicercaIntestazione(sender As Object, e As EventArgs)
        Dim conn As SqlConnection = New SqlConnection
        conn.ConnectionString = ConfigurationManager.ConnectionStrings("db_ncbConnectionString").ConnectionString
        Dim cmd As SqlCommand = New SqlCommand
        cmd.CommandText = "select idAnagrafica, Denominazione, Indirizzo, Citta, Cap, Provincia, PartitaIva, CodiceFiscale, Email  from " & _
        " Anagrafica where idAnagrafica = @IdAnagrafica"
        cmd.Parameters.AddWithValue("@IdAnagrafica", hdfIdCliente.Value)
        cmd.Connection = conn
        conn.Open()
        Dim employees As List(Of String) = New List(Of String)
        Dim sdr As SqlDataReader = cmd.ExecuteReader
        While sdr.Read
            txtRagioneSociale.Text = sdr("Denominazione")
            TxtIndirizzo.Text = sdr("Indirizzo") & vbCrLf & sdr("Cap") & " " & sdr("Citta") & " " & sdr("Provincia")
            txtPartitaIva.Text = sdr("PartitaIva")
            txtCodiceFiscale.Text = sdr("CodiceFiscale")
            txtWeb.Text = sdr("Email")
        End While
        conn.Close()
    End Sub




    Private Sub TitoloSezione(ByRef Titolo As String)
        Dim varTitoloezione As Label = DirectCast(Master.FindControl("lblTitoloSezione"), Label)
        varTitoloezione.Text = Titolo
    End Sub

    Private Sub CambiaTitoloMasterPage(ByVal Testo As String)
        DirectCast(Master.FindControl("lblTitoloSezione"), Label).Text = Testo
    End Sub

    Public Sub OpenModal(ByVal NomeDivModale As String)
        ScriptManager.RegisterStartupScript(Me.Page, Page.GetType, "HideLoginDialog", "<script type=""text/javascript"">$(document).ready(function () { $('#" & NomeDivModale & "').modal('show');});</script>", False)
    End Sub

    Protected Sub Page_Load(sender As Object, e As EventArgs) Handles Me.Load
        ConfigurationManager.AppSettings("ColoraIconaControllo") = "'icoAcquisti'"
        If Not IsPostBack Then
            Session("IDTabella") = 0
            Session("uploadTabella") = "tabAcquisti"
            CambiaTitoloMasterPage("ACQUISTI")

            mView.ActiveViewIndex = 0
            inpDataInizio.Value = "01/01/" & Now.Date.Year
            inpDataFine.Value = Now.Date.ToShortDateString
            RicercaAcquisti()
            pnlAllegati.Visible = False


        End If
    End Sub

    Private Sub SvuotaCampi()
        inpDataFattura.Value = Now.Date.ToShortDateString
        lblTipoTabella.Text = "ACQUISTO"
        txtNrNattura.Text = ""
        txtWeb.Text = ""
        TxtIndirizzo.Text = ""

        txtRagioneSociale.Text = ""
        txtPartitaIva.Text = ""
        txtNote.Text = ""

        txtImponibile.Text = "0,00"
        txtIva.Text = "0,00"
        txtRitenuta.Text = "0,00"
        txtImporto.Text = "0,00"

        hdfIDFattura.Value = 0



        lblFatturata.Text = "NON PAGATA"
        lblFatturata.ForeColor = Drawing.Color.Red

        pnlPagamenti.Visible = False

    End Sub

    Protected Sub btnRicerca_ServerClick(sender As Object, e As EventArgs)
        RicercaAcquisti()
    End Sub

    Private Sub RicercaAcquisti()
        Try
            Dim _BD As New BD_BindDataMain(oConn.ConnectionString(), False)
            Dim myGruppoParam As New SP_GruppoParametri()
            myGruppoParam.Add(New SP_Parametro("@Valore", 50, inpRicerca.Value, DbType.String, ParameterDirection.Input))
            myGruppoParam.Add(New SP_Parametro("@TipoTabella", 50, "ACQUISTO", DbType.String, ParameterDirection.Input))
            myGruppoParam.Add(New SP_Parametro("@DataInizio", 10, CDate(inpDataInizio.Value.ToString), DbType.Date, ParameterDirection.Input))
            myGruppoParam.Add(New SP_Parametro("@DataFine", 10, CDate(inpDataFine.Value.ToString).AddDays(1), DbType.Date, ParameterDirection.Input))


            Dim tmpDT As DataTable = _BD.getDataTable("[usp_RicercaAcquisti]", myGruppoParam)
            If _BD.ErrorNumber <> 0 Then
                showModal("ERRORE", String.Format("Errore in fase di estrazione dati: {0} ({1}).", _BD.ErrorMessage, _BD.ErrorNumber))
            End If
            grdAcquisti.DataSource = tmpDT
            grdAcquisti.DataBind()

        Catch ex As Exception
            showModal("ERRORE", String.Format("Errore In fase di estrazione dati: {0}.", ex.Message))
        End Try
    End Sub
    Protected Sub grdAcquisti_PreRender(sender As Object, e As EventArgs) Handles grdAcquisti.PreRender
        For Each tmpRow As GridViewRow In grdAcquisti.Rows
            DirectCast(tmpRow.FindControl("imgDettaglio"), ImageButton).CommandArgument = DirectCast(tmpRow.FindControl("lblId"), Label).Text
            DirectCast(tmpRow.FindControl("imgDelete"), ImageButton).CommandArgument = DirectCast(tmpRow.FindControl("lblId"), Label).Text
            DirectCast(tmpRow.FindControl("imgDelete"), ImageButton).Attributes.Add("onclick", "javascript:return confirm('Proseguire con la cancellazione dell'Acquisto?');")

            If DirectCast(tmpRow.FindControl("lblEvasa"), Label).Text.ToUpper = "FALSE" Then
                DirectCast(tmpRow.FindControl("imgFatturato"), Literal).Text = "<i class=""fa fa-toggle-off fa-2x"" style=""color:red;""/>"
            Else
                DirectCast(tmpRow.FindControl("imgFatturato"), Literal).Text = "<i class=""fa fa-toggle-off fa-2x"" style=""color:green;""/>"
            End If
        Next
    End Sub

    Public Sub DettaglioAnagrafica(ByVal sender As Object, ByVal e As System.EventArgs)
        Dim imgBtn As ImageButton = sender
        For Each tmpRow As GridViewRow In grdAcquisti.Rows
            If DirectCast(tmpRow.FindControl("imgDettaglio"), ImageButton).CommandArgument.Equals(imgBtn.CommandArgument) Then
                Dettaglio_Acquisto(imgBtn.CommandArgument)
                Exit For
            End If
        Next
    End Sub

    Private Sub Dettaglio_Acquisto(ByVal idAcquisto As Integer)
        Dim strSQL As String = "SELECT * FROM Acquisti WHERE idAcquisti=" & idAcquisto
        Dim AcquistiAdapter As New SqlClient.SqlDataAdapter
        Dim nwindConn As New SqlClient.SqlConnection(ConfigurationManager.ConnectionStrings("db_ncbConnectionString").ConnectionString)
        Dim selectCMD As New SqlClient.SqlCommand(strSQL, nwindConn)
        AcquistiAdapter.SelectCommand = selectCMD
        Dim dsAcquisti As New DataSet
        AcquistiAdapter.Fill(dsAcquisti, "Acquisti")
        Dim compensiRow As DataRow
        If dsAcquisti.Tables("Acquisti").Rows.Count > 0 Then
            Dim conta As Integer = 0
            For Each compensiRow In dsAcquisti.Tables("Acquisti").Rows
                SvuotaCampi()
                pnlAllegati.Visible = True

                Session("idTabella") = idAcquisto
                hdfIdCliente.Value = idAcquisto


                txtRagioneSociale.Text = compensiRow("RagioneSociale").ToString
                inpDataFattura.Value = CDate(compensiRow("Data").ToString).Date
                txtNrNattura.Text = compensiRow("Numero").ToString
                TxtIndirizzo.Text = compensiRow("Indirizzo").ToString
                txtPartitaIva.Text = compensiRow("PartitaIva").ToString
                txtCodiceFiscale.Text = compensiRow("CodiceFiscale").ToString
                txtWeb.Text = compensiRow("Web").ToString
                txtNote.Text = compensiRow("Note").ToString

                txtImponibile.Text = compensiRow("Imponibile").ToString
                txtIva.Text = compensiRow("ImportoIva").ToString
                txtRitenuta.Text = compensiRow("ImportoRitenuta").ToString
                txtImporto.Text = compensiRow("ImportoFattura").ToString
                lblTipoTabella.Text = "ACQUISTO"


                If compensiRow("Evasa") = True Then
                    lblFatturata.Text = "PAGATA"
                    lblFatturata.ForeColor = Drawing.Color.Green
                Else
                    lblFatturata.Text = "NON PAGATA"
                    lblFatturata.ForeColor = Drawing.Color.Red
                End If

                btnModifica.Text = "MODIFICA"
                pnlPagamenti.Visible = True

                CaricaListaAllegati()
                CaricaListaPagamenti()
                mView.ActiveViewIndex = 1
            Next
        End If
    End Sub


    Public Sub DeletePrenotazione(ByVal sender As Object, ByVal e As System.EventArgs)
        Dim imgBtn As ImageButton = sender
        Try
            For Each tmpRow As GridViewRow In grdAcquisti.Rows
                If DirectCast(tmpRow.FindControl("imgDelete"), ImageButton).CommandArgument.Equals(imgBtn.CommandArgument) Then
                    Dim _BD As New BD_BindDataMain(oConn.ConnectionString(), False)
                    Dim myGruppoParam As New SP_GruppoParametri()

                    myGruppoParam.Add(New SP_Parametro("@idAcquisti", 8, imgBtn.CommandArgument, DbType.Int32, ParameterDirection.Input))

                    Dim tmpDT As DataTable = _BD.getDataTable("[usp_DeleteAcquisti]", myGruppoParam)
                    If _BD.ErrorNumber <> 0 Then
                        showModal("ERRORE", String.Format("Errore in fase di cancellazione dati: {0} ({1}).", _BD.ErrorMessage, _BD.ErrorNumber))
                    End If

                    mView.ActiveViewIndex = 0
                    RicercaAcquisti()

                End If
            Next
        Catch ex As Exception
            showModal("ERRORE", (String.Format("Errore in fase di cancellazione dati: {0}.", ex.Message)))
        End Try
    End Sub
    Protected Sub btnNuovoInserimento_Click(sender As Object, e As EventArgs) Handles btnNuovoInserimento.Click
        SvuotaCampi()
        Session("IDTabella") = 0
        mView.ActiveViewIndex = 1
        btnModifica.Text = "SALVA"
        pnlAllegati.Visible = False
    End Sub

    Private Sub SALVA_PRENOTAZIONE()


        Using connection As New SqlClient.SqlConnection(ConfigurationManager.ConnectionStrings("db_ncbConnectionString").ConnectionString)

            connection.Open()

            '****************************************************************************************
            ' registrazione nel db della prenotazione
            '****************************************************************************************

            Dim cmd As SqlClient.SqlCommand = connection.CreateCommand()
            Dim transactionLog As SqlClient.SqlTransaction
            transactionLog = connection.BeginTransaction("Transactionlog")
            cmd.Connection = connection
            cmd.Transaction = transactionLog

            Try
                cmd.CommandType = CommandType.Text

                If Session("idTabella") = 0 Then
                    cmd.Parameters.Clear()
                    cmd.CommandText = "INSERT INTO Acquisti (Data, Numero, CodAnagrafica, RagioneSociale, Indirizzo, " & _
                                             "PartitaIva, CodiceFiscale, Web, Imponibile, ImportoIva, ImportoRitenuta, ImportoFattura, Evasa, Note, TipoTabella) VALUES " & _
                                             "(@Data, @Numero, @CodAnagrafica, @RagioneSociale, @Indirizzo, " & _
                                             "@PartitaIva, @CodiceFiscale, @Web, @Imponibile, @ImportoIva, @ImportoRitenuta, @ImportoFattura, '0', @Note, @TipoTabella);" & _
                                             "SELECT @@IDENTITY AS 'Identity'"



                Else
                    cmd.Parameters.Clear()
                    cmd.CommandText = "UPDATE Acquisti SET Data=@Data, Numero=@Numero, CodAnagrafica=@CodAnagrafica, RagioneSociale=@RagioneSociale, " & _
                                      "Indirizzo=@Indirizzo, PartitaIva=@PartitaIva, CodiceFiscale=@CodiceFiscale, Web=@Web, " & _
                                      "Imponibile=@Imponibile, ImportoIva=@ImportoIva, ImportoRitenuta=@ImportoRitenuta, " & _
                                       "ImportoFattura=@ImportoFattura, Evasa='0', Note=@Note, TipoTabella=@TipoTabella WHERE idAcquisti=@idAcquisti"
                    cmd.Parameters.AddWithValue("@idAcquisti", CInt(Session("idTabella")))

                    If CDbl(txtImporto.Text) < CDbl(lblImportoPagamenti.Text) Then
                        showModal("ERRORE", "IMPORTO ACQUISTO MINORE DEI PAGAMENTI REGISTRATI")
                        connection.Close()
                        Exit Sub
                    End If
                End If

                cmd.Parameters.AddWithValue("@Data", CDate(inpDataFattura.Value))
                cmd.Parameters.AddWithValue("@Numero", txtNrNattura.Text)
                cmd.Parameters.AddWithValue("@CodAnagrafica", CInt(hdfIdCliente.Value))
                cmd.Parameters.AddWithValue("@RagioneSociale", txtRagioneSociale.Text)
                cmd.Parameters.AddWithValue("@Indirizzo", TxtIndirizzo.Text)
                cmd.Parameters.AddWithValue("@PartitaIva", txtPartitaIva.Text)
                cmd.Parameters.AddWithValue("@CodiceFiscale", txtCodiceFiscale.Text)
                cmd.Parameters.AddWithValue("@Web", txtWeb.Text)
                cmd.Parameters.AddWithValue("@Imponibile", CDbl(txtImponibile.Text))
                cmd.Parameters.AddWithValue("@ImportoIva", CDbl(txtIva.Text))
                cmd.Parameters.AddWithValue("@ImportoRitenuta", CDbl(txtRitenuta.Text))
                cmd.Parameters.AddWithValue("@ImportoFattura", CDbl(txtImporto.Text))
                cmd.Parameters.AddWithValue("@Note", txtNote.Text)
                cmd.Parameters.AddWithValue("@TipoTabella", "ACQUISTO")

                Dim IdFattura As Integer = 0
                If Session("idTabella") = 0 Then
                    IdFattura = cmd.ExecuteScalar()
                Else
                    cmd.ExecuteNonQuery()
                End If

                transactionLog.Commit()
                connection.Close()

                If Session("idTabella") <> 0 Then
                    If CDbl(txtImporto.Text) > CDbl(lblImportoPagamenti.Text) Then
                        Salva_Saldato(False)
                    End If
                End If

                RicercaAcquisti()


                If Session("idTabella") = 0 Then
                    Session("idTabella") = IdFattura
                    Dettaglio_Acquisto(Session("idTabella"))
                End If

                showModal("SALVA", "DATI SALVATI CORRETTAMENTE")

            Catch ex As Exception
                showModal("ERRORE", String.Format("Ripristino Dati, " & vbCrLf & "{0}", ex))
                Try
                    transactionLog.Rollback()
                Catch ex2 As Exception
                    showModal("ERRORE", String.Format("Ripristino Dati, " & vbCrLf & "{0}", ex2))
                End Try
            End Try

        End Using

    End Sub

    Protected Sub btnEsci_Click(sender As Object, e As EventArgs) Handles btnEsci.Click
        mView.ActiveViewIndex = 0
    End Sub

    Protected Sub btnModifica_Click(sender As Object, e As EventArgs) Handles btnModifica.Click
        SALVA_PRENOTAZIONE()
    End Sub

    ' ----------------------------------------------------------------------------------------------------
    '-------------------------- CODICE PER CARICARE GLI ALLEGATI ----------------------------------------
    '----------------------------------------------------------------------------------------------------
    Protected Sub btnFinestaCaricaAllegato_Click(sender As Object, e As EventArgs) Handles btnFinestaCaricaAllegato.Click
        OpenModal("ModalAllegati")
    End Sub


    Protected Sub grdAllegatiManuale_PreRender(sender As Object, e As EventArgs) Handles grdAllegatiManuale.PreRender
        For Each tmpRow As GridViewRow In grdAllegatiManuale.Rows
            DirectCast(tmpRow.FindControl("imgDeleteAllegato"), ImageButton).CommandArgument = DirectCast(tmpRow.FindControl("lblidAllegato"), Label).Text
            DirectCast(tmpRow.FindControl("imgDeleteAllegato"), ImageButton).Attributes.Add("onclick", "javascript:return confirm('Proseguire con la cancellazione Allegato?');")
        Next
    End Sub
    Private Sub SalvaPersorsoAllegatoDB(ByVal varCodTipoAllegato As Integer, ByVal varDescrizione As String, ByVal varDirectory As String, ByVal varNomefile As String)

        Try

            Dim _BD As New BD_BindDataMain(oConn.ConnectionString(), False)
            Dim myGruppoParam As New SP_GruppoParametri()

            Dim tabControllata As String = Session("uploadTabella")
            Dim idRigaDaAllegareFile As Integer = Session("idTabella")

            myGruppoParam.Add(New SP_Parametro("@codTabella", 8, idRigaDaAllegareFile, DbType.Int32, ParameterDirection.Input))
            myGruppoParam.Add(New SP_Parametro("@TipoTabella", 50, tabControllata, DbType.String, ParameterDirection.Input))
            myGruppoParam.Add(New SP_Parametro("@codTipoAllegato", 8, varCodTipoAllegato, DbType.Int32, ParameterDirection.Input))
            myGruppoParam.Add(New SP_Parametro("@Descrizione", 4000, varDescrizione, DbType.String, ParameterDirection.Input))
            myGruppoParam.Add(New SP_Parametro("@Directory", 4000, varDirectory, DbType.String, ParameterDirection.Input))
            myGruppoParam.Add(New SP_Parametro("@NomeFile", 4000, varNomefile, DbType.String, ParameterDirection.Input))

            Dim tmpDT As DataTable = _BD.getDataTable("[usp_InsertAllegato]", myGruppoParam)


            If _BD.ErrorNumber <> 0 Then
                showModal("ERRORE", String.Format("Errore in fase di salvataggio dati allegato: {0} ({1}).", _BD.ErrorMessage, _BD.ErrorNumber))
            End If

        Catch ex As Exception
            showModal("ERRORE", String.Format("Errore in fase di salvataggio dati allegato: {0}.", ex.Message))
        End Try
    End Sub

    Public Sub CaricaListaAllegati()
        Try
            Dim _BD As New BD_BindDataMain(oConn.ConnectionString(), False)
            Dim myGruppoParam As New SP_GruppoParametri()

            Dim tabControllata As String = Session("uploadTabella")
            Dim idRigaDaAllegareFile As Integer = Session("idTabella")

            myGruppoParam.Add(New SP_Parametro("@codtabella", 8, idRigaDaAllegareFile, DbType.Int32, ParameterDirection.Input))
            myGruppoParam.Add(New SP_Parametro("@TipoTabella", 50, tabControllata, DbType.String, ParameterDirection.Input))


            Dim tmpDT As DataTable = _BD.getDataTable("[usp_RicercaAllegati]", myGruppoParam)
            If _BD.ErrorNumber <> 0 Then
                showModal("ERRORE", String.Format("Errore in fase di estrazione dati: {0} ({1}).", _BD.ErrorMessage, _BD.ErrorNumber))
            End If

            grdAllegatiManuale.DataSource = tmpDT
            grdAllegatiManuale.DataBind()

        Catch ex As Exception
            showModal("ERRORE", String.Format("Errore in fase di estrazione dati: {0}.", ex.Message))
        End Try
    End Sub

    Public Function ComponiNomeImgData(ByVal varNomeImg As String) As String
        ComponiNomeImgData = Now.Date.Year.ToString & _
                             Now.Date.Month.ToString & _
                             Now.Date.Day.ToString & _
                             Now.TimeOfDay.Hours.ToString & _
                             Now.TimeOfDay.Minutes.ToString & _
                             Now.TimeOfDay.Seconds.ToString & _
                             varNomeImg
        Return ComponiNomeImgData
    End Function
    Protected Sub btnUpload_Click(sender As Object, e As EventArgs) Handles btnUpload.Click
        Dim fileName As String = Path.GetFileName(uploadfiles1.FileName)
        Dim varCartellaUpload As String = ""



        Using connection As New SqlClient.SqlConnection(ConfigurationManager.ConnectionStrings("db_ncbConnectionString").ConnectionString)

            connection.Open()
            Dim command As SqlClient.SqlCommand = connection.CreateCommand()
            command.Connection = connection
            Try
                command.Parameters.Clear()
                command.CommandText = "SELECT DIRECTORY FROM ALLEGATOTIPO WHERE IDTIPOALLEGATO=@IDTIPOALLEGATO"

                command.Parameters.AddWithValue("@IDTIPOALLEGATO", drpTipoAllegato.SelectedValue)
                varCartellaUpload = command.ExecuteScalar()
                connection.Close()
                ' 
            Catch ex As Exception
                showModal("ERRORE", String.Format("ERRORE NELLA FASE DI UPLOAD DEL FILE: {0}.", ex.Message))
            End Try

        End Using

        If uploadfiles1.HasFile Then
            Try
                fileName = ComponiNomeImgData(fileName)


                uploadfiles1.SaveAs(Server.MapPath(varCartellaUpload) & fileName)
                System.Threading.Thread.Sleep(2000)

                showModal("SALVA", String.Format("FILE CARICATO CON SUCCESSO!"))

                SalvaPersorsoAllegatoDB(drpTipoAllegato.SelectedValue, drpTipoAllegato.SelectedItem.Text, varCartellaUpload, fileName)
                CaricaListaAllegati()

            Catch ex As Exception
                showModal("ERRORE", ex.Message)
            End Try
        Else

        End If
    End Sub

    Public Sub deleteAllegato(ByVal sender As Object, ByVal e As System.EventArgs)
        Dim imgBtn As ImageButton = sender
        Try
            For Each tmpRow As GridViewRow In grdAllegatiManuale.Rows
                If DirectCast(tmpRow.FindControl("imgDeleteAllegato"), ImageButton).CommandArgument.Equals(imgBtn.CommandArgument) Then

                    Dim strDirectory As String = DirectCast(tmpRow.FindControl("lblDirectory"), Label).Text
                    Dim strNomefile As String = DirectCast(tmpRow.FindControl("lblNomeFile"), Label).Text

                    File.Delete(Server.MapPath(strDirectory & strNomefile))

                    Dim _BD As New BD_BindDataMain(oConn.ConnectionString(), False)
                    Dim myGruppoParam As New SP_GruppoParametri()

                    myGruppoParam.Add(New SP_Parametro("@idAllegato", 8, imgBtn.CommandArgument, DbType.Int32, ParameterDirection.Input))

                    Dim tmpDT As DataTable = _BD.getDataTable("[usp_DeleteAllegato]", myGruppoParam)
                    If _BD.ErrorNumber <> 0 Then
                        showModal("ERRORE", String.Format("Errore in fase di cancellazione dati: {0} ({1}).", _BD.ErrorMessage, _BD.ErrorNumber))
                    End If

                    CaricaListaAllegati()

                End If
            Next
        Catch ex As Exception
            showModal("ERRORE", String.Format("Errore in fase di cancellazione dati: {0}.", ex.Message))
        End Try
    End Sub


    '------------------------------------------------------------------------------------------
    '--------------------------------------  SEZIONE PAGAMENTI --------------------------------
    '------------------------------------------------------------------------------------------

    Public Sub CalcoloPagamenti()
        Dim ImportoPagamenti As Double = 0
        For Each tmpRow As GridViewRow In grdPagamenti.Rows
            ImportoPagamenti += CDbl(DirectCast(tmpRow.FindControl("lblImporto"), Label).Text)
        Next
        lblImportoPagamenti.Text = ImportoPagamenti.ToString("N2")
    End Sub
    Protected Sub btnAggiungiPagamento_Click(sender As Object, e As EventArgs)
        OpenModal("modalPagamenti")
    End Sub

    Protected Sub grdPagamenti_PreRender(sender As Object, e As EventArgs) Handles grdPagamenti.PreRender
        For Each tmpRow As GridViewRow In grdPagamenti.Rows
            DirectCast(tmpRow.FindControl("imgDeletePagamenti"), ImageButton).CommandArgument = DirectCast(tmpRow.FindControl("lblIdPagamento"), Label).Text
            DirectCast(tmpRow.FindControl("imgDeletePagamenti"), ImageButton).Attributes.Add("onclick", "javascript:return confirm('Proseguire con la cancellazione del pagamento?');")
        Next
    End Sub

    Public Sub CaricaListaPagamenti()
        Try
            Dim _BD As New BD_BindDataMain(oConn.ConnectionString(), False)
            Dim myGruppoParam As New SP_GruppoParametri()

            Dim tabControllata As String = Session("uploadTabella")
            Dim idRigaDaAllegareFile As Integer = Session("idTabella")

            myGruppoParam.Add(New SP_Parametro("@codtabella", 8, idRigaDaAllegareFile, DbType.Int32, ParameterDirection.Input))
            myGruppoParam.Add(New SP_Parametro("@TipoTabella", 50, tabControllata, DbType.String, ParameterDirection.Input))


            Dim tmpDT As DataTable = _BD.getDataTable("[usp_RicercaPagamenti]", myGruppoParam)
            If _BD.ErrorNumber <> 0 Then
                showModal("ERRORE", String.Format("Errore in fase di estrazione dati: {0} ({1}).", _BD.ErrorMessage, _BD.ErrorNumber))
            End If

            grdPagamenti.DataSource = tmpDT
            grdPagamenti.DataBind()

            CalcoloPagamenti()

        Catch ex As Exception
            showModal("ERRORE", String.Format("Errore in fase di estrazione dati: {0}.", ex.Message))
        End Try
    End Sub

    Public Sub deleteDocumentoPagamenti(ByVal sender As Object, ByVal e As System.EventArgs)

        Dim imgBtn As ImageButton = sender
        Try
            For Each tmpRow As GridViewRow In grdPagamenti.Rows
                If DirectCast(tmpRow.FindControl("imgDeletePagamenti"), ImageButton).CommandArgument.Equals(imgBtn.CommandArgument) Then
                    Dim _BD As New BD_BindDataMain(oConn.ConnectionString(), False)
                    Dim myGruppoParam As New SP_GruppoParametri()

                    myGruppoParam.Add(New SP_Parametro("@idPagamento", 8, imgBtn.CommandArgument, DbType.Int32, ParameterDirection.Input))

                    Dim tmpDT As DataTable = _BD.getDataTable("[usp_DeletePagamento]", myGruppoParam)
                    If _BD.ErrorNumber <> 0 Then
                        showModal("ERRORE", String.Format("Errore in fase di cancellazione dati: {0} ({1}).", _BD.ErrorMessage, _BD.ErrorNumber))
                    Else

                        If lblFatturata.Text = "PAGATA" Then
                            lblFatturata.Text = "NON PAGATA"
                            lblFatturata.ForeColor = System.Drawing.Color.Red
                            Salva_Saldato(False)
                        End If
                        showModal("SALVA", String.Format("Pagamento Cancellato Correttamente"))

                    End If
                    CaricaListaPagamenti()
                End If
            Next
        Catch ex As Exception
            showModal("ERRORE", String.Format("Errore in fase di cancellazione dati: {0}.", ex.Message))
        End Try
    End Sub

    Protected Sub btnSalvaPagamento_Click(sender As Object, e As EventArgs)
        Try

            Dim varSaldo As Double = CDbl(lblImportoPagamenti.Text) + CDbl(txtImportoPagamento.Text)

            If varSaldo > CDbl(txtImporto.Text) Then
                showModal("ERRORE", "NON E' POSSIBILE REGISTRARE UN IMPORTO MAGGIORE DEL SALDO")
                Exit Sub
            End If

            Dim _BD As New BD_BindDataMain(oConn.ConnectionString(), False)
            Dim myGruppoParam As New SP_GruppoParametri()

            Dim tabControllata As String = Session("uploadTabella")
            Dim idRigaDaAllegareFile As Integer = Session("idTabella")

            myGruppoParam.Add(New SP_Parametro("@Data", 10, CDate(inpDataPagamento.Value).Date, DbType.Date, ParameterDirection.Input))
            myGruppoParam.Add(New SP_Parametro("@Importo", 18, txtImportoPagamento.Text, DbType.Decimal, ParameterDirection.Input))
            myGruppoParam.Add(New SP_Parametro("@Modalita", 100, drpModalita.SelectedItem.Text, DbType.String, ParameterDirection.Input))
            myGruppoParam.Add(New SP_Parametro("@note", 4000, txtNotePabamenti.Text, DbType.String, ParameterDirection.Input))
            myGruppoParam.Add(New SP_Parametro("@codtabella", 8, idRigaDaAllegareFile, DbType.Int32, ParameterDirection.Input))
            myGruppoParam.Add(New SP_Parametro("@tabella", 50, tabControllata, DbType.String, ParameterDirection.Input))

            Dim tmpDT As DataTable = _BD.getDataTable("[usp_InsertPagamento]", myGruppoParam)

            If _BD.ErrorNumber <> 0 Then
                showModal("ERRORE", String.Format("Errore in fase di salvataggio dati Pagamento: {0} ({1}).", _BD.ErrorMessage, _BD.ErrorNumber))
            Else
                If varSaldo = CDbl(txtImporto.Text) Then
                    lblFatturata.Text = "SALDATA"
                    lblFatturata.ForeColor = System.Drawing.Color.Green
                    Salva_Saldato(True)
                End If
                showModal("SALVA", String.Format("Pagamento Registrato Correttamente"))
            End If

            CaricaListaPagamenti()

            inpDataPagamento.Value = Now.Date.ToShortDateString
            txtImportoPagamento.Text = ""
            drpModalita.SelectedIndex = 0
            txtNotePabamenti.Text = ""


        Catch ex As Exception
            showModal("ERRORE", String.Format("Errore in fase di salvataggio dati Pagamento: {0}.", ex.Message))
        End Try
    End Sub


    Private Sub Salva_Saldato(ByVal Saldato As Boolean)
        Using ConnLog As New SqlClient.SqlConnection(ConfigurationManager.ConnectionStrings("db_ncbConnectionString").ConnectionString)


            ConnLog.Open()

            Dim CommandLog As SqlClient.SqlCommand = ConnLog.CreateCommand()
            Dim transactionLog As SqlClient.SqlTransaction
            transactionLog = ConnLog.BeginTransaction("Transactionlog")
            CommandLog.Connection = ConnLog
            CommandLog.Transaction = transactionLog

            Try
                CommandLog.Parameters.Clear()
                CommandLog.CommandText = "update Acquisti set Evasa='" & Saldato & "'  where idAcquisti=" & Session("IdTabella")

                CommandLog.ExecuteNonQuery()
                transactionLog.Commit()
                ConnLog.Close()

            Catch ex As Exception
                showModal("ERRORE", "ERRORE INASPETTATO")
                Try
                    transactionLog.Rollback()
                Catch ex2 As Exception
                    showModal("ERRORE", String.Format("Ripristino Dati, " & vbCrLf & "{0}", ex2))
                End Try
            End Try
        End Using
    End Sub

End Class
