﻿Imports SP_NameSpace
Imports System.Data

Partial Class AR_AliquotaIva
    Inherits System.Web.UI.Page
    Private oConn As New SqlClient.SqlConnection(ConfigurationManager.ConnectionStrings("db_ncbConnectionString").ConnectionString)

    '*****************************************************************************************
    'INIZIO CODICE PER FINESTRA MODALE
    '*****************************************************************************************

    Public ClassTitoloModal As String = "modal-header alert alert-success"
    Public Sub showModal(ByVal Classe As String, ByVal corpo As String)
        Select Case Classe
            Case "SALVA"
                ClassTitoloModal = "modal-header alert alert-success"
                lblTitoloModale.Text = "SALVA"
            Case "ATTENZIONE"
                ClassTitoloModal = "modal-header alert alert-danger"
                lblTitoloModale.Text = "ATTENZIONE"
            Case "INFORMAZIONE"
                ClassTitoloModal = "modal-header alert alert-info"
                lblTitoloModale.Text = "INFORMAZIONE"
            Case "ERRORE"
                ClassTitoloModal = "modal-header alert alert-warning"
                lblTitoloModale.Text = "ERRORE"
        End Select

        lblCorpoModale.Text = corpo
        ScriptManager.RegisterStartupScript(Me.Page, Page.GetType, "HideLoginDialog", "<script type=""text/javascript"">$(document).ready(function () { $('#myMessage').modal('show');});</script>", False)

    End Sub

    Protected Sub btnCloseModal_Click(sender As Object, e As EventArgs)
        ScriptManager.RegisterStartupScript(Page, Page.[GetType](), "myModalHide", "$('#myMessage').hide();", True)
        ScriptManager.RegisterStartupScript(Page, Page.[GetType](), "myModalAgainShow", "$('#myMessage').modal();", True)
    End Sub
    '*****************************************************************************************
    'FINE CODICE PER FINESTRA MODALE
    '*****************************************************************************************
    Private Sub OpenModal(ByVal NomeDivModale As String)
        ScriptManager.RegisterStartupScript(Me.Page, Page.GetType, "HideLoginDialog", "<script type=""text/javascript"">$(document).ready(function () { $('#" & NomeDivModale & "').modal('show');});</script>", False)
    End Sub
    Private Sub TitoloSezione(ByRef Titolo As String)
        Dim varTitoloezione As Label = DirectCast(Master.FindControl("lblTitoloSezione"), Label)
        varTitoloezione.Text = Titolo
    End Sub

    Protected Sub Page_Load(sender As Object, e As EventArgs) Handles Me.Load
        If Not IsPostBack Then
            Session("IDTabella") = 0
            Session("uploadTabella") = "TabAliquotaIva"
            TitoloSezione("ALIQUOTA IVA")
            RicercaAliquotaIva()
        End If
    End Sub

    Protected Sub btnNuovoInserimento_Click(sender As Object, e As EventArgs) Handles btnNuovoInserimento.Click
        Session("IDTabella") = 0
        OpenModal("ModalInsaAliquota")
        TitoloModale.Text = "NUOVA ALIQUOTA IVA"
        SvuotaCampi()
    End Sub

    Private Sub SvuotaCampi()
        txtAliquota.Text = "0"
        txtNome.Text = ""
        txtDescrizione.Text = ""
    End Sub

    Protected Sub btnRicerca_ServerClick(sender As Object, e As EventArgs)
        RicercaAliquotaIva()
    End Sub

    Private Sub RicercaAliquotaIva()
        Dim _BD As New BD_BindDataMain(oConn.ConnectionString(), False)
        Dim myGruppoParam As New SP_GruppoParametri()

        myGruppoParam.Add(New SP_Parametro("@valore", 50, inpRicerca.Value, DbType.String, ParameterDirection.Input))

        Dim tmpDT As DataTable = _BD.getDataTable("[usp_RicercaAliquotaIva]", myGruppoParam)

        grdAliquota.DataSource = tmpDT
        grdAliquota.DataBind()
    End Sub

    Protected Sub grdAliquota_PreRender(sender As Object, e As EventArgs) Handles grdAliquota.PreRender
        For Each tmpRow As GridViewRow In grdAliquota.Rows
            DirectCast(tmpRow.FindControl("imgDettaglio"), ImageButton).CommandArgument = DirectCast(tmpRow.FindControl("lblId"), Label).Text
            DirectCast(tmpRow.FindControl("imgCambiaIva"), ImageButton).CommandArgument = DirectCast(tmpRow.FindControl("lblId"), Label).Text
        Next
    End Sub

    Public Sub DettaglioAnagrafica(ByVal sender As Object, ByVal e As System.EventArgs)
        SvuotaCampi()
        TitoloModale.Text = "MODIFICA ALIQUOTA IVA"
        Dim imgBtn As ImageButton = sender
        For Each tmpRow As GridViewRow In grdAliquota.Rows
            If DirectCast(tmpRow.FindControl("imgDettaglio"), ImageButton).CommandArgument.Equals(imgBtn.CommandArgument) Then

                Session("idTabella") = imgBtn.CommandArgument

                txtAliquota.Text = DirectCast(tmpRow.FindControl("lblAliquota"), Label).Text
                txtNome.Text = DirectCast(tmpRow.FindControl("lblNome"), Label).Text
                txtDescrizione.Text = DirectCast(tmpRow.FindControl("lblDescrizione"), Label).Text

                OpenModal("ModalInsaAliquota")

                Exit For

            End If
        Next
    End Sub

    Public Sub CambiaIva(ByVal sender As Object, ByVal e As System.EventArgs)
        SvuotaCampi()
        TitoloModale.Text = "PREFERENZA ALIQUOTA IVA"
        Dim imgBtn As ImageButton = sender
        For Each tmpRow As GridViewRow In grdAliquota.Rows
            If DirectCast(tmpRow.FindControl("imgCambiaIva"), ImageButton).CommandArgument.Equals(imgBtn.CommandArgument) Then

                hdfID.Value = imgBtn.CommandArgument

                lblAliquota.Text = DirectCast(tmpRow.FindControl("lblAliquota"), Label).Text
                lblNome.Text = DirectCast(tmpRow.FindControl("lblNome"), Label).Text

                chkClienteIva.Checked = DirectCast(tmpRow.FindControl("rdbPrincipale"), RadioButton).Checked
                If DirectCast(tmpRow.FindControl("rdbPrincipale"), RadioButton).Checked Then
                    chkClienteIva.Enabled = False
                Else
                    chkClienteIva.Enabled = True
                End If


                chkTourIva.Checked = DirectCast(tmpRow.FindControl("rdbTourEstero"), RadioButton).Checked
                If DirectCast(tmpRow.FindControl("rdbTourEstero"), RadioButton).Checked Then
                    chkTourIva.Enabled = False
                Else
                    chkTourIva.Enabled = True
                End If


                chkAccessoriIva.Checked = DirectCast(tmpRow.FindControl("rdbAccessori"), RadioButton).Checked
                If DirectCast(tmpRow.FindControl("rdbAccessori"), RadioButton).Checked Then
                    chkAccessoriIva.Enabled = False
                Else
                    chkAccessoriIva.Enabled = True
                End If


                OpenModal("ModalPreferenzaIva")

                Exit For

            End If
        Next
    End Sub

    Protected Sub btnSceltaIva_Click1(sender As Object, e As EventArgs)

        If chkClienteIva.Enabled = True Then
            If chkClienteIva.Checked = True Then
                Salva_PreferenzaIva("Principale", hdfID.Value)
            End If
        End If

        If chkTourIva.Enabled = True Then
            If chkTourIva.Checked = True Then
                Salva_PreferenzaIva("TourEstero", hdfID.Value)
            End If
        End If

        If chkAccessoriIva.Enabled = True Then
            If chkAccessoriIva.Checked = True Then
                Salva_PreferenzaIva("Accessori", hdfID.Value)
            End If
        End If

        RicercaAliquotaIva()

    End Sub

    Private Sub Salva_PreferenzaIva(ByVal varColonna As String, ByVal varId As Integer)
        Using ConnLog As New SqlClient.SqlConnection(ConfigurationManager.ConnectionStrings("db_ncbConnectionString").ConnectionString)
            ConnLog.Open()

            Dim CommandLog As SqlClient.SqlCommand = ConnLog.CreateCommand()
            Dim transactionLog As SqlClient.SqlTransaction
            transactionLog = ConnLog.BeginTransaction("Transactionlog")
            CommandLog.Connection = ConnLog
            CommandLog.Transaction = transactionLog

            Try

                CommandLog.CommandText = "UPDATE AliquotaIva SET " & varColonna & "=0"
                CommandLog.ExecuteNonQuery()

                CommandLog.CommandText = "UPDATE AliquotaIva SET " & varColonna & "=1 WHERE idAliquota=" & varId
                CommandLog.ExecuteNonQuery()


                transactionLog.Commit()
                ConnLog.Close()


                showModal("SALVA", "DATI SALVATI CORRETTAMENTE")

            Catch ex As Exception
                showModal("ERORE", String.Format("Ripristino Dati, " & vbCrLf & "{0}", ex))
                Try
                    transactionLog.Rollback()
                Catch ex2 As Exception
                    showModal("ERORE", String.Format("Ripristino Dati, " & vbCrLf & "{0}", ex2))
                End Try
            End Try
        End Using
    End Sub

    Private Sub Salva_Aliquota()
        Try

            Using connection As New SqlClient.SqlConnection(ConfigurationManager.ConnectionStrings("db_ncbConnectionString").ConnectionString)

                connection.Open()

                Dim uspText As String = ""

                If Session("idTabella") = 0 Then
                    uspText = "[usp_InsertAliquota]"
                Else
                    uspText = "[usp_UpdateAliquota]"
                End If

                Dim cmd As SqlClient.SqlCommand = New SqlClient.SqlCommand(uspText, connection)
                cmd.CommandType = CommandType.StoredProcedure

                cmd.Parameters.Clear()

                If Session("idTabella") <> 0 Then
                    cmd.Parameters.AddWithValue("@idAliquota", Session("idTabella"))
                End If

                cmd.Parameters.AddWithValue("@Aliquota", CDbl(txtAliquota.Text))
                cmd.Parameters.AddWithValue("@Nome", txtNome.Text)
                cmd.Parameters.AddWithValue("@Descrizione", txtDescrizione.Text)
                Session("idTabella") = 0

                cmd.ExecuteNonQuery()

                connection.Close()


                RicercaAliquotaIva()
                showModal("SALVA", "DATI SALVATI CORRETTAMENTE")
            End Using
        Catch ex As Exception
            showModal("ERRORE", "ERRORE" & ex.Message)
        End Try
    End Sub
    Protected Sub btnSalvaDati_Click(sender As Object, e As EventArgs)
        Salva_Aliquota()
    End Sub
End Class
