﻿Imports System.Data
Imports SP_NameSpace
Partial Class AR_Anagrafica
    Inherits System.Web.UI.Page
    Private oConn As New SqlClient.SqlConnection(ConfigurationManager.ConnectionStrings("db_ncbConnectionString").ConnectionString)


    '*****************************************************************************************
    'INIZIO CODICE PER FINESTRA MODALE
    '*****************************************************************************************

    Public ClassTitoloModal As String = "modal-header alert alert-success"
    Public Sub showModal(ByVal Classe As String, ByVal corpo As String)
        Select Case Classe
            Case "SALVA"
                ClassTitoloModal = "modal-header alert alert-success"
                lblTitoloModale.Text = "SALVA"
            Case "ATTENZIONE"
                ClassTitoloModal = "modal-header alert alert-danger"
                lblTitoloModale.Text = "ATTENZIONE"
            Case "INFORMAZIONE"
                ClassTitoloModal = "modal-header alert alert-info"
                lblTitoloModale.Text = "INFORMAZIONE"
            Case "ERRORE"
                ClassTitoloModal = "modal-header alert alert-warning"
                lblTitoloModale.Text = "ERRORE"
        End Select

        lblCorpoModale.Text = corpo
        ScriptManager.RegisterStartupScript(Me.Page, Page.GetType, "HideLoginDialog", "<script type=""text/javascript"">$(document).ready(function () { $('#myMessage').modal('show');});</script>", False)

    End Sub

    Protected Sub btnCloseModal_Click(sender As Object, e As EventArgs)
        ScriptManager.RegisterStartupScript(Page, Page.[GetType](), "myModalHide", "$('#myMessage').hide();", True)
        ScriptManager.RegisterStartupScript(Page, Page.[GetType](), "myModalAgainShow", "$('#myMessage').modal();", True)
    End Sub
    '*****************************************************************************************
    'FINE CODICE PER FINESTRA MODALE
    '*****************************************************************************************

    Private Sub TitoloSezione(ByRef Titolo As String)
        Dim varTitoloezione As Label = DirectCast(Master.FindControl("lblTitoloSezione"), Label)
        varTitoloezione.Text = Titolo
    End Sub

    Private Sub CambiaTitoloMasterPage(ByVal Testo As String)
        DirectCast(Master.FindControl("lblTitoloSezione"), Label).Text = Testo
    End Sub

    Private Sub OpenModal()
        ScriptManager.RegisterStartupScript(Me.Page, Page.GetType, "HideLoginDialog", "<script type=""text/javascript"">$(document).ready(function () { $('#myModal').modal('show');});</script>", False)
    End Sub

    Protected Sub Page_Load(sender As Object, e As EventArgs) Handles Me.Load
        ConfigurationManager.AppSettings("ColoraIconaControllo") = "'icoAnagrafica'"
        If Not IsPostBack Then
            Session("IDTabella") = 0
            btnNuovoInserimento.Text = "+ CLIENTE"
            lblTitoloGriglia.Text = "CLIENTE"
            lblDenominazione.Text = "Denominazione"
            RicercaAnagrafica()
            lblMessage.Text = ""
            CambiaTitoloMasterPage("CLIENTE")
        End If
    End Sub

    Protected Sub btnOpen(sender As Object, e As EventArgs)
        OpenModal()
    End Sub

    Protected Sub btnClose(sender As Object, e As EventArgs)
        '  ScriptManager.RegisterStartupScript(Page, Page.GetType(), "myModalHide", "$('#myModal').hide();", True)
    End Sub

    Protected Sub btnChange_Click(sender As Object, e As EventArgs)
        'Response.Write("Button Clicked")
    End Sub
    Public Sub ButtonClienti()
        btnNuovoInserimento.Text = "+ CLIENTE"
        btnNuovoInserimento.CssClass = "btn btn-primary"
        SvuotaCampi("CLIENTE")
        lblTitoloGriglia.Text = "CLIENTE"
        lblDenominazione.Text = "Denominazione"
        txtnrPatente.Visible = False
        lblPatente.Visible = False
        RicercaAnagrafica()
        CambiaTitoloMasterPage("CLIENTE")
    End Sub

    Public Sub ButtonFornitori()
        btnNuovoInserimento.Text = "+ FORNITORE"
        btnNuovoInserimento.CssClass = "btn btn-warning"
        SvuotaCampi("FORNITORE")
        lblTitoloGriglia.Text = "FORNITORE"
        lblDenominazione.Text = "Denominazione"
        txtnrPatente.Visible = False
        lblPatente.Visible = False
        RicercaAnagrafica()
        CambiaTitoloMasterPage("FORNITORE")
    End Sub

    Public Sub ButtonAutisti()
        btnNuovoInserimento.Text = "+ AUTISTA"
        btnNuovoInserimento.CssClass = "btn btn-danger"
        SvuotaCampi("AUTISTA")
        lblTitoloGriglia.Text = "AUTISTA"
        lblDenominazione.Text = "Cognome e Nome"
        txtnrPatente.Visible = True
        lblPatente.Visible = False
        RicercaAnagrafica()
        CambiaTitoloMasterPage("AUTISTA")
    End Sub

    Private Sub SvuotaCampi(ByVal tipo As String)
        txtTipo.Text = tipo
        txtDenominazione.Text = ""
        txtIndirizzo.Text = ""
        txtCitta.Text = ""
        txtCap.Text = ""
        txtProvincia.Text = ""
        txtReferente.Text = ""
        txtPI.Text = ""
        txtCF.Text = ""
        txtEmail.Text = ""
        txtTelefono.Text = ""
        txtFax.Text = ""
        txtNoteExtraIndirizzo.Text = ""
        txtTerminidiPagamento.Text = "0"
        ' drpAliquotaIva.SelectedValue = ""
        txtIban.Text = ""
        lblMessage.Text = ""
        txtnrPatente.Text = ""
        drpNazione.SelectedItem.Text = "Italia"
    End Sub

    Protected Sub btnRicerca_ServerClick(sender As Object, e As EventArgs)
        RicercaAnagrafica()
    End Sub
    Private Sub RicercaAnagrafica()
        Dim _BD As New BD_BindDataMain(oConn.ConnectionString(), False)
        Dim myGruppoParam As New SP_GruppoParametri()

        myGruppoParam.Add(New SP_Parametro("@Valore", 50, inpRicerca.Value, DbType.String, ParameterDirection.Input))
        myGruppoParam.Add(New SP_Parametro("@Tipologia", 50, lblTitoloGriglia.Text, DbType.String, ParameterDirection.Input))
        'If chkCancellato.Checked = True Then
        '    myGruppoParam.Add(New SP_Parametro("@cancellato", 1, 1, DbType.Boolean, ParameterDirection.Input))
        'Else
        '    myGruppoParam.Add(New SP_Parametro("@cancellato", 1, 0, DbType.Boolean, ParameterDirection.Input))
        'End If

        Dim tmpDT As DataTable = _BD.getDataTable("[usp_AnagraficaRicreca]", myGruppoParam)

        grdAnagrafica.DataSource = tmpDT
        grdAnagrafica.DataBind()
    End Sub

    Protected Sub grdAnagrafica_PreRender(sender As Object, e As EventArgs) Handles grdAnagrafica.PreRender
        For Each tmpRow As GridViewRow In grdAnagrafica.Rows
            DirectCast(tmpRow.FindControl("imgDettaglio"), ImageButton).CommandArgument = DirectCast(tmpRow.FindControl("lblId"), Label).Text
        Next
    End Sub

    Public Sub DettaglioAnagrafica(ByVal sender As Object, ByVal e As System.EventArgs)
        SvuotaCampi(DirectCast(Master.FindControl("lblTitoloSezione"), Label).Text)
        TitoloModale.Text = "MODIFICA " & DirectCast(Master.FindControl("lblTitoloSezione"), Label).Text

        If DirectCast(Master.FindControl("lblTitoloSezione"), Label).Text = "AUTISTA" Then
            lblDenominazione.Text = "Cognome e Nome"
            txtnrPatente.Visible = True
            lblPatente.Visible = True
        Else
            lblDenominazione.Text = "Denominazione"
            txtnrPatente.Visible = False
            lblPatente.Visible = False
        End If

        Dim imgBtn As ImageButton = sender
        For Each tmpRow As GridViewRow In grdAnagrafica.Rows
            If DirectCast(tmpRow.FindControl("imgDettaglio"), ImageButton).CommandArgument.Equals(imgBtn.CommandArgument) Then

                Session("idTabella") = imgBtn.CommandArgument
                drpAliquotaIva.DataBind()
                txtDenominazione.Text = DirectCast(tmpRow.FindControl("lblDenominazione"), Label).Text
                txtEmail.Text = DirectCast(tmpRow.FindControl("lblEmail"), Label).Text
                txtTelefono.Text = DirectCast(tmpRow.FindControl("lblTelefono"), Label).Text
                txtFax.Text = DirectCast(tmpRow.FindControl("lblFax"), Label).Text
                txtTipo.Text = DirectCast(tmpRow.FindControl("lblTipoAnagrafica"), Label).Text
                txtIndirizzo.Text = DirectCast(tmpRow.FindControl("lblIndirizzo"), Label).Text
                txtCitta.Text = DirectCast(tmpRow.FindControl("lblCitta"), Label).Text
                txtCap.Text = DirectCast(tmpRow.FindControl("lblCap"), Label).Text
                txtProvincia.Text = DirectCast(tmpRow.FindControl("lblProvincia"), Label).Text
                drpNazione.SelectedValue = DirectCast(tmpRow.FindControl("lblNazione"), Label).Text
                txtReferente.Text = DirectCast(tmpRow.FindControl("lblNomeReferente"), Label).Text
                txtPI.Text = DirectCast(tmpRow.FindControl("lblPartitaIva"), Label).Text
                txtCF.Text = DirectCast(tmpRow.FindControl("lblCodiceFiscale"), Label).Text
                txtNoteExtraIndirizzo.Text = DirectCast(tmpRow.FindControl("lblNoteExtraIndirizzo"), Label).Text
                txtTerminidiPagamento.Text = DirectCast(tmpRow.FindControl("lblTerminiDiPagamento"), Label).Text
                txtnrPatente.Text = DirectCast(tmpRow.FindControl("lblnrPatente"), Label).Text

                drpAliquotaIva.SelectedValue = (DirectCast(tmpRow.FindControl("lblIvaDefault"), Label).Text)
                txtIban.Text = DirectCast(tmpRow.FindControl("lblIban"), Label).Text

                OpenModal()

                Exit For

            End If
        Next
    End Sub

    Protected Sub btnNuovoInserimento_Click(sender As Object, e As EventArgs) Handles btnNuovoInserimento.Click
        Session("IDTabella") = 0
        OpenModal()
        TitoloModale.Text = "NUOVO " & btnNuovoInserimento.Text.Substring(2, btnNuovoInserimento.Text.Length - 2)
        SvuotaCampi(btnNuovoInserimento.Text.Substring(2, btnNuovoInserimento.Text.Length - 2))
    End Sub
   
    Private Sub SALVA_ANAGRAFICA()
        Try

            Using connection As New SqlClient.SqlConnection(ConfigurationManager.ConnectionStrings("db_ncbConnectionString").ConnectionString)

                connection.Open()

                Dim uspText As String = ""

                If Session("idTabella") = 0 Then
                    uspText = "[usp_InsertAnagrafica]"
                Else
                    uspText = "[usp_UpdateAnagrafica]"
                End If

                Dim cmd As SqlClient.SqlCommand = New SqlClient.SqlCommand(uspText, connection)
                cmd.CommandType = CommandType.StoredProcedure

                cmd.Parameters.Clear()

                If Session("idTabella") <> 0 Then
                    cmd.Parameters.AddWithValue("@idAnagrafica", Session("idTabella"))
                End If

                cmd.Parameters.AddWithValue("@TipoAnagrafica", txtTipo.Text)
                cmd.Parameters.AddWithValue("@Denominazione", txtDenominazione.Text)
                cmd.Parameters.AddWithValue("@Indirizzo", txtIndirizzo.Text)
                cmd.Parameters.AddWithValue("@Citta", txtCitta.Text)
                cmd.Parameters.AddWithValue("@Cap", txtCap.Text)
                cmd.Parameters.AddWithValue("@Provincia", txtProvincia.Text)
                cmd.Parameters.AddWithValue("@Nazione", drpNazione.SelectedItem.Text)
                cmd.Parameters.AddWithValue("@NomeReferente", txtReferente.Text)
                cmd.Parameters.AddWithValue("@PartitaIva", txtPI.Text)
                cmd.Parameters.AddWithValue("@CodiceFiscale", txtCF.Text)
                cmd.Parameters.AddWithValue("@Email", txtEmail.Text)
                cmd.Parameters.AddWithValue("@Telefono", txtTelefono.Text)
                cmd.Parameters.AddWithValue("@Fax", txtFax.Text)
                cmd.Parameters.AddWithValue("@NoteExtraIndirizzo", txtNoteExtraIndirizzo.Text)
                cmd.Parameters.AddWithValue("@TerminiDiPagamento", CInt(txtTerminidiPagamento.Text))

                cmd.Parameters.AddWithValue("@IvaDefault", CInt(drpAliquotaIva.SelectedValue))
                cmd.Parameters.AddWithValue("@Iban", txtIban.Text)
                cmd.Parameters.AddWithValue("@Cancellato", 0)
                cmd.Parameters.AddWithValue("@nrPatente", txtnrPatente.Text)

                cmd.ExecuteNonQuery()

                connection.Close()

                Session("IDTabella") = 0

                showModal("SALVA", "DATI SALVATI CORRETTAMENTE")


                RicercaAnagrafica()

            End Using
        Catch ex As Exception
            showModal("ERRORE", "ERRORE" & ex.Message)
        End Try
    End Sub

    Protected Sub btnSalvaDati_Click(sender As Object, e As EventArgs)
        SALVA_ANAGRAFICA()
    End Sub


End Class
