﻿Imports System.Collections.Generic
Imports System.Configuration
Imports System.Web.Services
Imports System.Data.SqlClient
Imports System.Data

Partial Public Class AR_FatturaPrenotazioneNuova
    Inherits System.Web.UI.Page

    '*****************************************************************************************
    'INIZIO CODICE PER FINESTRA MODALE
    '*****************************************************************************************

    Public ClassTitoloModal As String = "modal-header alert alert-success"
    Public Sub showModal(ByVal Classe As String, ByVal corpo As String)
        Select Case Classe
            Case "SALVA"
                ClassTitoloModal = "modal-header alert alert-success"
                lblTitoloModale.Text = "SALVA"
            Case "ATTENZIONE"
                ClassTitoloModal = "modal-header alert alert-danger"
                lblTitoloModale.Text = "ATTENZIONE"
            Case "INFORMAZIONE"
                ClassTitoloModal = "modal-header alert alert-info"
                lblTitoloModale.Text = "INFORMAZIONE"
            Case "ERRORE"
                ClassTitoloModal = "modal-header alert alert-warning"
                lblTitoloModale.Text = "ERRORE"
        End Select

        lblCorpoModale.Text = corpo
        ScriptManager.RegisterStartupScript(Me.Page, Page.GetType, "HideLoginDialog", "<script type=""text/javascript"">$(document).ready(function () { $('#myMessage').modal('show');});</script>", False)

    End Sub

    Protected Sub btnCloseModal_Click(sender As Object, e As EventArgs)
        ScriptManager.RegisterStartupScript(Page, Page.[GetType](), "myModalHide", "$('#myMessage').hide();", True)
        ScriptManager.RegisterStartupScript(Page, Page.[GetType](), "myModalAgainShow", "$('#myMessage').modal();", True)
    End Sub
    '*****************************************************************************************
    'FINE CODICE PER FINESTRA MODALE
    '*****************************************************************************************
    Private Sub OpenModal()
        ScriptManager.RegisterStartupScript(Me.Page, Page.GetType, "HideLoginDialog", "<script type=""text/javascript"">$(document).ready(function () { $('#myModal').modal('show');});</script>", False)
    End Sub
    Protected Sub Button1_Click(sender As Object, e As EventArgs) Handles Button1.Click
        OpenModal()
    End Sub

    Private grpDettaglioFat As New Fattura.GruppoDettaglio
    Protected Sub Page_Load(ByVal sender As Object, ByVal e As EventArgs) Handles Me.Load
        If Not Page.IsPostBack Then
            inpDataFattura.Value = Now.Date
            DirectCast(Master.FindControl("lblTitoloSezione"), Label).Text = "FATTURA LIBERA"

            If Not Session("CurrentDettaglioFattura") Is Nothing Then
                grpDettaglioFat = DirectCast(Session("CurrentDettaglioFattura"), Fattura.GruppoDettaglio)
                grdLAvori.DataSource = grpDettaglioFat
                grdLAvori.DataBind()
            End If

        End If
    End Sub

    ' Popola Ricerca Intestazione
    <System.Web.Script.Services.ScriptMethod(), _
   System.Web.Services.WebMethod()> _
    Public Shared Function SearchEmployees(ByVal prefixText As String, ByVal count As Integer) As List(Of String)
        Dim conn As SqlConnection = New SqlConnection
        conn.ConnectionString = ConfigurationManager.ConnectionStrings("db_ncbConnectionString").ConnectionString
        Dim cmd As SqlCommand = New SqlCommand
        cmd.CommandText = "select idAnagrafica, Denominazione, TipoAnagrafica from " & _
        " Anagrafica where Denominazione like @SearchText + '%'"
        cmd.Parameters.AddWithValue("@SearchText", prefixText)
        cmd.Connection = conn
        conn.Open()
        Dim employees As List(Of String) = New List(Of String)
        Dim sdr As SqlDataReader = cmd.ExecuteReader
        While sdr.Read
            'employees.Add(AjaxControlToolkit.AutoCompleteExtender _
            '.CreateAutoCompleteItem(String.Format("{0} {1}", _
            ' sdr("Denominazione"), sdr("TipoAnagrafica")), sdr("idAnagrafica").ToString()))
            employees.Add(AjaxControlToolkit.AutoCompleteExtender.CreateAutoCompleteItem(String.Format("{0} ", sdr("Denominazione")), sdr("idAnagrafica").ToString()))
        End While
        conn.Close()
        Return employees
    End Function

    Protected Sub btnRicercaIntestazione(sender As Object, e As EventArgs)
        Dim conn As SqlConnection = New SqlConnection
        conn.ConnectionString = ConfigurationManager.ConnectionStrings("db_ncbConnectionString").ConnectionString
        Dim cmd As SqlCommand = New SqlCommand
        cmd.CommandText = "select idAnagrafica, Denominazione, Indirizzo, Citta, Cap, Provincia, PartitaIva, CodiceFiscale, Email  from " & _
        " Anagrafica where idAnagrafica = @IdAnagrafica"
        cmd.Parameters.AddWithValue("@IdAnagrafica", hdfIdCliente.Value)
        cmd.Connection = conn
        conn.Open()
        Dim employees As List(Of String) = New List(Of String)
        Dim sdr As SqlDataReader = cmd.ExecuteReader
        While sdr.Read
            txtRagioneSociale.Text = sdr("Denominazione")
            TxtIndirizzo.Text = sdr("Indirizzo") & vbCrLf & sdr("Cap") & " " & sdr("Citta") & " " & sdr("Provincia")
            txtPartitaIva.Text = sdr("PartitaIva")
            txtCodiceFiscale.Text = sdr("CodiceFiscale")
            txtWeb.Text = sdr("Email")
        End While
        conn.Close()
    End Sub


    '*****************************************************************
    '  DETTAGLIO FATTURA
    '*****************************************************************
    Protected Sub btnSalvaDati_Click(sender As Object, e As EventArgs)

        Dim dt As DataTable = New DataTable()
        Dim dr As DataRow = Nothing
        dt.Columns.Add(New DataColumn("RowNumber", GetType(String)))
        dt.Columns.Add(New DataColumn("Codice", GetType(String)))
        dt.Columns.Add(New DataColumn("Descrizione", GetType(String)))
        dt.Columns.Add(New DataColumn("Qta", GetType(Double)))
        dt.Columns.Add(New DataColumn("Imponibile", GetType(Double)))
        dt.Columns.Add(New DataColumn("Iva", GetType(Double)))
        dt.Columns.Add(New DataColumn("Ritenuta", GetType(Double)))
        dt.Columns.Add(New DataColumn("Importo", GetType(Double)))
        dt.Columns.Add(New DataColumn("libera", GetType(Boolean)))

        If grdLAvori.Rows.Count > 0 Then
            For I As Integer = 0 To grdLAvori.Rows.Count - 1
                dr = dt.NewRow()
                dr("RowNumber") = grdLAvori.Rows(I).Cells(0).Text
                dr("Codice") = grdLAvori.Rows(I).Cells(1).Text
                dr("Descrizione") = grdLAvori.Rows(I).Cells(2).Text
                dr("Qta") = grdLAvori.Rows(I).Cells(3).Text
                dr("Imponibile") = grdLAvori.Rows(I).Cells(4).Text
                dr("Iva") = grdLAvori.Rows(I).Cells(5).Text
                dr("Ritenuta") = grdLAvori.Rows(I).Cells(6).Text
                dr("Importo") = grdLAvori.Rows(I).Cells(7).Text
                dr("libera") = grdLAvori.Rows(I).Cells(8).Text
                dt.Rows.Add(dr)
            Next
        End If

        dr = dt.NewRow()
        dr("RowNumber") = 1
        dr("Codice") = txtCodice.Text
        dr("Descrizione") = txtDescrizione.Text
        dr("Qta") = txtQuantita.Text
        dr("Imponibile") = txtImponibile.Text

        Dim impXqta As Double = 0
        impXqta = CDbl(txtQuantita.Text) * CDbl(txtImponibile.Text)

        dr("Iva") = txtIva.Text
        Dim varIva As Double = 0
        varIva = (impXqta * CDbl(txtIva.Text)) / 100


        dr("Ritenuta") = txtRitenuta.Text
        Dim varRit As Double = 0
        varRit = (impXqta * CDbl(txtRitenuta.Text)) / 100

        dr("Importo") = impXqta + varIva - varRit

        dt.Rows.Add(dr)

        grdLAvori.DataSource = dt
        grdLAvori.DataBind()

        dt.Dispose()
        dr.Delete()

        CalcoloFattura()

    End Sub

    Protected Sub grvStudentDetails_RowDeleting(ByVal sender As Object, ByVal e As GridViewDeleteEventArgs)

        Dim dt As DataTable = New DataTable()
        Dim dr As DataRow = Nothing
        dt.Columns.Add(New DataColumn("RowNumber", GetType(String)))
        dt.Columns.Add(New DataColumn("Codice", GetType(String)))
        dt.Columns.Add(New DataColumn("Descrizione", GetType(String)))
        dt.Columns.Add(New DataColumn("Qta", GetType(Double)))
        dt.Columns.Add(New DataColumn("Imponibile", GetType(Double)))
        dt.Columns.Add(New DataColumn("Iva", GetType(Double)))
        dt.Columns.Add(New DataColumn("Ritenuta", GetType(Double)))
        dt.Columns.Add(New DataColumn("Importo", GetType(Double)))
        dt.Columns.Add(New DataColumn("libera", GetType(Boolean)))

        If grdLAvori.Rows.Count > 0 Then
            For I As Integer = 0 To grdLAvori.Rows.Count - 1
                dr = dt.NewRow()
                dr("RowNumber") = grdLAvori.Rows(I).Cells(0).Text
                dr("Codice") = grdLAvori.Rows(I).Cells(1).Text
                dr("Descrizione") = grdLAvori.Rows(I).Cells(2).Text
                dr("Qta") = grdLAvori.Rows(I).Cells(3).Text
                dr("Imponibile") = grdLAvori.Rows(I).Cells(4).Text
                dr("Iva") = grdLAvori.Rows(I).Cells(5).Text
                dr("Ritenuta") = grdLAvori.Rows(I).Cells(6).Text
                dr("Importo") = grdLAvori.Rows(I).Cells(7).Text
                dr("libera") = grdLAvori.Rows(I).Cells(8).Text
                dt.Rows.Add(dr)
            Next
        End If



        Dim drCurrentRow As DataRow = Nothing
        Dim rowIndex As Integer = Convert.ToInt32(e.RowIndex)
        If dt.Rows.Count > 0 Then
            dt.Rows.Remove(dt.Rows(rowIndex))
            drCurrentRow = dt.NewRow()

            grdLAvori.DataSource = dt
            grdLAvori.DataBind()

        End If

        dt.Dispose()
        dr.Delete()

        CalcoloFattura()
    End Sub

    Private Sub CalcoloFattura()
        lblImportoFattura.Text = "0,00"
        lblImponibile.Text = "0,00"
        lblIva.Text = "0,00"
        lblRitenuta.Text = "0,00"

        Dim ImportoFattura As Double = 0
        Dim Imponibile As Double = 0
        Dim impIva As Double = 0
        Dim ImpRit As Double = 0

        For i As Integer = 0 To grdLAvori.Rows.Count - 1
            Imponibile += CDbl(grdLAvori.Rows(i).Cells(4).Text) * CDbl(grdLAvori.Rows(i).Cells(3).Text)
            impIva += (CDbl(grdLAvori.Rows(i).Cells(4).Text) * CDbl(grdLAvori.Rows(i).Cells(5).Text)) / 100
            ImpRit += (CDbl(grdLAvori.Rows(i).Cells(4).Text) * CDbl(grdLAvori.Rows(i).Cells(6).Text)) / 100
            ImportoFattura += CDbl(grdLAvori.Rows(i).Cells(7).Text)
        Next

        lblImportoFattura.Text = ImportoFattura
        lblImponibile.Text = Imponibile
        lblIva.Text = impIva
        lblRitenuta.Text = ImpRit
    End Sub

    '*****************************************************************
    '  DETTAGLIO FATTURA
    '*****************************************************************

    Protected Sub btnSalvaFattura_Click(sender As Object, e As EventArgs) Handles btnSalvaFattura.Click


        If grdLAvori.Rows.Count <= 0 Then
            showModal("ERORE", "NESSUN DETTAGLIO FATTURA INSERITO")
            Exit Sub
        End If

        If txtRagioneSociale.Text.Length = 0 Then
            showModal("ERORE", "INTESTAZIONE DELLA FATTURA NON INSERITA")
            Exit Sub
        End If



        Using ConnLog As New SqlClient.SqlConnection(ConfigurationManager.ConnectionStrings("db_ncbConnectionString").ConnectionString)
            ConnLog.Open()

            Dim CommandLog As SqlClient.SqlCommand = ConnLog.CreateCommand()
            Dim transactionLog As SqlClient.SqlTransaction
            transactionLog = ConnLog.BeginTransaction("Transactionlog")
            CommandLog.Connection = ConnLog
            CommandLog.Transaction = transactionLog

            Try
                CommandLog.Parameters.Clear()
                CommandLog.CommandText = "SELECT COUNT(IDFATTURA) FROM FATTURAATTIVA WHERE YEAR(DATA) =@ANNO"
                CommandLog.Parameters.AddWithValue("@ANNO", CDate(inpDataFattura.Value).Date.Year)

                Dim NrFattura As String = ""

                Dim objExecute As Object = CommandLog.ExecuteScalar

                If objExecute = 0 Then
                    NrFattura = "1"
                Else
                    NrFattura = objExecute + 1
                End If

                NrFattura = NrFattura.ToString.PadLeft(5, "0"c) & "/" & CDate(inpDataFattura.Value).Date.Year

                txtNrNattura.Text = NrFattura

                CommandLog.Parameters.Clear()
                CommandLog.CommandText = "INSERT INTO FATTURAATTIVA (Data, Numero, CodAnagrafica, RagioneSociale, Indirizzo, " & _
                                         "PartitaIva, CodiceFiscale, Web, Imponibile, ImportoIva, ImportoRitenuta, ImportoFattura, Evasa) VALUES " & _
                                         "(@Data, @Numero, @CodAnagrafica, @RagioneSociale, @Indirizzo, " & _
                                         "@PartitaIva, @CodiceFiscale, @Web, @Imponibile, @ImportoIva, @ImportoRitenuta, @ImportoFattura, '0');" & _
                                          "SELECT @@IDENTITY AS 'Identity'"

                CommandLog.Parameters.AddWithValue("@Data", CDate(inpDataFattura.Value))
                CommandLog.Parameters.AddWithValue("@Numero", NrFattura)
                CommandLog.Parameters.AddWithValue("@CodAnagrafica", hdfIdCliente.Value)
                CommandLog.Parameters.AddWithValue("@RagioneSociale", txtRagioneSociale.Text)
                CommandLog.Parameters.AddWithValue("@Indirizzo", TxtIndirizzo.Text)
                CommandLog.Parameters.AddWithValue("@PartitaIva", txtPartitaIva.Text)
                CommandLog.Parameters.AddWithValue("@CodiceFiscale", txtCodiceFiscale.Text)
                CommandLog.Parameters.AddWithValue("@Web", txtWeb.Text)
                CommandLog.Parameters.AddWithValue("@Imponibile", CDbl(lblImponibile.Text))
                CommandLog.Parameters.AddWithValue("@ImportoIva", CDbl(lblIva.Text))
                CommandLog.Parameters.AddWithValue("@ImportoRitenuta", CDbl(lblRitenuta.Text))
                CommandLog.Parameters.AddWithValue("@ImportoFattura", CDbl(lblImportoFattura.Text))

                Dim IdFattura As Integer = CommandLog.ExecuteScalar()

                For I As Integer = 0 To grdLAvori.Rows.Count - 1
                    CommandLog.Parameters.Clear()
                    CommandLog.CommandText = "INSERT INTO FATTURAATTIVADETTAGLIO (Codice, Descrizione, Quantita, Imponibile, Iva, " & _
                                             "Ritenuta, Importo, CodFattura, libera, CodPrenotazione) VALUES " & _
                                             "(@Codice, @Descrizione, @Quantita, @Imponibile, @Iva, " & _
                                             "@Ritenuta, @Importo, @CodFattura, @libera, '0');"

                    CommandLog.Parameters.AddWithValue("@Codice", grdLAvori.Rows(I).Cells(1).Text)
                    CommandLog.Parameters.AddWithValue("@Descrizione", grdLAvori.Rows(I).Cells(2).Text)
                    CommandLog.Parameters.AddWithValue("@Quantita", CDbl(grdLAvori.Rows(I).Cells(3).Text))
                    CommandLog.Parameters.AddWithValue("@Imponibile", CDbl(grdLAvori.Rows(I).Cells(4).Text))
                    CommandLog.Parameters.AddWithValue("@Iva", CDbl(grdLAvori.Rows(I).Cells(5).Text))
                    CommandLog.Parameters.AddWithValue("@Ritenuta", CDbl(grdLAvori.Rows(I).Cells(6).Text))
                    CommandLog.Parameters.AddWithValue("@Importo", CDbl(grdLAvori.Rows(I).Cells(7).Text))
                    CommandLog.Parameters.AddWithValue("@CodFattura", IdFattura)
                    CommandLog.Parameters.AddWithValue("@libera", grdLAvori.Rows(I).Cells(8).Text)
                    CommandLog.ExecuteNonQuery()
                Next

                transactionLog.Commit()
                ConnLog.Close()

                showModal("SALVA", "FATTURA SALVATA CORRETTAMENTE")

            Catch ex As Exception
                showModal("ERORE", String.Format("Ripristino Dati, " & vbCrLf & "{0}", ex))
                Try
                    transactionLog.Rollback()
                Catch ex2 As Exception
                    showModal("ERORE", String.Format("Ripristino Dati, " & vbCrLf & "{0}", ex2))
                End Try
            End Try
        End Using
    End Sub
End Class
