﻿Imports System.Data
Imports SP_NameSpace
Imports System.IO
Imports System.Data.SqlClient

Partial Class ar_LayoutFatture

    Inherits System.Web.UI.Page

    '*****************************************************************************************
    'INIZIO CODICE PER FINESTRA MODALE
    '*****************************************************************************************

    Public ClassTitoloModal As String = "modal-header alert alert-success"
    Public Sub showModal(ByVal Classe As String, ByVal corpo As String)
        Select Case Classe
            Case "SALVA"
                ClassTitoloModal = "modal-header alert alert-success"
                lblTitoloModale.Text = "SALVA"
            Case "ATTENZIONE"
                ClassTitoloModal = "modal-header alert alert-danger"
                lblTitoloModale.Text = "ATTENZIONE"
            Case "INFORMAZIONE"
                ClassTitoloModal = "modal-header alert alert-info"
                lblTitoloModale.Text = "INFORMAZIONE"
            Case "ERRORE"
                ClassTitoloModal = "modal-header alert alert-warning"
                lblTitoloModale.Text = "ERRORE"
        End Select

        lblCorpoModale.Text = corpo

        ScriptManager.RegisterStartupScript(Page, Page.[GetType](), "myModal", "$('#myModal').modal();", True)
    End Sub

    'Protected Sub btnOpenModal_Click(sender As Object, e As EventArgs) Handles btnOpenModal.Click
    '    ScriptManager.RegisterStartupScript(Page, Page.[GetType](), "myModal", "$('#myModal').modal();", True)
    'End Sub

    Protected Sub btnCloseModal_Click(sender As Object, e As EventArgs)
        ScriptManager.RegisterStartupScript(Page, Page.[GetType](), "myModalHide", "$('#myModal').hide();", True)
        ScriptManager.RegisterStartupScript(Page, Page.[GetType](), "myModalAgainShow", "$('#myModal').modal();", True)
    End Sub
    '*****************************************************************************************
    'FINE CODICE PER FINESTRA MODALE
    '*****************************************************************************************

    Protected Sub Page_Load(sender As Object, e As EventArgs) Handles Me.Load
        ConfigurationManager.AppSettings("ColoraIconaControllo") = "'icoDatiAzienda'"
        If Not IsPostBack Then
            DirectCast(Master.FindControl("lblTitoloSezione"), Label).Text = "LAYOUT FATTURE"

            Dim conn As SqlConnection = New SqlConnection
            conn.ConnectionString = ConfigurationManager.ConnectionStrings("db_ncbConnectionString").ConnectionString
            Dim cmd As SqlCommand = New SqlCommand
            cmd.CommandText = "SELECT * from " & _
            " LayoutFattura where idLayoutFattura = 1"
            cmd.Connection = conn
            conn.Open()
            Dim sdr As SqlDataReader = cmd.ExecuteReader

            While sdr.Read
                Select Case sdr("TipoFattura")
                    Case "Personalizzata"
                        chkPersonalizzata.Checked = True
                        chkClassica.Checked = False
                        chkModerna.Checked = False
                    Case "Classica"
                        chkPersonalizzata.Checked = False
                        chkClassica.Checked = True
                        chkModerna.Checked = False
                    Case "Moderna"
                        chkPersonalizzata.Checked = False
                        chkClassica.Checked = False
                        chkModerna.Checked = True
                End Select

            End While
            conn.Close()

        End If
    End Sub

    Protected Sub chkPersonalizzata_CheckedChanged(sender As Object, e As EventArgs) Handles chkPersonalizzata.CheckedChanged
        chkPersonalizzata.Checked = True
        chkClassica.Checked = False
        chkModerna.Checked = False
    End Sub
    Protected Sub chkClassica_CheckedChanged(sender As Object, e As EventArgs) Handles chkClassica.CheckedChanged
        chkPersonalizzata.Checked = False
        chkClassica.Checked = True
        chkModerna.Checked = False
    End Sub

    Protected Sub chkModerna_CheckedChanged(sender As Object, e As EventArgs) Handles chkModerna.CheckedChanged
        chkPersonalizzata.Checked = False
        chkClassica.Checked = False
        chkModerna.Checked = True
    End Sub

    Protected Sub btnSalva_Click(sender As Object, e As EventArgs) Handles btnSalva.Click
        Dim Layoutscelto As String = ""

        If chkPersonalizzata.Checked = True Then Layoutscelto = "Personalizzata"
        If chkClassica.Checked = True Then Layoutscelto = "Classica"
        If chkModerna.Checked = True Then Layoutscelto = "Moderna"


        Using connection As New SqlClient.SqlConnection(ConfigurationManager.ConnectionStrings("db_ncbConnectionString").ConnectionString)

            connection.Open()

            Dim cmd As SqlClient.SqlCommand = connection.CreateCommand()
            Dim transactionLog As SqlClient.SqlTransaction
            transactionLog = connection.BeginTransaction("Transactionlog")
            cmd.Connection = connection
            cmd.Transaction = transactionLog

            Try
                cmd.CommandType = CommandType.Text

                cmd.Parameters.Clear()
                cmd.CommandText = "UPDATE  LayoutFattura SET  TipoFattura=@TipoFattura WHERE idLayoutFattura=1"
                cmd.Parameters.AddWithValue("@TipoFattura", Layoutscelto)
                cmd.ExecuteNonQuery()
                transactionLog.Commit()
                connection.Close()

                showModal("SALVA", "LAYOUT FATTURA SALVATO CORRETTAMENTE")

            Catch ex As Exception
                showModal("ERRORE", String.Format("Ripristino Dati, " & vbCrLf & "{0}", ex))
                Try
                    transactionLog.Rollback()
                Catch ex2 As Exception
                    showModal("ERRORE", String.Format("Ripristino Dati, " & vbCrLf & "{0}", ex2))
                End Try
            End Try

        End Using
    End Sub


End Class
