﻿<%@ Page Title="" Language="VB" MasterPageFile="~/AR/MasterPage.master" AutoEventWireup="false" CodeFile="Mezzi.aspx.vb" Inherits="AR_Mezzi" %>

<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="Server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder1" runat="Server">

    <script src="https://ajax.googleapis.com/ajax/libs/jquery/1.11.3/jquery.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.5/js/bootstrap.min.js"></script>


    <!-- MODALE MESSAGGIO -->
    <div id="myMessage" class="modal fade" role="dialog">
        <div class="modal-dialog text-left">
            <!-- Modal content-->
            <div class="modal-content">
                <div class='<%= ClassTitoloModal%>'>
                    <h4 class="card-title">
                        <asp:Label ID="lblTitoloModale" runat="server" Text=""></asp:Label>
                    </h4>
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                </div>
                <div class="modal-body">
                    <p>
                        <asp:Label ID="lblCorpoModale" runat="server" Text="Corpo"></asp:Label>
                    </p>
                </div>
                <div class="modal-footer">
                    <button class="btn btn-default" data-dismiss="modal" type="button">Chiudi</button>
                </div>
            </div>
        </div>
    </div>
    <!-- MODALE MESSAGGIO -->


    <!-- MODALE PANNELLO INSERIMENTO MEZZO -->
    <div id="ModalInsMezzi" class="modal fade hide" role="dialog">
        <div class="modal-dialog modal-lg text-left ">
            <div class="modal-content">
                <div class="card-header">
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                    <h4 class="card-title">
                        <asp:Label ID="TitoloModale" runat="server" Text=""></asp:Label></h4>
                </div>
                <div class="modal-body">
                    <div>
                        <div class="form-row">
                            <div class="form-group col-md-8" style="margin: 0px 0px 0px 0px;">
                                Mezzo*
                                <asp:TextBox ID="txtDescrizione" class="form-control form-control-sm" runat="server"></asp:TextBox>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidator7" runat="server" ControlToValidate="txtDescrizione" ErrorMessage="Campo Obbligatorio" Font-Bold="False" Font-Size="10px" ForeColor="Red" Display="Dynamic" ValidationGroup="Salva"></asp:RequiredFieldValidator>
                            </div>
                            <div class="form-group col-md-4" style="margin: 0px 0px 0px 0px;">
                                Targa*
                                <asp:TextBox ID="txtTarga" class=" form-control form-control-sm" runat="server"></asp:TextBox>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidator4" runat="server" ControlToValidate="txtTarga" ErrorMessage="Campo Obbligatorio" Font-Bold="False" Font-Size="10px" ForeColor="Red" Display="Dynamic" ValidationGroup="Salva"></asp:RequiredFieldValidator>
                            </div>
                        </div>
                        <div class="form-row">
                            <div class="form-group col-md-8" style="margin: 0px 0px 0px 0px;">
                                Note
                                <asp:TextBox ID="txtNote" class="form-control form-control-sm" runat="server" TextMode="MultiLine" Height="150px"></asp:TextBox>
                            </div>
                            <div class="form-group col-md-4" style="margin: 0px 0px 0px 0px;">
                                Colore
                                <div class="input-group color colorpicker-element" data-plugin-colorpicker="">
                                    <span class="input-group-addon"><i style="background-color: rgb(0, 136, 204);"></i></span>
                                    <input id="inpColor" runat="server" type="text" class="form-control" value="#0088cc" />
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <asp:Label ID="lblMessage" CssClass="form" runat="server" Text="Label" ForeColor="Red"></asp:Label>
                    <asp:Button ID="btnSalvaDati" runat="server" class="btn btn-primary" OnClick="btnSalvaDati_Click" Text="Salva" ValidationGroup="Salva" />
                    <button type="button" class="btn btn-default btn-raised" data-dismiss="modal">Chiudi</button>
                </div>
            </div>
        </div>
    </div>
    <!-- MODALE PANNELLO INSERIMENTO MEZZO -->

    <!-- MODALE PANNELLO INSERIMENTO ALLEGATO -->
    <div id="ModalAllegati" class="modal fade hide" role="dialog">
        <div class="modal-dialog text-left ">
            <div class="modal-content">
                <div class="card-header">
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                    <h4 class="card-title">CARICA ALLEGATO</h4>
                </div>
                <div class="modal-body">
                    <div class="panel-body">
                        <div class="col-lg-12">
                            Tipo Allegato                                                                
                            <asp:DropDownList ID="drpTipoAllegato" CssClass="form-control" runat="server" DataSourceID="SqlDataSource2" DataTextField="DescTipoAllegato" DataValueField="idTipoAllegato"></asp:DropDownList>
                            <!-- .File Upload -->
                            <asp:SqlDataSource ID="SqlDataSource2" runat="server" ConnectionString="<%$ ConnectionStrings:db_ncbConnectionString %>" SelectCommand="SELECT [DescTipoAllegato], [Directory], [idTipoAllegato] FROM [AllegatoTipo] ORDER BY [DescTipoAllegato]"></asp:SqlDataSource>
                        </div>
                        <div class="col-lg-12 ">
                            Seleziona il File da Allegare 
                            <asp:FileUpload ID="uploadfiles1" runat="server" CssClass="form-control" /><br />
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <asp:Button ID="btnUpload" runat="server" Text="Upload" CssClass="btn btn-success pull-right" />
                    <button type="button" class="btn btn-default btn-raised" data-dismiss="modal">close</button>
                </div>
            </div>
        </div>
    </div>
    <!-- MODALE PANNELLO INSERIMENTO ALLEGATO -->


    <asp:MultiView ID="mView" runat="server">
        <asp:View ID="vwRicerca" runat="server">
            <div class="row">
                <div class="col-lg-8">                    
                    <div class="input-group mb-md-3 ">
                        <input id="inpRicerca" runat="server" type="text" class="form-control" placeholder="Cerca per Descrizione / Targa / Note" />
                        <span class="input-group-btn">
                            <button id="btnRicerca" runat="server" class="btn btn-success" onserverclick="btnRicerca_ServerClick" type="button">Cerca</button>
                        </span>
                    </div>
                </div>
                <div class="col-lg-4" style="text-align: right">                  
                    <asp:Button ID="btnNuovoInserimento" CssClass="btn btn-primary" onserverclick="btnOpen" runat="server" Text="+ MEZZO" />
                </div>

                <div class="col-lg-12">
                    <section class="card">
                        <header class="card-header">
                            <h2 class="card-title">MEZZI</h2>
                        </header>
                        <div class="card-body ">
                            <div>
                                <asp:GridView ID="grdMezzi" CssClass="table table-bordered table-responsive " runat="server" AllowPaging="True" AllowSorting="True" AutoGenerateColumns="False" DataKeyNames="idMezzo" PageSize="100">
                                    <Columns>
                                        <asp:TemplateField HeaderText="Sel.">
                                            <ItemTemplate>
                                                <asp:ImageButton ID="imgDettaglio" runat="server" ImageUrl="../img/edit.png" OnClick="DettaglioAnagrafica" />
                                            </ItemTemplate>
                                            <ItemStyle VerticalAlign="Top" Width="1%" />
                                        </asp:TemplateField>
                                        <asp:TemplateField HeaderText="idAnagrafica" ItemStyle-VerticalAlign="Top" ItemStyle-Width="1%" Visible="false">
                                            <ItemTemplate>
                                                <asp:Label ID="lblID" runat="server" Text='<%# Eval("idMezzo")%>' Visible="true"></asp:Label>
                                            </ItemTemplate>
                                        </asp:TemplateField>
                                        <asp:TemplateField HeaderText="Mezzo" ItemStyle-VerticalAlign="Top" ItemStyle-Width="1%" Visible="true">
                                            <ItemTemplate>
                                                <asp:Label ID="lblDescrizione" runat="server" Text='<%# Eval("Descrizione")%>' Visible="true"></asp:Label>
                                            </ItemTemplate>
                                        </asp:TemplateField>
                                        <asp:TemplateField HeaderText="Targa" ItemStyle-VerticalAlign="Top" ItemStyle-Width="1%" Visible="true">
                                            <ItemTemplate>
                                                <asp:Label ID="lblTarga" runat="server" Text='<%# Eval("Targa")%>' Visible="true"></asp:Label>
                                            </ItemTemplate>
                                        </asp:TemplateField>
                                        <asp:TemplateField HeaderText="Note" ItemStyle-VerticalAlign="Top" ItemStyle-Width="10%" Visible="true">
                                            <ItemTemplate>
                                                <asp:Label ID="lblNote" runat="server" Text='<%# Eval("Note")%>' Visible="true"></asp:Label>
                                            </ItemTemplate>
                                        </asp:TemplateField>
                                        <asp:TemplateField HeaderText="Colore" ItemStyle-VerticalAlign="Top" ItemStyle-HorizontalAlign="Center" ItemStyle-Width="1%" Visible="true">
                                            <ItemTemplate>
                                                <div class="input-group color colorpicker-element" >
                                                    <span class="input-group-addon"><i <%# String.Format("style="" background-color:{0};""", Eval("Colore"))%>></i></span>
                                                </div>
                                            </ItemTemplate>
                                        </asp:TemplateField>
                                        <asp:TemplateField HeaderText="Colore" ItemStyle-VerticalAlign="Top" ItemStyle-Width="8%" Visible="false">
                                            <ItemTemplate>
                                                <asp:Label ID="lblColore" runat="server" Text='<%# Eval("Colore")%>' Visible="true"></asp:Label>
                                            </ItemTemplate>
                                        </asp:TemplateField>
                                    </Columns>
                                    <EmptyDataTemplate>
                                        NESSUNA MEZZO TROVATO
                                    </EmptyDataTemplate>
                                    <PagerSettings Mode="NumericFirstLast" PageButtonCount="20" />
                                </asp:GridView>
                            </div>
                        </div>
                    </section>
                </div>
            </div>
        </asp:View>
        <asp:View ID="vwDettaglio" runat="server">
            <div class="row">
                <div class="col-lg-12">
                    <section class="card card-featured card-featured-primary mb-6">
                        <header class="card-header">
                            <h2 class="card-title">DETTAGLIO MEZZO</h2>
                        </header>
                        <div class="card-body" style="display: block;">
                            <div class="form-row">
                                <div class="form-group col-md-4" style="margin: 0px 0px 0px 0px;">
                                    Mezzo*
                                <asp:TextBox ID="txtDettMezzo" class="form-control form-control" runat="server"></asp:TextBox>
                                    <asp:RequiredFieldValidator ID="RequiredFieldValidator1" runat="server" ControlToValidate="txtDettMezzo" ErrorMessage="Campo Obbligatorio" Font-Bold="False" Font-Size="10px" ForeColor="Red" Display="Dynamic" ValidationGroup="Modifica"></asp:RequiredFieldValidator>
                                </div>
                                <div class="form-group col-md-4" style="margin: 0px 0px 0px 0px;">
                                    Targa*
                                <asp:TextBox ID="txtDettTarga" class=" form-control form-control" runat="server"></asp:TextBox>
                                    <asp:RequiredFieldValidator ID="RequiredFieldValidator2" runat="server" ControlToValidate="txtDettTarga" ErrorMessage="Campo Obbligatorio" Font-Bold="False" Font-Size="10px" ForeColor="Red" Display="Dynamic" ValidationGroup="Modifica"></asp:RequiredFieldValidator>
                                </div>

                                <div class="form-group col-md-4" style="margin: 0px 0px 0px 0px;">
                                    Colore
                                <div class="input-group color colorpicker-element" data-plugin-colorpicker="">
                                    <span class="input-group-addon"><i style="background-color: rgb(0, 136, 204);"></i></span>
                                    <input id="inpDettColore" runat="server" type="text" class="form-control" />
                                </div>
                                </div>
                            </div>
                            <div class="form-row">
                                <div class="form-group col-md-12" style="margin: 0px 0px 0px 0px;">
                                    Note
                                <asp:TextBox ID="txtDettNote" class="form-control form-control-sm" runat="server" TextMode="MultiLine" Height="150px"></asp:TextBox>
                                </div>
                            </div>
                        </div>
                        <div class="card-footer">
                            <asp:Button ID="btnModifica" runat="server" class="btn btn-primary" Text="Modifica" ValidationGroup="Modifica" />
                            <asp:Button ID="btnEsci" runat="server" class="btn btn-default" Text="Esci" ValidationGroup="Modifica" />
                        </div>
                    </section>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-12">
                    <section class="card card-featured card-featured-danger mb-6">
                        <header class="card-header">
                            <h2 class="card-title">ALLEGATI</h2>
                        </header>
                        <div class="card-body" style="display: block;">
                            <asp:GridView ID="grdAllegatiManuale" CssClass="table table-bordered table-responsive "
                                runat="server" AllowPaging="True" AllowSorting="True"
                                AutoGenerateColumns="False" CellPadding="3" PageSize="100">
                                <Columns>
                                    <asp:TemplateField HeaderText="Canc." ItemStyle-VerticalAlign="Top" ItemStyle-Width="1%">
                                        <ItemTemplate>
                                            <asp:HyperLink ID="HyperLink1" Target="_blank" runat="server" ImageUrl="~/img/Preview.png" NavigateUrl='<%# Eval("Directory") + Eval("NomeFile") %>'>HyperLink</asp:HyperLink>
                                        </ItemTemplate>
                                    </asp:TemplateField>
                                    <asp:TemplateField HeaderText="idAllegato" ItemStyle-VerticalAlign="Top" ItemStyle-Width="1%" Visible="false">
                                        <ItemTemplate>
                                            <asp:Label ID="lblidAllegato" runat="server" Text='<%# Eval("idAllegato")%>'></asp:Label>
                                        </ItemTemplate>
                                    </asp:TemplateField>
                                    <asp:TemplateField HeaderText="codTabella" ItemStyle-VerticalAlign="Top" ItemStyle-Width="15%">
                                        <ItemTemplate>
                                            <asp:Label ID="lblcodTabella" runat="server" Text='<%# Eval("codTabella")%>'></asp:Label>
                                        </ItemTemplate>
                                    </asp:TemplateField>
                                    <asp:TemplateField HeaderText="TipoTabella" ItemStyle-VerticalAlign="Top" ItemStyle-Width="15%">
                                        <ItemTemplate>
                                            <asp:Label ID="lblTipoTabella" runat="server" Text='<%# Eval("TipoTabella")%>'></asp:Label>
                                        </ItemTemplate>
                                    </asp:TemplateField>
                                    <asp:TemplateField HeaderText="codTipoAllegato" ItemStyle-VerticalAlign="Top" ItemStyle-Width="15%">
                                        <ItemTemplate>
                                            <asp:Label ID="lblcodTipoAllegato" runat="server" Text='<%# Eval("codTipoAllegato")%>'></asp:Label>
                                        </ItemTemplate>
                                    </asp:TemplateField>
                                    <asp:TemplateField HeaderText="Descrizione" ItemStyle-VerticalAlign="Top" ItemStyle-Width="10%">
                                        <ItemTemplate>
                                            <asp:Label ID="lblDescrizione" runat="server" Text='<%# Eval("Descrizione")%>'></asp:Label>
                                        </ItemTemplate>
                                    </asp:TemplateField>
                                    <asp:TemplateField HeaderText="Directory" ItemStyle-VerticalAlign="Top" ItemStyle-Width="10%">
                                        <ItemTemplate>
                                            <asp:Label ID="lblDirectory" runat="server" Text='<%# Eval("Directory")%>'></asp:Label>
                                        </ItemTemplate>
                                    </asp:TemplateField>
                                    <asp:TemplateField HeaderText="NomeFile" ItemStyle-VerticalAlign="Top" ItemStyle-Width="10%">
                                        <ItemTemplate>
                                            <asp:Label ID="lblNomeFile" runat="server" Text='<%# Eval("NomeFile")%>'></asp:Label>
                                        </ItemTemplate>
                                    </asp:TemplateField>
                                    <asp:TemplateField HeaderText="Canc." ItemStyle-VerticalAlign="Top" ItemStyle-Width="1%">
                                        <ItemTemplate>
                                            <asp:ImageButton ID="imgDeleteAllegato" runat="server" ImageUrl="~/img/delete.png"
                                                AlternateText="Cancella Documento" OnClick="deleteAllegato" />
                                        </ItemTemplate>
                                    </asp:TemplateField>
                                </Columns>
                                <EmptyDataTemplate>
                                    Attenzione: NESSUN ALLEGATO TROVATO
                                </EmptyDataTemplate>
                                <PagerSettings FirstPageText="Prima" LastPageText="Ultima" Mode="NumericFirstLast" Position="TopAndBottom" />
                            </asp:GridView>
                        </div>
                        <div class="card-footer">
                            <asp:Button ID="btnFinestaCaricaAllegato" runat="server" class="btn btn-primary" Text="Carica Allegato" />
                        </div>
                    </section>
                </div>
            </div>
        </asp:View>
    </asp:MultiView>
</asp:Content>

