﻿Imports System.Data
Imports SP_NameSpace
Imports System.IO

Partial Class AR_Mezzi
    Inherits System.Web.UI.Page
    Private oConn As New SqlClient.SqlConnection(ConfigurationManager.ConnectionStrings("db_ncbConnectionString").ConnectionString)

    '*****************************************************************************************
    'INIZIO CODICE PER FINESTRA MODALE
    '*****************************************************************************************

    'Public Function ConvertiColore(ByVal Colore As String) As String
    '    Dim ConvColore As String = System.Drawing.ColorTranslator.FromHtml(Colore)
    '    Return ConvColore
    'End Function

    Public ClassTitoloModal As String = "modal-header alert alert-success"
    Public Sub showModal(ByVal Classe As String, ByVal corpo As String)
        Select Case Classe
            Case "SALVA"
                ClassTitoloModal = "modal-header alert alert-success"
                lblTitoloModale.Text = "SALVA"
            Case "ATTENZIONE"
                ClassTitoloModal = "modal-header alert alert-danger"
                lblTitoloModale.Text = "ATTENZIONE"
            Case "INFORMAZIONE"
                ClassTitoloModal = "modal-header alert alert-info"
                lblTitoloModale.Text = "INFORMAZIONE"
            Case "ERRORE"
                ClassTitoloModal = "modal-header alert alert-warning"
                lblTitoloModale.Text = "ERRORE"
        End Select

        lblCorpoModale.Text = corpo
        ScriptManager.RegisterStartupScript(Me.Page, Page.GetType, "HideLoginDialog", "<script type=""text/javascript"">$(document).ready(function () { $('#myMessage').modal('show');});</script>", False)

    End Sub

    Protected Sub btnCloseModal_Click(sender As Object, e As EventArgs)
        ScriptManager.RegisterStartupScript(Page, Page.[GetType](), "myModalHide", "$('#myMessage').hide();", True)
        ScriptManager.RegisterStartupScript(Page, Page.[GetType](), "myModalAgainShow", "$('#myMessage').modal();", True)
    End Sub
    '*****************************************************************************************
    'FINE CODICE PER FINESTRA MODALE
    '*****************************************************************************************



    Private Sub TitoloSezione(ByRef Titolo As String)
        Dim varTitoloezione As Label = DirectCast(Master.FindControl("lblTitoloSezione"), Label)
        varTitoloezione.Text = Titolo
    End Sub

    Private Sub CambiaTitoloMasterPage(ByVal Testo As String)
        DirectCast(Master.FindControl("lblTitoloSezione"), Label).Text = Testo
    End Sub

    Private Sub OpenModal(ByVal NomeDivModale As String)
        ScriptManager.RegisterStartupScript(Me.Page, Page.GetType, "HideLoginDialog", "<script type=""text/javascript"">$(document).ready(function () { $('#" & NomeDivModale & "').modal('show');});</script>", False)
    End Sub

    Protected Sub Page_Load(sender As Object, e As EventArgs) Handles Me.Load
        ConfigurationManager.AppSettings("ColoraIconaControllo") = "'icoMezzi'"
        If Not IsPostBack Then
            Session("IDTabella") = 0
            Session("uploadTabella") = "TabMezzi"
            CambiaTitoloMasterPage("MEZZI")
            RicercaMezzi()
            lblMessage.Text = ""
            mView.ActiveViewIndex = 0
        End If
    End Sub

    Protected Sub btnOpen(sender As Object, e As EventArgs)
        OpenModal("ModalInsMezzi")
    End Sub

    Private Sub SvuotaCampi()
        txtTarga.Text = ""
        txtDescrizione.Text = ""
        txtNote.Text = ""
        lblMessage.Text = ""
        inpColor.Value = "#0088cc"
    End Sub

    Protected Sub btnRicerca_ServerClick(sender As Object, e As EventArgs)
        RicercaMezzi()
    End Sub
    Private Sub RicercaMezzi()
        Dim _BD As New BD_BindDataMain(oConn.ConnectionString(), False)
        Dim myGruppoParam As New SP_GruppoParametri()

        myGruppoParam.Add(New SP_Parametro("@valore", 50, inpRicerca.Value, DbType.String, ParameterDirection.Input))

        Dim tmpDT As DataTable = _BD.getDataTable("[usp_RicercaMezzi]", myGruppoParam)

        grdMezzi.DataSource = tmpDT
        grdMezzi.DataBind()
    End Sub

    Protected Sub grdMezzi_PreRender(sender As Object, e As EventArgs) Handles grdMezzi.PreRender
        For Each tmpRow As GridViewRow In grdMezzi.Rows
            DirectCast(tmpRow.FindControl("imgDettaglio"), ImageButton).CommandArgument = DirectCast(tmpRow.FindControl("lblId"), Label).Text
        Next
    End Sub

    Public Sub DettaglioAnagrafica(ByVal sender As Object, ByVal e As System.EventArgs)
        SvuotaCampi()
        TitoloModale.Text = "MODIFICA " & DirectCast(Master.FindControl("lblTitoloSezione"), Label).Text
        Dim imgBtn As ImageButton = sender
        For Each tmpRow As GridViewRow In grdMezzi.Rows
            If DirectCast(tmpRow.FindControl("imgDettaglio"), ImageButton).CommandArgument.Equals(imgBtn.CommandArgument) Then

                Session("idTabella") = imgBtn.CommandArgument

                txtDettMezzo.Text = DirectCast(tmpRow.FindControl("lblDescrizione"), Label).Text
                txtDettTarga.Text = DirectCast(tmpRow.FindControl("lblTarga"), Label).Text
                txtDettNote.Text = DirectCast(tmpRow.FindControl("lblNote"), Label).Text
                inpDettColore.Value = DirectCast(tmpRow.FindControl("lblColore"), Label).Text

                mView.ActiveViewIndex = 1
                CaricaListaAllegati()

                Exit For

            End If
        Next
    End Sub

    Protected Sub btnNuovoInserimento_Click(sender As Object, e As EventArgs) Handles btnNuovoInserimento.Click
        Session("IDTabella") = 0
        OpenModal("ModalInsMezzi")
        TitoloModale.Text = "NUOVO MEZZO"
        SvuotaCampi()
    End Sub

    Private Sub SALVA_MEZZO()
        Try

            Using connection As New SqlClient.SqlConnection(ConfigurationManager.ConnectionStrings("db_ncbConnectionString").ConnectionString)

                connection.Open()

                Dim uspText As String = ""

                If Session("idTabella") = 0 Then
                    uspText = "[usp_InsertMezzi]"
                Else
                    uspText = "[usp_UpdateMezzi]"
                End If

                Dim cmd As SqlClient.SqlCommand = New SqlClient.SqlCommand(uspText, connection)
                cmd.CommandType = CommandType.StoredProcedure

                cmd.Parameters.Clear()

                If Session("idTabella") <> 0 Then
                    cmd.Parameters.AddWithValue("@idMezzo", Session("idTabella"))
                End If


                If Session("idTabella") = 0 Then
                    cmd.Parameters.AddWithValue("@descrizione", txtDescrizione.Text)
                    cmd.Parameters.AddWithValue("@targa", txtTarga.Text)
                    cmd.Parameters.AddWithValue("@note", txtNote.Text)
                    cmd.Parameters.AddWithValue("@Colore", inpColor.Value)
                    Session("IDTabella") = 0
                Else
                    cmd.Parameters.AddWithValue("@descrizione", txtDettMezzo.Text)
                    cmd.Parameters.AddWithValue("@targa", txtDettTarga.Text)
                    cmd.Parameters.AddWithValue("@note", txtDettNote.Text)
                    cmd.Parameters.AddWithValue("@Colore", inpDettColore.Value)
                End If

                cmd.ExecuteNonQuery()

                connection.Close()

                mView.ActiveViewIndex = 0
                RicercaMezzi()
                showModal("SALVA", "DATI SALVATI CORRETTAMENTE")
            End Using
        Catch ex As Exception
            showModal("ERRORE", "ERRORE" & ex.Message)
        End Try
    End Sub

    Protected Sub btnSalvaDati_Click(sender As Object, e As EventArgs)
        SALVA_MEZZO()
    End Sub

    Protected Sub btnEsci_Click(sender As Object, e As EventArgs) Handles btnEsci.Click
        mView.ActiveViewIndex = 0
    End Sub

    Protected Sub btnModifica_Click(sender As Object, e As EventArgs) Handles btnModifica.Click
        SALVA_MEZZO()
    End Sub


    ' ----------------------------------------------------------------------------------------------------
    '-------------------------- CODICE PER CARICARE GLI ALLEGATI ----------------------------------------
    '----------------------------------------------------------------------------------------------------
    Protected Sub btnFinestaCaricaAllegato_Click(sender As Object, e As EventArgs) Handles btnFinestaCaricaAllegato.Click
        OpenModal("ModalAllegati")
    End Sub


    Protected Sub grdAllegatiManuale_PreRender(sender As Object, e As EventArgs) Handles grdAllegatiManuale.PreRender
        For Each tmpRow As GridViewRow In grdAllegatiManuale.Rows
            DirectCast(tmpRow.FindControl("imgDeleteAllegato"), ImageButton).CommandArgument = DirectCast(tmpRow.FindControl("lblidAllegato"), Label).Text
            DirectCast(tmpRow.FindControl("imgDeleteAllegato"), ImageButton).Attributes.Add("onclick", "javascript:return confirm('Proseguire con la cancellazione Allegato?');")
        Next
    End Sub
    Private Sub SalvaPersorsoAllegatoDB(ByVal varCodTipoAllegato As Integer, ByVal varDescrizione As String, ByVal varDirectory As String, ByVal varNomefile As String)

        Try

            Dim _BD As New BD_BindDataMain(oConn.ConnectionString(), False)
            Dim myGruppoParam As New SP_GruppoParametri()

            Dim tabControllata As String = Session("uploadTabella")
            Dim idRigaDaAllegareFile As Integer = Session("idTabella")

            myGruppoParam.Add(New SP_Parametro("@codTabella", 8, idRigaDaAllegareFile, DbType.Int32, ParameterDirection.Input))
            myGruppoParam.Add(New SP_Parametro("@TipoTabella", 50, tabControllata, DbType.String, ParameterDirection.Input))
            myGruppoParam.Add(New SP_Parametro("@codTipoAllegato", 8, varCodTipoAllegato, DbType.Int32, ParameterDirection.Input))
            myGruppoParam.Add(New SP_Parametro("@Descrizione", 4000, varDescrizione, DbType.String, ParameterDirection.Input))
            myGruppoParam.Add(New SP_Parametro("@Directory", 4000, varDirectory, DbType.String, ParameterDirection.Input))
            myGruppoParam.Add(New SP_Parametro("@NomeFile", 4000, varNomefile, DbType.String, ParameterDirection.Input))

            Dim tmpDT As DataTable = _BD.getDataTable("[usp_InsertAllegato]", myGruppoParam)


            If _BD.ErrorNumber <> 0 Then
                showModal("ERRORE", String.Format("Errore in fase di salvataggio dati allegato: {0} ({1}).", _BD.ErrorMessage, _BD.ErrorNumber))
            End If

        Catch ex As Exception
            showModal("ERRORE", String.Format("Errore in fase di salvataggio dati allegato: {0}.", ex.Message))
        End Try
    End Sub

    Public Sub CaricaListaAllegati()
        Try
            Dim _BD As New BD_BindDataMain(oConn.ConnectionString(), False)
            Dim myGruppoParam As New SP_GruppoParametri()

            Dim tabControllata As String = Session("uploadTabella")
            Dim idRigaDaAllegareFile As Integer = Session("idTabella")

            myGruppoParam.Add(New SP_Parametro("@codtabella", 8, idRigaDaAllegareFile, DbType.Int32, ParameterDirection.Input))
            myGruppoParam.Add(New SP_Parametro("@TipoTabella", 50, tabControllata, DbType.String, ParameterDirection.Input))


            Dim tmpDT As DataTable = _BD.getDataTable("[usp_RicercaAllegati]", myGruppoParam)
            If _BD.ErrorNumber <> 0 Then
                showModal("ERRORE", String.Format("Errore in fase di estrazione dati: {0} ({1}).", _BD.ErrorMessage, _BD.ErrorNumber))
            End If

            grdAllegatiManuale.DataSource = tmpDT
            grdAllegatiManuale.DataBind()

        Catch ex As Exception
            showModal("ERRORE", String.Format("Errore in fase di estrazione dati: {0}.", ex.Message))
        End Try
    End Sub

    Public Function ComponiNomeImgData(ByVal varNomeImg As String) As String
        ComponiNomeImgData = Now.Date.Year.ToString & _
                             Now.Date.Month.ToString & _
                             Now.Date.Day.ToString & _
                             Now.TimeOfDay.Hours.ToString & _
                             Now.TimeOfDay.Minutes.ToString & _
                             Now.TimeOfDay.Seconds.ToString & _
                             varNomeImg
        Return ComponiNomeImgData
    End Function
    Protected Sub btnUpload_Click(sender As Object, e As EventArgs) Handles btnUpload.Click
        Dim fileName As String = Path.GetFileName(uploadfiles1.FileName)
        Dim varCartellaUpload As String = ""



        Using connection As New SqlClient.SqlConnection(ConfigurationManager.ConnectionStrings("db_ncbConnectionString").ConnectionString)

            connection.Open()
            Dim command As SqlClient.SqlCommand = connection.CreateCommand()
            command.Connection = connection
            Try
                command.Parameters.Clear()
                command.CommandText = "SELECT DIRECTORY FROM ALLEGATOTIPO WHERE IDTIPOALLEGATO=@IDTIPOALLEGATO"

                command.Parameters.AddWithValue("@IDTIPOALLEGATO", drpTipoAllegato.SelectedValue)
                varCartellaUpload = command.ExecuteScalar()
                connection.Close()
                ' 
            Catch ex As Exception
                showModal("ERRORE", String.Format("ERRORE NELLA FASE DI UPLOAD DEL FILE: {0}.", ex.Message))
            End Try

        End Using

        If uploadfiles1.HasFile Then
            Try
                fileName = ComponiNomeImgData(fileName)


                uploadfiles1.SaveAs(Server.MapPath(varCartellaUpload) & fileName)
                System.Threading.Thread.Sleep(2000)

                showModal("SALVA", String.Format("FILE CARICATO CON SUCCESSO!"))

                SalvaPersorsoAllegatoDB(drpTipoAllegato.SelectedValue, drpTipoAllegato.SelectedItem.Text, varCartellaUpload, fileName)
                CaricaListaAllegati()

            Catch ex As Exception
                showModal("ERRORE", ex.Message)
            End Try
        Else

        End If
    End Sub

    Public Sub deleteAllegato(ByVal sender As Object, ByVal e As System.EventArgs)
        Dim imgBtn As ImageButton = sender
        Try
            For Each tmpRow As GridViewRow In grdAllegatiManuale.Rows
                If DirectCast(tmpRow.FindControl("imgDeleteAllegato"), ImageButton).CommandArgument.Equals(imgBtn.CommandArgument) Then

                    Dim strDirectory As String = DirectCast(tmpRow.FindControl("lblDirectory"), Label).Text
                    Dim strNomefile As String = DirectCast(tmpRow.FindControl("lblNomeFile"), Label).Text

                    File.Delete(Server.MapPath(strDirectory & strNomefile))

                    Dim _BD As New BD_BindDataMain(oConn.ConnectionString(), False)
                    Dim myGruppoParam As New SP_GruppoParametri()

                    myGruppoParam.Add(New SP_Parametro("@idAllegato", 8, imgBtn.CommandArgument, DbType.Int32, ParameterDirection.Input))

                    Dim tmpDT As DataTable = _BD.getDataTable("[usp_DeleteAllegato]", myGruppoParam)
                    If _BD.ErrorNumber <> 0 Then
                        showModal("ERRORE", String.Format("Errore in fase di cancellazione dati: {0} ({1}).", _BD.ErrorMessage, _BD.ErrorNumber))
                    End If

                    CaricaListaAllegati()

                End If
            Next
        Catch ex As Exception
            showModal("ERRORE", String.Format("Errore in fase di cancellazione dati: {0}.", ex.Message))
        End Try
    End Sub

End Class
