﻿Imports System.Data
Imports SP_NameSpace
Imports System.IO
Imports System.Data.SqlClient
Imports System.Collections.Generic
Imports System.Web
Imports System.Web.UI
Imports System.Web.UI.WebControls
Imports SelectPdf
Partial Class AR_NotaCreditoEmesseRicerca
    Inherits System.Web.UI.Page
    Private oConn As New SqlClient.SqlConnection(ConfigurationManager.ConnectionStrings("db_ncbConnectionString").ConnectionString)

    '*****************************************************************************************
    'INIZIO CODICE PER FINESTRA MODALE
    '*****************************************************************************************

    Public ClassTitoloModal As String = "modal-header alert alert-success"
    Public Sub showModal(ByVal Classe As String, ByVal corpo As String)
        Select Case Classe
            Case "SALVA"
                ClassTitoloModal = "modal-header alert alert-success"
                lblTitoloModale.Text = "SALVA"
            Case "ATTENZIONE"
                ClassTitoloModal = "modal-header alert alert-danger"
                lblTitoloModale.Text = "ATTENZIONE"
            Case "INFORMAZIONE"
                ClassTitoloModal = "modal-header alert alert-info"
                lblTitoloModale.Text = "INFORMAZIONE"
            Case "ERRORE"
                ClassTitoloModal = "modal-header alert alert-warning"
                lblTitoloModale.Text = "ERRORE"
        End Select

        lblCorpoModale.Text = corpo
        ScriptManager.RegisterStartupScript(Me.Page, Page.GetType, "HideLoginDialog", "<script type=""text/javascript"">$(document).ready(function () { $('#myMessage').modal('show');});</script>", False)

    End Sub

    Protected Sub btnCloseModal_Click(sender As Object, e As EventArgs)
        ScriptManager.RegisterStartupScript(Page, Page.[GetType](), "myModalHide", "$('#myMessage').hide();", True)
        ScriptManager.RegisterStartupScript(Page, Page.[GetType](), "myModalAgainShow", "$('#myMessage').modal();", True)
    End Sub
    '*****************************************************************************************
    'FINE CODICE PER FINESTRA MODALE
    '*****************************************************************************************

    Private Sub TitoloSezione(ByRef Titolo As String)
        Dim varTitoloezione As Label = DirectCast(Master.FindControl("lblTitoloSezione"), Label)
        varTitoloezione.Text = Titolo
    End Sub

    Private Sub CambiaTitoloMasterPage(ByVal Testo As String)
        DirectCast(Master.FindControl("lblTitoloSezione"), Label).Text = Testo
    End Sub

    Private Sub OpenModal(ByVal NomeDivModale As String)
        ScriptManager.RegisterStartupScript(Me.Page, Page.GetType, "HideLoginDialog", "<script type=""text/javascript"">$(document).ready(function () { $('#" & NomeDivModale & "').modal('show');});</script>", False)
    End Sub

    Protected Sub Page_Load(sender As Object, e As EventArgs) Handles Me.Load
        ConfigurationManager.AppSettings("ColoraIconaControllo") = "'icoElenconotecredito'"
        If Not IsPostBack Then
            Session("IDTabella") = 0
            Session("uploadTabella") = "TabNotaCreditoEmesse"
            CambiaTitoloMasterPage("NOTA DI CREDITO")

            inpDataInizio.Value = "01/01/" & Now.Date.Year
            inpDataFine.Value = Now.Date.ToShortDateString

            RicercaFatture()

            If Request.QueryString("opt") <> Nothing Then
                If Request.QueryString("opt") = "mod" Then

                    Session("IDTabella") = Request.QueryString("id")
                    hdfIdFattura.Value = Request.QueryString("id")
                    CaricaFattura(Request.QueryString("id"))

                    mView.ActiveViewIndex = 1
                End If
            Else
                mView.ActiveViewIndex = 0
            End If

        End If
    End Sub

    Protected Sub btnRicerca_ServerClick(sender As Object, e As EventArgs)
        RicercaFatture()
    End Sub

    Private Sub RicercaFatture()
        Dim _BD As New BD_BindDataMain(oConn.ConnectionString(), False)
        Dim myGruppoParam As New SP_GruppoParametri()

        myGruppoParam.Add(New SP_Parametro("@valore", 50, inpRicerca.Value, DbType.String, ParameterDirection.Input))
        myGruppoParam.Add(New SP_Parametro("@DataInizio", 10, CDate(inpDataInizio.Value.ToString), DbType.Date, ParameterDirection.Input))
        myGruppoParam.Add(New SP_Parametro("@DataFine", 10, CDate(inpDataFine.Value.ToString), DbType.Date, ParameterDirection.Input))

        Dim tmpDT As DataTable = _BD.getDataTable("[usp_RicercaNoteCreditoEmesse]", myGruppoParam)

        grdNotaDiCredito.DataSource = tmpDT
        grdNotaDiCredito.DataBind()
    End Sub

    Protected Sub btnEmesse_Click(sender As Object, e As EventArgs) Handles btnEmesse.Click
        Response.Redirect("NotaCreditoEmesseNuova.aspx")
    End Sub

    Protected Sub grdNotaDiCredito_PreRender(sender As Object, e As EventArgs) Handles grdNotaDiCredito.PreRender

        Dim UltimoIdFattura As Integer = 0
        Using ConnLog As New SqlClient.SqlConnection(ConfigurationManager.ConnectionStrings("db_ncbConnectionString").ConnectionString)
            ConnLog.Open()

            Dim CommandLog As SqlClient.SqlCommand = ConnLog.CreateCommand()
            CommandLog.Connection = ConnLog
            Try

                CommandLog.Parameters.Clear()
                CommandLog.CommandText = "SELECT TOP 1 idNotaCredito FROM NotaCreditoEmesse ORDER BY idNotaCredito DESC"
                UltimoIdFattura = CommandLog.ExecuteScalar()

                ConnLog.Close()

            Catch ex As Exception
                ConnLog.Close()
                showModal("ERRORE", String.Format("contattare l'Amministratore del Programma, " & vbCrLf & "{0}", ex))
            End Try
        End Using


        For Each tmpRow As GridViewRow In grdNotaDiCredito.Rows
            DirectCast(tmpRow.FindControl("imgDettaglio"), ImageButton).CommandArgument = DirectCast(tmpRow.FindControl("lblId"), Label).Text

            If UltimoIdFattura = DirectCast(tmpRow.FindControl("lblId"), Label).Text Then
                DirectCast(tmpRow.FindControl("imgDeleteFattura"), ImageButton).Visible = True
                DirectCast(tmpRow.FindControl("imgDeleteFattura"), ImageButton).CommandArgument = DirectCast(tmpRow.FindControl("lblId"), Label).Text
                DirectCast(tmpRow.FindControl("imgDeleteFattura"), ImageButton).Attributes.Add("onclick", "javascript:return confirm('Proseguire con la cancellazione?');")
            Else
                DirectCast(tmpRow.FindControl("imgDeleteFattura"), ImageButton).Visible = False
            End If


            If DirectCast(tmpRow.FindControl("lblEvasa"), Label).Text = False Then
                DirectCast(tmpRow.FindControl("imgFatturato"), Literal).Text = "<i class=""fa fa-toggle-off fa-2x"" style=""color:red;""/>"
            Else
                DirectCast(tmpRow.FindControl("imgFatturato"), Literal).Text = "<i class=""fa fa-toggle-off fa-2x"" style=""color:green;""/>"
            End If

        Next
    End Sub

    Public Sub CaricaFattura(ByVal varIdFattura As Integer)

        Session("idTabella") = varIdFattura
        hdfIdFattura.Value = varIdFattura

        Dim conn As SqlConnection = New SqlConnection
        conn.ConnectionString = ConfigurationManager.ConnectionStrings("db_ncbConnectionString").ConnectionString
        Dim cmd As SqlCommand = New SqlCommand
        cmd.CommandText = "select idNotaCredito, Data, Numero, CodAnagrafica, RagioneSociale, Indirizzo, PartitaIva, CodiceFiscale, Web, Imponibile, ImportoIva, ImportoRitenuta, ImportoFattura, Evasa  from " & _
        " NotaCreditoEmesse where idNotaCredito = @ID"
        cmd.Parameters.AddWithValue("@ID", varIdFattura)
        cmd.Connection = conn
        conn.Open()
        Dim employees As List(Of String) = New List(Of String)
        Dim sdr As SqlDataReader = cmd.ExecuteReader
        While sdr.Read
            inpDataFattura.Value = sdr("Data")
            txtNrNattura.Text = sdr("Numero")
            txtRagioneSociale.Text = sdr("RagioneSociale")
            TxtIndirizzo.Text = sdr("Indirizzo")
            txtPartitaIva.Text = sdr("PartitaIva")
            txtCodiceFiscale.Text = sdr("CodiceFiscale")
            txtWeb.Text = sdr("web")
            'lblImponibile.Text = sdr("Imponibile")
            lblIva.Text = sdr("ImportoIva")
            lblRitenuta.Text = sdr("ImportoRitenuta")
            lblImportoFattura.Text = sdr("ImportoFattura")
            If sdr("Evasa") = True Then
                lblSaldata.Text = "PAGATA"
                lblSaldata.ForeColor = System.Drawing.Color.Green
            Else
                lblSaldata.Text = "NON PAGATA"
                lblSaldata.ForeColor = System.Drawing.Color.Red
            End If
        End While
        conn.Close()

        Carica_Dettaglio_Fattura()

        CaricaListaPagamenti()
        CalcoloFattura()

        mView.ActiveViewIndex = 1

    End Sub


    Public Sub DettaglioAnagrafica(ByVal sender As Object, ByVal e As System.EventArgs)

        Dim imgBtn As ImageButton = sender
        For Each tmpRow As GridViewRow In grdNotaDiCredito.Rows
            If DirectCast(tmpRow.FindControl("imgDettaglio"), ImageButton).CommandArgument.Equals(imgBtn.CommandArgument) Then

                Session("idTabella") = imgBtn.CommandArgument
                hdfIdFattura.Value = imgBtn.CommandArgument
                CaricaFattura(imgBtn.CommandArgument)
                Carica_Dettaglio_Fattura()
            End If
        Next
    End Sub

    Private Sub Carica_Dettaglio_Fattura()
        grdLAvori.DataSource = GetData()
        grdLAvori.DataBind()
    End Sub

    Protected Sub grdLAvori_PreRender(sender As Object, e As EventArgs) Handles grdLAvori.PreRender
        For Each tmpRow As GridViewRow In grdLAvori.Rows
            DirectCast(tmpRow.FindControl("imgSelDetFat"), ImageButton).CommandArgument = DirectCast(tmpRow.FindControl("lblIdDettaglio"), Label).Text
            DirectCast(tmpRow.FindControl("imgDelDetFat"), ImageButton).CommandArgument = DirectCast(tmpRow.FindControl("lblIdDettaglio"), Label).Text
            DirectCast(tmpRow.FindControl("imgDelDetFat"), ImageButton).Attributes.Add("onclick", "javascript:return confirm('Proseguire con la cancellazione?');")

            DirectCast(tmpRow.FindControl("lblDescrizione"), Label).Text = Replace(DirectCast(tmpRow.FindControl("lblDescrizione"), Label).Text, "&lt;br/&gt;", "<br />")

        Next
    End Sub

    Public Sub Modifica_Dettaglio(ByVal sender As Object, ByVal e As System.EventArgs)

        'If lblSaldata.Text = "PAGATA" Then
        '    showModal("ATTENZIONE", "OPERAZIONE NON CONSENTITA. LA FATTURA E' PAGATA")
        '    Exit Sub
        'End If

        Svuota()
        Dim imgBtn As ImageButton = sender
        For Each tmpRow As GridViewRow In grdLAvori.Rows
            If DirectCast(tmpRow.FindControl("imgSelDetFat"), ImageButton).CommandArgument.Equals(imgBtn.CommandArgument) Then

                hdfIdDettaglioFattura.Value = imgBtn.CommandArgument

                txtCodice.Text = DirectCast(tmpRow.FindControl("lblCodice"), Label).Text
                txtDescrizione.Text = DirectCast(tmpRow.FindControl("lblDescrizione"), Label).Text
                txtQuantita.Text = DirectCast(tmpRow.FindControl("lblQuantita"), Label).Text
                txtImponibile.Text = DirectCast(tmpRow.FindControl("lblImponibile"), Label).Text
                txtIva.Text = DirectCast(tmpRow.FindControl("lblIva"), Label).Text
                txtRitenuta.Text = DirectCast(tmpRow.FindControl("lblRitenuta"), Label).Text

                OpenModal("myModal")

                Exit For
            End If
        Next
    End Sub

    Public Sub Elimina_Dettaglio(ByVal sender As Object, ByVal e As System.EventArgs)

        If lblSaldata.Text = "SALDATA" Then
            showModal("ATTENZIONE", "OPERAZIONE NON CONSENTITA. LA NOTA DI CREDITO E' SALDATA")
            Exit Sub
        End If

        Dim imgBtn As ImageButton = sender
        For Each tmpRow As GridViewRow In grdLAvori.Rows
            If DirectCast(tmpRow.FindControl("imgDelDetFat"), ImageButton).CommandArgument.Equals(imgBtn.CommandArgument) Then

                hdfIdDettaglioFattura.Value = imgBtn.CommandArgument

                Using ConnLog As New SqlClient.SqlConnection(ConfigurationManager.ConnectionStrings("db_ncbConnectionString").ConnectionString)
                    ConnLog.Open()

                    Dim CommandLog As SqlClient.SqlCommand = ConnLog.CreateCommand()
                    Dim transactionLog As SqlClient.SqlTransaction
                    transactionLog = ConnLog.BeginTransaction("Transactionlog")
                    CommandLog.Connection = ConnLog
                    CommandLog.Transaction = transactionLog

                    '     Try

                    CommandLog.Parameters.Clear()
                    CommandLog.CommandText = "DELETE NotaCreditoEmesseDettaglio WHERE idNCDEttaglio=@idNCDEttaglio"

                    CommandLog.Parameters.AddWithValue("@idNCDEttaglio", hdfIdDettaglioFattura.Value)
                    CommandLog.ExecuteNonQuery()

                    CommandLog.ExecuteNonQuery()
                    transactionLog.Commit()
                    ConnLog.Close()

                    Carica_Dettaglio_Fattura()
                    CalcoloFattura()
                    Salva_Fattura()

                    'Catch ex As Exception
                    '    showModal("ERRORE", String.Format("Ripristino Dati, " & vbCrLf & "{0}", ex))
                    '    Try
                    '        transactionLog.Rollback()
                    '    Catch ex2 As Exception
                    '        showModal("ERRORE", String.Format("Ripristino Dati, " & vbCrLf & "{0}", ex2))
                    '    End Try
                    'End Try
                End Using

                Exit For
            End If
        Next
    End Sub
    Private Function GetData() As DataTable
        Dim dt As New DataTable()
        Dim constr As String = ConfigurationManager.ConnectionStrings("db_ncbConnectionString").ConnectionString
        Dim sql As String = "SELECT * FROM NotaCreditoEmesseDettaglio where CodNotaCredito=" & hdfIdFattura.Value
        Using conn As New SqlConnection(constr)
            Using cmd As New SqlCommand(sql)
                cmd.Connection = conn
                Using sda As New SqlDataAdapter(cmd)
                    sda.Fill(dt)
                End Using
            End Using
        End Using

        Return dt
    End Function

    Private Sub Svuota()
        txtCodice.Text = ""
        txtDescrizione.Text = ""
        txtQuantita.Text = ""
        txtImponibile.Text = ""
        txtIva.Text = ""
        txtRitenuta.Text = ""
    End Sub
    Protected Sub btnAggiungiDettaglioFattura_Click(sender As Object, e As EventArgs) Handles btnAggiungiDettaglioFattura.Click

        If lblSaldata.Text = "SALDATA" Then
            showModal("ATTENZIONE", "OPERAZIONE NON CONSENTITA. LA NOTA DI CREDITO E' SALDATA")
            Exit Sub
        End If

        Svuota()
        hdfIdFattura.Value = Session("idTabella")
        hdfIdDettaglioFattura.Value = 0
        OpenModal("myModal")
    End Sub

    Public Sub btnSalvaDettaglioFattura(ByVal sender As Object, ByVal e As System.EventArgs)

        Using ConnLog As New SqlClient.SqlConnection(ConfigurationManager.ConnectionStrings("db_ncbConnectionString").ConnectionString)
            ConnLog.Open()

            Dim CommandLog As SqlClient.SqlCommand = ConnLog.CreateCommand()
            Dim transactionLog As SqlClient.SqlTransaction
            transactionLog = ConnLog.BeginTransaction("Transactionlog")
            CommandLog.Connection = ConnLog
            CommandLog.Transaction = transactionLog

            '    Try
            CommandLog.Parameters.Clear()
            CommandLog.CommandType = CommandType.StoredProcedure

            If hdfIdDettaglioFattura.Value = 0 Then
                CommandLog.CommandText = "usp_InsertDettaglioNotaCredito"
            Else
                CommandLog.CommandText = "usp_UpdateDettaglioNotaCredito"
                CommandLog.Parameters.AddWithValue("@IdFatDettaglio", hdfIdDettaglioFattura.Value)
            End If


            CommandLog.Parameters.AddWithValue("@Codice", txtCodice.Text)
            CommandLog.Parameters.AddWithValue("@Descrizione", txtDescrizione.Text)
            CommandLog.Parameters.AddWithValue("@Quantita", CDbl(txtQuantita.Text))
            CommandLog.Parameters.AddWithValue("@Imponibile", CDbl(txtImponibile.Text))
            CommandLog.Parameters.AddWithValue("@Iva", CDbl(txtIva.Text))
            CommandLog.Parameters.AddWithValue("@Ritenuta", CDbl(txtRitenuta.Text))
            CommandLog.Parameters.AddWithValue("@CodNotaCredito", CInt(hdfIdFattura.Value))

            Dim ImponibileTot As Double = CDbl(txtImponibile.Text) * CDbl(txtQuantita.Text)
            Dim ImportoIva As Double = (ImponibileTot * CDbl(txtIva.Text)) / 100
            Dim importoRit As Double = (ImponibileTot * CDbl(txtRitenuta.Text)) / 100

            CommandLog.Parameters.AddWithValue("@Importo", (ImponibileTot + ImportoIva - importoRit))


            CommandLog.ExecuteNonQuery()

            transactionLog.Commit()
            ConnLog.Close()

            Carica_Dettaglio_Fattura()
            CalcoloFattura()
            Salva_Fattura()


            'Catch ex As Exception
            '    showModal("ERRORE", String.Format("Ripristino Dati, " & vbCrLf & "{0}", ex))
            '    Try
            '        transactionLog.Rollback()
            '    Catch ex2 As Exception
            '        showModal("ERRORE", String.Format("Ripristino Dati, " & vbCrLf & "{0}", ex2))
            '    End Try
            'End Try
        End Using

    End Sub
    Private Sub Salva_Fattura()
        If grdLAvori.Rows.Count <= 0 Then
            showModal("ERRORE", "NESSUN DETTAGLIO DELLA NOTA DI CREDITO INSERITO")
            Exit Sub
        End If

        If txtRagioneSociale.Text.Length = 0 Then
            showModal("ERRORE", "INTESTAZIONE DELLA NOTA DI CREDITO NON INSERITA")
            Exit Sub
        End If



        Using ConnLog As New SqlClient.SqlConnection(ConfigurationManager.ConnectionStrings("db_ncbConnectionString").ConnectionString)
            ConnLog.Open()

            Dim CommandLog As SqlClient.SqlCommand = ConnLog.CreateCommand()
            Dim transactionLog As SqlClient.SqlTransaction
            transactionLog = ConnLog.BeginTransaction("Transactionlog")
            CommandLog.Connection = ConnLog
            CommandLog.Transaction = transactionLog

            '     Try

            CommandLog.Parameters.Clear()
            CommandLog.CommandText = "UPDATE NotaCreditoEmesse SET Imponibile=@Imponibile, ImportoIva=@ImportoIva, ImportoRitenuta=@ImportoRitenuta, " & _
                                     "ImportoFattura=@ImportoFattura, Evasa='0' WHERE idNotaCredito=@idNotaCredito"

            CommandLog.Parameters.AddWithValue("@Imponibile", CDbl(lblImponibileACC.Text) + CDbl(lblImponibilePRN.Text))
            CommandLog.Parameters.AddWithValue("@ImportoIva", CDbl(lblIva.Text))
            CommandLog.Parameters.AddWithValue("@ImportoRitenuta", CDbl(lblRitenuta.Text))
            CommandLog.Parameters.AddWithValue("@ImportoFattura", CDbl(lblImportoFattura.Text))
            CommandLog.Parameters.AddWithValue("@idNotaCredito", hdfIdFattura.Value)
            CommandLog.ExecuteNonQuery()

            CommandLog.ExecuteNonQuery()
            transactionLog.Commit()
            ConnLog.Close()

            showModal("SALVA", "NOTA DI CREDITO SALVATA CORRETTAMENTE")

            'Catch ex As Exception
            '    showModal("ERRORE", String.Format("Ripristino Dati, " & vbCrLf & "{0}", ex))
            '    Try
            '        transactionLog.Rollback()
            '    Catch ex2 As Exception
            '        showModal("ERRORE", String.Format("Ripristino Dati, " & vbCrLf & "{0}", ex2))
            '    End Try
            'End Try
        End Using
    End Sub
    Private Sub CalcoloFattura()
        lblImportoFattura.Text = "0,00"
        lblImponibilePRN.Text = "0,00"
        lblImponibileACC.Text = "0,00"
        lblIva.Text = "0,00"
        lblRitenuta.Text = "0,00"

        Dim ImponibileEsenteIva As Double = 0
        Dim ImportoFattura As Double = 0
        Dim ImponibilePRN As Double = 0
        Dim ImponibileACC As Double = 0
        Dim impIva As Double = 0
        Dim ImpRit As Double = 0

        For Each tmpRow As GridViewRow In grdLAvori.Rows

            If DirectCast(tmpRow.FindControl("lblCodice"), Label).Text = "ACC" Then
                ImponibileACC += CDbl(DirectCast(tmpRow.FindControl("lblImponibile"), Label).Text) * CDbl(DirectCast(tmpRow.FindControl("lblQuantita"), Label).Text)
            Else
                If CDbl(DirectCast(tmpRow.FindControl("lblIva"), Label).Text) <> 0 Then
                    ImponibilePRN += CDbl(DirectCast(tmpRow.FindControl("lblImponibile"), Label).Text) * CDbl(DirectCast(tmpRow.FindControl("lblQuantita"), Label).Text)
                Else
                    ImponibileEsenteIva += CDbl(DirectCast(tmpRow.FindControl("lblImponibile"), Label).Text) * CDbl(DirectCast(tmpRow.FindControl("lblQuantita"), Label).Text)
                End If

            End If

            impIva += (CDbl(DirectCast(tmpRow.FindControl("lblImponibile"), Label).Text) * CDbl(DirectCast(tmpRow.FindControl("lblIva"), Label).Text)) / 100
            ImpRit += (CDbl(DirectCast(tmpRow.FindControl("lblImponibile"), Label).Text) * CDbl(DirectCast(tmpRow.FindControl("lblRitenuta"), Label).Text)) / 100
            ImportoFattura += CDbl(DirectCast(tmpRow.FindControl("lblImporto"), Label).Text)

        Next

        lblImportoEsente.Text = ImponibileEsenteIva.ToString("N2")
        lblImportoFattura.Text = ImportoFattura.ToString("N2")
        lblImponibilePRN.Text = ImponibilePRN.ToString("N2")
        lblImponibileACC.Text = ImponibileACC.ToString("N2")
        lblIva.Text = impIva.ToString("N2")
        lblRitenuta.Text = ImpRit.ToString("N2")
    End Sub

    '------------------------------------------------------------------------------------------
    '--------------------------------------  SEZIONE PAGAMENTI --------------------------------
    '------------------------------------------------------------------------------------------

    Public Sub CalcoloPagamenti()
        Dim ImportoPagamenti As Double = 0
        For Each tmpRow As GridViewRow In grdPagamenti.Rows
            ImportoPagamenti += CDbl(DirectCast(tmpRow.FindControl("lblImporto"), Label).Text)
        Next
        lblImportoPagamenti.Text = ImportoPagamenti.ToString("N2")
    End Sub
    Protected Sub btnAggiungiPagamento_Click(sender As Object, e As EventArgs)
        OpenModal("modalPagamenti")
    End Sub

    Protected Sub grdPagamenti_PreRender(sender As Object, e As EventArgs) Handles grdPagamenti.PreRender
        For Each tmpRow As GridViewRow In grdPagamenti.Rows
            DirectCast(tmpRow.FindControl("imgDeletePagamenti"), ImageButton).CommandArgument = DirectCast(tmpRow.FindControl("lblIdPagamento"), Label).Text
            DirectCast(tmpRow.FindControl("imgDeletePagamenti"), ImageButton).Attributes.Add("onclick", "javascript:return confirm('Proseguire con la cancellazione del pagamento?');")
        Next
    End Sub

    Public Sub CaricaListaPagamenti()
        Try
            Dim _BD As New BD_BindDataMain(oConn.ConnectionString(), False)
            Dim myGruppoParam As New SP_GruppoParametri()

            Dim tabControllata As String = Session("uploadTabella")
            Dim idRigaDaAllegareFile As Integer = Session("idTabella")

            myGruppoParam.Add(New SP_Parametro("@codtabella", 8, idRigaDaAllegareFile, DbType.Int32, ParameterDirection.Input))
            myGruppoParam.Add(New SP_Parametro("@TipoTabella", 50, tabControllata, DbType.String, ParameterDirection.Input))


            Dim tmpDT As DataTable = _BD.getDataTable("[usp_RicercaPagamenti]", myGruppoParam)
            If _BD.ErrorNumber <> 0 Then
                showModal("ERRORE", String.Format("Errore in fase di estrazione dati: {0} ({1}).", _BD.ErrorMessage, _BD.ErrorNumber))
            End If

            grdPagamenti.DataSource = tmpDT
            grdPagamenti.DataBind()

            CalcoloPagamenti()

        Catch ex As Exception
            showModal("ERRORE", String.Format("Errore in fase di estrazione dati: {0}.", ex.Message))
        End Try
    End Sub

    Public Sub deleteDocumentoPagamenti(ByVal sender As Object, ByVal e As System.EventArgs)

        Dim imgBtn As ImageButton = sender
        Try
            For Each tmpRow As GridViewRow In grdPagamenti.Rows
                If DirectCast(tmpRow.FindControl("imgDeletePagamenti"), ImageButton).CommandArgument.Equals(imgBtn.CommandArgument) Then
                    Dim _BD As New BD_BindDataMain(oConn.ConnectionString(), False)
                    Dim myGruppoParam As New SP_GruppoParametri()

                    myGruppoParam.Add(New SP_Parametro("@idPagamento", 8, imgBtn.CommandArgument, DbType.Int32, ParameterDirection.Input))

                    Dim tmpDT As DataTable = _BD.getDataTable("[usp_DeletePagamento]", myGruppoParam)
                    If _BD.ErrorNumber <> 0 Then
                        showModal("ERRORE", String.Format("Errore in fase di cancellazione dati: {0} ({1}).", _BD.ErrorMessage, _BD.ErrorNumber))
                    Else

                        If lblSaldata.Text = "SALDATA" Then
                            lblSaldata.Text = "NON SALDATA"
                            lblSaldata.ForeColor = System.Drawing.Color.Red
                            Salva_Saldato(False)
                        End If
                        showModal("SALVA", String.Format("Pagamento Cancellato Correttamente"))

                    End If
                    CaricaListaPagamenti()
                End If
            Next
        Catch ex As Exception
            showModal("ERRORE", String.Format("Errore in fase di cancellazione dati: {0}.", ex.Message))
        End Try
    End Sub

    Protected Sub btnSalvaPagamento_Click(sender As Object, e As EventArgs)
        Try

            Dim varSaldo As Double = CDbl(lblImportoPagamenti.Text) + CDbl(txtImportoPagamento.Text)

            If varSaldo > CDbl(lblImportoFattura.Text) Then
                showModal("ERRORE", "NON E' POSSIBILE REGISTRARE UN IMPORTO MAGGIORE DEL SALDO")
                Exit Sub
            End If

            Dim _BD As New BD_BindDataMain(oConn.ConnectionString(), False)
            Dim myGruppoParam As New SP_GruppoParametri()

            Dim tabControllata As String = Session("uploadTabella")
            Dim idRigaDaAllegareFile As Integer = Session("idTabella")

            myGruppoParam.Add(New SP_Parametro("@Data", 10, CDate(inpDataPagamento.Value).Date, DbType.Date, ParameterDirection.Input))
            myGruppoParam.Add(New SP_Parametro("@Importo", 18, txtImportoPagamento.Text, DbType.Decimal, ParameterDirection.Input))
            myGruppoParam.Add(New SP_Parametro("@Modalita", 100, drpModalita.SelectedItem.Text, DbType.String, ParameterDirection.Input))
            myGruppoParam.Add(New SP_Parametro("@note", 4000, txtNote.Text, DbType.String, ParameterDirection.Input))
            myGruppoParam.Add(New SP_Parametro("@codtabella", 8, idRigaDaAllegareFile, DbType.Int32, ParameterDirection.Input))
            myGruppoParam.Add(New SP_Parametro("@tabella", 50, tabControllata, DbType.String, ParameterDirection.Input))

            Dim tmpDT As DataTable = _BD.getDataTable("[usp_InsertPagamento]", myGruppoParam)

            If _BD.ErrorNumber <> 0 Then
                showModal("ERRORE", String.Format("Errore in fase di salvataggio dati Pagamento: {0} ({1}).", _BD.ErrorMessage, _BD.ErrorNumber))
            Else
                If varSaldo = CDbl(lblImportoFattura.Text) Then
                    lblSaldata.Text = "SALDATA"
                    lblSaldata.ForeColor = System.Drawing.Color.Green
                    Salva_Saldato(True)
                End If
                showModal("SALVA", String.Format("Pagamento Registrato Correttamente"))
            End If

            CaricaListaPagamenti()

            inpDataPagamento.Value = Now.Date.ToShortDateString
            txtImportoPagamento.Text = ""
            drpModalita.SelectedIndex = 0
            txtNote.Text = ""


        Catch ex As Exception
            showModal("ERRORE", String.Format("Errore in fase di salvataggio dati Pagamento: {0}.", ex.Message))
        End Try
    End Sub


    Private Sub Salva_Saldato(ByVal Saldato As Boolean)
        Using ConnLog As New SqlClient.SqlConnection(ConfigurationManager.ConnectionStrings("db_ncbConnectionString").ConnectionString)


            ConnLog.Open()

            Dim CommandLog As SqlClient.SqlCommand = ConnLog.CreateCommand()
            Dim transactionLog As SqlClient.SqlTransaction
            transactionLog = ConnLog.BeginTransaction("Transactionlog")
            CommandLog.Connection = ConnLog
            CommandLog.Transaction = transactionLog

            Try
                CommandLog.Parameters.Clear()
                CommandLog.CommandText = "update NotaCreditoEmesse set Evasa='" & Saldato & "'  where idNotaCredito=" & Session("IdTabella")

                CommandLog.ExecuteNonQuery()
                transactionLog.Commit()
                ConnLog.Close()

            Catch ex As Exception
                showModal("ERRORE", "ERRORE INASPETTATO")
                Try
                    transactionLog.Rollback()
                Catch ex2 As Exception
                    showModal("ERRORE", String.Format("Ripristino Dati, " & vbCrLf & "{0}", ex2))
                End Try
            End Try
        End Using
    End Sub


    Protected Sub btnSalvaFattura_Click(sender As Object, e As EventArgs) Handles btnSalvaFattura.Click
        ' get parameters
        'Dim headerUrl As String = "http://gestionalencb.it/_Header1.aspx"
        Dim footerUrl As String = "http://gestionalencb.it/_NC_Footer2.aspx?idf=" & Session("IDTabella")

        'Dim showHeaderOnFirstPage As Boolean = True
        'Dim showHeaderOnOddPages As Boolean = True
        'Dim showHeaderOnEvenPages As Boolean = True

        Dim showFooterOnFirstPage As Boolean = True
        Dim showFooterOnOddPages As Boolean = True
        Dim showFooterOnEvenPages As Boolean = True

        'Dim headerHeight As Integer = 80
        Dim footerHeight As Integer = 150

        ' instantiate a html to pdf converter object
        Dim Converter As New HtmlToPdf

        ' header settings
        'Converter.Options.DisplayHeader = showHeaderOnFirstPage OrElse _
        '       showHeaderOnOddPages OrElse showHeaderOnEvenPages
        'Converter.Header.DisplayOnFirstPage = showHeaderOnFirstPage
        'Converter.Header.DisplayOnOddPages = showHeaderOnOddPages
        'Converter.Header.DisplayOnEvenPages = showHeaderOnEvenPages
        'Converter.Header.Height = headerHeight

        'Dim headerHtml As New PdfHtmlSection(headerUrl)
        'headerHtml.AutoFitHeight = HtmlToPdfPageFitMode.AutoFit
        'Converter.Header.Add(headerHtml)

        ' footer settings
        Converter.Options.DisplayFooter = showFooterOnFirstPage OrElse _
            showFooterOnOddPages OrElse showFooterOnEvenPages
        Converter.Footer.DisplayOnFirstPage = showFooterOnFirstPage
        Converter.Footer.DisplayOnOddPages = showFooterOnOddPages
        Converter.Footer.DisplayOnEvenPages = showFooterOnEvenPages
        Converter.Footer.Height = footerHeight

        Dim footerHtml As New PdfHtmlSection(footerUrl)
        footerHtml.AutoFitHeight = HtmlToPdfPageFitMode.AutoFit
        Converter.Footer.Add(footerHtml)

        ' page numbers can be added using a PdfTextSection object
        Dim text As New PdfTextSection(0, 83, "Pag. {page_number} of {total_pages}     ", _
                                              New System.Drawing.Font("Arial", 8))
        text.HorizontalAlign = PdfTextHorizontalAlign.Right
        Converter.Footer.Add(text)

        Dim doc As PdfDocument = Converter.ConvertUrl("http://gestionalencb.it/NotadiCreditoPDF2.aspx?idf=" & Session("IDTabella"))
        doc.Save(Response, False, "NC-NR." & txtNrNattura.Text & ".pdf")
        doc.Close()
    End Sub

    Protected Sub btnModificaData_Click(sender As Object, e As EventArgs) Handles btnModificaData.Click
        If btnModificaData.Text = "Modifica" Then
            btnModificaData.Text = "Salva"
            btnModificaData.CssClass = "btn btn-success"
            inpDataFattura.Disabled = False
        Else


            Using ConnLog As New SqlClient.SqlConnection(ConfigurationManager.ConnectionStrings("db_ncbConnectionString").ConnectionString)
                ConnLog.Open()

                Dim CommandLog As SqlClient.SqlCommand = ConnLog.CreateCommand()
                Dim transactionLog As SqlClient.SqlTransaction
                transactionLog = ConnLog.BeginTransaction("Transactionlog")
                CommandLog.Connection = ConnLog
                CommandLog.Transaction = transactionLog

                Try

                    'CommandLog.Parameters.Clear()
                    'CommandLog.CommandText = "SELECT COUNT(IDFATTURA) FROM FATTURAATTIVA WHERE DATA > @Data"
                    'CommandLog.Parameters.AddWithValue("@Data", CDate(inpDataFattura.Value))
                    'Dim objExecuteNrFatture As Object = CommandLog.ExecuteScalar

                    'If objExecuteNrFatture > 0 Then
                    '    showModal("ERORE", "LA DATA DELLA FATTURA NON PUO' ESSERE INFERIORE ALLA DATA DELLE FATTURE GIA' EMESSE")
                    '    transactionLog.Commit()
                    '    ConnLog.Close()
                    '    Exit Sub
                    'End If

                    CommandLog.Parameters.Clear()
                    CommandLog.CommandText = "UPDATE NotaCreditoEmesse SET DATA=@DATA WHERE idNotaCredito=@idNotaCredito"
                    CommandLog.Parameters.AddWithValue("@DATA", CDate(inpDataFattura.Value))
                    CommandLog.Parameters.AddWithValue("@idNotaCredito", CInt(Session("idTabella")))

                    CommandLog.ExecuteNonQuery()

                    transactionLog.Commit()
                    ConnLog.Close()

                    btnModificaData.Text = "Modifica"
                    inpDataFattura.Disabled = True
                    btnModificaData.CssClass = "btn btn-Primary"

                    showModal("SALVA", "DATA NOTA DI CREDITO MODIFICATA")

                Catch ex As Exception
                    showModal("ERORE", String.Format("Ripristino Dati, " & vbCrLf & "{0}", ex))
                    Try
                        transactionLog.Rollback()
                    Catch ex2 As Exception
                        showModal("ERORE", String.Format("Ripristino Dati, " & vbCrLf & "{0}", ex2))
                    End Try
                End Try
            End Using
        End If
    End Sub

    Protected Sub imgDeleteFattura_Click(sender As Object, e As ImageClickEventArgs)

        Dim imgBtn As ImageButton = sender
        For Each tmpRow As GridViewRow In grdNotaDiCredito.Rows
            If DirectCast(tmpRow.FindControl("imgDeletefATTURA"), ImageButton).CommandArgument.Equals(imgBtn.CommandArgument) Then

                Dim UltimoIdFattura As Integer = 0
                Using ConnLog As New SqlClient.SqlConnection(ConfigurationManager.ConnectionStrings("db_ncbConnectionString").ConnectionString)
                    ConnLog.Open()

                    Dim CommandLog As SqlClient.SqlCommand = ConnLog.CreateCommand()
                    CommandLog.Connection = ConnLog
                    Try

                        CommandLog.Parameters.Clear()
                        CommandLog.CommandText = "SELECT COUNT(CodNotaCredito) FROM NotaCreditoEmesseDettaglio WHERE CodNotaCredito=@CodNotaCredito"
                        CommandLog.Parameters.AddWithValue("@CodNotaCredito", CInt(imgBtn.CommandArgument))
                        UltimoIdFattura = CommandLog.ExecuteScalar()

                        Dim objExecuteNrFatture As Object = CommandLog.ExecuteScalar
                        If objExecuteNrFatture = 0 Then

                            CommandLog.Parameters.Clear()
                            CommandLog.CommandText = "DELETE NotaCreditoEmesse WHERE idNotaCredito=@idNotaCredito; DELETE NotaCreditoEmesseDettaglio WHERE CodNotaCredito=@idNotaCredito"
                            CommandLog.Parameters.AddWithValue("@idNotaCredito", CInt(imgBtn.CommandArgument))
                            CommandLog.ExecuteNonQuery()
                            ConnLog.Close()

                            showModal("SALVA", "NOTA DI CREDITO ELIMINATA CORRETTAMENTE")

                            RicercaFatture()

                        Else
                            ConnLog.Close()
                            showModal("ATTENZIONE", "IMPOSSIBILE CANCELLARE LA NOTA DI CREDITO - ELIMINARE IL DETTAGLIO PER POTER ESEGUIRE L'OPERAZIONE")
                        End If

                    Catch ex As Exception
                        ConnLog.Close()
                        showModal("ERRORE", String.Format("contattare l'Amministratore del Programma, " & vbCrLf & "{0}", ex))
                    End Try
                End Using
            End If
        Next
    End Sub


End Class
