﻿Imports System.Data
Imports System.Data.SqlClient
Imports SelectPdf

Partial Class AR_OrdineDiServizio
    Inherits System.Web.UI.Page
    '*****************************************************************************************
    'INIZIO CODICE PER FINESTRA MODALE
    '*****************************************************************************************

    Public ClassTitoloModal As String = "modal-header alert alert-success"
    Public Sub showModal(ByVal Classe As String, ByVal corpo As String)
        Select Case Classe
            Case "SALVA"
                ClassTitoloModal = "modal-header alert alert-success"
                lblTitoloModale.Text = "SALVA"
            Case "ATTENZIONE"
                ClassTitoloModal = "modal-header alert alert-danger"
                lblTitoloModale.Text = "ATTENZIONE"
            Case "INFORMAZIONE"
                ClassTitoloModal = "modal-header alert alert-info"
                lblTitoloModale.Text = "INFORMAZIONE"
            Case "ERRORE"
                ClassTitoloModal = "modal-header alert alert-warning"
                lblTitoloModale.Text = "ERRORE"
        End Select

        lblCorpoModale.Text = corpo
        ScriptManager.RegisterStartupScript(Me.Page, Page.GetType, "HideLoginDialog", "<script type=""text/javascript"">$(document).ready(function () { $('#myMessage').modal('show');});</script>", False)

    End Sub

    Protected Sub btnCloseModal_Click(sender As Object, e As EventArgs)
        ScriptManager.RegisterStartupScript(Page, Page.[GetType](), "myModalHide", "$('#myMessage').hide();", True)
        ScriptManager.RegisterStartupScript(Page, Page.[GetType](), "myModalAgainShow", "$('#myMessage').modal();", True)
    End Sub
    '*****************************************************************************************
    'FINE CODICE PER FINESTRA MODALE
    '*****************************************************************************************
    Private Function GetData() As DataTable
        Dim dt As New DataTable()
        Dim constr As String = ConfigurationManager.ConnectionStrings("db_ncbConnectionString").ConnectionString

        Using conn As New SqlConnection(constr)
            Dim cmd As SqlCommand = New SqlCommand
            cmd.CommandText = "SELECT * FROM vw_OrdineDiServizio where (Convert(nvarchar(10), DataInizio, 101)<=@DataRicerca1 AND Convert(nvarchar(10), DataFine, 101)>=@DataRicerca2) AND  (Autista LIKE @Autista + '%') order by autista, datainizio"
            cmd.Parameters.AddWithValue("@DataRicerca1", CDate(inpData.Value))
            cmd.Parameters.AddWithValue("@DataRicerca2", CDate(inpData.Value))
            cmd.Parameters.AddWithValue("@Autista", inpRicerca.Value)
            cmd.Connection = conn
            Using sda As New SqlDataAdapter(cmd)
                sda.Fill(dt)
            End Using
        End Using

        Return dt
    End Function

    Protected Sub btnRicercaAutista(sender As Object, e As EventArgs)
        InizializzaGriglia()
    End Sub

    Protected Sub Page_Load(sender As Object, e As EventArgs) Handles Me.Load
        ConfigurationManager.AppSettings("ColoraIconaControllo") = "'icoOrdineDiServizio'"
        If Not IsPostBack Then
            inpData.Value = Now.Date.ToShortDateString
            DirectCast(Master.FindControl("lblTitoloSezione"), Label).Text = "ORDINE DI SERVIZIO "

            InizializzaGriglia()

        End If
    End Sub


    Private Sub InizializzaGriglia()
        grdPrenotazioni.DataSource = GetData()
        grdPrenotazioni.DataBind()

        'If grdPrenotazioni.Rows.Count > 0 Then
        '    btnStampaPdf.Visible = True
        'Else
        '    btnStampaPdf.Visible = False
        'End If
    End Sub

    'Protected Sub btnStampaPdf_ServerClick(sender As Object, e As EventArgs)
    '    Dim RicordaIdAutista As Integer = 0
    '    For Each tmpRow As GridViewRow In grdPrenotazioni.Rows
    '        If DirectCast(tmpRow.FindControl("lblidAutisti"), Label).Text.Trim <> RicordaIdAutista Then
    '            RicordaIdAutista = DirectCast(tmpRow.FindControl("lblidAutisti"), Label).Text.Trim

    '            CreaPDF(RicordaIdAutista, DirectCast(tmpRow.FindControl("lblAutista"), Label).Text)

    '        End If
    '    Next
    'End Sub

    Protected Sub CreaPDF(ByVal varIdAutista As Integer, ByVal varAutista As String)
        ' get parameters
        'Dim headerUrl As String = "http://gestionalencb.it/_Header1.aspx"
        Dim footerUrl As String = "http://gestionalencb.it/_FooterServizio.aspx"

        'Dim showHeaderOnFirstPage As Boolean = True
        'Dim showHeaderOnOddPages As Boolean = True
        'Dim showHeaderOnEvenPages As Boolean = True

        Dim showFooterOnFirstPage As Boolean = True
        Dim showFooterOnOddPages As Boolean = True
        Dim showFooterOnEvenPages As Boolean = True

        'Dim headerHeight As Integer = 80
        Dim footerHeight As Integer = 150

        ' instantiate a html to pdf converter object
        Dim Converter As New HtmlToPdf

        ' header settings
        'Converter.Options.DisplayHeader = showHeaderOnFirstPage OrElse _
        '       showHeaderOnOddPages OrElse showHeaderOnEvenPages
        'Converter.Header.DisplayOnFirstPage = showHeaderOnFirstPage
        'Converter.Header.DisplayOnOddPages = showHeaderOnOddPages
        'Converter.Header.DisplayOnEvenPages = showHeaderOnEvenPages
        'Converter.Header.Height = headerHeight

        'Dim headerHtml As New PdfHtmlSection(headerUrl)
        'headerHtml.AutoFitHeight = HtmlToPdfPageFitMode.AutoFit
        'Converter.Header.Add(headerHtml)

        ' footer settings
        Converter.Options.DisplayFooter = showFooterOnFirstPage OrElse _
            showFooterOnOddPages OrElse showFooterOnEvenPages
        Converter.Footer.DisplayOnFirstPage = showFooterOnFirstPage
        Converter.Footer.DisplayOnOddPages = showFooterOnOddPages
        Converter.Footer.DisplayOnEvenPages = showFooterOnEvenPages
        Converter.Footer.Height = footerHeight

        Dim footerHtml As New PdfHtmlSection(footerUrl)
        footerHtml.AutoFitHeight = HtmlToPdfPageFitMode.AutoFit
        Converter.Footer.Add(footerHtml)

        ' page numbers can be added using a PdfTextSection object
        Dim text As New PdfTextSection(0, 83, "Pag. {page_number} of {total_pages}     ", _
                                              New System.Drawing.Font("Arial", 8))
        text.HorizontalAlign = PdfTextHorizontalAlign.Right
        Converter.Footer.Add(text)

        Dim doc As PdfDocument = Converter.ConvertUrl("http://gestionalencb.it/OrdineServizioPDF.aspx?idAutista=" & varIdAutista & "&data=" & inpData.Value & "&autista=" & varAutista)
        doc.Save(Response, False, "Servizio-" & inpData.Value & "-" & varAutista & ".pdf")
        doc.Close()
    End Sub

    Protected Sub grdPrenotazioni_PreRender(sender As Object, e As EventArgs) Handles grdPrenotazioni.PreRender
        Dim ricordaIdAutista As Integer = 0
        For Each tmpRow As GridViewRow In grdPrenotazioni.Rows
            If DirectCast(tmpRow.FindControl("lblidAutisti"), Label).Text.Trim <> ricordaIdAutista Then
                DirectCast(tmpRow.FindControl("imgPrint"), ImageButton).Visible = True
                DirectCast(tmpRow.FindControl("imgPrint"), ImageButton).CommandArgument = DirectCast(tmpRow.FindControl("lblidAutisti"), Label).Text
                ricordaIdAutista = DirectCast(tmpRow.FindControl("lblidAutisti"), Label).Text.Trim
            Else
                DirectCast(tmpRow.FindControl("imgPrint"), Image).Visible = False
            End If
        Next
    End Sub

    Protected Sub imgPrint_Click(sender As Object, e As ImageClickEventArgs)
        Dim imgBtn As ImageButton = sender
        For Each tmpRow As GridViewRow In grdPrenotazioni.Rows
            If DirectCast(tmpRow.FindControl("imgPrint"), ImageButton).CommandArgument.Equals(imgBtn.CommandArgument) Then
                CreaPDF(DirectCast(tmpRow.FindControl("lblidAutisti"), Label).Text, DirectCast(tmpRow.FindControl("lblAutista"), Label).Text)
            End If
        Next
    End Sub
End Class
