﻿Imports System.Data
Imports System.IO
Imports System.Net.Mail

Partial Class AR_PagamentiEmail
    Inherits System.Web.UI.Page

    '*****************************************************************************************
    'INIZIO CODICE PER FINESTRA MODALE
    '*****************************************************************************************

    Public ClassTitoloModal As String = "modal-header alert alert-success"
    Public Sub showModal(ByVal Classe As String, ByVal corpo As String)
        Select Case Classe
            Case "SALVA"
                ClassTitoloModal = "modal-header alert alert-success"
                lblTitoloModale.Text = "SALVA"
            Case "ATTENZIONE"
                ClassTitoloModal = "modal-header alert alert-danger"
                lblTitoloModale.Text = "ATTENZIONE"
            Case "INFORMAZIONE"
                ClassTitoloModal = "modal-header alert alert-info"
                lblTitoloModale.Text = "INFORMAZIONE"
            Case "ERRORE"
                ClassTitoloModal = "modal-header alert alert-warning"
                lblTitoloModale.Text = "ERRORE"
        End Select

        lblCorpoModale.Text = corpo
        ScriptManager.RegisterStartupScript(Me.Page, Page.GetType, "HideLoginDialog", "<script type=""text/javascript"">$(document).ready(function () { $('#myMessage').modal('show');});</script>", False)

    End Sub

    Protected Sub btnCloseModal_Click(sender As Object, e As EventArgs)
        ScriptManager.RegisterStartupScript(Page, Page.[GetType](), "myModalHide", "$('#myMessage').hide();", True)
        ScriptManager.RegisterStartupScript(Page, Page.[GetType](), "myModalAgainShow", "$('#myMessage').modal();", True)
    End Sub
    '*****************************************************************************************
    'FINE CODICE PER FINESTRA MODALE
    '*****************************************************************************************
    Private Sub TitoloSezione(ByRef Titolo As String)
        Dim varTitoloezione As Label = DirectCast(Master.FindControl("lblTitoloSezione"), Label)
        varTitoloezione.Text = Titolo
    End Sub
    Protected Sub Page_Load(sender As Object, e As EventArgs) Handles Me.Load
        ConfigurationManager.AppSettings("ColoraIconaControllo") = "'icoDatiAzienda'"
        If Not IsPostBack Then
            Session("IDTabella") = 1
            Session("uploadTabella") = "tabDatiAzienda"
            TitoloSezione("PAGAMENTI / EMAIL")
            VERIDICAEMAIL()
            '  SezPagamenti.Attributes.Add("class", "card card-featured card-featured-primary card-collapcardsed card-collapsed")
            ' ltrDiv.Text = " <div id=""divChiusura"" runat=""server""  class=""card-actions""><a href=""#"" class=""card-action card-action-toggle"" data-card-toggle></a></div>"
        Else
            ' SezPagamenti.Attributes.Add("class", "card card-featured card-featured-primary card-collapcardsed")
        End If
    End Sub

   
    Private Sub VERIDICAEMAIL()
        Using ConnLog As New SqlClient.SqlConnection(ConfigurationManager.ConnectionStrings("db_ncbConnectionString").ConnectionString)
            ConnLog.Open()

            Dim CommandLog As SqlClient.SqlCommand = ConnLog.CreateCommand()
            Dim transactionLog As SqlClient.SqlTransaction
            transactionLog = ConnLog.BeginTransaction("Transactionlog")
            CommandLog.Connection = ConnLog
            CommandLog.Transaction = transactionLog

            '  Try
            CommandLog.Parameters.Clear()
            CommandLog.CommandText = "SELECT COUNT(idEmail) FROM DatiEmail"
            Dim objExecute As Object = CommandLog.ExecuteScalar

            If objExecute = 0 Then
                CommandLog.Parameters.Clear()
                CommandLog.CommandText = "INSERT INTO DatiEmail (IndirizzoEmail, NomeMittente, Sicurezza, ServerSMTP, Porta, Username, Password) VALUES " & _
                                         "('', '', '', '', '', '', '')"
                CommandLog.ExecuteNonQuery()
            End If

            CARICA_DETTAGLIO_EMAIL()

            transactionLog.Commit()
            ConnLog.Close()

            'Catch ex As Exception
            '    showModal("ERORE", String.Format("Ripristino Dati, " & vbCrLf & "{0}", ex))
            '    Try
            '        transactionLog.Rollback()
            '    Catch ex2 As Exception
            '        showModal("ERORE", String.Format("Ripristino Dati, " & vbCrLf & "{0}", ex2))
            '    End Try
            'End Try
        End Using
    End Sub
    Private Sub CARICA_DETTAGLIO_EMAIL()
        Dim strSQL As String = "SELECT * FROM DatiEmail WHERE idEmail=2"
        Dim CompensiAdapter As New SqlClient.SqlDataAdapter
        Dim nwindConn As New SqlClient.SqlConnection(ConfigurationManager.ConnectionStrings("db_ncbConnectionString").ConnectionString)
        Dim selectCMD As New SqlClient.SqlCommand(strSQL, nwindConn)
        CompensiAdapter.SelectCommand = selectCMD

        Dim dsCompensi As New DataSet
        CompensiAdapter.Fill(dsCompensi, "DatiEmail")
        Dim compensiRow As DataRow

        If dsCompensi.Tables("DatiEmail").Rows.Count > 0 Then
            Dim conta As Integer = 0
            For Each compensiRow In dsCompensi.Tables("DatiEmail").Rows
                txtIndirizzoEmail.Text = compensiRow("IndirizzoEmail").ToString
                txtMittente.Text = compensiRow("NomeMittente").ToString

                Try
                    drpSicurezza.SelectedValue = compensiRow("Sicurezza").ToString
                Catch ex As Exception
                End Try

                txtSmtp.Text = compensiRow("ServerSMTP").ToString
                txtPorta.Text = compensiRow("Porta").ToString
                txtUsername.Text = compensiRow("Username").ToString
                txtPassword.Text = compensiRow("Password")

            Next
        End If
    End Sub


    Protected Sub btnSalvaEmail_Click(sender As Object, e As EventArgs) Handles btnSalvaEmail.Click
        Using ConnLog As New SqlClient.SqlConnection(ConfigurationManager.ConnectionStrings("db_ncbConnectionString").ConnectionString)
            ConnLog.Open()

            Dim CommandLog As SqlClient.SqlCommand = ConnLog.CreateCommand()
            Dim transactionLog As SqlClient.SqlTransaction
            transactionLog = ConnLog.BeginTransaction("Transactionlog")
            CommandLog.Connection = ConnLog
            CommandLog.Transaction = transactionLog

            Try

                CommandLog.Parameters.Clear()
                CommandLog.CommandText = "UPDATE DatiEmail SET IndirizzoEmail=@IndirizzoEmail, NomeMittente=@NomeMittente, Sicurezza=@Sicurezza, " & _
                                         "ServerSMTP=@ServerSMTP, Porta=@Porta, Username=@Username, Password=@Password " & _
                                         "WHERE idEmail=2"

                CommandLog.Parameters.AddWithValue("@IndirizzoEmail", txtIndirizzoEmail.Text.Trim)
                CommandLog.Parameters.AddWithValue("@NomeMittente", txtMittente.Text.Trim)
                CommandLog.Parameters.AddWithValue("@Sicurezza", drpSicurezza.SelectedValue)
                CommandLog.Parameters.AddWithValue("@ServerSMTP", txtSmtp.Text.Trim)
                CommandLog.Parameters.AddWithValue("@Porta", txtPorta.Text.Trim)
                CommandLog.Parameters.AddWithValue("@Username", txtUsername.Text.Trim)
                CommandLog.Parameters.AddWithValue("@Password", txtPassword.Text.Trim)

                CommandLog.ExecuteNonQuery()

                transactionLog.Commit()
                ConnLog.Close()

                CARICA_DETTAGLIO_EMAIL()

                showModal("SALVA", "DATI SALVATI CORRETTAMENTE")

            Catch ex As Exception
                showModal("ERORE", String.Format("Ripristino Dati, " & vbCrLf & "{0}", ex))
                Try
                    transactionLog.Rollback()
                Catch ex2 As Exception
                    showModal("ERORE", String.Format("Ripristino Dati, " & vbCrLf & "{0}", ex2))
                End Try
            End Try
        End Using
    End Sub

    Protected Sub btnEliminaEmail_ServerClick(sender As Object, e As EventArgs)
        Using ConnLog As New SqlClient.SqlConnection(ConfigurationManager.ConnectionStrings("db_ncbConnectionString").ConnectionString)
            ConnLog.Open()

            Dim CommandLog As SqlClient.SqlCommand = ConnLog.CreateCommand()
            Dim transactionLog As SqlClient.SqlTransaction
            transactionLog = ConnLog.BeginTransaction("Transactionlog")
            CommandLog.Connection = ConnLog
            CommandLog.Transaction = transactionLog

            Try

                CommandLog.Parameters.Clear()
                CommandLog.CommandText = "UPDATE DatiEmail SET IndirizzoEmail=@IndirizzoEmail, NomeMittente=@NomeMittente, Sicurezza=@Sicurezza, " & _
                                         "ServerSMTP=@ServerSMTP, Porta=@Porta, Username=@Username, Password=@Password " & _
                                         "WHERE idEmail=2"

                CommandLog.Parameters.AddWithValue("@IndirizzoEmail", "")
                CommandLog.Parameters.AddWithValue("@NomeMittente", "")
                CommandLog.Parameters.AddWithValue("@Sicurezza", "")
                CommandLog.Parameters.AddWithValue("@ServerSMTP", "")
                CommandLog.Parameters.AddWithValue("@Porta", "")
                CommandLog.Parameters.AddWithValue("@Username", "")
                CommandLog.Parameters.AddWithValue("@Password", "")

                CommandLog.ExecuteNonQuery()

                transactionLog.Commit()
                ConnLog.Close()

                CARICA_DETTAGLIO_EMAIL()

                showModal("SALVA", "DATI EMAIL CANCELLATI CORRETTAMENTE")

            Catch ex As Exception
                showModal("ERORE", String.Format("Ripristino Dati, " & vbCrLf & "{0}", ex))
                Try
                    transactionLog.Rollback()
                Catch ex2 As Exception
                    showModal("ERORE", String.Format("Ripristino Dati, " & vbCrLf & "{0}", ex2))
                End Try
            End Try
        End Using
    End Sub
   
    Protected Sub btnVerifica_ServerClick(sender As Object, e As EventArgs)
        Dim strSQL As String = "SELECT * FROM DatiEmail WHERE idEmail=2"
        Dim CompensiAdapter As New SqlClient.SqlDataAdapter
        Dim nwindConn As New SqlClient.SqlConnection(ConfigurationManager.ConnectionStrings("db_ncbConnectionString").ConnectionString)
        Dim selectCMD As New SqlClient.SqlCommand(strSQL, nwindConn)
        CompensiAdapter.SelectCommand = selectCMD

        Dim dsCompensi As New DataSet
        CompensiAdapter.Fill(dsCompensi, "DatiEmail")
        Dim compensiRow As DataRow

        If dsCompensi.Tables("DatiEmail").Rows.Count > 0 Then
            Dim conta As Integer = 0
            For Each compensiRow In dsCompensi.Tables("DatiEmail").Rows

                Dim mail As System.Net.Mail.MailMessage = New System.Net.Mail.MailMessage()
                mail.To.Add(compensiRow("IndirizzoEmail").ToString)
                mail.From = New MailAddress(compensiRow("IndirizzoEmail").ToString, compensiRow("NomeMittente").ToString, System.Text.Encoding.UTF8)
                mail.Subject = "Email di Verifica - Nova Bus"
                mail.SubjectEncoding = System.Text.Encoding.UTF8
                mail.Body = "Questa email è stata inviata per verificare le esatte impostazioni dell'account"
                mail.BodyEncoding = System.Text.Encoding.UTF8
                mail.IsBodyHtml = True
                'mail.Priority = MailPriority.Normal
                Dim client As SmtpClient = New SmtpClient(compensiRow("ServerSMTP").ToString, compensiRow("Porta").ToString)

                If compensiRow("Sicurezza").ToString <> "Standard" Then
                    client.EnableSsl = True
                Else
                    client.EnableSsl = False
                End If


                client.UseDefaultCredentials = False
                client.Credentials = New System.Net.NetworkCredential(compensiRow("Username").ToString, compensiRow("Password").ToString)
                client.DeliveryMethod = SmtpDeliveryMethod.Network
                Try
                    client.Send(mail)
                    showModal("INFORMAZIONE", "L'EMAIL DI VERIFICA E' STATA INVIATA CON SUCCESSO")
                Catch ex As Exception
                    showModal("ERRORE", ex.Message)
                End Try
            Next
        End If
    End Sub
End Class
