﻿Imports System.Data
Imports SP_NameSpace
Imports System.IO
Imports System.Data.SqlClient

Partial Class AR_Scadenzario
    Inherits System.Web.UI.Page
    Private oConn As New SqlClient.SqlConnection(ConfigurationManager.ConnectionStrings("db_ncbConnectionString").ConnectionString)
    Public varAbilita As Boolean = True
    '*****************************************************************************************
    'INIZIO CODICE PER FINESTRA MODALE
    '*****************************************************************************************

    Public ClassTitoloModal As String = "modal-header alert alert-success"
    Public Sub showModal(ByVal Classe As String, ByVal corpo As String)
        Select Case Classe
            Case "SALVA"
                ClassTitoloModal = "modal-header alert alert-success"
                lblTitoloModale.Text = "SALVA"
            Case "ATTENZIONE"
                ClassTitoloModal = "modal-header alert alert-danger"
                lblTitoloModale.Text = "ATTENZIONE"
            Case "INFORMAZIONE"
                ClassTitoloModal = "modal-header alert alert-info"
                lblTitoloModale.Text = "INFORMAZIONE"
            Case "ERRORE"
                ClassTitoloModal = "modal-header alert alert-warning"
                lblTitoloModale.Text = "ERRORE"
        End Select

        lblCorpoModale.Text = corpo
        ScriptManager.RegisterStartupScript(Me.Page, Page.GetType, "HideLoginDialog", "<script type=""text/javascript"">$(document).ready(function () { $('#myMessage').modal('show');});</script>", False)
    End Sub

    Protected Sub btnCloseModal_Click(sender As Object, e As EventArgs)
        ScriptManager.RegisterStartupScript(Page, Page.[GetType](), "myModalHide", "$('#myMessage').hide();", True)
        ScriptManager.RegisterStartupScript(Page, Page.[GetType](), "myModalAgainShow", "$('#myMessage').modal();", True)
    End Sub
    '*****************************************************************************************
    'FINE CODICE PER FINESTRA MODALE
    '*****************************************************************************************

    <System.Web.Script.Services.ScriptMethod(), _
    System.Web.Services.WebMethod()> _
    Public Shared Function CercaCittaDA(ByVal prefixText As String, ByVal count As Integer) As List(Of String)

        Dim conn As SqlClient.SqlConnection = New SqlClient.SqlConnection
        conn.ConnectionString = ConfigurationManager.ConnectionStrings("db_ncbConnectionString").ConnectionString

        Dim cmd As SqlClient.SqlCommand = New SqlClient.SqlCommand
        cmd.CommandText = "select nome from comuni where" & _
        " nome like  @SearchText + '%'"
        cmd.Parameters.AddWithValue("@SearchText", prefixText)
        cmd.Connection = conn
        conn.Open()
        Dim customers As List(Of String) = New List(Of String)
        Dim sdr As SqlClient.SqlDataReader = cmd.ExecuteReader
        While sdr.Read
            customers.Add(sdr("nome").ToString)
        End While
        conn.Close()
        Return customers
    End Function

    Public Shared Function CercaCittaA(ByVal prefixText As String, ByVal count As Integer) As List(Of String)

        Dim conn As SqlClient.SqlConnection = New SqlClient.SqlConnection
        conn.ConnectionString = ConfigurationManager.ConnectionStrings("db_ncbConnectionString").ConnectionString

        Dim cmd As SqlClient.SqlCommand = New SqlClient.SqlCommand
        cmd.CommandText = "select nome from comuni where" & _
        " nome like  @SearchText + '%'"
        cmd.Parameters.AddWithValue("@SearchText", prefixText)
        cmd.Connection = conn
        conn.Open()
        Dim customers As List(Of String) = New List(Of String)
        Dim sdr As SqlClient.SqlDataReader = cmd.ExecuteReader
        While sdr.Read
            customers.Add(sdr("nome").ToString)
        End While
        conn.Close()
        Return customers
    End Function

    Private Sub TitoloSezione(ByRef Titolo As String)
        Dim varTitoloezione As Label = DirectCast(Master.FindControl("lblTitoloSezione"), Label)
        varTitoloezione.Text = Titolo
    End Sub

    Private Sub CambiaTitoloMasterPage(ByVal Testo As String)
        DirectCast(Master.FindControl("lblTitoloSezione"), Label).Text = Testo
    End Sub

    Public Sub OpenModal(ByVal NomeDivModale As String)
        ScriptManager.RegisterStartupScript(Me.Page, Page.GetType, "HideLoginDialog", "<script type=""text/javascript"">$(document).ready(function () { $('#" & NomeDivModale & "').modal('show');});</script>", False)
    End Sub

    Protected Sub Page_Load(sender As Object, e As EventArgs) Handles Me.Load
        ConfigurationManager.AppSettings("ColoraIconaControllo") = "'icoPrenotazione'"
        If Not IsPostBack Then
            Session("IDTabella") = 0
            lblIdPrenotazione.Text = 0
            Session("uploadTabella") = "tabPrenotazione"
            CambiaTitoloMasterPage("PRENOTAZIONI")
            mView.ActiveViewIndex = 0
            drpTarga.DataBind()
            txtMezzo.Text = drpTarga.SelectedValue
            inpDataInizioDett.Value = Now.Date.ToShortDateString
            inpDataFineDett.Value = Now.Date.ToShortDateString
            varAbilita = True

            inpDataInizio.Value = "01/01/" & Now.Date.Year
            inpDataFine.Value = Now.Date.ToShortDateString

            RicercaPrenotazioni()
            pnlAllegati.Visible = False
        Else
            txtMezzo.Text = drpTarga.SelectedValue
        End If

        AbilitaFornitore(inpFornitore.Checked)

        If inpFornitore.Checked = True Then
            AbilitaAutisti(False)
        Else
            AbilitaAutisti(True)
        End If



        If Not IsPostBack Then
            If Request.QueryString("id") <> Nothing Then
                Dettaglio_Chiamata_Calenario(Request.QueryString("id"))
                mView.ActiveViewIndex = 1
            End If
        End If

    End Sub

    Private Sub AbilitaFornitore(ByVal Abilita As Boolean)
        drpFornitore.Visible = Abilita
        txtCostoServizio.Visible = Abilita
        lblCostoServizio.Visible = Abilita
        lblFornitore.Visible = Abilita
        btnAcquistiCollegati.Visible = Abilita
    End Sub

    Private Sub AbilitaAutisti(ByVal Abilita As Boolean)
        drpAutisti.Visible = Abilita
        lblAutisti.Visible = Abilita
    End Sub

    Protected Sub btnOpen(sender As Object, e As EventArgs)
        OpenModal("ModalInsScad")
    End Sub

    Private Sub SvuotaCampi()
        inpDataInizioDett.Value = Now.Date.ToShortDateString
        inpDataFineDett.Value = Now.Date.ToShortDateString

        drpCliente.DataBind()

        txtReferente.Text = ""
        txtCodiceTour.Text = ""
        txtNrPax.Text = "0"

        txtCittaPartenza.Text = ""
        txtIndirizzoPartenza.Text = ""
        txtCittaArrivo.Text = ""
        txtIndirizzoArrivo.Text = ""
        txtTipoServizio.Text = ""
        txtImporto.Text = "0,00"
        inpConfermata.Checked = False
        inpFornitore.Checked = False

        txtCostoServizio.Text = "0,00"
        txtNote.Text = ""
        hdfIDFattura.Value = 0
        varAbilita = True
        inpOraPartenza.Value = "00 00"
        inpOraArrivo.Value = "23 59"
        inpConfermata.Checked = False
        inpFornitore.Checked = False
        inpTourEstero.Checked = False
        inpFatturare.Checked = True

        btnAccessorie.Visible = False
        btnDuplica.Visible = False

        lblIdPrenotazione.Text = 0

        AbilitaFornitore(inpFornitore.Checked)
        If inpFornitore.Checked = True Then
            AbilitaAutisti(False)
        Else
            AbilitaAutisti(True)
        End If
        CaricaIvaPredefinitaCliente()
        lblFatturata.Text = "NON FATTURATA"
        lblFatturata.ForeColor = Drawing.Color.Red
    End Sub

    Protected Sub btnRicerca_ServerClick(sender As Object, e As EventArgs)
        RicercaPrenotazioni()
    End Sub

    Private Sub RicercaPrenotazioni()
        Try
            Dim _BD As New BD_BindDataMain(oConn.ConnectionString(), False)
            Dim myGruppoParam As New SP_GruppoParametri()
            myGruppoParam.Add(New SP_Parametro("@Valore", 50, inpRicerca.Value, DbType.String, ParameterDirection.Input))
            myGruppoParam.Add(New SP_Parametro("@DataInizio", 10, CDate(inpDataInizio.Value.ToString), DbType.Date, ParameterDirection.Input))
            myGruppoParam.Add(New SP_Parametro("@DataFine", 10, CDate(inpDataFine.Value.ToString).AddDays(1), DbType.Date, ParameterDirection.Input))


            Dim tmpDT As DataTable = _BD.getDataTable("[usp_RicercaPrenotazione]", myGruppoParam)
            If _BD.ErrorNumber <> 0 Then
                showModal("ERRORE", String.Format("Errore in fase di estrazione dati: {0} ({1}).", _BD.ErrorMessage, _BD.ErrorNumber))
            End If
            grdPrenotazioni.DataSource = tmpDT
            grdPrenotazioni.DataBind()

        Catch ex As Exception
            showModal("ERRORE", String.Format("Errore In fase di estrazione dati: {0}.", ex.Message))
        End Try
    End Sub
    Protected Sub grdPrenotazioni_PreRender(sender As Object, e As EventArgs) Handles grdPrenotazioni.PreRender
        For Each tmpRow As GridViewRow In grdPrenotazioni.Rows
            DirectCast(tmpRow.FindControl("imgDettaglio"), ImageButton).CommandArgument = DirectCast(tmpRow.FindControl("lblId"), Label).Text
            DirectCast(tmpRow.FindControl("imgServizioEsterno"), ImageButton).CommandArgument = DirectCast(tmpRow.FindControl("lblId"), Label).Text
            DirectCast(tmpRow.FindControl("imgDelete"), ImageButton).CommandArgument = DirectCast(tmpRow.FindControl("lblId"), Label).Text
            DirectCast(tmpRow.FindControl("imgDelete"), ImageButton).Attributes.Add("onclick", "javascript:return confirm('Proseguire con la cancellazione della Prenotazione?');")

            If DirectCast(tmpRow.FindControl("chkServizioEsterno"), CheckBox).Checked = True Then
                DirectCast(tmpRow.FindControl("imgServizioEsterno"), ImageButton).Visible = True
            Else
                DirectCast(tmpRow.FindControl("imgServizioEsterno"), ImageButton).Visible = False
            End If

            If DirectCast(tmpRow.FindControl("lblcodFattura"), Label).Text = 0 Then
                DirectCast(tmpRow.FindControl("imgFatturato"), Literal).Text = "<i class=""fa fa-toggle-off fa-2x"" style=""color:red;""/>"
            Else
                DirectCast(tmpRow.FindControl("imgFatturato"), Literal).Text = "<i class=""fa fa-toggle-off fa-2x"" style=""color:green;""/>"
            End If
        Next
    End Sub

    Public Sub DettaglioAnagrafica(ByVal sender As Object, ByVal e As System.EventArgs)
        SvuotaCampi()
        pnlAllegati.Visible = True
        Dim imgBtn As ImageButton = sender
        For Each tmpRow As GridViewRow In grdPrenotazioni.Rows
            If DirectCast(tmpRow.FindControl("imgDettaglio"), ImageButton).CommandArgument.Equals(imgBtn.CommandArgument) Then

                Session("idTabella") = imgBtn.CommandArgument
                lblIdPrenotazione.Text = imgBtn.CommandArgument
                btnDuplica.Visible = True


                drpCliente.SelectedValue = DirectCast(tmpRow.FindControl("lblIdCliente"), Label).Text
                inpDataInizioDett.Value = CDate(DirectCast(tmpRow.FindControl("lblDataInizio"), Label).Text).Date
                inpDataFineDett.Value = CDate(DirectCast(tmpRow.FindControl("lblDataFine"), Label).Text).Date

                inpOraPartenza.Value = CDate(DirectCast(tmpRow.FindControl("lblDataInizio"), Label).Text).Hour.ToString.PadLeft(2, "0"c) & " " & _
                                       CDate(DirectCast(tmpRow.FindControl("lblDataInizio"), Label).Text).Minute.ToString.PadLeft(2, "0"c)

                inpOraArrivo.Value = CDate(DirectCast(tmpRow.FindControl("lblDataFine"), Label).Text).Hour.ToString.PadLeft(2, "0"c) & " " & _
                                     CDate(DirectCast(tmpRow.FindControl("lblDataFine"), Label).Text).Minute.ToString.PadLeft(2, "0"c)

                txtReferente.Text = DirectCast(tmpRow.FindControl("lblReferente"), Label).Text
                txtCodiceTour.Text = DirectCast(tmpRow.FindControl("lblCodiceTour"), Label).Text
                txtNrPax.Text = DirectCast(tmpRow.FindControl("lblNrPax"), Label).Text
                txtCittaPartenza.Text = DirectCast(tmpRow.FindControl("lblDaCitta"), Label).Text
                txtIndirizzoPartenza.Text = DirectCast(tmpRow.FindControl("lblDaIndirizzo"), Label).Text
                txtCittaArrivo.Text = DirectCast(tmpRow.FindControl("lblACitta"), Label).Text
                txtIndirizzoArrivo.Text = DirectCast(tmpRow.FindControl("lblAIndirizzo"), Label).Text
                txtImporto.Text = DirectCast(tmpRow.FindControl("lblImporto"), Label).Text
                txtTipoServizio.Text = DirectCast(tmpRow.FindControl("lblTipoServizio"), Label).Text
                drpTarga.SelectedValue = DirectCast(tmpRow.FindControl("lblMezzo"), Label).Text
                txtMezzo.Text = DirectCast(tmpRow.FindControl("lblMezzo"), Label).Text
                txtNote.Text = DirectCast(tmpRow.FindControl("lblNote"), Label).Text

                If DirectCast(tmpRow.FindControl("lblcodFattura"), Label).Text = 0 Then
                    lblFatturata.Text = "NON FATTURATA"
                    lblFatturata.ForeColor = Drawing.Color.Red
                Else
                    lblFatturata.Text = "FATTURATA"
                    lblFatturata.ForeColor = Drawing.Color.Green
                End If

                hdfIDFattura.Value = DirectCast(tmpRow.FindControl("lblcodFattura"), Label).Text
                inpConfermata.Checked = DirectCast(tmpRow.FindControl("chkConfermata"), CheckBox).Checked

                inpTourEstero.Checked = DirectCast(tmpRow.FindControl("chkTourEstero"), CheckBox).Checked
                inpFornitore.Checked = DirectCast(tmpRow.FindControl("chkServizioEsterno"), CheckBox).Checked

                inpFatturare.Checked = DirectCast(tmpRow.FindControl("chkFatturare"), CheckBox).Checked

                If DirectCast(tmpRow.FindControl("chkServizioEsterno"), CheckBox).Checked = True Then
                    drpFornitore.SelectedValue = DirectCast(tmpRow.FindControl("lblIdFornitore"), Label).Text
                    txtCostoServizio.Text = DirectCast(tmpRow.FindControl("lblCostoServizio"), Label).Text

                    AbilitaAutisti(False)
                Else
                    txtCostoServizio.Text = "0,00"
                    AbilitaAutisti(True)
                    drpAutisti.SelectedValue = DirectCast(tmpRow.FindControl("lblidAutisti"), Label).Text
                End If

                AbilitaFornitore(inpFornitore.Checked)

                drpAliquotaIva.SelectedValue = DirectCast(tmpRow.FindControl("lblidAliquotaIva"), Label).Text
                ConfigurationManager.AppSettings("IvaIdCliente") = DirectCast(tmpRow.FindControl("lblidAliquotaIva"), Label).Text


                btnAccessorie.Visible = True

                btnModifica.Text = "MODIFICA"
                varAbilita = False
                inpDataInizioDett.EnableViewState = False

                RicercaAccessorie()
                CaricaListaAllegati()

                mView.ActiveViewIndex = 1

                Exit For

            End If
        Next
    End Sub

    Private Sub RicercaAccessorie()
        Try
            Dim _BD As New BD_BindDataMain(oConn.ConnectionString(), False)
            Dim myGruppoParam As New SP_GruppoParametri()
            myGruppoParam.Add(New SP_Parametro("@Valore", 18, lblIdPrenotazione.Text, DbType.Int32, ParameterDirection.Input))
            Dim tmpDT As DataTable = _BD.getDataTable("[usp_RicercaAccessorie]", myGruppoParam)
            If _BD.ErrorNumber <> 0 Then
                showModal("ERRORE", String.Format("Errore in fase di estrazione dati: {0} ({1}).", _BD.ErrorMessage, _BD.ErrorNumber))
            End If
            grdAccessori.DataSource = tmpDT
            grdAccessori.DataBind()

        Catch ex As Exception
            showModal("ERRORE", String.Format("Errore In fase di estrazione dati: {0}.", ex.Message))
        End Try
    End Sub

    Protected Sub grdAccessori_PreRender(sender As Object, e As EventArgs) Handles grdAccessori.PreRender
        For Each tmpRow As GridViewRow In grdAccessori.Rows
            DirectCast(tmpRow.FindControl("imgDelete"), ImageButton).CommandArgument = DirectCast(tmpRow.FindControl("lblId"), Label).Text
            DirectCast(tmpRow.FindControl("imgDelete"), ImageButton).Attributes.Add("onclick", "javascript:return confirm('Proseguire con la cancellazione dell'Accessorie?');")
        Next
    End Sub



    Public Sub Dettaglio_Chiamata_Calenario(ByVal IdPassato As String)
        SvuotaCampi()
        pnlAllegati.Visible = True

        Session("idTabella") = IdPassato
        lblIdPrenotazione.Text = IdPassato

        btnDuplica.Visible = True

        Dim strSQL As String = "SELECT * FROM Prenotazione WHERE idPrenotazione=" & IdPassato
        Dim CompensiAdapter As New SqlClient.SqlDataAdapter
        Dim nwindConn As New SqlClient.SqlConnection(ConfigurationManager.ConnectionStrings("db_ncbConnectionString").ConnectionString)
        Dim selectCMD As New SqlClient.SqlCommand(strSQL, nwindConn)
        CompensiAdapter.SelectCommand = selectCMD
        Dim dsCompensi As New DataSet
        CompensiAdapter.Fill(dsCompensi, "Prenotazione")
        Dim compensiRow As DataRow
        If dsCompensi.Tables("Prenotazione").Rows.Count > 0 Then
            Dim conta As Integer = 0
            For Each compensiRow In dsCompensi.Tables("Prenotazione").Rows

                drpCliente.SelectedValue = compensiRow("IdCliente").ToString
                inpDataInizioDett.Value = CDate(compensiRow("DataInizio").ToString).Date
                inpDataFineDett.Value = CDate(compensiRow("DataFine").ToString).Date
                inpOraPartenza.Value = CDate(compensiRow("DataInizio").ToString).Hour.ToString.PadLeft(2, "0"c) & " " & _
                                      CDate(compensiRow("DataInizio").ToString).Minute.ToString.PadLeft(2, "0"c)
                inpOraArrivo.Value = CDate(compensiRow("DataFine").ToString).Hour.ToString.PadLeft(2, "0"c) & " " & _
                                    CDate(compensiRow("DataFine").ToString).Minute.ToString.PadLeft(2, "0"c)
                txtReferente.Text = compensiRow("Referente").ToString
                txtCodiceTour.Text = compensiRow("CodiceTour").ToString
                txtNrPax.Text = compensiRow("NrPax").ToString
                txtCittaPartenza.Text = compensiRow("DaCitta").ToString
                txtIndirizzoPartenza.Text = compensiRow("DaIndirizzo").ToString
                txtCittaArrivo.Text = compensiRow("ACitta").ToString
                txtIndirizzoArrivo.Text = compensiRow("AIndirizzo").ToString
                txtImporto.Text = compensiRow("Importo").ToString
                txtTipoServizio.Text = compensiRow("TipoServizio").ToString
                drpTarga.SelectedValue = compensiRow("Mezzo").ToString
                txtMezzo.Text = compensiRow("Mezzo").ToString
                txtNote.Text = compensiRow("Note").ToString
                hdfIDFattura.Value = compensiRow("codFattura").ToString
                If compensiRow("codFattura").ToString = 0 Then
                    lblFatturata.Text = "NON FATTURATA"
                    lblFatturata.ForeColor = Drawing.Color.Red
                Else
                    lblFatturata.Text = "FATTURATA"
                    lblFatturata.ForeColor = Drawing.Color.Green
                End If

                inpConfermata.Checked = compensiRow("Confermata")
                inpTourEstero.Checked = compensiRow("TourEstero")
                inpFornitore.Checked = compensiRow("ServizioEsterno")
                inpFatturare.Checked = compensiRow("Fatturare")
                If compensiRow("ServizioEsterno") = True Then
                    drpFornitore.SelectedValue = compensiRow("IdFornitore").ToString
                    txtCostoServizio.Text = compensiRow("CostoServizio").ToString

                    AbilitaAutisti(False)

                Else
                    txtCostoServizio.Text = "0,00"
                    AbilitaAutisti(True)
                    drpAutisti.SelectedValue = compensiRow("idAutista").ToString

                End If
                AbilitaFornitore(inpFornitore.Checked)

                btnAccessorie.Visible = True

                drpAliquotaIva.SelectedValue = compensiRow("idAliquotaIva").ToString
                ConfigurationManager.AppSettings("IvaIdCliente") = compensiRow("idAliquotaIva").ToString
                btnModifica.Text = "MODIFICA"
                varAbilita = False
                inpDataInizioDett.EnableViewState = False
                RicercaAccessorie()
                CaricaListaAllegati()
                mView.ActiveViewIndex = 1
            Next
        End If
    End Sub

    Protected Sub btnDuplica_Click(sender As Object, e As EventArgs) Handles btnDuplica.Click

        inpDuplicaDataDal.Value = CDate(inpDataInizioDett.Value).Date.AddDays(7)
        inpDuplicaDataAl.Value = CDate(inpDataFineDett.Value).Date.AddDays(7)

        inpDuplicaOraDal.Value = inpOraPartenza.Value
        inpDuplicaOraAl.Value = inpOraArrivo.Value

        OpenModal("ModalDuplica")
    End Sub

    Public Sub DuplicaPrenotazione(sender As Object, e As EventArgs)

        Try
            Using connection As New SqlClient.SqlConnection(ConfigurationManager.ConnectionStrings("db_ncbConnectionString").ConnectionString)

                connection.Open()

                If inpFornitore.Checked = False Then
                    '****************************************************************************************
                    ' controllo delle date per non prenotare lo stesso mezzo già impegnato nelle date scelte
                    '****************************************************************************************
                    Dim ContaMezzo As Integer = 0
                    Dim ContaAutista As Integer = 0

                    ' CONTROLLO MEZZO
                    '***************************************************************************************************
                    Dim cmdControllo As SqlClient.SqlCommand = connection.CreateCommand
                    cmdControllo.Connection = connection
                    cmdControllo.Parameters.Clear()
                    cmdControllo.CommandType = CommandType.Text




                    Dim dataInizioDuplica As DateTime = CDate(inpDuplicaDataDal.Value).Day.ToString & "/" & _
                                            CDate(inpDuplicaDataDal.Value).Month.ToString & "/" & _
                                            CDate(inpDuplicaDataDal.Value).Year.ToString & " " & inpDuplicaOraDal.Value.ToString

                    Dim dataFineDuplica As DateTime = CDate(inpDuplicaDataAl.Value).Day.ToString & "/" & _
                                                          CDate(inpDuplicaDataAl.Value).Month.ToString & "/" & _
                                                          CDate(inpDuplicaDataAl.Value).Year.ToString & " " & inpDuplicaOraAl.Value.ToString


                    cmdControllo.CommandText = "SELECT count(idPrenotazione) from Prenotazione where " & _
                                                         "(targa=@Targa)  and (ServizioEsterno=0) and " & _
                                                         "((DataInizio <= @DataInizio and DataFine>= @DataInizio) or " & _
                                                         "(DataInizio <= @DataFine and DataFine>= @DataFine) or " & _
                                                         "(DataInizio >= @DataInizio and DataFine<= @DataFine))"


                    cmdControllo.Parameters.AddWithValue("@Targa", drpTarga.SelectedItem.Text)
                    cmdControllo.Parameters.AddWithValue("@DataInizio", dataInizioDuplica)
                    cmdControllo.Parameters.AddWithValue("@DataFine", dataFineDuplica)

                    ContaMezzo = cmdControllo.ExecuteScalar()

                    If ContaMezzo > 0 Then
                        showModal("ERRORE", String.Format("IL MEZZO HA GIA' UNA PRENOTAZIONE PER IL PERIODO SELEZIONATO"))
                        connection.Close()
                        Exit Sub
                    End If

                    'CONTROLLO AUTISTA
                    '******************************************************************************
                    cmdControllo.Parameters.Clear()
                    cmdControllo.CommandType = CommandType.Text


                    cmdControllo.CommandText = "SELECT count(idPrenotazione) from Prenotazione where " & _
                                                     "(IDAUTISTA=@IDAUTISTA) and (idPrenotazione<>@idPrenotazione) and" & _
                                                      "((DataInizio <= @DataInizio and DataFine>= @DataInizio) or " & _
                                                         "(DataInizio <= @DataFine and DataFine>= @DataFine) or " & _
                                                         "(DataInizio >= @DataInizio and DataFine<= @DataFine))"
                    cmdControllo.Parameters.AddWithValue("@idPrenotazione", CInt(lblIdPrenotazione.Text))


                    cmdControllo.Parameters.AddWithValue("@IDAUTISTA", drpAutisti.SelectedValue)
                    cmdControllo.Parameters.AddWithValue("@DataInizio", dataInizioDuplica)
                    cmdControllo.Parameters.AddWithValue("@DataFine", dataFineDuplica)

                    ContaAutista = cmdControllo.ExecuteScalar()

                    If ContaAutista > 0 Then
                        showModal("ERRORE", String.Format("L'AUTISTA HA GIA' UNA PRENOTAZIONE PER IL PERIODO SELEZIONATO"))
                        connection.Close()
                        Exit Sub
                    End If

                End If

            End Using


            Dim _BD As New BD_BindDataMain(oConn.ConnectionString(), False)
            Dim myGruppoParam As New SP_GruppoParametri()

            myGruppoParam.Add(New SP_Parametro("@idPrenotazione", 8, lblIdPrenotazione.Text, DbType.Int32, ParameterDirection.Input))



            Dim dataInizioCalcolata As DateTime = CDate(inpDuplicaDataDal.Value).Day.ToString & "/" & _
                                             CDate(inpDuplicaDataDal.Value).Month.ToString & "/" & _
                                             CDate(inpDuplicaDataDal.Value).Year.ToString & " " & inpDuplicaOraDal.Value.ToString

            Dim dataFineCalcolata As DateTime = CDate(inpDuplicaDataAl.Value).Day.ToString & "/" & _
                                                  CDate(inpDuplicaDataAl.Value).Month.ToString & "/" & _
                                                  CDate(inpDuplicaDataAl.Value).Year.ToString & " " & inpDuplicaOraAl.Value.ToString


            myGruppoParam.Add(New SP_Parametro("@dal", 8, dataInizioCalcolata, DbType.DateTime, ParameterDirection.Input))
            myGruppoParam.Add(New SP_Parametro("@al", 8, dataFineCalcolata, DbType.DateTime, ParameterDirection.Input))

            Dim tmpDT As DataTable = _BD.getDataTable("[usp_duplicaPrenotazione]", myGruppoParam)
            If _BD.ErrorNumber <> 0 Then
                showModal("ERRORE", String.Format("Errore in fase di cancellazione dati: {0} ({1}).", _BD.ErrorMessage, _BD.ErrorNumber))
            End If

            showModal("SALVA", "PRENOTAZIONE DUPLICATA")

            mView.ActiveViewIndex = 0
            RicercaPrenotazioni()

        Catch ex As Exception
            showModal("ERRORE", (String.Format("Errore in fase di cancellazione dati: {0}.", ex.Message)))
        End Try
    End Sub

    Public Sub DeletePrenotazione(ByVal sender As Object, ByVal e As System.EventArgs)
        Dim imgBtn As ImageButton = sender
        Try
            For Each tmpRow As GridViewRow In grdPrenotazioni.Rows
                If DirectCast(tmpRow.FindControl("imgDelete"), ImageButton).CommandArgument.Equals(imgBtn.CommandArgument) Then
                    Dim _BD As New BD_BindDataMain(oConn.ConnectionString(), False)
                    Dim myGruppoParam As New SP_GruppoParametri()

                    myGruppoParam.Add(New SP_Parametro("@idPrenotazione", 8, imgBtn.CommandArgument, DbType.Int32, ParameterDirection.Input))

                    Dim tmpDT As DataTable = _BD.getDataTable("[usp_DeletePrenotazione]", myGruppoParam)
                    If _BD.ErrorNumber <> 0 Then
                        showModal("ERRORE", String.Format("Errore in fase di cancellazione dati: {0} ({1}).", _BD.ErrorMessage, _BD.ErrorNumber))
                    End If

                    mView.ActiveViewIndex = 0
                    RicercaPrenotazioni()

                End If
            Next
        Catch ex As Exception
            showModal("ERRORE", (String.Format("Errore in fase di cancellazione dati: {0}.", ex.Message)))
        End Try
    End Sub
    Protected Sub btnNuovoInserimento_Click(sender As Object, e As EventArgs) Handles btnNuovoInserimento.Click
        SvuotaCampi()
        Session("IDTabella") = 0
        lblIdPrenotazione.Text = 0
        txtMezzo.Text = drpTarga.SelectedValue
        mView.ActiveViewIndex = 1
        btnModifica.Text = "SALVA"
        inpDataFineDett.EnableViewState = True
        inpDataInizioDett.EnableViewState = True
        pnlAllegati.Visible = False
    End Sub

    Private Sub SALVA_PRENOTAZIONE()
        Try

            Dim dataInizioCalcolata As DateTime = CDate(inpDataInizioDett.Value).Day.ToString & "/" & _
                                                CDate(inpDataInizioDett.Value).Month.ToString & "/" & _
                                                CDate(inpDataInizioDett.Value).Year.ToString & " " & inpOraPartenza.Value.ToString

            Dim dataFineCalcolata As DateTime = CDate(inpDataFineDett.Value).Day.ToString & "/" & _
                                                  CDate(inpDataFineDett.Value).Month.ToString & "/" & _
                                                  CDate(inpDataFineDett.Value).Year.ToString & " " & inpOraArrivo.Value.ToString

            Using connection As New SqlClient.SqlConnection(ConfigurationManager.ConnectionStrings("db_ncbConnectionString").ConnectionString)

                connection.Open()

                If inpFornitore.Checked = False Then
                    '****************************************************************************************
                    ' controllo delle date per non prenotare lo stesso mezzo già impegnato nelle date scelte
                    '****************************************************************************************
                    Dim ContaMezzo As Integer = 0
                    Dim ContaAutista As Integer = 0

                    ' CONTROLLO MEZZO
                    '***************************************************************************************************
                    Dim cmdControllo As SqlClient.SqlCommand = connection.CreateCommand
                    cmdControllo.Connection = connection
                    cmdControllo.Parameters.Clear()
                    cmdControllo.CommandType = CommandType.Text

                    If lblIdPrenotazione.Text = 0 Then
                        cmdControllo.CommandText = "SELECT count(idPrenotazione) from Prenotazione where " & _
                                                         "(targa=@Targa) and (ServizioEsterno=0) and " & _
                                                          "((DataInizio <= @DataInizio and DataFine>= @DataInizio) or " & _
                                                         "(DataInizio <= @DataFine and DataFine>= @DataFine) or " & _
                                                         "(DataInizio >= @DataInizio and DataFine<= @DataFine))"
                    Else
                        cmdControllo.CommandText = "SELECT count(idPrenotazione) from Prenotazione where " & _
                                                         "(targa=@Targa) and (ServizioEsterno=0) and (idPrenotazione<>@idPrenotazione) and" & _
                                                        "((DataInizio <= @DataInizio and DataFine>= @DataInizio) or " & _
                                                         "(DataInizio <= @DataFine and DataFine>= @DataFine) or " & _
                                                         "(DataInizio >= @DataInizio and DataFine<= @DataFine))"
                        cmdControllo.Parameters.AddWithValue("@idPrenotazione", CInt(lblIdPrenotazione.Text))
                    End If

                    cmdControllo.Parameters.AddWithValue("@Targa", drpTarga.SelectedItem.Text)
                    cmdControllo.Parameters.AddWithValue("@DataInizio", dataInizioCalcolata)
                    cmdControllo.Parameters.AddWithValue("@DataFine", dataFineCalcolata)

                    ContaMezzo = cmdControllo.ExecuteScalar()

                    If ContaMezzo > 0 Then
                        showModal("ERRORE", String.Format("IL MEZZO HA GIA' UNA PRENOTAZIONE PER IL PERIODO SELEZIONATO"))
                        connection.Close()
                        Exit Sub
                    End If

                    'CONTROLLO AUTISTA
                    '******************************************************************************
                    cmdControllo.Parameters.Clear()
                    cmdControllo.CommandType = CommandType.Text

                    If lblIdPrenotazione.Text = 0 Then
                        cmdControllo.CommandText = "SELECT count(idPrenotazione) from Prenotazione where " & _
                                                         "(IDAUTISTA=@IDAUTISTA) and " & _
                                                          "((DataInizio <= @DataInizio and DataFine>= @DataInizio) or " & _
                                                         "(DataInizio <= @DataFine and DataFine>= @DataFine) or " & _
                                                         "(DataInizio >= @DataInizio and DataFine<= @DataFine))"
                    Else
                        cmdControllo.CommandText = "SELECT count(idPrenotazione) from Prenotazione where " & _
                                                         "(IDAUTISTA=@IDAUTISTA) and (idPrenotazione<>@idPrenotazione) and" & _
                                                        "((DataInizio <= @DataInizio and DataFine>= @DataInizio) or " & _
                                                         "(DataInizio <= @DataFine and DataFine>= @DataFine) or " & _
                                                         "(DataInizio >= @DataInizio and DataFine<= @DataFine))"
                        cmdControllo.Parameters.AddWithValue("@idPrenotazione", CInt(lblIdPrenotazione.Text))
                    End If

                    cmdControllo.Parameters.AddWithValue("@IDAUTISTA", drpAutisti.SelectedValue)
                    cmdControllo.Parameters.AddWithValue("@DataInizio", dataInizioCalcolata)
                    cmdControllo.Parameters.AddWithValue("@DataFine", dataFineCalcolata)

                    ContaAutista = cmdControllo.ExecuteScalar()

                    If ContaAutista > 0 Then
                        showModal("ERRORE", String.Format("L'AUTISTA HA GIA' UNA PRENOTAZIONE PER IL PERIODO SELEZIONATO"))
                        connection.Close()
                        Exit Sub
                    End If

                End If

                '****************************************************************************************
                ' registrazione nel db della prenotazione
                '****************************************************************************************

                Dim uspText As String = ""

                If lblIdPrenotazione.Text = 0 Then
                    uspText = "[usp_InsertPrenotazione]"
                Else
                    uspText = "[usp_UpdatePrenotazione]"
                End If

                Dim cmd As SqlClient.SqlCommand = New SqlClient.SqlCommand(uspText, connection)
                cmd.CommandType = CommandType.StoredProcedure

                cmd.Parameters.Clear()

                If lblIdPrenotazione.Text <> 0 Then
                    cmd.Parameters.AddWithValue("@idPRenotazione", CInt(lblIdPrenotazione.Text))
                Else
                    Dim pOutput = New SqlParameter("@RecordID", SqlDbType.Int, 1)
                    pOutput.Direction = ParameterDirection.Output
                    cmd.Parameters.Add(pOutput)
                End If

                cmd.Parameters.AddWithValue("@IdCliente", CInt(drpCliente.SelectedValue))
                cmd.Parameters.AddWithValue("@Cliente", drpCliente.SelectedItem.Text)

                cmd.Parameters.AddWithValue("@DataInizio", dataInizioCalcolata)
                cmd.Parameters.AddWithValue("@DataFine", dataFineCalcolata)

                cmd.Parameters.AddWithValue("@Referente", txtReferente.Text)
                cmd.Parameters.AddWithValue("@CodiceTour", txtCodiceTour.Text)
                cmd.Parameters.AddWithValue("@NrPax", txtNrPax.Text)
                cmd.Parameters.AddWithValue("@DaCitta", txtCittaPartenza.Text)
                cmd.Parameters.AddWithValue("@DaIndirizzo", txtIndirizzoPartenza.Text)
                cmd.Parameters.AddWithValue("@ACitta", txtCittaArrivo.Text)
                cmd.Parameters.AddWithValue("@AIndirizzo", txtIndirizzoArrivo.Text)
                cmd.Parameters.AddWithValue("@Importo", CDbl(txtImporto.Text))
                cmd.Parameters.AddWithValue("@TipoServizio", txtTipoServizio.Text)
                cmd.Parameters.AddWithValue("@Targa", drpTarga.SelectedItem.Text)
                cmd.Parameters.AddWithValue("@Mezzo", drpTarga.SelectedValue)
                cmd.Parameters.AddWithValue("@Note", txtNote.Text)
                cmd.Parameters.AddWithValue("@codFattura", hdfIDFattura.Value)

                cmd.Parameters.AddWithValue("@Confermata", inpConfermata.Checked)
                cmd.Parameters.AddWithValue("@TourEstero", inpTourEstero.Checked)
                cmd.Parameters.AddWithValue("@Fatturare", inpFatturare.Checked)

                cmd.Parameters.AddWithValue("@ServizioEsterno", inpFornitore.Checked)

                cmd.Parameters.AddWithValue("@idAliquotaIva", CInt(drpAliquotaIva.SelectedValue))

                If inpFornitore.Checked = True Then
                    cmd.Parameters.AddWithValue("@IdFornitore", drpFornitore.SelectedValue)
                    cmd.Parameters.AddWithValue("@Fornitore", drpFornitore.SelectedItem.Text)
                    cmd.Parameters.AddWithValue("@CostoServizio", CDbl(txtCostoServizio.Text))


                    cmd.Parameters.AddWithValue("@Autista", "")
                    cmd.Parameters.AddWithValue("@IDAutista", 0)

                Else
                    cmd.Parameters.AddWithValue("@IdFornitore", 0)
                    cmd.Parameters.AddWithValue("@Fornitore", "")
                    cmd.Parameters.AddWithValue("@CostoServizio", 0)

                    cmd.Parameters.AddWithValue("@Autista", drpAutisti.SelectedItem.Text)
                    cmd.Parameters.AddWithValue("@IDAutista", drpAutisti.SelectedValue)

                End If

                cmd.ExecuteNonQuery()

                RicercaPrenotazioni()

                If lblIdPrenotazione.Text = 0 Then
                    lblIdPrenotazione.Text = Convert.ToInt32(cmd.Parameters("@RecordID").Value)
                    Dettaglio_Chiamata_Calenario(lblIdPrenotazione.Text)
                End If


                connection.Close()



                showModal("SALVA", "DATI SALVATI CORRETTAMENTE")

            End Using
        Catch ex As Exception
            showModal("ERRORE", "ERRORE" & ex.Message)
        End Try
    End Sub

    Protected Sub drpTarga_SelectedIndexChanged(sender As Object, e As EventArgs) Handles drpTarga.SelectedIndexChanged
        txtMezzo.Text = drpTarga.SelectedValue
    End Sub

    Protected Sub btnEsci_Click(sender As Object, e As EventArgs) Handles btnEsci.Click
        mView.ActiveViewIndex = 0
    End Sub

    Protected Sub btnModifica_Click(sender As Object, e As EventArgs) Handles btnModifica.Click
        SALVA_PRENOTAZIONE()
    End Sub


    Protected Sub btnAccessorie_Click(sender As Object, e As EventArgs) Handles btnAccessorie.Click
        If ConfigurationManager.AppSettings("IvaIdAccessori") <> 0 Then
            DrpAccIva.SelectedValue = ConfigurationManager.AppSettings("IvaIdAccessori")
        End If

        txtAccDescrizione.Text = ""
        txtAccImponibile.Text = "0,00"

        OpenModal("ModalInsAccessorie")
    End Sub

    Protected Sub btnSalvaAccessorie_Click(sender As Object, e As EventArgs)
        Try

            Using connection As New SqlClient.SqlConnection(ConfigurationManager.ConnectionStrings("db_ncbConnectionString").ConnectionString)

                connection.Open()

                Dim cmd As SqlClient.SqlCommand = New SqlClient.SqlCommand("[usp_InsertAccessorie]", connection)
                cmd.CommandType = CommandType.StoredProcedure

                cmd.Parameters.Clear()

                cmd.Parameters.AddWithValue("@descrizione", txtAccDescrizione.Text.Trim)
                cmd.Parameters.AddWithValue("@idaliquotaIva", DrpAccIva.SelectedValue)
                cmd.Parameters.AddWithValue("@Imponibile", CDbl(txtAccImponibile.Text))
                cmd.Parameters.AddWithValue("@idPrenotazione", lblIdPrenotazione.Text)

                cmd.ExecuteNonQuery()

                connection.Close()

                RicercaAccessorie()

            End Using
        Catch ex As Exception
            showModal("ERRORE", "ERRORE" & ex.Message)
        End Try
    End Sub

    Public Sub DeleteAccessorie(ByVal sender As Object, ByVal e As System.EventArgs)
        Dim imgBtn As ImageButton = sender
        Try
            For Each tmpRow As GridViewRow In grdAccessori.Rows
                If DirectCast(tmpRow.FindControl("imgDelete"), ImageButton).CommandArgument.Equals(imgBtn.CommandArgument) Then
                    Dim _BD As New BD_BindDataMain(oConn.ConnectionString(), False)
                    Dim myGruppoParam As New SP_GruppoParametri()

                    myGruppoParam.Add(New SP_Parametro("@idAccessorie", 8, imgBtn.CommandArgument, DbType.Int32, ParameterDirection.Input))

                    Dim tmpDT As DataTable = _BD.getDataTable("[usp_DeleteAccessorie]", myGruppoParam)
                    If _BD.ErrorNumber <> 0 Then
                        showModal("ERRORE", String.Format("Errore in fase di cancellazione dati: {0} ({1}).", _BD.ErrorMessage, _BD.ErrorNumber))
                    End If

                    showModal("SALVA", "Accessorie eliminate con successo")

                    RicercaAccessorie()

                End If
            Next
        Catch ex As Exception
            showModal("ERRORE", (String.Format("Errore in fase di cancellazione dati: {0}.", ex.Message)))
        End Try
    End Sub

    Protected Sub inpTourEstero_ServerChange(sender As Object, e As EventArgs)
        If inpTourEstero.Checked = True Then
            drpAliquotaIva.SelectedValue = ConfigurationManager.AppSettings("IvaIdTour")
        Else
            CaricaIvaPredefinitaCliente()
        End If
    End Sub

    Protected Sub drpCliente_SelectedIndexChanged(sender As Object, e As EventArgs) Handles drpCliente.SelectedIndexChanged
        CaricaIvaPredefinitaCliente()
    End Sub

    Private Sub CaricaIvaPredefinitaCliente()
        Try

            Using connection As New SqlClient.SqlConnection(ConfigurationManager.ConnectionStrings("db_ncbConnectionString").ConnectionString)

                connection.Open()

                Dim cmd As SqlClient.SqlCommand = connection.CreateCommand
                cmd.CommandType = CommandType.Text
                cmd.CommandText = "SELECT IvaDefault from Anagrafica where  idAnagrafica=@idAnagrafica"

                cmd.Parameters.Clear()
                cmd.Parameters.AddWithValue("@idAnagrafica", drpCliente.SelectedValue)

                Dim aliquotaIva As String = cmd.ExecuteScalar

                drpAliquotaIva.SelectedValue = aliquotaIva
                ConfigurationManager.AppSettings("IvaIdCliente") = aliquotaIva
                connection.Close()
            End Using
        Catch ex As Exception
            showModal("ERRORE", "ERRORE" & ex.Message)
        End Try
    End Sub

    ' ----------------------------------------------------------------------------------------------------
    '-----------------------------------    CODICE LEGA ACQUISTI  ----------------------------------------
    '-----------------------------------------------------------------------------------------------------
    Public Sub imgServizioEsterno_Click(ByVal sender As Object, ByVal e As System.EventArgs)
        OpenModal("ModalAcquistidaLegare")
        inpDataAcquistiRicDAL.Value = "01/01/" & Now.Date.Year
        inpDataAcquistiRicAL.Value = Now.Date.ToShortDateString
        inpAcquistiRic.Value = ""
        grdAcquisti.DataBind()

        Dim imgBtn As ImageButton = sender
        For Each tmpRow As GridViewRow In grdPrenotazioni.Rows
            If DirectCast(tmpRow.FindControl("imgServizioEsterno"), ImageButton).CommandArgument.Equals(imgBtn.CommandArgument) Then
                hdfIdPrenotazioneAssociata.Value = imgBtn.CommandArgument
                Exit For
            End If
        Next

    End Sub

    Protected Sub btnRicercaAcquisti_ServerClick(sender As Object, e As EventArgs)

        Try
            Dim constr As String = ConfigurationManager.ConnectionStrings("db_ncbConnectionString").ConnectionString
            Dim sql As String = "SELECT * FROM vw_AcquistiPagamenti Where " & _
                                "((Numero Like '%' + @numero + '%') OR (RagioneSociale  Like '%' + @RagioneSocliale + '%') OR " & _
                                "(PartitaIva Like '%' + @PartitaIva + '%')) AND (TipoTabella  = 'ACQUISTO') AND " & _
                                "((Data >= @DataInizio) AND (Data  <= @Datafine)) "

            Dim strSQL As String = "SELECT * FROM PrenotazioneAcquisti WHERE IdPrenotazione=" & hdfIdPrenotazioneAssociata.Value
            Dim AcquistiAdapter As New SqlClient.SqlDataAdapter
            Dim AcquistiConn As New SqlClient.SqlConnection(constr)
            Dim selectCMD As New SqlClient.SqlCommand(strSQL, AcquistiConn)
            AcquistiAdapter.SelectCommand = selectCMD
            Dim dsAcquisti As New DataSet
            AcquistiAdapter.Fill(dsAcquisti, "Acquisti")
            Dim AcquistiRow As DataRow
            If dsAcquisti.Tables("Acquisti").Rows.Count > 0 Then
                For Each AcquistiRow In dsAcquisti.Tables("Acquisti").Rows
                    sql &= "AND (idAcquisti <> " & AcquistiRow("idAcquisti").ToString() & ") "
                Next
            End If
            dsAcquisti.Clear()
            dsAcquisti.Dispose()

            Dim dt As New DataTable()

            Using conn As New SqlConnection(constr)
                Dim commandText As String = sql
                Dim command As New SqlCommand(commandText, conn)
                command.Parameters.AddWithValue("@numero", inpAcquistiRic.Value)
                command.Parameters.AddWithValue("@RagioneSocliale", inpAcquistiRic.Value)
                command.Parameters.AddWithValue("@PartitaIva", inpAcquistiRic.Value)

                command.Parameters.AddWithValue("@DataInizio", CDate(inpDataAcquistiRicDAL.Value).Date)
                command.Parameters.AddWithValue("@Datafine", CDate(inpDataAcquistiRicAL.Value).Date)

                conn.Open()
                Using sda As New SqlDataAdapter(command)
                    sda.Fill(dt)
                End Using

            End Using

            grdAcquisti.DataSource = dt
            grdAcquisti.DataBind()

            OpenModal("ModalAcquistidaLegare")
        Catch ex As Exception
            showModal("ERRORE", String.Format("Errore In fase di estrazione dati: {0}.", ex.Message))
        End Try
    End Sub

    Protected Sub btnLegaAcquisti_Click(sender As Object, e As EventArgs)



        Using connection As New SqlClient.SqlConnection(ConfigurationManager.ConnectionStrings("db_ncbConnectionString").ConnectionString)
            connection.Open()

            '****************************************************************************************
            ' associo gli acquisti selezionati alla prenotazione
            '****************************************************************************************

            Dim cmd As SqlClient.SqlCommand = connection.CreateCommand()
            Dim transactionLog As SqlClient.SqlTransaction
            transactionLog = connection.BeginTransaction("Transactionlog")
            cmd.Connection = connection
            cmd.Transaction = transactionLog

            '  Try
            cmd.CommandType = CommandType.Text
            Dim AlmenoUnoModificato As Boolean = False

            For Each tmpRow As GridViewRow In grdAcquisti.Rows
                If DirectCast(tmpRow.FindControl("chkLega"), CheckBox).Checked = True Then
                    cmd.Parameters.Clear()
                    cmd.CommandText = "INSERT PrenotazioneAcquisti (idPrenotazione, idAcquisti) VALUES (@idPrenotazione, @idAcquisti)"
                    cmd.Parameters.AddWithValue("@idAcquisti", CInt(DirectCast(tmpRow.FindControl("lblID"), Label).Text))
                    cmd.Parameters.AddWithValue("@idPrenotazione", CInt(hdfIdPrenotazioneAssociata.Value))
                    cmd.ExecuteNonQuery()
                    AlmenoUnoModificato = True
                End If

            Next


            transactionLog.Commit()
            connection.Close()

            If AlmenoUnoModificato = True Then
                showModal("SALVA", "ACQUISTI ASSOCIATI CORRETTAMENTE")
            End If

            'Catch ex As Exception
            '    showModal("ERRORE", String.Format("Ripristino Dati, " & vbCrLf & "{0}", ex))
            '    Try
            '        transactionLog.Rollback()
            '    Catch ex2 As Exception
            '        showModal("ERRORE", String.Format("Ripristino Dati, " & vbCrLf & "{0}", ex2))
            '    End Try
            'End Try

        End Using
    End Sub

    Protected Sub btnAcquistiCollegati_Click(sender As Object, e As EventArgs)
        Dim dt As New DataTable()
        Dim constr As String = ConfigurationManager.ConnectionStrings("db_ncbConnectionString").ConnectionString
        Dim sql As String = "SELECT * FROM vw_PrenotazioneAcquisti where idprenotazione=" & lblIdPrenotazione.Text
        Using conn As New SqlConnection(constr)
            Using cmd As New SqlCommand(sql)
                cmd.Connection = conn
                Using sda As New SqlDataAdapter(cmd)
                    sda.Fill(dt)
                End Using
            End Using
        End Using

        grdAcquistiCollegati.DataSource = dt
        grdAcquistiCollegati.DataBind()
        OpenModal("ModalAcquistiAssociati")
    End Sub


    Protected Sub grdAcquistiCollegati_PreRender(sender As Object, e As EventArgs) Handles grdAcquistiCollegati.PreRender
        For Each tmpRow As GridViewRow In grdAcquistiCollegati.Rows
            DirectCast(tmpRow.FindControl("imgScollega"), ImageButton).CommandArgument = DirectCast(tmpRow.FindControl("lblId"), Label).Text
            DirectCast(tmpRow.FindControl("imgScollega"), ImageButton).Attributes.Add("onclick", "javascript:return confirm('Sicuro di Scollegare l'Acquisto?');")
        Next
    End Sub

    Protected Sub ScollegaAcquisto(sender As Object, e As EventArgs)
        Dim imgBtn As ImageButton = sender
        For Each tmpRow As GridViewRow In grdAcquistiCollegati.Rows
            If DirectCast(tmpRow.FindControl("imgScollega"), ImageButton).CommandArgument.Equals(imgBtn.CommandArgument) Then
                Using connection As New SqlClient.SqlConnection(ConfigurationManager.ConnectionStrings("db_ncbConnectionString").ConnectionString)
                    connection.Open()

                    Dim cmd As SqlClient.SqlCommand = connection.CreateCommand()
                    cmd.Connection = connection

                    Try
                        cmd.CommandType = CommandType.Text
                        cmd.Parameters.Clear()
                        cmd.CommandText = "DELETE PrenotazioneAcquisti WHERE idPrenotazione=@idPrenotazione AND idAcquisti=@idAcquisti"
                        cmd.Parameters.AddWithValue("@idAcquisti", CInt(imgBtn.CommandArgument))
                        cmd.Parameters.AddWithValue("@idPrenotazione", CInt(lblIdPrenotazione.Text))
                        cmd.ExecuteNonQuery()

                        connection.Close()

                        showModal("SALVA", "ACQUISTO SCOLLEGATO")

                    Catch ex As Exception
                        showModal("ERRORE", String.Format("Ripristino Dati, " & vbCrLf & "{0}", ex))
                    End Try
                End Using
            End If
        Next
    End Sub

    ' ----------------------------------------------------------------------------------------------------
    '-------------------------- CODICE PER CARICARE GLI ALLEGATI ----------------------------------------
    '----------------------------------------------------------------------------------------------------
    Protected Sub btnFinestaCaricaAllegato_Click(sender As Object, e As EventArgs) Handles btnFinestaCaricaAllegato.Click
        OpenModal("ModalAllegati")
    End Sub


    Protected Sub grdAllegatiManuale_PreRender(sender As Object, e As EventArgs) Handles grdAllegatiManuale.PreRender
        For Each tmpRow As GridViewRow In grdAllegatiManuale.Rows
            DirectCast(tmpRow.FindControl("imgDeleteAllegato"), ImageButton).CommandArgument = DirectCast(tmpRow.FindControl("lblidAllegato"), Label).Text
            DirectCast(tmpRow.FindControl("imgDeleteAllegato"), ImageButton).Attributes.Add("onclick", "javascript:return confirm('Proseguire con la cancellazione Allegato?');")
        Next
    End Sub
    Private Sub SalvaPersorsoAllegatoDB(ByVal varCodTipoAllegato As Integer, ByVal varDescrizione As String, ByVal varDirectory As String, ByVal varNomefile As String)

        Try

            Dim _BD As New BD_BindDataMain(oConn.ConnectionString(), False)
            Dim myGruppoParam As New SP_GruppoParametri()

            Dim tabControllata As String = Session("uploadTabella")
            Dim idRigaDaAllegareFile As Integer = lblIdPrenotazione.Text

            myGruppoParam.Add(New SP_Parametro("@codTabella", 8, idRigaDaAllegareFile, DbType.Int32, ParameterDirection.Input))
            myGruppoParam.Add(New SP_Parametro("@TipoTabella", 50, tabControllata, DbType.String, ParameterDirection.Input))
            myGruppoParam.Add(New SP_Parametro("@codTipoAllegato", 8, varCodTipoAllegato, DbType.Int32, ParameterDirection.Input))
            myGruppoParam.Add(New SP_Parametro("@Descrizione", 4000, varDescrizione, DbType.String, ParameterDirection.Input))
            myGruppoParam.Add(New SP_Parametro("@Directory", 4000, varDirectory, DbType.String, ParameterDirection.Input))
            myGruppoParam.Add(New SP_Parametro("@NomeFile", 4000, varNomefile, DbType.String, ParameterDirection.Input))

            Dim tmpDT As DataTable = _BD.getDataTable("[usp_InsertAllegato]", myGruppoParam)


            If _BD.ErrorNumber <> 0 Then
                showModal("ERRORE", String.Format("Errore in fase di salvataggio dati allegato: {0} ({1}).", _BD.ErrorMessage, _BD.ErrorNumber))
            End If

        Catch ex As Exception
            showModal("ERRORE", String.Format("Errore in fase di salvataggio dati allegato: {0}.", ex.Message))
        End Try
    End Sub

    Public Sub CaricaListaAllegati()
        Try
            Dim _BD As New BD_BindDataMain(oConn.ConnectionString(), False)
            Dim myGruppoParam As New SP_GruppoParametri()

            Dim tabControllata As String = Session("uploadTabella")
            Dim idRigaDaAllegareFile As Integer = lblIdPrenotazione.Text

            myGruppoParam.Add(New SP_Parametro("@codtabella", 8, idRigaDaAllegareFile, DbType.Int32, ParameterDirection.Input))
            myGruppoParam.Add(New SP_Parametro("@TipoTabella", 50, tabControllata, DbType.String, ParameterDirection.Input))


            Dim tmpDT As DataTable = _BD.getDataTable("[usp_RicercaAllegati]", myGruppoParam)
            If _BD.ErrorNumber <> 0 Then
                showModal("ERRORE", String.Format("Errore in fase di estrazione dati: {0} ({1}).", _BD.ErrorMessage, _BD.ErrorNumber))
            End If

            grdAllegatiManuale.DataSource = tmpDT
            grdAllegatiManuale.DataBind()

        Catch ex As Exception
            showModal("ERRORE", String.Format("Errore in fase di estrazione dati: {0}.", ex.Message))
        End Try
    End Sub

    Public Function ComponiNomeImgData(ByVal varNomeImg As String) As String
        ComponiNomeImgData = Now.Date.Year.ToString & _
                             Now.Date.Month.ToString & _
                             Now.Date.Day.ToString & _
                             Now.TimeOfDay.Hours.ToString & _
                             Now.TimeOfDay.Minutes.ToString & _
                             Now.TimeOfDay.Seconds.ToString & _
                             varNomeImg
        Return ComponiNomeImgData
    End Function
    Protected Sub btnUpload_Click(sender As Object, e As EventArgs) Handles btnUpload.Click
        Dim fileName As String = Path.GetFileName(uploadfiles1.FileName)
        Dim varCartellaUpload As String = ""



        Using connection As New SqlClient.SqlConnection(ConfigurationManager.ConnectionStrings("db_ncbConnectionString").ConnectionString)

            connection.Open()
            Dim command As SqlClient.SqlCommand = connection.CreateCommand()
            command.Connection = connection
            Try
                command.Parameters.Clear()
                command.CommandText = "SELECT DIRECTORY FROM ALLEGATOTIPO WHERE IDTIPOALLEGATO=@IDTIPOALLEGATO"

                command.Parameters.AddWithValue("@IDTIPOALLEGATO", drpTipoAllegato.SelectedValue)
                varCartellaUpload = command.ExecuteScalar()
                connection.Close()
                ' 
            Catch ex As Exception
                showModal("ERRORE", String.Format("ERRORE NELLA FASE DI UPLOAD DEL FILE: {0}.", ex.Message))
            End Try

        End Using

        If uploadfiles1.HasFile Then
            Try
                fileName = ComponiNomeImgData(fileName)


                uploadfiles1.SaveAs(Server.MapPath(varCartellaUpload) & fileName)
                System.Threading.Thread.Sleep(2000)

                showModal("SALVA", String.Format("FILE CARICATO CON SUCCESSO!"))

                SalvaPersorsoAllegatoDB(drpTipoAllegato.SelectedValue, drpTipoAllegato.SelectedItem.Text, varCartellaUpload, fileName)
                CaricaListaAllegati()

            Catch ex As Exception
                showModal("ERRORE", ex.Message)
            End Try
        Else

        End If
    End Sub

    Public Sub deleteAllegato(ByVal sender As Object, ByVal e As System.EventArgs)
        Dim imgBtn As ImageButton = sender
        Try
            For Each tmpRow As GridViewRow In grdAllegatiManuale.Rows
                If DirectCast(tmpRow.FindControl("imgDeleteAllegato"), ImageButton).CommandArgument.Equals(imgBtn.CommandArgument) Then

                    Dim strDirectory As String = DirectCast(tmpRow.FindControl("lblDirectory"), Label).Text
                    Dim strNomefile As String = DirectCast(tmpRow.FindControl("lblNomeFile"), Label).Text

                    File.Delete(Server.MapPath(strDirectory & strNomefile))

                    Dim _BD As New BD_BindDataMain(oConn.ConnectionString(), False)
                    Dim myGruppoParam As New SP_GruppoParametri()

                    myGruppoParam.Add(New SP_Parametro("@idAllegato", 8, imgBtn.CommandArgument, DbType.Int32, ParameterDirection.Input))

                    Dim tmpDT As DataTable = _BD.getDataTable("[usp_DeleteAllegato]", myGruppoParam)
                    If _BD.ErrorNumber <> 0 Then
                        showModal("ERRORE", String.Format("Errore in fase di cancellazione dati: {0} ({1}).", _BD.ErrorMessage, _BD.ErrorNumber))
                    End If

                    CaricaListaAllegati()

                End If
            Next
        Catch ex As Exception
            showModal("ERRORE", String.Format("Errore in fase di cancellazione dati: {0}.", ex.Message))
        End Try
    End Sub


    Protected Sub btnTornaACalendario_Click(sender As Object, e As EventArgs) Handles btnTornaACalendario.Click
        ConfigurationManager.AppSettings("RicordaData") = inpDataInizioDett.Value
        Response.Redirect("default.aspx")
    End Sub


End Class
