﻿<%@ Page Title="" Language="VB" MasterPageFile="~/AR/MasterPage.master" AutoEventWireup="false" CodeFile="PrenotazioneDaFatturare.aspx.vb" Inherits="AR_Scadenzario" %>

<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="cc1" %>

<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="Server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder1" runat="Server">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/1.11.3/jquery.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.5/js/bootstrap.min.js"></script>


    <!-- MODALE MESSAGGIO -->
    <div id="myMessage" class="modal fade" role="dialog">
        <div class="modal-dialog text-left">
            <!-- Modal content-->
            <div class="modal-content">
                <div class='<%= ClassTitoloModal%>'>
                    <h4 class="card-title">
                        <asp:Label ID="lblTitoloModale" runat="server" Text=""></asp:Label>
                    </h4>
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                </div>
                <div class="modal-body">
                    <p>
                        <asp:Label ID="lblCorpoModale" runat="server" Text="Corpo"></asp:Label>
                    </p>
                </div>
                <div class="modal-footer">
                    <button class="btn btn-default" data-dismiss="modal" type="button">Chiudi</button>
                </div>
            </div>
        </div>
    </div>
    <!-- MODALE MESSAGGIO -->

    <asp:MultiView ID="mwPrenotazioni" runat="server">
        <asp:View ID="vwPrenotazioni" runat="server">
            <div class="row">
                <div class="col-lg-5">
                    <asp:SqlDataSource ID="sqlClienti" runat="server" ConnectionString="<%$ ConnectionStrings:db_ncbConnectionString %>" SelectCommand="SELECT [Nominativo], [idCliente] FROM [vw_ClientiPrenotazioniDaFatturare] ORDER BY [Nominativo]"></asp:SqlDataSource>
                    <asp:DropDownList ID="drpCliente" runat="server" CssClass="form form-control" DataSourceID="sqlClienti" DataTextField="Nominativo" DataValueField="idCliente"></asp:DropDownList>
                </div>
                <div class="col-lg-3" style="text-align: left">
                    <asp:Button ID="btnNuovoInserimento" CssClass="btn btn-success" runat="server" Text="SELEZIONA CLIENTE" />
                </div>
                 <div class="col-lg-2"></div>
                <div class="col-lg-2 text-right">
                    <asp:Button ID="btnTutteLePrenotazioni" CssClass="btn btn-primary" runat="server" Text="TUTTE LE PRENOTAZIONI" />
                </div>
            </div>
            <div class="row">
                <div class="col-lg-12">
                    <section class="card">
                        <header class="card-header">
                            <h2 class="card-title">PRENOTAZIONI DA FATTURARE</h2>
                        </header>
                        <div class="card-body ">
                            <div>
                                <asp:Button ID="btnInviaPerFatturare" style="margin-bottom:20px;" CssClass="btn btn-primary pull-right" runat="server" Text="+ Fattura" Visible="False" />
                            </div>
                            <div>
                                <asp:GridView ID="grdPrenotazioni" CssClass="table table-bordered table-responsive " runat="server" AllowPaging="True" AllowSorting="True" AutoGenerateColumns="False" DataKeyNames="idPrenotazione" PageSize="10000">
                                    <Columns>
                                        <asp:TemplateField HeaderText="Sel." ItemStyle-VerticalAlign="Top" ItemStyle-Width="1%" Visible="true">
                                            <ItemTemplate>
                                                <asp:CheckBox class="checkbox-primary" ID="chkSelezionato" runat="server" />
                                            </ItemTemplate>
                                            <ItemStyle VerticalAlign="Top" Width="1%" />
                                        </asp:TemplateField>
                                        <asp:TemplateField HeaderText="idPrenotazione" ItemStyle-VerticalAlign="Top" ItemStyle-Width="8%" Visible="false">
                                            <ItemTemplate>
                                                <asp:Label ID="lblID" runat="server" Text='<%# Eval("idPrenotazione")%>' Visible="true"></asp:Label>
                                            </ItemTemplate>
                                            <ItemStyle VerticalAlign="Top" Width="8%" />
                                        </asp:TemplateField>
                                        <asp:TemplateField HeaderText="IdCliente" ItemStyle-VerticalAlign="Top" ItemStyle-Width="8%" Visible="false">
                                            <ItemTemplate>
                                                <asp:Label ID="lblIdCliente" runat="server" Text='<%# Eval("IdCliente")%>' Visible="false"></asp:Label>
                                            </ItemTemplate>
                                            <ItemStyle VerticalAlign="Top" Width="8%" />
                                        </asp:TemplateField>
                                        <asp:TemplateField HeaderText="Cliente" ItemStyle-VerticalAlign="Top" ItemStyle-Width="8%" Visible="true">
                                            <ItemTemplate>
                                                <asp:Label ID="lblCliente" runat="server" Text='<%# Eval("Cliente")%>' Visible="true"></asp:Label>
                                            </ItemTemplate>
                                            <ItemStyle VerticalAlign="Top" Width="8%" />
                                        </asp:TemplateField>
                                        <asp:TemplateField HeaderText="Data Inizio" ItemStyle-VerticalAlign="Top" ItemStyle-Width="8%" Visible="true">
                                            <ItemTemplate>
                                                <asp:Label ID="lblDataInizio" runat="server" Text='<%# Eval("DataInizio", "{0:d}")%>' Visible="true"></asp:Label>
                                            </ItemTemplate>
                                            <ItemStyle VerticalAlign="Top" Width="8%" />
                                        </asp:TemplateField>
                                        <asp:TemplateField HeaderText="Data Fine" ItemStyle-VerticalAlign="Top" ItemStyle-Width="8%" Visible="true">
                                            <ItemTemplate>
                                                <asp:Label ID="lblDataFine" runat="server" Text='<%# Eval("DataFine" , "{0:d}")%>' Visible="true"></asp:Label>
                                            </ItemTemplate>
                                            <ItemStyle VerticalAlign="Top" Width="8%" />
                                        </asp:TemplateField>

                                        <asp:TemplateField HeaderText="Referente" ItemStyle-VerticalAlign="Top" ItemStyle-Width="8%" Visible="false">
                                            <ItemTemplate>
                                                <asp:Label ID="lblReferente" runat="server" Text='<%# Eval("Referente")%>' Visible="true"></asp:Label>
                                            </ItemTemplate>
                                            <ItemStyle VerticalAlign="Top" Width="8%" />
                                        </asp:TemplateField>

                                        <asp:TemplateField HeaderText="CodiceTour" ItemStyle-VerticalAlign="Top" ItemStyle-Width="8%" Visible="false">
                                            <ItemTemplate>
                                                <asp:Label ID="lblCodiceTour" runat="server" Text='<%# Eval("CodiceTour")%>' Visible="true"></asp:Label>
                                            </ItemTemplate>
                                            <ItemStyle VerticalAlign="Top" Width="8%" />
                                        </asp:TemplateField>

                                        <asp:TemplateField HeaderText="NrPax" ItemStyle-VerticalAlign="Top" ItemStyle-Width="8%" Visible="false">
                                            <ItemTemplate>
                                                <asp:Label ID="lblNrPax" runat="server" Text='<%# Eval("NrPax")%>' Visible="true"></asp:Label>
                                            </ItemTemplate>
                                            <ItemStyle VerticalAlign="Top" Width="8%" />
                                        </asp:TemplateField>
                                        <asp:TemplateField HeaderText="Targa" ItemStyle-VerticalAlign="Top" ItemStyle-Width="8%" Visible="true">
                                            <ItemTemplate>
                                                <asp:Label ID="lblTarga" runat="server" Text='<%# Eval("Targa")%>' Visible="true"></asp:Label>
                                            </ItemTemplate>
                                            <ItemStyle VerticalAlign="Top" Width="8%" />
                                        </asp:TemplateField>
                                        <asp:TemplateField HeaderText="Da Città" ItemStyle-VerticalAlign="Top" ItemStyle-Width="8%" Visible="true">
                                            <ItemTemplate>
                                                <asp:Label ID="lblDaCitta" runat="server" Text='<%# Eval("DaCitta")%>' Visible="true"></asp:Label>
                                            </ItemTemplate>
                                            <ItemStyle VerticalAlign="Top" Width="8%" />
                                        </asp:TemplateField>
                                        <asp:TemplateField HeaderText="DaIndirizzo" ItemStyle-VerticalAlign="Top" ItemStyle-Width="8%" Visible="false">
                                            <ItemTemplate>
                                                <asp:Label ID="lblDaIndirizzo" runat="server" Text='<%# Eval("DaIndirizzo")%>' Visible="true"></asp:Label>
                                            </ItemTemplate>
                                            <ItemStyle VerticalAlign="Top" Width="8%" />
                                        </asp:TemplateField>
                                        <asp:TemplateField HeaderText="A Città" ItemStyle-VerticalAlign="Top" ItemStyle-Width="8%" Visible="true">
                                            <ItemTemplate>
                                                <asp:Label ID="lblACitta" runat="server" Text='<%# Eval("ACitta")%>' Visible="true"></asp:Label>
                                            </ItemTemplate>
                                            <ItemStyle VerticalAlign="Top" Width="8%" />
                                        </asp:TemplateField>
                                        <asp:TemplateField HeaderText="AIndirizzo" ItemStyle-VerticalAlign="Top" ItemStyle-Width="8%" Visible="false">
                                            <ItemTemplate>
                                                <asp:Label ID="lblAIndirizzo" runat="server" Text='<%# Eval("AIndirizzo")%>' Visible="true"></asp:Label>
                                            </ItemTemplate>
                                            <ItemStyle VerticalAlign="Top" Width="8%" />
                                        </asp:TemplateField>
                                        <asp:TemplateField HeaderText="Importo" ItemStyle-VerticalAlign="Top" ItemStyle-Width="8%" Visible="true">
                                            <ItemTemplate>
                                                <asp:Label ID="lblImporto" runat="server" Text='<%# Eval("Importo", "{0:N2}")%>' Visible="true"></asp:Label>
                                            </ItemTemplate>
                                            <ItemStyle VerticalAlign="Top" Width="8%" />
                                        </asp:TemplateField>
                                        <asp:TemplateField HeaderText="TipoServizio" ItemStyle-VerticalAlign="Top" ItemStyle-Width="8%" Visible="false">
                                            <ItemTemplate>
                                                <asp:Label ID="lblTipoServizio" runat="server" Text='<%# Eval("TipoServizio")%>' Visible="true"></asp:Label>
                                            </ItemTemplate>
                                            <ItemStyle VerticalAlign="Top" Width="8%" />
                                        </asp:TemplateField>
                                        <asp:TemplateField HeaderText="Mezzo" ItemStyle-VerticalAlign="Top" ItemStyle-Width="8%" Visible="false">
                                            <ItemTemplate>
                                                <asp:Label ID="lblMezzo" runat="server" Text='<%# Eval("Mezzo")%>' Visible="true"></asp:Label>
                                            </ItemTemplate>
                                            <ItemStyle VerticalAlign="Top" Width="8%" />
                                        </asp:TemplateField>
                                        <asp:TemplateField HeaderText="IdFornitore" ItemStyle-VerticalAlign="Top" ItemStyle-Width="8%" Visible="false">
                                            <ItemTemplate>
                                                <asp:Label ID="lblIdFornitore" runat="server" Text='<%# Eval("IdFornitore")%>' Visible="true"></asp:Label>
                                            </ItemTemplate>
                                            <ItemStyle VerticalAlign="Top" Width="8%" />
                                        </asp:TemplateField>
                                        <asp:TemplateField HeaderText="Fornitore" ItemStyle-VerticalAlign="Top" ItemStyle-Width="8%" Visible="false">
                                            <ItemTemplate>
                                                <asp:Label ID="lblFornitore" runat="server" Text='<%# Eval("Fornitore")%>' Visible="true"></asp:Label>
                                            </ItemTemplate>
                                            <ItemStyle VerticalAlign="Top" Width="8%" />
                                        </asp:TemplateField>
                                        <asp:TemplateField HeaderText="CostoServizio" ItemStyle-VerticalAlign="Top" ItemStyle-Width="8%" Visible="false">
                                            <ItemTemplate>
                                                <asp:Label ID="lblCostoServizio" runat="server" Text='<%# Eval("CostoServizio")%>' Visible="true"></asp:Label>
                                            </ItemTemplate>
                                            <ItemStyle VerticalAlign="Top" Width="8%" />
                                        </asp:TemplateField>
                                        <asp:TemplateField HeaderText="Note" ItemStyle-VerticalAlign="Top" ItemStyle-Width="8%" Visible="false">
                                            <ItemTemplate>
                                                <asp:Label ID="lblNote" runat="server" Text='<%# Eval("Note")%>' Visible="true"></asp:Label>
                                            </ItemTemplate>
                                            <ItemStyle VerticalAlign="Top" Width="8%" />
                                        </asp:TemplateField>
                                        <asp:TemplateField HeaderText="codFattura" ItemStyle-VerticalAlign="Top" ItemStyle-Width="8%" Visible="false">
                                            <ItemTemplate>
                                                <asp:Label ID="lblcodFattura" runat="server" Text='<%# Eval("codFattura")%>' Visible="true"></asp:Label>
                                            </ItemTemplate>
                                            <ItemStyle VerticalAlign="Top" Width="8%" />
                                        </asp:TemplateField>
                                        <asp:TemplateField HeaderText="AliquotaIva" ItemStyle-VerticalAlign="Top" ItemStyle-Width="8%" Visible="false">
                                            <ItemTemplate>
                                                <asp:Label ID="lblAliquotaIva" runat="server" Text='<%# Eval("AliquotaIva")%>' Visible="true"></asp:Label>
                                            </ItemTemplate>
                                            <ItemStyle VerticalAlign="Top" Width="8%" />
                                        </asp:TemplateField>
                                        <asp:TemplateField HeaderText="TourEstero" ItemStyle-VerticalAlign="Top" ItemStyle-Width="8%" Visible="true">
                                            <ItemTemplate>
                                                <asp:CheckBox ID="chkTourEstero" runat="server" Checked='<%# Eval("TourEstero")%>' Enabled="false" />
                                            </ItemTemplate>
                                            <ItemStyle VerticalAlign="Top" Width="8%" />
                                        </asp:TemplateField>
                                        <asp:TemplateField HeaderText="TestoAliquota" ItemStyle-VerticalAlign="Top" ItemStyle-Width="8%" Visible="false">
                                            <ItemTemplate>
                                                <asp:Label ID="lblTestoAliquota" runat="server" Text='<%# Eval("TestoAliquota")%>' Visible="true"></asp:Label>
                                            </ItemTemplate>
                                            <ItemStyle VerticalAlign="Top" Width="8%" />
                                        </asp:TemplateField>
                                    </Columns>
                                    <EmptyDataTemplate>
                                        NESSUNA PRENOTAZIONE TROVATA
                                    </EmptyDataTemplate>
                                    <PagerSettings Mode="NumericFirstLast" PageButtonCount="1000" />
                                </asp:GridView>
                            </div>
                        </div>
                    </section>
                </div>
            </div>
        </asp:View>
        <asp:View ID="vwFattura" runat="server">
            <div class="row">
                <div class="col-lg-12 right" style="margin-bottom: 25px">
                    <asp:Button ID="btnSalvaFattura" CssClass="btn btn-primary pull-right" runat="server" Text="+ SALVA FATTURA" />
                </div>
                <div class="col-lg-12 ">
                    <section class="card card-featured card-featured-primary mb-6">
                        <header class="card-header">
                            <h2 class="card-title">INTESTAZIONE FATTURA</h2>
                            <asp:HiddenField ID="hdfIdCliente" runat="server" />
                        </header>
                        <div class="card-body ">
                            <div class="form-group row">
                                <div class="col-md-4">
                                    <div class="col-md-12">
                                        Data
                             <div class="input-group">
                                 <span class="input-group-addon ">
                                     <i class="fa fa-calendar"></i>
                                 </span>
                                 <input id="inpDataFattura" runat="server" type="text" data-plugin-datepicker data-plugin-options='{"language": "it"}' class="form-control " />
                             </div>
                                    </div>
                                    <div class="col-md-12">
                                        Nr. Fattura
                             <asp:TextBox CssClass="form form-control " ID="txtNrNattura" runat="server" Enabled="false"></asp:TextBox>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="col-md-12">
                                        Ragione Sociale
                            <asp:TextBox CssClass="form form-control form-control-sm " ID="txtRagioneSociale" runat="server"></asp:TextBox>
                                        Partita Iva
                            <asp:TextBox CssClass="form form-control form-control-sm  " ID="txtPartitaIva" runat="server"></asp:TextBox>
                                        Codice Fiscale
                            <asp:TextBox CssClass="form form-control form-control-sm  " ID="txtCodiceFiscale" runat="server"></asp:TextBox>

                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="col-md-12">
                                        Indirizzo
                            <asp:TextBox CssClass="form form-control form-control-sm  " ID="TxtIndirizzo" runat="server" TextMode="MultiLine" Height="72px"></asp:TextBox>
                                        Email - Sito Web
                            <asp:TextBox CssClass="form form-control form-control-sm  " ID="txtWeb" runat="server"></asp:TextBox>
                                    </div>
                                </div>

                            </div>
                        </div>
                    </section>
                </div>
                <div class="col-lg-12 ">
                    <section class="card card-featured card-featured-danger mb-6">
                        <header class="card-header">
                            <h2 class="card-title">DETTAGLIO FATTURA</h2>
                        </header>
                        <div class="card-body ">
                            <div class="col-lg-12" style="text-align: right; margin-bottom: 10px">
                                <asp:Button ID="Button1" CssClass="btn btn-default" runat="server" Text="+ AGGIUNGI VOCE" Visible="false" />
                            </div>
                            <asp:GridView ID="grdLAvori" CssClass="table table-sm table-striped table-bordered  table-responsive " runat="server" AllowPaging="True" AllowSorting="True" AutoGenerateColumns="False" PageSize="100" ShowFooter="True">
                                <%-- OnRowDeleting="grvStudentDetails_RowDeleting"--%>
                                <Columns>
                                    <asp:BoundField DataField="RowNumber" HeaderText="RowNumber" ItemStyle-Width="1%" Visible="TRUE">
                                        <ItemStyle Width="1%"></ItemStyle>
                                    </asp:BoundField>
                                    <asp:BoundField DataField="Codice" HeaderText="Codice" ItemStyle-Width="1%" Visible="TRUE">
                                        <ItemStyle Width="1%"></ItemStyle>
                                    </asp:BoundField>
                                    <asp:BoundField DataField="Descrizione" HeaderText="Descrizione" ItemStyle-Width="1%" Visible="TRUE">
                                        <ItemStyle Width="1%"></ItemStyle>
                                    </asp:BoundField>
                                    <asp:BoundField DataField="Qta" HeaderText="Qta" ItemStyle-Width="1%" Visible="TRUE" DataFormatString="{0:N2}">
                                        <ItemStyle Width="1%"></ItemStyle>
                                    </asp:BoundField>
                                    <asp:BoundField DataField="Imponibile" HeaderText="Importo" ItemStyle-Width="1%" Visible="TRUE" DataFormatString="{0:N2}">
                                        <ItemStyle Width="1%"></ItemStyle>
                                    </asp:BoundField>
                                    <asp:BoundField DataField="Iva" HeaderText="Iva" ItemStyle-Width="1%" Visible="TRUE" DataFormatString="{0:N2}">
                                        <ItemStyle Width="1%"></ItemStyle>
                                    </asp:BoundField>
                                    <asp:BoundField DataField="Ritenuta" HeaderText="Ritenuta" ItemStyle-Width="1%" Visible="TRUE" DataFormatString="{0:N2}">
                                        <ItemStyle Width="1%"></ItemStyle>
                                    </asp:BoundField>
                                    <asp:BoundField DataField="Importo" HeaderText="Importo" ItemStyle-Width="1%" Visible="TRUE" DataFormatString="{0:N2}">
                                        <ItemStyle Width="1%"></ItemStyle>
                                    </asp:BoundField>
                                    <asp:BoundField DataField="Libera" HeaderText="Libera" ItemStyle-Width="1%" Visible="TRUE">
                                        <ItemStyle Width="1%"></ItemStyle>
                                    </asp:BoundField>
                                    <asp:BoundField DataField="CodPrenotazione" HeaderText="CodPrenotazione" ItemStyle-Width="1%" Visible="TRUE">
                                        <ItemStyle Width="1%"></ItemStyle>
                                    </asp:BoundField>
                                    <asp:CommandField ShowDeleteButton="True" ItemStyle-Width="1%" ButtonType="Image" DeleteImageUrl="~/img/Delete.png">
                                        <ItemStyle Width="1%"></ItemStyle>
                                    </asp:CommandField>
                                </Columns>
                                <EmptyDataTemplate>
                                    NESSUN LAVORO INSERITO IN FATTURA
                                </EmptyDataTemplate>
                                <PagerSettings Mode="NumericFirstLast" PageButtonCount="20" />
                            </asp:GridView>
                        </div>
                        <footer>
                            <div class="row">
                                <div class="col-lg-2  text-lg-right">
                                    <h4>Imponibile €
                                <br />
                                        <asp:Label ID="lblImponibilePRN" runat="server" Text="0,00"></asp:Label></h4>
                                </div>
                                <div class="col-lg-2  text-lg-right">
                                    <h4>IVA €<br />
                                        <asp:Label ID="lblIva" runat="server" Text="0,00"></asp:Label></h4>
                                </div>
                                <div class="col-lg-2  text-lg-right">
                                    <h4>Imp. Acc. €<br />
                                        <asp:Label ID="lblImponibileACC" runat="server" Text="0,00"></asp:Label></h4>
                                </div>
                                <div class="col-lg-2  text-lg-right">
                                    <h4>Non imp. €
                                <br />
                                        <asp:Label ID="lblImportoEsente" runat="server" Text="0,00"></asp:Label></h4>
                                </div>
                                <div class="col-lg-2  text-lg-right">
                                    <h4>Ritenuta €<br />
                                        <asp:Label ID="lblRitenuta" runat="server" Text="0,00"></asp:Label></h4>
                                </div>
                                <div class="col-lg-2 text-lg-right " style="color: red">
                                    <h4>TOT. IMPORTO €<br />
                                        <asp:Label ID="lblImportoFattura" runat="server" Text="0,00"></asp:Label></h4>
                                </div>
                            </div>
                        </footer>
                    </section>
                </div>
            </div>
        </asp:View>
    </asp:MultiView>


</asp:Content>

