﻿Imports System.Data
Imports SP_NameSpace
Imports System.IO
Imports System.Data.SqlClient

Partial Class AR_Scadenzario
    Inherits System.Web.UI.Page
    Private oConn As New SqlClient.SqlConnection(ConfigurationManager.ConnectionStrings("db_ncbConnectionString").ConnectionString)
    Public varAbilita As Boolean = True
    '*****************************************************************************************
    'INIZIO CODICE PER FINESTRA MODALE
    '*****************************************************************************************

    Public ClassTitoloModal As String = "modal-header alert alert-success"
    Public Sub showModal(ByVal Classe As String, ByVal corpo As String)
        Select Case Classe
            Case "SALVA"
                ClassTitoloModal = "modal-header alert alert-success"
                lblTitoloModale.Text = "SALVA"
            Case "ATTENZIONE"
                ClassTitoloModal = "modal-header alert alert-danger"
                lblTitoloModale.Text = "ATTENZIONE"
            Case "INFORMAZIONE"
                ClassTitoloModal = "modal-header alert alert-info"
                lblTitoloModale.Text = "INFORMAZIONE"
            Case "ERRORE"
                ClassTitoloModal = "modal-header alert alert-warning"
                lblTitoloModale.Text = "ERRORE"
        End Select

        lblCorpoModale.Text = corpo
        ScriptManager.RegisterStartupScript(Me.Page, Page.GetType, "HideLoginDialog", "<script type=""text/javascript"">$(document).ready(function () { $('#myMessage').modal('show');});</script>", False)

    End Sub

    Protected Sub btnCloseModal_Click(sender As Object, e As EventArgs)
        ScriptManager.RegisterStartupScript(Page, Page.[GetType](), "myModalHide", "$('#myMessage').hide();", True)
        ScriptManager.RegisterStartupScript(Page, Page.[GetType](), "myModalAgainShow", "$('#myMessage').modal();", True)
    End Sub
    '*****************************************************************************************
    'FINE CODICE PER FINESTRA MODALE
    '*****************************************************************************************
    Private Sub CambiaTitoloMasterPage(ByVal Testo As String)
        DirectCast(Master.FindControl("lblTitoloSezione"), Label).Text = Testo
    End Sub

    Public Sub OpenModal(ByVal NomeDivModale As String)
        ScriptManager.RegisterStartupScript(Me.Page, Page.GetType, "HideLoginDialog", "<script type=""text/javascript"">$(document).ready(function () { $('#" & NomeDivModale & "').modal('show');});</script>", False)
    End Sub

    Protected Sub Page_Load(sender As Object, e As EventArgs) Handles Me.Load
        If Not IsPostBack Then
            CambiaTitoloMasterPage("PRENOTAZIONI DA FATTURARE")
            TutteLePrenotazioni()
            mwPrenotazioni.ActiveViewIndex = 0
        End If
    End Sub

    Private Sub RicercaPrenotazioni()
        Try
            Dim _BD As New BD_BindDataMain(oConn.ConnectionString(), False)
            Dim myGruppoParam As New SP_GruppoParametri()
            myGruppoParam.Add(New SP_Parametro("@idCliente", 50, drpCliente.SelectedValue, DbType.Int32, ParameterDirection.Input))
            Dim tmpDT As DataTable = _BD.getDataTable("[usp_RicercaPrenotazionedaFatturare]", myGruppoParam)
            If _BD.ErrorNumber <> 0 Then
                showModal("ERRORE", String.Format("Errore in fase di estrazione dati: {0} ({1}).", _BD.ErrorMessage, _BD.ErrorNumber))
            End If
            grdPrenotazioni.DataSource = tmpDT
            grdPrenotazioni.DataBind()

        Catch ex As Exception
            showModal("ERRORE", String.Format("Errore In fase di estrazione dati: {0}.", ex.Message))
        End Try
    End Sub

    Protected Sub btnNuovoInserimento_Click(sender As Object, e As EventArgs) Handles btnNuovoInserimento.Click
        btnInviaPerFatturare.Visible = True
        RicercaPrenotazioni()
    End Sub

    Protected Sub btnTutteLePrenotazioni_Click(sender As Object, e As EventArgs) Handles btnTutteLePrenotazioni.Click
        btnInviaPerFatturare.Visible = False
        TutteLePrenotazioni()
    End Sub

    Private Sub TutteLePrenotazioni()
        Try

            Dim _BD As New BD_BindDataMain(oConn.ConnectionString(), False)
            Dim myGruppoParam As New SP_GruppoParametri()

            Dim tmpDT As DataTable = _BD.getDataTable("[usp_RicercaPrenotazioneDaFatturareTutte]", myGruppoParam)
            If _BD.ErrorNumber <> 0 Then
                showModal("ERRORE", String.Format("Errore in fase di estrazione dati: {0} ({1}).", _BD.ErrorMessage, _BD.ErrorNumber))
            End If
            grdPrenotazioni.DataSource = tmpDT
            grdPrenotazioni.DataBind()

        Catch ex As Exception
            showModal("ERRORE", String.Format("Errore In fase di estrazione dati: {0}.", ex.Message))
        End Try
    End Sub


    '*****************************************************************************************
    ' SEZIONE FATTURA
    '*****************************************************************************************
    Protected Sub btnInviaPerFatturare_Click(sender As Object, e As EventArgs) Handles btnInviaPerFatturare.Click

        'DATATABLE CHE CONTERRA' il Dettaglio Fattura

        Dim dt As DataTable = New DataTable()
        Dim dr As DataRow = Nothing
        dt.Columns.Add(New DataColumn("RowNumber", GetType(String)))
        dt.Columns.Add(New DataColumn("Codice", GetType(String)))
        dt.Columns.Add(New DataColumn("Descrizione", GetType(String)))
        dt.Columns.Add(New DataColumn("Qta", GetType(Double)))
        dt.Columns.Add(New DataColumn("Imponibile", GetType(Double)))
        dt.Columns.Add(New DataColumn("Iva", GetType(Double)))
        dt.Columns.Add(New DataColumn("Ritenuta", GetType(Double)))
        dt.Columns.Add(New DataColumn("Importo", GetType(Double)))
        dt.Columns.Add(New DataColumn("libera", GetType(Boolean)))
        dt.Columns.Add(New DataColumn("CodPrenotazione", GetType(Integer)))

        Dim CaricaIntestazioneFattura As Boolean = False
        grdLAvori.DataBind()

        For Each tmpRow As GridViewRow In grdPrenotazioni.Rows
            If DirectCast(tmpRow.FindControl("chkSelezionato"), CheckBox).Checked = True Then
                If CaricaIntestazioneFattura = False Then
                    CaricaIntestazioneFattura = True
                    'INTESTAZIONE FATTURA
                    IntestazioneFattura(DirectCast(tmpRow.FindControl("lblIdCliente"), Label).Text)
                    hdfIdCliente.Value = DirectCast(tmpRow.FindControl("lblIdCliente"), Label).Text
                End If

                'Dim varDescrizione As String = "Prenotazione - " & _
                '                                DirectCast(tmpRow.FindControl("lblDataInizio"), Label).Text & " - " & _
                '                                DirectCast(tmpRow.FindControl("lblDataFine"), Label).Text & vbCrLf & _
                '                                DirectCast(tmpRow.FindControl("lblDaCitta"), Label).Text & " - " & _
                '                                DirectCast(tmpRow.FindControl("lblACitta"), Label).Text


                Dim varDescrizione As String = ""
                Dim varDataPrenotazione As String = ""

                If DirectCast(tmpRow.FindControl("chkTourEstero"), CheckBox).Checked = True Then
                    varDescrizione = DirectCast(tmpRow.FindControl("lblNote"), Label).Text & _
                        "<br/>(" & DirectCast(tmpRow.FindControl("lblTestoAliquota"), Label).Text & ")"
                Else
                    varDescrizione = DirectCast(tmpRow.FindControl("lblNote"), Label).Text
                End If


                If DirectCast(tmpRow.FindControl("lblDataInizio"), Label).Text.Trim.Equals(DirectCast(tmpRow.FindControl("lblDataFine"), Label).Text.Trim) Then
                    varDataPrenotazione = " (Data: " & DirectCast(tmpRow.FindControl("lblDataInizio"), Label).Text & ")"
                Else
                    varDataPrenotazione = " (Data Inizio: " & DirectCast(tmpRow.FindControl("lblDataInizio"), Label).Text & " - Data Fine: " & DirectCast(tmpRow.FindControl("lblDataFine"), Label).Text & ")"
                End If


                'PRIMO DETTAGLIO FATTURA  -  PRENOTAZIONE
                dr = dt.NewRow()
                dr("RowNumber") = CInt(DirectCast(tmpRow.FindControl("lblID"), Label).Text)
                dr("Codice") = DirectCast(tmpRow.FindControl("lblCodiceTour"), Label).Text
                dr("Descrizione") = varDescrizione & varDataPrenotazione
                dr("Qta") = 1
                dr("Imponibile") = CDbl(DirectCast(tmpRow.FindControl("lblImporto"), Label).Text)
                dr("Iva") = CDbl(DirectCast(tmpRow.FindControl("lblAliquotaIva"), Label).Text)
                dr("Ritenuta") = 0
                dr("Importo") = CalcolaImporto(CDbl(DirectCast(tmpRow.FindControl("lblImporto"), Label).Text), CDbl(DirectCast(tmpRow.FindControl("lblAliquotaIva"), Label).Text), 0)
                dr("libera") = 0
                dr("CodPrenotazione") = CInt(DirectCast(tmpRow.FindControl("lblID"), Label).Text)
                dt.Rows.Add(dr)


                'RICERCA ACCESSORI DELLA PRENOTAZIONE PER INSERIRLI INFATTURA
                Dim conn As SqlConnection = New SqlConnection
                conn.ConnectionString = ConfigurationManager.ConnectionStrings("db_ncbConnectionString").ConnectionString
                Dim cmd As SqlCommand = New SqlCommand
                cmd.CommandText = "select idAccessorie, Descrizione, aliquotaIva, Imponibile, idPrenotazione from " & _
                " Accessorie where idPrenotazione = @idPrenotazione"
                cmd.Parameters.AddWithValue("@idPrenotazione", CInt(DirectCast(tmpRow.FindControl("lblID"), Label).Text))
                cmd.Connection = conn
                conn.Open()
                Dim employees As List(Of String) = New List(Of String)
                Dim sdr As SqlDataReader = cmd.ExecuteReader
                While sdr.Read


                    'SOTTORIGHE  DETTAGLIO FATTURA  -  ACCESSORIE
                    dr = dt.NewRow()
                    dr("RowNumber") = CInt(sdr("idAccessorie"))
                    dr("Codice") = "ACC"
                    dr("Descrizione") = sdr("Descrizione")
                    dr("Qta") = 1
                    dr("Imponibile") = CDbl(sdr("Imponibile"))
                    dr("Iva") = CDbl(sdr("aliquotaIva"))
                    dr("Ritenuta") = 0
                    dr("Importo") = CalcolaImporto(CDbl(sdr("Imponibile")), CDbl(sdr("aliquotaIva")), 0)
                    dr("libera") = 0
                    dr("CodPrenotazione") = CInt(DirectCast(tmpRow.FindControl("lblID"), Label).Text)
                    dt.Rows.Add(dr)
                End While
                conn.Close()
            End If
        Next

        grdLAvori.DataSource = dt
        grdLAvori.DataBind()

        dt.Dispose()
        dr.Delete()

        CalcoloFattura()

        mwPrenotazioni.ActiveViewIndex = 1

    End Sub

    Private Function CalcolaImporto(ByVal varImponibile As Double, ByVal varIva As Double, ByVal varRit As Double) As Double
        Dim IvaImporto As Double = (varImponibile * varIva) / 100
        Dim RitImporto As Double = (varImponibile * varRit) / 100
        Dim varImporto As Double = varImponibile + IvaImporto - RitImporto
        Return varImporto
    End Function
    Private Sub IntestazioneFattura(ByVal idCliente As Integer)

        inpDataFattura.Value = Now.Date.ToShortDateString
        Dim IntestazioneRiuscita As Boolean = False

        Dim conn As SqlConnection = New SqlConnection
        conn.ConnectionString = ConfigurationManager.ConnectionStrings("db_ncbConnectionString").ConnectionString
        Dim cmd As SqlCommand = New SqlCommand
        cmd.CommandText = "select idAnagrafica, Denominazione, Indirizzo, Citta, Cap, Provincia, PartitaIva, CodiceFiscale, Email  from " & _
        " Anagrafica where idAnagrafica = @IdAnagrafica"
        cmd.Parameters.AddWithValue("@IdAnagrafica", idCliente)
        cmd.Connection = conn
        conn.Open()
        Dim employees As List(Of String) = New List(Of String)
        Dim sdr As SqlDataReader = cmd.ExecuteReader
        While sdr.Read
            txtRagioneSociale.Text = sdr("Denominazione")
            TxtIndirizzo.Text = sdr("Indirizzo") & vbCrLf & sdr("Cap") & " " & sdr("Citta") & " " & sdr("Provincia")
            txtPartitaIva.Text = sdr("PartitaIva")
            txtCodiceFiscale.Text = sdr("CodiceFiscale")
            txtWeb.Text = sdr("Email")
        End While
        conn.Close()
    End Sub

    Private Sub CalcoloFattura()
        lblImportoFattura.Text = "0,00"
        lblImponibilePRN.Text = "0,00"
        lblImponibileACC.Text = "0,00"
        lblIva.Text = "0,00"
        lblRitenuta.Text = "0,00"

        Dim ImponibileEsenteIva As Double = 0
        Dim ImportoFattura As Double = 0
        Dim ImponibilePRN As Double = 0
        Dim ImponibileACC As Double = 0
        Dim impIva As Double = 0
        Dim ImpRit As Double = 0

        For i As Integer = 0 To grdLAvori.Rows.Count - 1


            If grdLAvori.Rows(i).Cells(1).Text = "ACC" Then
                ImponibileACC += CDbl(grdLAvori.Rows(i).Cells(4).Text) * CDbl(grdLAvori.Rows(i).Cells(3).Text)
            Else
                If CDbl(grdLAvori.Rows(i).Cells(5).Text) <> 0 Then
                    ImponibilePRN += CDbl(grdLAvori.Rows(i).Cells(4).Text) * CDbl(grdLAvori.Rows(i).Cells(3).Text)
                Else
                    ImponibileEsenteIva += CDbl(grdLAvori.Rows(i).Cells(4).Text) * CDbl(grdLAvori.Rows(i).Cells(3).Text)
                End If
            End If


            impIva += (CDbl(grdLAvori.Rows(i).Cells(4).Text) * CDbl(grdLAvori.Rows(i).Cells(5).Text)) / 100
            ImpRit += (CDbl(grdLAvori.Rows(i).Cells(4).Text) * CDbl(grdLAvori.Rows(i).Cells(6).Text)) / 100
            ImportoFattura += CDbl(grdLAvori.Rows(i).Cells(7).Text)
        Next

        lblImportoEsente.Text = ImponibileEsenteIva.ToString("N2")
        lblImportoFattura.Text = ImportoFattura.ToString("N2")
        lblImponibilePRN.Text = ImponibilePRN.ToString("N2")
        lblImponibileACC.Text = ImponibileACC.ToString("N2")
        lblIva.Text = impIva.ToString("N2")
        lblRitenuta.Text = ImpRit.ToString("N2")
    End Sub


    Protected Sub btnSalvaFattura_Click(sender As Object, e As EventArgs) Handles btnSalvaFattura.Click
        If grdLAvori.Rows.Count <= 0 Then
            showModal("ERORE", "NESSUN DETTAGLIO FATTURA INSERITO")
            Exit Sub
        End If

        If txtRagioneSociale.Text.Length = 0 Then
            showModal("ERORE", "INTESTAZIONE DELLA FATTURA NON INSERITA")
            Exit Sub
        End If

        Using ConnLog As New SqlClient.SqlConnection(ConfigurationManager.ConnectionStrings("db_ncbConnectionString").ConnectionString)
            ConnLog.Open()

            Dim CommandLog As SqlClient.SqlCommand = ConnLog.CreateCommand()
            Dim transactionLog As SqlClient.SqlTransaction
            transactionLog = ConnLog.BeginTransaction("Transactionlog")
            CommandLog.Connection = ConnLog
            CommandLog.Transaction = transactionLog

            Try

                CommandLog.Parameters.Clear()
                CommandLog.CommandText = "SELECT COUNT(IDFATTURA) FROM FATTURAATTIVA WHERE DATA > @Data"
                CommandLog.Parameters.AddWithValue("@Data", CDate(inpDataFattura.Value))
                Dim objExecuteNrFatture As Object = CommandLog.ExecuteScalar

                If objExecuteNrFatture > 0 Then
                    showModal("ERORE", "LA DATA DELLA FATTURA NON PUO' ESSERE INFERIORE ALLA DATA DELLE FATTURE GIA' EMESSE")
                    transactionLog.Commit()
                    ConnLog.Close()
                    Exit Sub
                End If


                CommandLog.Parameters.Clear()
                CommandLog.CommandText = "SELECT COUNT(IDFATTURA) FROM FATTURAATTIVA WHERE YEAR(DATA) =@ANNO"
                CommandLog.Parameters.AddWithValue("@ANNO", CDate(inpDataFattura.Value).Date.Year)

                Dim NrFattura As String = ""

                Dim objExecute As Object = CommandLog.ExecuteScalar

                If objExecute = 0 Then
                    NrFattura = "1"
                Else
                    NrFattura = objExecute + 1
                End If

                NrFattura = NrFattura.ToString.PadLeft(5, "0"c) & "/" & CDate(inpDataFattura.Value).Date.Year

                txtNrNattura.Text = NrFattura

                CommandLog.Parameters.Clear()
                CommandLog.CommandText = "INSERT INTO FATTURAATTIVA (Data, Numero, CodAnagrafica, RagioneSociale, Indirizzo, " & _
                                         "PartitaIva, CodiceFiscale, Web, Imponibile, ImportoIva, ImportoRitenuta, ImportoFattura, Evasa) VALUES " & _
                                         "(@Data, @Numero, @CodAnagrafica, @RagioneSociale, @Indirizzo, " & _
                                         "@PartitaIva, @CodiceFiscale, @Web, @Imponibile, @ImportoIva, @ImportoRitenuta, @ImportoFattura, '0');" & _
                                          "SELECT @@IDENTITY AS 'Identity'"

                CommandLog.Parameters.AddWithValue("@Data", CDate(inpDataFattura.Value))
                CommandLog.Parameters.AddWithValue("@Numero", NrFattura)
                CommandLog.Parameters.AddWithValue("@CodAnagrafica", hdfIdCliente.Value)
                CommandLog.Parameters.AddWithValue("@RagioneSociale", txtRagioneSociale.Text)
                CommandLog.Parameters.AddWithValue("@Indirizzo", TxtIndirizzo.Text)
                CommandLog.Parameters.AddWithValue("@PartitaIva", txtPartitaIva.Text)
                CommandLog.Parameters.AddWithValue("@CodiceFiscale", txtCodiceFiscale.Text)
                CommandLog.Parameters.AddWithValue("@Web", txtWeb.Text)
                CommandLog.Parameters.AddWithValue("@Imponibile", CDbl(lblImponibilePRN.Text) + CDbl(lblImponibileACC.Text))
                CommandLog.Parameters.AddWithValue("@ImportoIva", CDbl(lblIva.Text))
                CommandLog.Parameters.AddWithValue("@ImportoRitenuta", CDbl(lblRitenuta.Text))
                CommandLog.Parameters.AddWithValue("@ImportoFattura", CDbl(lblImportoFattura.Text))

                Dim IdFattura As Integer = CommandLog.ExecuteScalar()

                For I As Integer = 0 To grdLAvori.Rows.Count - 1
                    CommandLog.Parameters.Clear()
                    CommandLog.CommandText = "INSERT INTO FATTURAATTIVADETTAGLIO (Codice, Descrizione, Quantita, Imponibile, Iva, " & _
                                             "Ritenuta, Importo, CodFattura, libera, CodPrenotazione) VALUES " & _
                                             "(@Codice, @Descrizione, @Quantita, @Imponibile, @Iva, " & _
                                             "@Ritenuta, @Importo, @CodFattura, @libera,  @CodPrenotazione);" & _
                                             " UPDATE Prenotazione SET codFattura=@codFattura WHERE idPrenotazione=@CodPrenotazione"

                    CommandLog.Parameters.AddWithValue("@Codice", grdLAvori.Rows(I).Cells(1).Text)
                    CommandLog.Parameters.AddWithValue("@Descrizione", grdLAvori.Rows(I).Cells(2).Text)
                    CommandLog.Parameters.AddWithValue("@Quantita", CDbl(grdLAvori.Rows(I).Cells(3).Text))
                    CommandLog.Parameters.AddWithValue("@Imponibile", CDbl(grdLAvori.Rows(I).Cells(4).Text))
                    CommandLog.Parameters.AddWithValue("@Iva", CDbl(grdLAvori.Rows(I).Cells(5).Text))
                    CommandLog.Parameters.AddWithValue("@Ritenuta", CDbl(grdLAvori.Rows(I).Cells(6).Text))
                    CommandLog.Parameters.AddWithValue("@Importo", CDbl(grdLAvori.Rows(I).Cells(7).Text))
                    CommandLog.Parameters.AddWithValue("@CodFattura", IdFattura)
                    CommandLog.Parameters.AddWithValue("@libera", grdLAvori.Rows(I).Cells(8).Text)
                    CommandLog.Parameters.AddWithValue("@CodPrenotazione", grdLAvori.Rows(I).Cells(9).Text)
                    CommandLog.ExecuteNonQuery()


                Next

                transactionLog.Commit()
                ConnLog.Close()

                mwPrenotazioni.ActiveViewIndex = 0
                RicercaPrenotazioni()

                showModal("SALVA", "FATTURA SALVATA CORRETTAMENTE")

                Response.Redirect("FatturaRicerca.aspx?opt=mod&id=" & IdFattura)

            Catch ex As Exception
                showModal("ERORE", String.Format("Ripristino Dati, " & vbCrLf & "{0}", ex))
                Try
                    transactionLog.Rollback()
                Catch ex2 As Exception
                    showModal("ERORE", String.Format("Ripristino Dati, " & vbCrLf & "{0}", ex2))
                End Try
            End Try
        End Using
    End Sub


End Class
