﻿Imports System.Data
Imports SP_NameSpace
Imports System.IO

Partial Class AR_Scadenzario
    Inherits System.Web.UI.Page
    Private oConn As New SqlClient.SqlConnection(ConfigurationManager.ConnectionStrings("db_ncbConnectionString").ConnectionString)

    '*****************************************************************************************
    'INIZIO CODICE PER FINESTRA MODALE
    '*****************************************************************************************

    Public ClassTitoloModal As String = "modal-header alert alert-success"
    Public Sub showModal(ByVal Classe As String, ByVal corpo As String)
        Select Case Classe
            Case "SALVA"
                ClassTitoloModal = "modal-header alert alert-success"
                lblTitoloModale.Text = "SALVA"
            Case "ATTENZIONE"
                ClassTitoloModal = "modal-header alert alert-danger"
                lblTitoloModale.Text = "ATTENZIONE"
            Case "INFORMAZIONE"
                ClassTitoloModal = "modal-header alert alert-info"
                lblTitoloModale.Text = "INFORMAZIONE"
            Case "ERRORE"
                ClassTitoloModal = "modal-header alert alert-warning"
                lblTitoloModale.Text = "ERRORE"
        End Select

        lblCorpoModale.Text = corpo
        ScriptManager.RegisterStartupScript(Me.Page, Page.GetType, "HideLoginDialog", "<script type=""text/javascript"">$(document).ready(function () { $('#myMessage').modal('show');});</script>", False)

    End Sub

    Protected Sub btnCloseModal_Click(sender As Object, e As EventArgs)
        ScriptManager.RegisterStartupScript(Page, Page.[GetType](), "myModalHide", "$('#myMessage').hide();", True)
        ScriptManager.RegisterStartupScript(Page, Page.[GetType](), "myModalAgainShow", "$('#myMessage').modal();", True)
    End Sub
    '*****************************************************************************************
    'FINE CODICE PER FINESTRA MODALE
    '*****************************************************************************************
    Protected Sub drpTipoTabella_SelectedIndexChanged(sender As Object, e As EventArgs) Handles drpTipoTabella.SelectedIndexChanged
        If drpTipoTabella.SelectedValue = "MEZZI" Then
            CaricaMezzi()
            OpenModal("ModalInsScad")
        Else
            CaricaAnagrafica()
            OpenModal("ModalInsScad")
        End If
    End Sub

    Private Sub CaricaMezzi()
        drpLegaScadenza.Items.Clear()
        Try

            Dim _BD As New BD_BindDataMain(oConn.ConnectionString(), False)
            Dim myGruppoParam As New SP_GruppoParametri()
            myGruppoParam.Add(New SP_Parametro("@valore", 50, "%", DbType.String, ParameterDirection.Input))
            Dim tmpDT As DataTable = _BD.getDataTable("[usp_RicercaMezzi]", myGruppoParam)
            If _BD.ErrorNumber <> 0 Then
                showModal("ERRORE", String.Format("Errore in fase di estrazione dati: {0} ({1}).", _BD.ErrorMessage, _BD.ErrorNumber))
            End If
            drpLegaScadenza.DataSource = tmpDT
            drpLegaScadenza.DataTextField = "Targa"
            drpLegaScadenza.DataValueField = "idMezzo"
            drpLegaScadenza.DataBind()
            '  drpLegaScadenza.SelectedValue = -1
        Catch ex As Exception
            showModal("ERRORE", String.Format("Errore In fase di estrazione dati: {0}.", ex.Message))
        End Try
    End Sub

    Private Sub CaricaAnagrafica()
        drpLegaScadenza.Items.Clear()
        Try

            Dim _BD As New BD_BindDataMain(oConn.ConnectionString(), False)
            Dim myGruppoParam As New SP_GruppoParametri()
            myGruppoParam.Add(New SP_Parametro("@Valore", 50, "%", DbType.String, ParameterDirection.Input))
            myGruppoParam.Add(New SP_Parametro("@Tipologia", 50, "AUTISTA", DbType.String, ParameterDirection.Input))
            Dim tmpDT As DataTable = _BD.getDataTable("[usp_AnagraficaRicreca]", myGruppoParam)
            If _BD.ErrorNumber <> 0 Then
                showModal("ERRORE", String.Format("Errore in fase di estrazione dati: {0} ({1}).", _BD.ErrorMessage, _BD.ErrorNumber))
            End If
            drpLegaScadenza.DataSource = tmpDT
            drpLegaScadenza.DataTextField = "Denominazione"
            drpLegaScadenza.DataValueField = "idAnagrafica"
            drpLegaScadenza.DataBind()
            '  drpLegaScadenza.SelectedValue = -1
        Catch ex As Exception
            showModal("ERRORE", String.Format("Errore In fase di estrazione dati: {0}.", ex.Message))
        End Try
    End Sub

    Private Sub TitoloSezione(ByRef Titolo As String)
        Dim varTitoloezione As Label = DirectCast(Master.FindControl("lblTitoloSezione"), Label)
        varTitoloezione.Text = Titolo
    End Sub

    Private Sub CambiaTitoloMasterPage(ByVal Testo As String)
        DirectCast(Master.FindControl("lblTitoloSezione"), Label).Text = Testo
    End Sub

    Public Sub OpenModal(ByVal NomeDivModale As String)
        ScriptManager.RegisterStartupScript(Me.Page, Page.GetType, "HideLoginDialog", "<script type=""text/javascript"">$(document).ready(function () { $('#" & NomeDivModale & "').modal('show');});</script>", False)
    End Sub

    Protected Sub Page_Load(sender As Object, e As EventArgs) Handles Me.Load
        ConfigurationManager.AppSettings("ColoraIconaControllo") = "'icoScadenzario'"
        If Not IsPostBack Then
            Session("IDTabella") = 0
            Session("uploadTabella") = "TabScadenzario"
            CambiaTitoloMasterPage("SCADENZARIO")
            RicercaScadenze()
            lblMessage.Text = ""
            drpTipoTabella.SelectedValue = "Mezzi"
            CaricaMezzi()
            mView.ActiveViewIndex = 0

            If Request.QueryString("id") <> Nothing Then
                Dettaglio_Chiamata_Calenario(Request.QueryString("id"))
            End If

        End If
    End Sub

    Protected Sub btnOpen(sender As Object, e As EventArgs)
        OpenModal("ModalInsScad")
    End Sub

    Private Sub SvuotaCampi()
        txtDataInizio.Value = Now.Date
        txtDataFine.Value = Now.Date
        txtPromemoria.Text = ""
    End Sub

    Protected Sub btnRicerca_ServerClick(sender As Object, e As EventArgs)
        RicercaScadenze()
    End Sub
    Private Sub RicercaScadenze()
        Dim _BD As New BD_BindDataMain(oConn.ConnectionString(), False)
        Dim myGruppoParam As New SP_GruppoParametri()

        myGruppoParam.Add(New SP_Parametro("@valore", 50, inpRicerca.Value, DbType.String, ParameterDirection.Input))

        Dim tmpDT As DataTable = _BD.getDataTable("[usp_RicercaScadenze]", myGruppoParam)

        grdScadenze.DataSource = tmpDT
        grdScadenze.DataBind()
    End Sub

    Protected Sub grdScadenze_PreRender(sender As Object, e As EventArgs) Handles grdScadenze.PreRender
        For Each tmpRow As GridViewRow In grdScadenze.Rows
            DirectCast(tmpRow.FindControl("imgDettaglio"), ImageButton).CommandArgument = DirectCast(tmpRow.FindControl("lblId"), Label).Text
            DirectCast(tmpRow.FindControl("imgDelete"), ImageButton).CommandArgument = DirectCast(tmpRow.FindControl("lblId"), Label).Text
            DirectCast(tmpRow.FindControl("imgDelete"), ImageButton).Attributes.Add("onclick", "javascript:return confirm('Proseguire con la cancellazione');")
        Next
    End Sub

    Public Sub DettaglioAnagrafica(ByVal sender As Object, ByVal e As System.EventArgs)
        SvuotaCampi()
        TitoloModale.Text = "MODIFICA " & DirectCast(Master.FindControl("lblTitoloSezione"), Label).Text
        Dim imgBtn As ImageButton = sender
        For Each tmpRow As GridViewRow In grdScadenze.Rows
            If DirectCast(tmpRow.FindControl("imgDettaglio"), ImageButton).CommandArgument.Equals(imgBtn.CommandArgument) Then

                Session("idTabella") = imgBtn.CommandArgument

                txtTipologiaDett.Text = DirectCast(tmpRow.FindControl("lblTipologia"), Label).Text
                txtRiferimetoDett.Text = DirectCast(tmpRow.FindControl("lblRiferimento"), Label).Text
                txtDataInizioDett.Value = DirectCast(tmpRow.FindControl("lblDataInizio"), Label).Text
                txtDataFineDett.Value = DirectCast(tmpRow.FindControl("lblDatafine"), Label).Text
                drpTipoScadenzaDett.SelectedValue = DirectCast(tmpRow.FindControl("lblTipoScadenza"), Label).Text
                txtPromemoriaDett.Text = DirectCast(tmpRow.FindControl("lblPromemoria"), Label).Text

                mView.ActiveViewIndex = 1
                CaricaListaAllegati()

                Exit For

            End If
        Next
    End Sub

    Public Sub Dettaglio_Chiamata_Calenario(ByVal IdPassato As String)
        SvuotaCampi()
        TitoloModale.Text = "MODIFICA " & DirectCast(Master.FindControl("lblTitoloSezione"), Label).Text

        For Each tmpRow As GridViewRow In grdScadenze.Rows
            If DirectCast(tmpRow.FindControl("lblID"), Label).Text.Equals(IdPassato) Then

                Session("idTabella") = IdPassato

                txtTipologiaDett.Text = DirectCast(tmpRow.FindControl("lblTipologia"), Label).Text
                txtRiferimetoDett.Text = DirectCast(tmpRow.FindControl("lblRiferimento"), Label).Text
                txtDataInizioDett.Value = DirectCast(tmpRow.FindControl("lblDataInizio"), Label).Text
                txtDataFineDett.Value = DirectCast(tmpRow.FindControl("lblDatafine"), Label).Text
                drpTipoScadenzaDett.SelectedValue = DirectCast(tmpRow.FindControl("lblTipoScadenza"), Label).Text
                txtPromemoriaDett.Text = DirectCast(tmpRow.FindControl("lblPromemoria"), Label).Text

                mView.ActiveViewIndex = 1
                CaricaListaAllegati()

                Exit For

            End If
        Next
    End Sub

    Protected Sub imgDelete_Click(sender As Object, e As ImageClickEventArgs)
        Dim imgBtn As ImageButton = sender
        Try
            For Each tmpRow As GridViewRow In grdScadenze.Rows
                If DirectCast(tmpRow.FindControl("imgDelete"), ImageButton).CommandArgument.Equals(imgBtn.CommandArgument) Then

                    Dim _BD As New BD_BindDataMain(oConn.ConnectionString(), False)
                    Dim myGruppoParam As New SP_GruppoParametri()

                    myGruppoParam.Add(New SP_Parametro("@valore", 8, imgBtn.CommandArgument, DbType.Int32, ParameterDirection.Input))

                    Dim tmpDT As DataTable = _BD.getDataTable("[usp_DeleteScadenze]", myGruppoParam)
                    If _BD.ErrorNumber <> 0 Then
                        showModal("ERRORE", String.Format("Errore in fase di cancellazione dati: {0} ({1}).", _BD.ErrorMessage, _BD.ErrorNumber))
                    End If

                    RicercaScadenze()

                End If
            Next
        Catch ex As Exception
            showModal("ERRORE", String.Format("Errore in fase di cancellazione dati: {0}.", ex.Message))
        End Try
    End Sub
    Protected Sub btnNuovoInserimento_Click(sender As Object, e As EventArgs) Handles btnNuovoInserimento.Click
        Session("IDTabella") = 0
        OpenModal("ModalInsScad")
        TitoloModale.Text = "NUOVA SCADENZA"
        SvuotaCampi()
    End Sub

    Private Sub SALVA_SCADENZA()
        Try

            Using connection As New SqlClient.SqlConnection(ConfigurationManager.ConnectionStrings("db_ncbConnectionString").ConnectionString)

                connection.Open()

                Dim uspText As String = ""

                If Session("idTabella") = 0 Then
                    uspText = "[usp_InsertScadenza]"
                Else
                    uspText = "[usp_Updatescadenza]"
                End If

                Dim cmd As SqlClient.SqlCommand = New SqlClient.SqlCommand(uspText, connection)
                cmd.CommandType = CommandType.StoredProcedure

                cmd.Parameters.Clear()

                Dim dataInizioCalcolata As DateTime
                Dim dataFineCalcolata As DateTime

                If Session("idTabella") <> 0 Then
                    cmd.Parameters.AddWithValue("@idScadenzario", Session("idTabella"))
                    dataInizioCalcolata = CDate(txtDataInizioDett.Value).Day.ToString & "/" & _
                                         CDate(txtDataInizioDett.Value).Month.ToString & "/" & _
                                         CDate(txtDataInizioDett.Value).Year.ToString & " 23:59"

                    dataFineCalcolata = CDate(txtDataFineDett.Value).Day.ToString & "/" & _
                                        CDate(txtDataFineDett.Value).Month.ToString & "/" & _
                                        CDate(txtDataFineDett.Value).Year.ToString & " 23:59"
                Else
                    dataInizioCalcolata = CDate(txtDataInizio.Value).Day.ToString & "/" & _
                                          CDate(txtDataInizio.Value).Month.ToString & "/" & _
                                          CDate(txtDataInizio.Value).Year.ToString & " 23:59"

                    dataFineCalcolata = CDate(txtDataFine.Value).Day.ToString & "/" & _
                                        CDate(txtDataFine.Value).Month.ToString & "/" & _
                                        CDate(txtDataFine.Value).Year.ToString & " 23:59"
                End If


               


                If Session("idTabella") = 0 Then
                    cmd.Parameters.AddWithValue("@DataInizio", dataInizioCalcolata)
                    cmd.Parameters.AddWithValue("@DataFine", dataFineCalcolata)
                    cmd.Parameters.AddWithValue("@TipoScadenza", drpTipoScadenza.SelectedValue)
                    cmd.Parameters.AddWithValue("@Promemoria", txtPromemoria.Text)

                    Dim NometabellaScadenza As String = ""
                    If drpTipoTabella.SelectedValue = "MEZZI" Then NometabellaScadenza = "TabMezzi"
                    If drpTipoTabella.SelectedValue = "AUTISTI" Then NometabellaScadenza = "TabAnagrafica"
                    cmd.Parameters.AddWithValue("@codTabella", drpLegaScadenza.SelectedValue)
                    cmd.Parameters.AddWithValue("@TipoTabella", NometabellaScadenza)

                    cmd.Parameters.AddWithValue("@Tipologia", drpTipoTabella.SelectedValue)
                    cmd.Parameters.AddWithValue("@Riferimento", drpLegaScadenza.SelectedItem.Text)

                    Session("IDTabella") = 0
                Else
                    cmd.Parameters.AddWithValue("@DataInizio", dataInizioCalcolata)
                    cmd.Parameters.AddWithValue("@DataFine", dataFineCalcolata)
                    cmd.Parameters.AddWithValue("@TipoScadenza", drpTipoScadenzaDett.SelectedValue)
                    cmd.Parameters.AddWithValue("@Promemoria", txtPromemoriaDett.Text)
                End If


                cmd.ExecuteNonQuery()

                connection.Close()

                RicercaScadenze()

                If Session("idTabella") = 0 Then
                    mView.ActiveViewIndex = 0
                Else
                    mView.ActiveViewIndex = 1
                End If

                showModal("SALVA", "DATI SALVATI CORRETTAMENTE")

            End Using
        Catch ex As Exception
            showModal("ERRORE", "ERRORE" & ex.Message)
        End Try
    End Sub

    Protected Sub btnSalvaDati_Click(sender As Object, e As EventArgs)
        SALVA_SCADENZA()
    End Sub

    Protected Sub btnEsci_Click(sender As Object, e As EventArgs) Handles btnEsci.Click
        mView.ActiveViewIndex = 0
    End Sub

    Protected Sub btnModifica_Click(sender As Object, e As EventArgs) Handles btnModifica.Click
        SALVA_SCADENZA()
    End Sub

    ' ----------------------------------------------------------------------------------------------------
    '-------------------------- CODICE PER CARICARE GLI ALLEGATI ----------------------------------------
    '----------------------------------------------------------------------------------------------------
    Protected Sub btnFinestaCaricaAllegato_Click(sender As Object, e As EventArgs) Handles btnFinestaCaricaAllegato.Click
        OpenModal("ModalAllegati")
    End Sub


    Protected Sub grdAllegatiManuale_PreRender(sender As Object, e As EventArgs) Handles grdAllegatiManuale.PreRender
        For Each tmpRow As GridViewRow In grdAllegatiManuale.Rows
            DirectCast(tmpRow.FindControl("imgDeleteAllegato"), ImageButton).CommandArgument = DirectCast(tmpRow.FindControl("lblidAllegato"), Label).Text
            DirectCast(tmpRow.FindControl("imgDeleteAllegato"), ImageButton).Attributes.Add("onclick", "javascript:return confirm('Proseguire con la cancellazione Allegato?');")
        Next
    End Sub
    Private Sub SalvaPersorsoAllegatoDB(ByVal varCodTipoAllegato As Integer, ByVal varDescrizione As String, ByVal varDirectory As String, ByVal varNomefile As String)

        Try

            Dim _BD As New BD_BindDataMain(oConn.ConnectionString(), False)
            Dim myGruppoParam As New SP_GruppoParametri()

            Dim tabControllata As String = Session("uploadTabella")
            Dim idRigaDaAllegareFile As Integer = Session("idTabella")

            myGruppoParam.Add(New SP_Parametro("@codTabella", 8, idRigaDaAllegareFile, DbType.Int32, ParameterDirection.Input))
            myGruppoParam.Add(New SP_Parametro("@TipoTabella", 50, tabControllata, DbType.String, ParameterDirection.Input))
            myGruppoParam.Add(New SP_Parametro("@codTipoAllegato", 8, varCodTipoAllegato, DbType.Int32, ParameterDirection.Input))
            myGruppoParam.Add(New SP_Parametro("@Descrizione", 4000, varDescrizione, DbType.String, ParameterDirection.Input))
            myGruppoParam.Add(New SP_Parametro("@Directory", 4000, varDirectory, DbType.String, ParameterDirection.Input))
            myGruppoParam.Add(New SP_Parametro("@NomeFile", 4000, varNomefile, DbType.String, ParameterDirection.Input))

            Dim tmpDT As DataTable = _BD.getDataTable("[usp_InsertAllegato]", myGruppoParam)


            If _BD.ErrorNumber <> 0 Then
                showModal("ERRORE", String.Format("Errore in fase di salvataggio dati allegato: {0} ({1}).", _BD.ErrorMessage, _BD.ErrorNumber))
            End If

        Catch ex As Exception
            showModal("ERRORE", String.Format("Errore in fase di salvataggio dati allegato: {0}.", ex.Message))
        End Try
    End Sub

    Public Sub CaricaListaAllegati()
        Try
            Dim _BD As New BD_BindDataMain(oConn.ConnectionString(), False)
            Dim myGruppoParam As New SP_GruppoParametri()

            Dim tabControllata As String = Session("uploadTabella")
            Dim idRigaDaAllegareFile As Integer = Session("idTabella")

            myGruppoParam.Add(New SP_Parametro("@codtabella", 8, idRigaDaAllegareFile, DbType.Int32, ParameterDirection.Input))
            myGruppoParam.Add(New SP_Parametro("@TipoTabella", 50, tabControllata, DbType.String, ParameterDirection.Input))


            Dim tmpDT As DataTable = _BD.getDataTable("[usp_RicercaAllegati]", myGruppoParam)
            If _BD.ErrorNumber <> 0 Then
                showModal("ERRORE", String.Format("Errore in fase di estrazione dati: {0} ({1}).", _BD.ErrorMessage, _BD.ErrorNumber))
            End If

            grdAllegatiManuale.DataSource = tmpDT
            grdAllegatiManuale.DataBind()

        Catch ex As Exception
            showModal("ERRORE", String.Format("Errore in fase di estrazione dati: {0}.", ex.Message))
        End Try
    End Sub

    Public Function ComponiNomeImgData(ByVal varNomeImg As String) As String
        ComponiNomeImgData = Now.Date.Year.ToString & _
                             Now.Date.Month.ToString & _
                             Now.Date.Day.ToString & _
                             Now.TimeOfDay.Hours.ToString & _
                             Now.TimeOfDay.Minutes.ToString & _
                             Now.TimeOfDay.Seconds.ToString & _
                             varNomeImg
        Return ComponiNomeImgData
    End Function
    Protected Sub btnUpload_Click(sender As Object, e As EventArgs) Handles btnUpload.Click
        Dim fileName As String = Path.GetFileName(uploadfiles1.FileName)
        Dim varCartellaUpload As String = ""



        Using connection As New SqlClient.SqlConnection(ConfigurationManager.ConnectionStrings("db_ncbConnectionString").ConnectionString)

            connection.Open()
            Dim command As SqlClient.SqlCommand = connection.CreateCommand()
            command.Connection = connection
            Try
                command.Parameters.Clear()
                command.CommandText = "SELECT DIRECTORY FROM ALLEGATOTIPO WHERE IDTIPOALLEGATO=@IDTIPOALLEGATO"

                command.Parameters.AddWithValue("@IDTIPOALLEGATO", drpTipoAllegato.SelectedValue)
                varCartellaUpload = command.ExecuteScalar()
                connection.Close()
                ' 
            Catch ex As Exception
                showModal("ERRORE", String.Format("ERRORE NELLA FASE DI UPLOAD DEL FILE: {0}.", ex.Message))
            End Try

        End Using

        If uploadfiles1.HasFile Then
            Try
                fileName = ComponiNomeImgData(fileName)


                uploadfiles1.SaveAs(Server.MapPath(varCartellaUpload) & fileName)
                System.Threading.Thread.Sleep(2000)

                showModal("SALVA", String.Format("FILE CARICATO CON SUCCESSO!"))

                SalvaPersorsoAllegatoDB(drpTipoAllegato.SelectedValue, drpTipoAllegato.SelectedItem.Text, varCartellaUpload, fileName)
                CaricaListaAllegati()

            Catch ex As Exception
                showModal("ERRORE", ex.Message)
            End Try
        Else

        End If
    End Sub

    Public Sub deleteAllegato(ByVal sender As Object, ByVal e As System.EventArgs)
        Dim imgBtn As ImageButton = sender
        Try
            For Each tmpRow As GridViewRow In grdAllegatiManuale.Rows
                If DirectCast(tmpRow.FindControl("imgDeleteAllegato"), ImageButton).CommandArgument.Equals(imgBtn.CommandArgument) Then

                    Dim strDirectory As String = DirectCast(tmpRow.FindControl("lblDirectory"), Label).Text
                    Dim strNomefile As String = DirectCast(tmpRow.FindControl("lblNomeFile"), Label).Text

                    File.Delete(Server.MapPath(strDirectory & strNomefile))

                    Dim _BD As New BD_BindDataMain(oConn.ConnectionString(), False)
                    Dim myGruppoParam As New SP_GruppoParametri()

                    myGruppoParam.Add(New SP_Parametro("@idAllegato", 8, imgBtn.CommandArgument, DbType.Int32, ParameterDirection.Input))

                    Dim tmpDT As DataTable = _BD.getDataTable("[usp_DeleteAllegato]", myGruppoParam)
                    If _BD.ErrorNumber <> 0 Then
                        showModal("ERRORE", String.Format("Errore in fase di cancellazione dati: {0} ({1}).", _BD.ErrorMessage, _BD.ErrorNumber))
                    End If

                    CaricaListaAllegati()

                End If
            Next
        Catch ex As Exception
            showModal("ERRORE", String.Format("Errore in fase di cancellazione dati: {0}.", ex.Message))
        End Try
    End Sub

    
    Protected Sub btnTornaACalendario_Click(sender As Object, e As EventArgs) Handles btnTornaACalendario.Click
        ConfigurationManager.AppSettings("RicordaData") = txtDataInizioDett.Value
        Response.Redirect("default.aspx")
    End Sub
End Class
