﻿Imports System.Data
Imports SP_NameSpace
Imports System.IO
Partial Class ar_TipoAllegato

    Inherits System.Web.UI.Page
    Private oConn As New SqlClient.SqlConnection(ConfigurationManager.ConnectionStrings("db_ncbConnectionString").ConnectionString)

    '*****************************************************************************************
    'INIZIO CODICE PER FINESTRA MODALE
    '*****************************************************************************************

    Public ClassTitoloModal As String = "modal-header alert alert-success"
    Public Sub showModal(ByVal Classe As String, ByVal corpo As String)
        Select Case Classe
            Case "SALVA"
                ClassTitoloModal = "modal-header alert alert-success"
                lblTitoloModale.Text = "SALVA"
            Case "ATTENZIONE"
                ClassTitoloModal = "modal-header alert alert-danger"
                lblTitoloModale.Text = "ATTENZIONE"
            Case "INFORMAZIONE"
                ClassTitoloModal = "modal-header alert alert-info"
                lblTitoloModale.Text = "INFORMAZIONE"
            Case "ERRORE"
                ClassTitoloModal = "modal-header alert alert-warning"
                lblTitoloModale.Text = "ERRORE"
        End Select

        lblCorpoModale.Text = corpo

        ScriptManager.RegisterStartupScript(Page, Page.[GetType](), "myModal", "$('#myModal').modal();", True)
    End Sub

    'Protected Sub btnOpenModal_Click(sender As Object, e As EventArgs) Handles btnOpenModal.Click
    '    ScriptManager.RegisterStartupScript(Page, Page.[GetType](), "myModal", "$('#myModal').modal();", True)
    'End Sub

    Protected Sub btnCloseModal_Click(sender As Object, e As EventArgs)
        ScriptManager.RegisterStartupScript(Page, Page.[GetType](), "myModalHide", "$('#myModal').hide();", True)
        ScriptManager.RegisterStartupScript(Page, Page.[GetType](), "myModalAgainShow", "$('#myModal').modal();", True)
    End Sub
    '*****************************************************************************************
    'FINE CODICE PER FINESTRA MODALE
    '*****************************************************************************************

    Protected Sub Page_Load(sender As Object, e As EventArgs) Handles Me.Load
        If Not IsPostBack Then
            mAllegatoTipo.ActiveViewIndex = 0
            DirectCast(Master.FindControl("lblTitoloSezione"), Label).Text = "TIPO ALLEGATI"
            CaricaAllegatotipo()
        End If
    End Sub


    Protected Sub btnNuovoInserimento_Click(sender As Object, e As EventArgs) Handles btnNuovoInserimento.Click
        lblTitoloPanel.Text = "NUOVO TIPO ALLEGATO"
        ViewState("id") = 0


        txtTipoAllegato.Text = ""
        txtDirectory.Text = ""

        mAllegatoTipo.ActiveViewIndex = 1
    End Sub

    Private Sub CaricaAllegatotipo()
        Try
            Dim _BD As New BD_BindDataMain(oConn.ConnectionString(), False)
            Dim myGruppoParam As New SP_GruppoParametri()

            myGruppoParam.Add(New SP_Parametro("@Allegatotipo", 100, txtRicercaTipoAllegato.Value.Trim, DbType.String, ParameterDirection.Input))

            Dim tmpDT As DataTable = _BD.getDataTable("[usp_RicercaAllegatoTipo]", myGruppoParam)
            If _BD.ErrorNumber <> 0 Then
                showModal("ERRORE", (String.Format("Errore in fase di estrazione dati: {0} ({1}).", _BD.ErrorMessage, _BD.ErrorNumber)))
            End If

            grdTipoAllegato.DataSource = tmpDT
            grdTipoAllegato.DataBind()


        Catch ex As Exception
            showModal("ERRORE", String.Format("Errore in fase di estrazione dati: {0}.", ex.Message))
        End Try
    End Sub

    Protected Sub btnSalva_Click(sender As Object, e As EventArgs) Handles btnSalva.Click
        Dim id As Int32 = ViewState("id")
        Try
            Dim _BD As New BD_BindDataMain(oConn.ConnectionString(), False)
            Dim myGruppoParam As New SP_GruppoParametri()

            If id = 0 Then

                Dim folderPath As String = Server.MapPath("~/allegati/" & txtTipoAllegato.Text.Trim & "/")
                'Check whether Directory (Folder) exists.
                If Not Directory.Exists(folderPath) Then
                    'If Directory (Folder) does not exists. Create it.
                    Directory.CreateDirectory(folderPath)
                    myGruppoParam.Add(New SP_Parametro("@Directory", 4000, "~/allegati/" & txtTipoAllegato.Text.Trim & "/", DbType.String, ParameterDirection.Input))
                End If

            End If

            myGruppoParam.Add(New SP_Parametro("@DescTipoAllegato", 100, txtTipoAllegato.Text, DbType.String, ParameterDirection.Input))


            If id = 0 Then
                Dim tmpDT As DataTable = _BD.getDataTable("[usp_InsertAllegatoTipo]", myGruppoParam)

                If _BD.ErrorNumber <> 0 Then
                    showModal("ERRORE", String.Format("Errore in fase di salvataggio dati presenza: {0} ({1}).", _BD.ErrorMessage, _BD.ErrorNumber))
                Else
                    showModal("SALVA", String.Format("Tipo Allegato Salvato Correttamente"))
                    mAllegatoTipo.ActiveViewIndex = 0
                End If
            Else

                myGruppoParam.Add(New SP_Parametro("@idTipoAllegato", 8, id, DbType.Int32, ParameterDirection.Input))

                Dim tmpDT As DataTable = _BD.getDataTable("[usp_UpdateAllegatoTipo]", myGruppoParam)
                If _BD.ErrorNumber <> 0 Then
                    showModal("ERRORE", String.Format("Errore in fase di salvataggio dati presenza: {0} ({1}).", _BD.ErrorMessage, _BD.ErrorNumber))
                Else
                    showModal("SALVA", String.Format("Tipo Allegato Salvato Correttamente"))
                    mAllegatoTipo.ActiveViewIndex = 1
                End If
            End If

            CaricaAllegatotipo()

        Catch ex As Exception
            showModal("ERRORE", String.Format("Errore in fase di salvataggio dati presenza: {0}.", ex.Message))
        End Try
    End Sub

    Protected Sub grdTipoAllegato_PreRender(sender As Object, e As EventArgs) Handles grdTipoAllegato.PreRender
        For Each tmpRow As GridViewRow In grdTipoAllegato.Rows
            DirectCast(tmpRow.FindControl("imgDettaglio"), ImageButton).CommandArgument = DirectCast(tmpRow.FindControl("lblId"), Label).Text
            'DirectCast(tmpRow.FindControl("imgDelete"), ImageButton).CommandArgument = DirectCast(tmpRow.FindControl("lblId"), Label).Text
            'DirectCast(tmpRow.FindControl("imgDelete"), ImageButton).Attributes.Add("onclick", "javascript:return confirm('Proseguire con la cancellazione del sospeso?');")
        Next
    End Sub

    Public Sub DettaglioSospeso(ByVal sender As Object, ByVal e As System.EventArgs)
        Dim imgBtn As ImageButton = sender
        For Each tmpRow As GridViewRow In grdTipoAllegato.Rows
            If DirectCast(tmpRow.FindControl("imgDettaglio"), ImageButton).CommandArgument.Equals(imgBtn.CommandArgument) Then

                ViewState("id") = imgBtn.CommandArgument
                txtTipoAllegato.Text = DirectCast(tmpRow.FindControl("lblDescTipoAllegato"), Label).Text
                txtDirectory.Text = DirectCast(tmpRow.FindControl("lblDirectory"), Label).Text

                mAllegatoTipo.ActiveViewIndex = 1
                lblTitoloPanel.Text = "MODIFICA MATURATO PREGRESSO"
            End If
        Next
    End Sub
    Public Sub btnRicerca_ServerClick(ByVal sender As Object, ByVal e As System.EventArgs)
        CaricaAllegatotipo()
    End Sub

   
End Class
