﻿Imports System.Data
Imports System.Data.SqlClient
Imports SelectPdf

Partial Class AR_Utenti
    Inherits System.Web.UI.Page
    '*****************************************************************************************
    'INIZIO CODICE PER FINESTRA MODALE
    '*****************************************************************************************

    Public ClassTitoloModal As String = "modal-header alert alert-success"
    Public Sub showModal(ByVal Classe As String, ByVal corpo As String)
        Select Case Classe
            Case "SALVA"
                ClassTitoloModal = "modal-header alert alert-success"
                lblTitoloModale.Text = "SALVA"
            Case "ATTENZIONE"
                ClassTitoloModal = "modal-header alert alert-danger"
                lblTitoloModale.Text = "ATTENZIONE"
            Case "INFORMAZIONE"
                ClassTitoloModal = "modal-header alert alert-info"
                lblTitoloModale.Text = "INFORMAZIONE"
            Case "ERRORE"
                ClassTitoloModal = "modal-header alert alert-warning"
                lblTitoloModale.Text = "ERRORE"
        End Select

        lblCorpoModale.Text = corpo
        ScriptManager.RegisterStartupScript(Me.Page, Page.GetType, "HideLoginDialog", "<script type=""text/javascript"">$(document).ready(function () { $('#myMessage').modal('show');});</script>", False)

    End Sub

    Private Sub OpenModal(ByVal NomeDivModale As String)
        ScriptManager.RegisterStartupScript(Me.Page, Page.GetType, "HideLoginDialog", "<script type=""text/javascript"">$(document).ready(function () { $('#" & NomeDivModale & "').modal('show');});</script>", False)
    End Sub
    Protected Sub btnCloseModal_Click(sender As Object, e As EventArgs)
        ScriptManager.RegisterStartupScript(Page, Page.[GetType](), "myModalHide", "$('#myMessage').hide();", True)
        ScriptManager.RegisterStartupScript(Page, Page.[GetType](), "myModalAgainShow", "$('#myMessage').modal();", True)
    End Sub
    '*****************************************************************************************
    'FINE CODICE PER FINESTRA MODALE
    '*****************************************************************************************
    Protected Sub Page_Load(sender As Object, e As EventArgs) Handles Me.Load
        If Not IsPostBack Then
            DirectCast(Master.FindControl("lblTitoloSezione"), Label).Text = "UTENTI"
            UserAccount.DataSource = CaricaUser()
            UserAccount.DataBind()
        End If
    End Sub

    Protected Sub UserAccount_PreRender(sender As Object, e As EventArgs) Handles UserAccount.PreRender
        For Each tmpRow As GridViewRow In UserAccount.Rows

            DirectCast(tmpRow.FindControl("imgDelete"), ImageButton).CommandArgument = DirectCast(tmpRow.FindControl("lblUtente"), Label).Text
            DirectCast(tmpRow.FindControl("imgDelete"), ImageButton).Attributes.Add("onclick", "javascript:return confirm('Proseguire con la cancellazione');")

            If DirectCast(tmpRow.FindControl("Ruolo"), Label).Text.Trim = "SUPERADMIN" Then
                DirectCast(tmpRow.FindControl("chkReset"), CheckBox).Visible = False
                DirectCast(tmpRow.FindControl("imgDelete"), ImageButton).Visible = False
            Else
                DirectCast(tmpRow.FindControl("chkReset"), CheckBox).Visible = True
                DirectCast(tmpRow.FindControl("imgDelete"), ImageButton).Visible = True
            End If
        Next
    End Sub


    Protected Sub imgDelete_Click(sender As Object, e As EventArgs)
        Dim imgBtn As ImageButton = sender
        For Each tmpRow As GridViewRow In UserAccount.Rows
            If DirectCast(tmpRow.FindControl("imgDelete"), ImageButton).CommandArgument.Equals(imgBtn.CommandArgument) Then
                Try
                    Membership.DeleteUser(DirectCast(tmpRow.FindControl("lblUtente"), Label).Text, True)
                    UserAccount.DataSource = CaricaUser()
                    UserAccount.DataBind()
                    showModal("SALVA", "UTENTI ELIMINATO CON SUCCESSO</b>")

                Catch ex As Exception
                    showModal("ERRORE", "ERRORE DURANTE LE OPERAZIONI DI RESET: <br />" & ex.Message)
                End Try
            End If
        Next

    End Sub

    Public Function CaricaUser() As DataSet
        Dim ds As New DataSet
        Dim dt As New DataTable
        dt = ds.Tables.Add("Users")

        Dim muc As MembershipUserCollection
        muc = Membership.GetAllUsers

        dt.Columns.Add("Utente", Type.GetType("System.String"))
        dt.Columns.Add("UltimoAccesso", Type.GetType("System.String"))
        dt.Columns.Add("Ruolo", Type.GetType("System.String"))
        dt.Columns.Add("Bloccato", Type.GetType("System.String"))


        For Each mu As MembershipUser In muc
            Dim dr As DataRow

            dr = dt.NewRow
            dr("Utente") = mu.UserName
            dr("UltimoAccesso") = mu.LastLoginDate
            dr("Bloccato") = mu.IsLockedOut

            Dim strRuolo As String = ""
            For Each rolesForUser As String In Roles.GetRolesForUser(mu.UserName)
                strRuolo &= rolesForUser & " "
            Next
            dr("Ruolo") = strRuolo

            dt.Rows.Add(dr)
        Next
        Return ds

    End Function
    Protected Sub btnResetUtente_Click(sender As Object, e As EventArgs)
        Dim UtenteSelezionato As Boolean = False

        For Each tmpRow As GridViewRow In UserAccount.Rows
            If DirectCast(tmpRow.FindControl("chkReset"), CheckBox).Checked = True Then
                UtenteSelezionato = True
                Exit For
            End If
        Next

        If UtenteSelezionato = False Then
            showModal("INFORMAZIONE", "NESSUN UTENTE SELEZIONATO")
        Else
            Dim mbs As MembershipUser
            Dim sNewPassword As String

            Try
                For Each tmpRow As GridViewRow In UserAccount.Rows
                    If DirectCast(tmpRow.FindControl("chkReset"), CheckBox).Checked = True Then
                        mbs = Membership.GetUser(DirectCast(tmpRow.FindControl("lblUtente"), Label).Text)
                        mbs.IsApproved = True
                        mbs.UnlockUser()
                        sNewPassword = mbs.ResetPassword()
                        mbs.ChangePassword(sNewPassword, "Capital-pass2017!")
                    End If
                Next

                UserAccount.DataSource = CaricaUser()
                UserAccount.DataBind()

                showModal("SALVA", "UTENTI E PASSWORD RESETTATA <br /> Nuova Password: <b>Capital-pass2017!</b>")
            Catch ex As Exception
                showModal("ERRORE", "ERRORE DURANTE LE OPERAZIONI DI RESET: <br />" & ex.Message)
            End Try
        End If
    End Sub

    Protected Sub btnSalvaUtente_Click(sender As Object, e As EventArgs)

        For Each tmpRow As GridViewRow In UserAccount.Rows
            If DirectCast(tmpRow.FindControl("lblUtente"), Label).Text.Trim.ToUpper = txtUserName.Text.Trim.ToUpper Then
                showModal("ATTENZIONE", "UTENTE GIA' REGISTRATO")
                Exit Sub
            End If
        Next


        Try

            Dim nomeRuolo As String = txtRuolo.Text.Trim.ToUpper
            Dim nomeUser As String = txtUserName.Text.Trim
            Dim pswUser As String = "Capital-pass2017!"
            Dim emailUser As String = "info@newts.it"
            Dim questUser As String = "Question"
            Dim answUser As String = "Answer"

            Dim mbs As MembershipUser
            Dim msStatus As MembershipCreateStatus

            Dim sProviderUserKey As String = ""

            Try
                mbs = Membership.GetUser(nomeUser)
                If mbs Is Nothing Then
                    Membership.CreateUser(nomeUser, pswUser, emailUser, questUser, answUser, True, msStatus)
                    mbs = Membership.GetUser(nomeUser)
                End If
            Catch ex As Exception
            End Try

            If Not Roles.RoleExists(nomeRuolo) Then
                Roles.CreateRole(nomeRuolo)
            End If
            If Not Roles.IsUserInRole(nomeUser, nomeRuolo) Then
                Roles.AddUserToRole(nomeUser, nomeRuolo)
            End If

            UserAccount.DataSource = CaricaUser()
            UserAccount.DataBind()


            showModal("SALVA", "UTENTE CREATO CORRETTAMENTE <br /> Password: <b>Capital-pass2017!</b>")

        Catch ex As Exception
            showModal("ERRORE", "ERRORE DURANTE LE OPERAZIONI: <br />" & ex.Message)
        End Try
    End Sub

    Protected Sub btnUtenteDettaglio_Click(sender As Object, e As EventArgs)
        OpenModal("ModalInsUtente")
    End Sub

   


End Class

