﻿<%@ Page Title="" Language="VB" MasterPageFile="~/AR/MasterPage.master" MaintainScrollPositionOnPostback="true" AutoEventWireup="false" CodeFile="Prenotazione.aspx.vb" Inherits="AR_Scadenzario" %>

<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="cc1" %>

<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="Server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder1" runat="Server">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/1.11.3/jquery.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.5/js/bootstrap.min.js"></script>


    <!-- MODALE MESSAGGIO -->
    <div id="myMessage" class="modal fade" role="dialog">
        <div class="modal-dialog text-left">
            <!-- Modal content-->
            <div class="modal-content">
                <div class='<%= ClassTitoloModal%>'>
                    <h4 class="card-title">
                        <asp:Label ID="lblTitoloModale" runat="server" Text=""></asp:Label>
                    </h4>
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                </div>
                <div class="modal-body">
                    <p>
                        <asp:Label ID="lblCorpoModale" runat="server" Text="Corpo"></asp:Label>
                    </p>
                </div>
                <div class="modal-footer">
                    <button class="btn btn-default" data-dismiss="modal" type="button">Chiudi</button>
                </div>
            </div>
        </div>
    </div>
    <!-- MODALE MESSAGGIO -->

    <!-- MODALE PANNELLO DUPLICA PRENOTAZIONE -->
    <div id="ModalDuplica" class="modal fade hide" role="dialog">
        <div class="modal-dialog text-left ">
            <div class="modal-content">
                <div class="card-header">
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                    <h4 class="card-title">SELEZIONA DATE
                    </h4>
                </div>
                <div class="modal-body">
                    <div>
                        <div class="form-row">
                            <div class="form-group col-md-12" style="margin: 0px 0px 0px 0px;">
                                <div class="input-daterange input-group" data-plugin-datepicker data-plugin-options='{"language": "it"}'>
                                    <span class="input-group-addon">
                                        <i class="fa fa-calendar"></i>
                                    </span>
                                    <input runat="server" id="inpDuplicaDataDal" type="text" class="form-control" readonly="true" />
                                    <span class="input-group-addon"><i class="fa fa-calendar"></i></span>
                                    <input runat="server" id="inpDuplicaDataAl" type="text" class="form-control" readonly="true" />
                                </div>
                            </div>
                        </div>
                        <div class="form-row">
                            <div class="form-group col-md-6" style="margin: 0px 0px 0px 0px;">
                                Orario di Partenza
                                    <div class="input-group">
                                        <span class="input-group-addon">
                                            <i class="fa fa-clock-o"></i>
                                        </span>
                                        <input id="inpDuplicaOraDal" runat="server" type="text" data-plugin-timepicker="" class="form-control" data-plugin-options="{ &quot;showMeridian&quot;: false }" />
                                    </div>
                            </div>
                            <div class="form-group col-md-6" style="margin: 0px 0px 0px 0px;">
                                Orario di Arrivo
                                    <div class="input-group">
                                        <span class="input-group-addon">
                                            <i class="fa fa-clock-o"></i>
                                        </span>
                                        <input id="inpDuplicaOraAl" runat="server" type="text" data-plugin-timepicker="" class="form-control" data-plugin-options="{ &quot;showMeridian&quot;: false }" />
                                    </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <asp:Button ID="btnDuplicaPrenotazione" runat="server" class="btn btn-primary" OnClick="DuplicaPrenotazione" Text="Salva" ValidationGroup="Salva" />
                    <button type="button" class="btn btn-default btn-raised" data-dismiss="modal">Chiudi</button>
                </div>
            </div>
        </div>
    </div>
    <!-- MODALE PANNELLO DUPLICA PRENOTAZIONE -->

    <!-- MODALE PANNELLO INSERIMENTO ACCESSORIE -->
    <div id="ModalInsAccessorie" class="modal fade hide" role="dialog">
        <div class="modal-dialog modal-lg text-left ">
            <div class="modal-content">
                <div class="card-header">
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                    <h4 class="card-title">ACCESSORIE</h4>
                </div>
                <div class="modal-body">
                    <div>
                        <div class="form-row">
                            <div class="form-group col-md-8" style="margin: 0px 0px 0px 0px;">
                                Descrizione
                                <asp:TextBox ID="txtAccDescrizione" class=" form-control form-control" runat="server"></asp:TextBox>
                            </div>
                            <div class="form-group col-md-4" style="margin: 0px 0px 0px 0px;">
                                Iva
                                <asp:SqlDataSource ID="SqlAccIva" runat="server" ConnectionString="<%$ ConnectionStrings:db_ncbConnectionString %>" SelectCommand="SELECT [idAliquota], [Nome] FROM [AliquotaIva] ORDER BY [Principale] DESC, [Nome]"></asp:SqlDataSource>
                                <asp:DropDownList ID="DrpAccIva" CssClass="form-control form-control" runat="server" DataSourceID="SqlAccIva" DataTextField="nome" DataValueField="idAliquota"></asp:DropDownList>
                            </div>
                        </div>
                        <div class="form-row">
                            <div class="form-group col-md-4" style="margin: 0px 0px 0px 0px;">
                                Imponibile*
                                <asp:TextBox ID="txtAccImponibile" class="form-control form-control" runat="server"></asp:TextBox>
                                <cc1:FilteredTextBoxExtender ID="FilteredTextBoxExtender3" runat="server" FilterType="Numbers, Custom"
                                    ValidChars="," TargetControlID="txtAccImponibile" />
                                <asp:RequiredFieldValidator ID="RequiredFieldValidator9" runat="server" ControlToValidate="txtAccImponibile" ErrorMessage="Campo Obbligatorio" Font-Bold="False" Font-Size="10px" ForeColor="Red" Display="Dynamic" ValidationGroup="SalvaAccessorie"></asp:RequiredFieldValidator>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <asp:Button ID="btnSalvaAccessorie" runat="server" class="btn btn-primary" Text="Salva" OnClick="btnSalvaAccessorie_Click" ValidationGroup="SalvaAccessorie" />
                    <button type="button" class="btn btn-default btn-raised" data-dismiss="modal">Chiudi</button>
                </div>
            </div>
        </div>
    </div>
    <!-- MODALE PANNELLO INSERIMENTO ACCESSORIE -->

    <!-- MODALE PANNELLO INSERIMENTO ALLEGATO -->
    <div id="ModalAllegati" class="modal fade hide" role="dialog">
        <div class="modal-dialog text-left ">
            <div class="modal-content">
                <div class="card-header">
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                    <h4 class="card-title">CARICA ALLEGATO</h4>
                </div>
                <div class="modal-body">
                    <div class="panel-body">
                        <div class="col-lg-12">
                            Tipo Allegato                                                                
                            <asp:DropDownList ID="drpTipoAllegato" CssClass="form-control" runat="server" DataSourceID="SqlDataSource2" DataTextField="DescTipoAllegato" DataValueField="idTipoAllegato"></asp:DropDownList>
                            <!-- .File Upload -->
                            <asp:SqlDataSource ID="SqlDataSource2" runat="server" ConnectionString="<%$ ConnectionStrings:db_ncbConnectionString %>" SelectCommand="SELECT [DescTipoAllegato], [Directory], [idTipoAllegato] FROM [AllegatoTipo] ORDER BY [DescTipoAllegato]"></asp:SqlDataSource>
                        </div>
                        <div class="col-lg-12 ">
                            Seleziona il File da Allegare 
                            <asp:FileUpload ID="uploadfiles1" runat="server" CssClass="form-control" /><br />
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <asp:Button ID="btnUpload" runat="server" Text="Upload" CssClass="btn btn-success pull-right" />
                    <button type="button" class="btn btn-default btn-raised" data-dismiss="modal">Chiudi</button>
                </div>
            </div>
        </div>
    </div>
    <!-- MODALE PANNELLO INSERIMENTO ALLEGATO -->

    <!-- MODALE PANNELLO RICERCA ACQUISTI DA LEGARE -->
    <div id="ModalAcquistidaLegare" class="modal fade hide" role="dialog">
        <div class="modal-dialog  modal-lg  text-left ">
            <div class="modal-content">
                <div class="card-header">
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                    <h4 class="card-title">ASSOCIA ACQUISTO</h4>
                </div>
                <div class="modal-body">

                    <div class="row">
                        <div class="col-lg-6">
                            <div class="input-daterange input-group" data-plugin-datepicker data-plugin-options='{"language": "it"}'>
                                <span class="input-group-addon">
                                    <i class="fa fa-calendar"></i>
                                </span>
                                <input runat="server" id="inpDataAcquistiRicDAL" type="text" class="form-control" readonly="true" />
                                <span class="input-group-addon"><i class="fa fa-calendar"></i></span>
                                <input runat="server" id="inpDataAcquistiRicAL" type="text" class="form-control" readonly="true" />
                            </div>
                        </div>
                        <div class="col-lg-6">
                            <div class="input-group mb-md-3 ">
                                <input id="inpAcquistiRic" runat="server" type="text" class="form-control" placeholder="Cerca per Numero Fattura / Fornitore / Partita Iva" />
                                <span class="input-group-btn">
                                    <button id="btnRicercaAcquisti" runat="server" class="btn btn-success" onserverclick="btnRicercaAcquisti_ServerClick" type="button">Cerca</button>
                                </span>
                            </div>
                        </div>
                    </div>
                    <asp:HiddenField ID="hdfIdPrenotazioneAssociata" runat="server" />

                    <div class="panel-body">
                        <div class="col-lg-12">
                            <asp:GridView ID="grdAcquisti" CssClass="table table-bordered table-responsive " runat="server" AllowPaging="True" AllowSorting="True" AutoGenerateColumns="False" DataKeyNames="idAcquisti" PageSize="100">
                                <Columns>
                                    <asp:TemplateField HeaderText="idAcquisti" ItemStyle-VerticalAlign="Top" ItemStyle-Width="1%" Visible="false">
                                        <ItemTemplate>
                                            <asp:Label ID="lblID" runat="server" Text='<%# Eval("idAcquisti")%>' Visible="true"></asp:Label>
                                        </ItemTemplate>
                                    </asp:TemplateField>
                                    <asp:TemplateField HeaderText="Numero" ItemStyle-VerticalAlign="Top" ItemStyle-Width="1%" Visible="true">
                                        <ItemTemplate>
                                            <asp:Label ID="lblNumero" runat="server" Text='<%# Eval("Numero")%>' Visible="true"></asp:Label>
                                        </ItemTemplate>
                                    </asp:TemplateField>
                                    <asp:TemplateField HeaderText="Data" ItemStyle-VerticalAlign="Top" ItemStyle-Width="1%">
                                        <ItemTemplate>
                                            <asp:Label ID="lblIData" runat="server" Text='<%# Eval("Data" , "{0:d}")%>'></asp:Label>
                                        </ItemTemplate>
                                    </asp:TemplateField>

                                    <asp:TemplateField HeaderText="RagioneSociale" ItemStyle-VerticalAlign="Top" ItemStyle-Width="20%" Visible="true">
                                        <ItemTemplate>
                                            <asp:Label ID="lblRagioneSociale" runat="server" Text='<%# Eval("RagioneSociale")%>' Visible="true"></asp:Label>
                                        </ItemTemplate>
                                    </asp:TemplateField>

                                    <asp:TemplateField HeaderText="ImportoRitenuta" ItemStyle-VerticalAlign="Top" ItemStyle-Width="1%" ItemStyle-HorizontalAlign="Right" Visible="false">
                                        <ItemTemplate>
                                            <asp:Label ID="lblImportoRitenuta" runat="server" Text='<%# Eval("ImportoRitenuta", "{0:N2}")%>' Visible="true"></asp:Label>
                                        </ItemTemplate>
                                    </asp:TemplateField>

                                    <asp:TemplateField HeaderText="Importo" ItemStyle-VerticalAlign="Top" ItemStyle-Width="1%" ItemStyle-HorizontalAlign="Right" Visible="true">
                                        <ItemTemplate>
                                            <asp:Label ID="lblImportoFattura" runat="server" Text='<%# Eval("ImportoFattura", "{0:N2}")%>' Visible="true"></asp:Label>
                                        </ItemTemplate>
                                    </asp:TemplateField>

                                    <asp:TemplateField HeaderText="Pagato" ItemStyle-VerticalAlign="Top" ItemStyle-Width="1%" ItemStyle-HorizontalAlign="Right" Visible="true">
                                        <ItemTemplate>
                                            <asp:Label ID="lblPagato" runat="server" Text='<%# Eval("Pagato", "{0:N2}")%>' Visible="true"></asp:Label>
                                        </ItemTemplate>
                                    </asp:TemplateField>

                                    <%--   <asp:TemplateField HeaderText="Saldo" ItemStyle-VerticalAlign="Top" ItemStyle-Width="1%" ItemStyle-HorizontalAlign="Right" Visible="true">
                                            <ItemTemplate>
                                                <asp:Label ID="lblSaldo" runat="server" Text='<%# Eval("Saldo", "{0:N2}")%>' Visible="true"></asp:Label>
                                            </ItemTemplate>
                                        </asp:TemplateField>


                                        <asp:TemplateField HeaderText="Evasa" ItemStyle-VerticalAlign="Top" ItemStyle-Width="1%" ItemStyle-HorizontalAlign="Center" Visible="false">
                                            <ItemTemplate>
                                                <asp:Label ID="lblEvasa" runat="server" Text='<%# Eval("Evasa")%>' Visible="true"></asp:Label>
                                            </ItemTemplate>
                                        </asp:TemplateField>--%>

                                    <asp:TemplateField HeaderText="Lega" ItemStyle-Width="1%">
                                        <ItemTemplate>
                                            <asp:CheckBox ID="chkLega" runat="server" />
                                        </ItemTemplate>
                                    </asp:TemplateField>

                                </Columns>
                                <EmptyDataTemplate>
                                    NESSUN DOCUMENTO TROVATO
                                </EmptyDataTemplate>
                                <PagerSettings Mode="NumericFirstLast" PageButtonCount="20" />
                            </asp:GridView>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <asp:Button ID="btnLegaAcquisti" runat="server" Text="Associa Aquisti Selezionati" CssClass="btn btn-success pull-right" OnClick="btnLegaAcquisti_Click" />
                    <button type="button" class="btn btn-default btn-raised" data-dismiss="modal">Chiudi</button>
                </div>
            </div>
        </div>
    </div>
    <!-- MODALE PANNELLO RICERCA ACQUISTI DA LEGARE -->


    <!-- MODALE PANNELLO ACQUISTI ASSOCIATI -->
    <div id="ModalAcquistiAssociati" class="modal fade hide" role="dialog">
        <div class="modal-dialog  modal-lg  text-left ">
            <div class="modal-content">
                <div class="card-header">
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                    <h4 class="card-title">ACQUISTI ASSOCIATI</h4>
                </div>
                <div class="modal-body">
                    <div class="panel-body">
                        <div class="col-lg-12">
                            <asp:GridView ID="grdAcquistiCollegati" CssClass="table table-bordered table-responsive " runat="server" AllowPaging="True" AllowSorting="True" AutoGenerateColumns="False" DataKeyNames="idAcquisti" PageSize="100">
                                <Columns>
                                    <asp:TemplateField HeaderText="idAcquisti" ItemStyle-VerticalAlign="Top" ItemStyle-Width="1%" Visible="false">
                                        <ItemTemplate>
                                            <asp:Label ID="lblID" runat="server" Text='<%# Eval("idAcquisti")%>' Visible="true"></asp:Label>
                                        </ItemTemplate>
                                    </asp:TemplateField>
                                    <asp:TemplateField HeaderText="Numero" ItemStyle-VerticalAlign="Top" ItemStyle-Width="1%" Visible="true">
                                        <ItemTemplate>
                                            <asp:Label ID="lblNumero" runat="server" Text='<%# Eval("Numero")%>' Visible="true"></asp:Label>
                                        </ItemTemplate>
                                    </asp:TemplateField>
                                    <asp:TemplateField HeaderText="Data" ItemStyle-VerticalAlign="Top" ItemStyle-Width="1%">
                                        <ItemTemplate>
                                            <asp:Label ID="lblIData" runat="server" Text='<%# Eval("Data" , "{0:d}")%>'></asp:Label>
                                        </ItemTemplate>
                                    </asp:TemplateField>

                                    <asp:TemplateField HeaderText="RagioneSociale" ItemStyle-VerticalAlign="Top" ItemStyle-Width="20%" Visible="true">
                                        <ItemTemplate>
                                            <asp:Label ID="lblRagioneSociale" runat="server" Text='<%# Eval("RagioneSociale")%>' Visible="true"></asp:Label>
                                        </ItemTemplate>
                                    </asp:TemplateField>

                                    <asp:TemplateField HeaderText="ImportoRitenuta" ItemStyle-VerticalAlign="Top" ItemStyle-Width="1%" ItemStyle-HorizontalAlign="Right" Visible="false">
                                        <ItemTemplate>
                                            <asp:Label ID="lblImportoRitenuta" runat="server" Text='<%# Eval("ImportoRitenuta", "{0:N2}")%>' Visible="true"></asp:Label>
                                        </ItemTemplate>
                                    </asp:TemplateField>

                                    <asp:TemplateField HeaderText="Importo" ItemStyle-VerticalAlign="Top" ItemStyle-Width="1%" ItemStyle-HorizontalAlign="Right" Visible="true">
                                        <ItemTemplate>
                                            <asp:Label ID="lblImportoFattura" runat="server" Text='<%# Eval("ImportoFattura", "{0:N2}")%>' Visible="true"></asp:Label>
                                        </ItemTemplate>
                                    </asp:TemplateField>
                                    <asp:TemplateField HeaderText="Pagato" ItemStyle-VerticalAlign="Top" ItemStyle-Width="1%" ItemStyle-HorizontalAlign="Right" Visible="true">
                                        <ItemTemplate>
                                            <asp:Label ID="lblPagato" runat="server" Text='<%# Eval("Pagato", "{0:N2}")%>' Visible="true"></asp:Label>
                                        </ItemTemplate>
                                    </asp:TemplateField>

                                    <asp:TemplateField HeaderText="Scoll." ItemStyle-Width="1%">
                                        <ItemTemplate>
                                            <asp:ImageButton ID="imgScollega" runat="server" ImageUrl="../img/unlink.png" OnClick="ScollegaAcquisto" ToolTip="Scollega l'Acquisto" />
                                        </ItemTemplate>
                                    </asp:TemplateField>

                                </Columns>
                                <EmptyDataTemplate>
                                    NESSUN DOCUMENTO TROVATO
                                </EmptyDataTemplate>
                                <PagerSettings Mode="NumericFirstLast" PageButtonCount="20" />
                            </asp:GridView>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <%-- <asp:Button ID="Button2" runat="server" Text="Associa Aquisti Selezionati" CssClass="btn btn-success pull-right" OnClick="btnLegaAcquisti_Click" />--%>
                    <button type="button" class="btn btn-default btn-raised" data-dismiss="modal">Chiudi</button>
                </div>
            </div>
        </div>
    </div>
    <!-- MODALE PANNELLO ACQUISTI ASSOCIATI -->








    <asp:MultiView ID="mView" runat="server">
        <asp:View ID="vwRicerca" runat="server">
            <div class="row">
                <div class="col-lg-4">
                    <div class="input-daterange input-group" data-plugin-datepicker data-plugin-options='{"language": "it"}'>
                        <span class="input-group-addon">
                            <i class="fa fa-calendar"></i>
                        </span>
                        <input runat="server" id="inpDataInizio" type="text" class="form-control" readonly="true" />
                        <span class="input-group-addon"><i class="fa fa-calendar"></i></span>
                        <input runat="server" id="inpDataFine" type="text" class="form-control" readonly="true" />
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="input-group mb-md-3 ">
                        <input id="inpRicerca" runat="server" type="text" class="form-control" placeholder=" Cerca per Cliente / Referente / Città / Indirizzo / Mezzo / Targa / Fornitore" />
                        <span class="input-group-btn">
                            <button id="btnRicerca" runat="server" class="btn btn-success" onserverclick="btnRicerca_ServerClick" type="button">Cerca</button>
                        </span>
                    </div>
                </div>
                <div class="col-lg-2" style="text-align: right">
                    <asp:Button ID="btnNuovoInserimento" CssClass="btn btn-primary" onserverclick="btnOpen" runat="server" Text="+ PRENOTAZIONE" />
                </div>
            </div>

            <div class="row">
                <div class="col-lg-12">
                    <section class="card">
                        <header class="card-header">
                            <h2 class="card-title">PRENOTAZIONI</h2>
                        </header>
                        <div class="card-body ">
                            <div>
                                <asp:GridView ID="grdPrenotazioni" CssClass="table table-bordered table-responsive " runat="server" AllowPaging="True" AllowSorting="True" AutoGenerateColumns="False" DataKeyNames="idPrenotazione" PageSize="1000">
                                    <Columns>
                                        <asp:TemplateField HeaderText="Sel.">
                                            <ItemTemplate>
                                                <asp:ImageButton ID="imgDettaglio" runat="server" ImageUrl="../img/edit.png" OnClick="DettaglioAnagrafica" />
                                            </ItemTemplate>
                                            <ItemStyle VerticalAlign="Top" Width="1%" />
                                        </asp:TemplateField>
                                        <asp:TemplateField HeaderText="idPrenotazione" ItemStyle-VerticalAlign="Top" ItemStyle-Width="1%" Visible="false">
                                            <ItemTemplate>
                                                <asp:Label ID="lblID" runat="server" Text='<%# Eval("idPrenotazione")%>' Visible="true"></asp:Label>
                                            </ItemTemplate>
                                        </asp:TemplateField>
                                        <asp:TemplateField HeaderText="IdCliente" ItemStyle-VerticalAlign="Top" ItemStyle-Width="1%" Visible="false">
                                            <ItemTemplate>
                                                <asp:Label ID="lblIdCliente" runat="server" Text='<%# Eval("IdCliente")%>' Visible="false"></asp:Label>
                                            </ItemTemplate>
                                        </asp:TemplateField>
                                        <asp:TemplateField HeaderText="Cliente" ItemStyle-VerticalAlign="Top" ItemStyle-Width="20%" Visible="true">
                                            <ItemTemplate>
                                                <asp:Label ID="lblCliente" runat="server" Text='<%# Eval("Cliente")%>' Visible="true"></asp:Label>
                                            </ItemTemplate>
                                        </asp:TemplateField>
                                        <asp:TemplateField HeaderText="Data Inizio" ItemStyle-VerticalAlign="Top" ItemStyle-Width="1%" Visible="true">
                                            <ItemTemplate>
                                                <asp:Label ID="lblDataInizio" runat="server" Text='<%# Eval("DataInizio")%>' Visible="true"></asp:Label>
                                            </ItemTemplate>
                                        </asp:TemplateField>
                                        <asp:TemplateField HeaderText="Data Fine" ItemStyle-VerticalAlign="Top" ItemStyle-Width="1%" Visible="true">
                                            <ItemTemplate>
                                                <asp:Label ID="lblDataFine" runat="server" Text='<%# Eval("DataFine")%>' Visible="true"></asp:Label>
                                            </ItemTemplate>
                                        </asp:TemplateField>

                                        <asp:TemplateField HeaderText="Referente" ItemStyle-VerticalAlign="Top" ItemStyle-Width="1%" Visible="false">
                                            <ItemTemplate>
                                                <asp:Label ID="lblReferente" runat="server" Text='<%# Eval("Referente")%>' Visible="true"></asp:Label>
                                            </ItemTemplate>
                                        </asp:TemplateField>

                                        <asp:TemplateField HeaderText="CodiceTour" ItemStyle-VerticalAlign="Top" ItemStyle-Width="1%" Visible="true">
                                            <ItemTemplate>
                                                <asp:Label ID="lblCodiceTour" runat="server" Text='<%# Eval("CodiceTour")%>' Visible="true"></asp:Label>
                                            </ItemTemplate>
                                        </asp:TemplateField>

                                        <asp:TemplateField HeaderText="NrPax" ItemStyle-VerticalAlign="Top" ItemStyle-Width="1%" Visible="false">
                                            <ItemTemplate>
                                                <asp:Label ID="lblNrPax" runat="server" Text='<%# Eval("NrPax")%>' Visible="true"></asp:Label>
                                            </ItemTemplate>
                                        </asp:TemplateField>
                                        <asp:TemplateField HeaderText="Targa" ItemStyle-VerticalAlign="Top" ItemStyle-Width="1%" Visible="false">
                                            <ItemTemplate>
                                                <asp:Label ID="lblTarga" runat="server" Text='<%# Eval("Targa")%>' Visible="true"></asp:Label>
                                            </ItemTemplate>
                                        </asp:TemplateField>
                                        <asp:TemplateField HeaderText="Da Città <br/> A Città" ItemStyle-VerticalAlign="Top" ItemStyle-Width="1%" Visible="true">
                                            <ItemTemplate>
                                                <asp:Label ID="lblDaCitta" runat="server" Text='<%# Eval("DaCitta")%>' Visible="true"></asp:Label><br />
                                                <asp:Label ID="lblACitta" runat="server" Text='<%# Eval("ACitta")%>' Visible="true"></asp:Label>
                                            </ItemTemplate>
                                        </asp:TemplateField>
                                        <asp:TemplateField HeaderText="DaIndirizzo" ItemStyle-VerticalAlign="Top" ItemStyle-Width="1%" Visible="false">
                                            <ItemTemplate>
                                                <asp:Label ID="lblDaIndirizzo" runat="server" Text='<%# Eval("DaIndirizzo")%>' Visible="true"></asp:Label>
                                            </ItemTemplate>
                                        </asp:TemplateField>

                                        <asp:TemplateField HeaderText="AIndirizzo" ItemStyle-VerticalAlign="Top" ItemStyle-Width="1%" Visible="false">
                                            <ItemTemplate>
                                                <asp:Label ID="lblAIndirizzo" runat="server" Text='<%# Eval("AIndirizzo")%>' Visible="true"></asp:Label>
                                            </ItemTemplate>
                                        </asp:TemplateField>
                                        <asp:TemplateField HeaderText="Importo" ItemStyle-VerticalAlign="Top" ItemStyle-Width="1%" ItemStyle-HorizontalAlign="Right" Visible="true">
                                            <ItemTemplate>
                                                <asp:Label ID="lblImporto" runat="server" Text='<%# Eval("Importo", "{0:N2}")%>' Visible="true"></asp:Label>
                                            </ItemTemplate>
                                        </asp:TemplateField>
                                        <asp:TemplateField HeaderText="TipoServizio" ItemStyle-VerticalAlign="Top" ItemStyle-Width="1%" Visible="false">
                                            <ItemTemplate>
                                                <asp:Label ID="lblTipoServizio" runat="server" Text='<%# Eval("TipoServizio")%>' Visible="true"></asp:Label>
                                            </ItemTemplate>
                                        </asp:TemplateField>
                                        <asp:TemplateField HeaderText="Mezzo" ItemStyle-VerticalAlign="Top" ItemStyle-Width="1%" Visible="false">
                                            <ItemTemplate>
                                                <asp:Label ID="lblMezzo" runat="server" Text='<%# Eval("Mezzo")%>' Visible="true"></asp:Label>
                                            </ItemTemplate>
                                        </asp:TemplateField>
                                        <asp:TemplateField HeaderText="IdFornitore" ItemStyle-VerticalAlign="Top" ItemStyle-Width="1%" Visible="false">
                                            <ItemTemplate>
                                                <asp:Label ID="lblIdFornitore" runat="server" Text='<%# Eval("IdFornitore")%>' Visible="true"></asp:Label>
                                            </ItemTemplate>
                                        </asp:TemplateField>
                                        <asp:TemplateField HeaderText="Fornitore" ItemStyle-VerticalAlign="Top" ItemStyle-Width="1%" Visible="false">
                                            <ItemTemplate>
                                                <asp:Label ID="lblFornitore" runat="server" Text='<%# Eval("Fornitore")%>' Visible="true"></asp:Label>
                                            </ItemTemplate>
                                        </asp:TemplateField>
                                        <asp:TemplateField HeaderText="CostoServizio" ItemStyle-VerticalAlign="Top" ItemStyle-Width="1%" Visible="false">
                                            <ItemTemplate>
                                                <asp:Label ID="lblCostoServizio" runat="server" Text='<%# Eval("CostoServizio")%>' Visible="true"></asp:Label>
                                            </ItemTemplate>
                                        </asp:TemplateField>
                                        <asp:TemplateField HeaderText="Note" ItemStyle-VerticalAlign="Top" ItemStyle-Width="1%" Visible="false">
                                            <ItemTemplate>
                                                <asp:Label ID="lblNote" runat="server" Text='<%# Eval("Note")%>' Visible="true"></asp:Label>
                                            </ItemTemplate>
                                        </asp:TemplateField>

                                        <asp:TemplateField HeaderText="Servizio Esterno" ItemStyle-VerticalAlign="Top" ItemStyle-Width="3%" ItemStyle-HorizontalAlign="Center">
                                            <ItemTemplate>
                                                <div class="pretty p-icon p-toggle p-plain p-round p-locked" style="text-align:center;">
                                                    <asp:CheckBox ID="chkServizioEsterno" runat="server" Checked='<%# Eval("ServizioEsterno")%>'/>
                                                    <div class="state p-off">
                                                          <i class="fa fa-square-o  fa-2x" aria-hidden="true"></i>
                                                    </div>
                                                    <div class="state p-on p-info-o">
                                                          <i class="fa fa-check-square-o fa-2x" style="color:#ED9C28"></i>
                                                    </div>
                                                </div>                                               
                                                <asp:ImageButton ID="imgServizioEsterno" runat="server" ImageUrl="../img/link.png" OnClick="imgServizioEsterno_Click" ToolTip="Associa Acquisti" />
                                            </ItemTemplate>
                                        </asp:TemplateField>

                                        <asp:TemplateField HeaderText="Tour Estero" ItemStyle-VerticalAlign="Top" ItemStyle-Width="3%" Visible="true" ItemStyle-HorizontalAlign="Center">
                                            <ItemTemplate>
                                                <div class="pretty p-icon p-toggle p-plain p-round p-locked">
                                                    <asp:CheckBox ID="chkTourEstero" runat="server" Checked='<%# Eval("TourEstero")%>'/>
                                                    <div class="state p-off">
                                                        <i class="fa fa-square-o  fa-2x" aria-hidden="true"></i>                                                        
                                                    </div>
                                                    <div class="state p-on p-info-o">
                                                        <i class="fa fa-check-square-o fa-2x" style="color:steelblue"></i>                                                        
                                                    </div>
                                                </div>
                                            </ItemTemplate>
                                        </asp:TemplateField>


                                        <asp:TemplateField HeaderText="Confermato" ItemStyle-VerticalAlign="Top" ItemStyle-Width="1%" ItemStyle-HorizontalAlign="Center" Visible="true">
                                            <ItemTemplate>
                                                 <div class="pretty p-icon p-toggle p-plain p-round p-locked">
                                                  <asp:CheckBox ID="chkConfermata" runat="server" Checked='<%# Eval("Confermata")%>'/>
                                                    <div class="state p-off">
                                                        <i class="fa fa-square-o fa-2x " aria-hidden="true"></i>
                                                    </div>
                                                    <div class="state p-on p-info-o">
                                                        <i class="fa fa-check-square-o fa-2x" style="color:green"></i>
                                                    </div>
                                                </div>                                                
                                            </ItemTemplate>
                                        </asp:TemplateField>

                                        <asp:TemplateField HeaderText="Autista" ItemStyle-VerticalAlign="Top" ItemStyle-Width="1%" Visible="false">
                                            <ItemTemplate>
                                                <asp:Label ID="lblAutista" runat="server" Text='<%# Eval("Autista")%>' Visible="true"></asp:Label>
                                            </ItemTemplate>
                                        </asp:TemplateField>


                                        <asp:TemplateField HeaderText="idAutista" ItemStyle-VerticalAlign="Top" ItemStyle-Width="1%" Visible="false">
                                            <ItemTemplate>
                                                <asp:Label ID="lblidAutisti" runat="server" Text='<%# Eval("idAutista")%>' Visible="true"></asp:Label>
                                            </ItemTemplate>
                                        </asp:TemplateField>

                                        <asp:TemplateField HeaderText="idAliquotaIva" ItemStyle-VerticalAlign="Top" ItemStyle-Width="1%" Visible="false">
                                            <ItemTemplate>
                                                <asp:Label ID="lblidAliquotaIva" runat="server" Text='<%# Eval("idAliquotaIva")%>' Visible="true"></asp:Label>
                                            </ItemTemplate>
                                        </asp:TemplateField>


                                        <asp:TemplateField HeaderText="Fatturare" ItemStyle-VerticalAlign="Top" ItemStyle-Width="1%" Visible="false">
                                            <ItemTemplate>
                                                <asp:CheckBox ID="chkFatturare" runat="server" Checked='<%# Eval("Fatturare")%>' Enabled="false" />
                                            </ItemTemplate>
                                        </asp:TemplateField>


                                        <asp:TemplateField HeaderText="Fatturato" ItemStyle-VerticalAlign="Top" ItemStyle-Width="1%" Visible="false">
                                            <ItemTemplate>
                                                <asp:Label ID="lblcodFattura" runat="server" Text='<%# Eval("codFattura")%>' Visible="true"></asp:Label>
                                            </ItemTemplate>
                                        </asp:TemplateField>

                                        <asp:TemplateField HeaderText="Fatturato" ItemStyle-Width="1%">
                                            <ItemTemplate>
                                                <asp:Literal ID="imgFatturato" runat="server"></asp:Literal>

                                            </ItemTemplate>
                                        </asp:TemplateField>


                                        <asp:TemplateField HeaderText="Canc." ItemStyle-Width="1%">
                                            <ItemTemplate>
                                                <asp:ImageButton ID="imgDelete" runat="server" ImageUrl="../img/delete.png" OnClick="DeletePRenotazione" />
                                            </ItemTemplate>
                                        </asp:TemplateField>

                                    </Columns>
                                    <EmptyDataTemplate>
                                        NESSUNA PRENOTAZIONE TROVATA
                                    </EmptyDataTemplate>
                                    <PagerSettings Mode="NumericFirstLast" PageButtonCount="20" />
                                </asp:GridView>
                            </div>
                        </div>
                    </section>
                </div>
            </div>
        </asp:View>
        <asp:View ID="vwDettaglio" runat="server">
            <div class="row">
                <div class="col-lg-12">
                    <section class="card card-featured card-featured-primary mb-6">
                        <header class="card-header">
                            <h2 class="card-title">DETTAGLIO PRENOTAZIONI</h2>
                            <p class="card-subtitle">
                                <asp:Label ID="lblFatturata" runat="server" Text="NON FATTURATA" ForeColor="Red" Font-Bold="true"></asp:Label>
                            </p>
                        </header>
                        <div class="card-body">
                            <div class="form-row">
                                <div class="form-group col-md-8" style="margin: 0px 0px 0px 0px;">
                                    Cliente<asp:SqlDataSource ID="sqlClienti" runat="server" ConnectionString="<%$ ConnectionStrings:db_ncbConnectionString %>" SelectCommand="SELECT [Denominazione], [idAnagrafica] FROM [Anagrafica] WHERE (([TipoAnagrafica] = @TipoAnagrafica) AND ([Cancellato] = @Cancellato)) ORDER BY [Denominazione]">
                                        <SelectParameters>
                                            <asp:Parameter DefaultValue="CLIENTE" Name="TipoAnagrafica" Type="String" />
                                            <asp:Parameter DefaultValue="FALSE" Name="Cancellato" Type="Boolean" />
                                        </SelectParameters>
                                    </asp:SqlDataSource>
                                    <asp:DropDownList ID="drpCliente" runat="server" CssClass="form form-control" DataSourceID="sqlClienti" DataTextField="Denominazione" DataValueField="idAnagrafica" AutoPostBack="True"></asp:DropDownList>
                                    <asp:RequiredFieldValidator ID="RequiredFieldValidator3" runat="server" ControlToValidate="drpCliente" ErrorMessage="Campo Obbligatorio" Font-Bold="False" Font-Size="10px" ForeColor="Red" Display="Dynamic" ValidationGroup="Salva"></asp:RequiredFieldValidator>

                                </div>
                                <div class="form-group col-md-4" style="margin: 0px 0px 0px 0px;">
                                    Periodo di Prenotazione
                                <div class="input-daterange input-group" data-plugin-datepicker data-plugin-options='{"language": "it"}'>
                                    <span class="input-group-addon">
                                        <i class="fa fa-calendar"></i>
                                    </span>
                                    <input runat="server" id="inpDataInizioDett" type="text" class="form-control" readonly="true" />
                                    <span class="input-group-addon"><i class="fa fa-calendar"></i></span>
                                    <input runat="server" id="inpDataFineDett" type="text" class="form-control" readonly="true" />
                                </div>
                                </div>
                            </div>
                            <div class="form-row">
                                <div class="form-group col-md-8" style="margin: 0px 0px 0px 0px;">
                                    Referente
                                    <asp:TextBox ID="txtReferente" class="form-control form-control" runat="server"></asp:TextBox>
                                </div>
                                <div class="form-group col-md-2" style="margin: 0px 0px 0px 0px;">
                                    Orario di Partenza
                                    <div class="input-group">
                                        <span class="input-group-addon">
                                            <i class="fa fa-clock-o"></i>
                                        </span>
                                        <input id="inpOraPartenza" runat="server" type="text" data-plugin-timepicker="" class="form-control" data-plugin-options="{ &quot;showMeridian&quot;: false }" />
                                    </div>
                                </div>
                                <div class="form-group col-md-2" style="margin: 0px 0px 0px 0px;">
                                    Orario di Arrivo
                                    <div class="input-group">
                                        <span class="input-group-addon">
                                            <i class="fa fa-clock-o"></i>
                                        </span>
                                        <input id="inpOraArrivo" runat="server" type="text" data-plugin-timepicker="" class="form-control" data-plugin-options="{ &quot;showMeridian&quot;: false }" />
                                    </div>
                                </div>

                            </div>
                            <div class="form-row">
                                <div class="form-group col-md-4" style="margin: 0px 0px 0px 0px;">
                                    Codice Tour
                                <asp:TextBox ID="txtCodiceTour" class="form-control form-control" runat="server"></asp:TextBox>
                                </div>
                                <div class="form-group col-md-4" style="margin: 0px 0px 0px 0px;">
                                    Nr. Passeggeri
                                    <asp:TextBox ID="txtNrPax" class="form-control form-control" runat="server" Text="0"></asp:TextBox>
                                    <asp:RequiredFieldValidator ID="RequiredFieldValidator4" runat="server" ControlToValidate="txtNrPax" ErrorMessage="Campo Obbligatorio" Font-Bold="False" Font-Size="10px" ForeColor="Red" Display="Dynamic" ValidationGroup="Salva"></asp:RequiredFieldValidator>
                                </div>
                                <div class="form-group col-md-4" style="margin: 0px 0px 0px 0px;">
                                    Città di Partenza
                                    <asp:TextBox ID="txtCittaPartenza" class="form-control form-control" runat="server"></asp:TextBox>
                                    <cc1:AutoCompleteExtender ServiceMethod="CercaCittaDA" MinimumPrefixLength="2"
                                        CompletionInterval="100" EnableCaching="false" CompletionSetCount="10" TargetControlID="txtCittaPartenza"
                                        ID="AutoCompleteExtender1" runat="server" FirstRowSelected="false" CompletionListCssClass="panel panel-default">
                                    </cc1:AutoCompleteExtender>
                                    <asp:RequiredFieldValidator ID="RequiredFieldValidator5" runat="server" ControlToValidate="txtCittaPartenza" ErrorMessage="Campo Obbligatorio" Font-Bold="False" Font-Size="10px" ForeColor="Red" Display="Dynamic" ValidationGroup="Salva"></asp:RequiredFieldValidator>
                                </div>
                            </div>
                            <div class="form-row">
                                <div class="form-group col-md-4" style="margin: 0px 0px 0px 0px;">
                                    Targa
                                    <asp:SqlDataSource ID="SqlTarga" runat="server" ConnectionString="<%$ ConnectionStrings:db_ncbConnectionString %>" SelectCommand="SELECT [Targa], [Descrizione] FROM [Mezzi] ORDER BY [Targa]"></asp:SqlDataSource>
                                    <asp:DropDownList ID="drpTarga" runat="server" CssClass="form form-control" DataSourceID="SqlTarga" DataTextField="Targa" DataValueField="Descrizione" AutoPostBack="True"></asp:DropDownList>
                                </div>
                                <div class="form-group col-md-4" style="margin: 0px 0px 0px 0px;">
                                    Mezzo<br />
                                    <asp:Label ID="txtMezzo" class="form-control form-control" BackColor="#F6F6F6" runat="server"></asp:Label>
                                </div>
                                <div class="form-group col-md-4" style="margin: 0px 0px 0px 0px;">
                                    Indirizzo di Partenza
                                <asp:TextBox ID="txtIndirizzoPartenza" class="form-control form-control" runat="server"></asp:TextBox>
                                </div>
                            </div>
                            <div class="form-row">
                                <div class="form-group col-md-4" style="margin: 0px 0px 0px 0px;">
                                    Codice Fatturazione
                                    <asp:TextBox ID="txtTipoServizio" class="form-control form-control" runat="server" MaxLength="7"></asp:TextBox>
                                </div>
                                <div class="form-group col-md-4" style="margin: 0px 0px 0px 0px;">
                                    <asp:Label ID="lblAutisti" runat="server" Text="Autisti"></asp:Label>
                                    <asp:SqlDataSource ID="SqlAutisti" runat="server" ConnectionString="<%$ ConnectionStrings:db_ncbConnectionString %>" SelectCommand="SELECT [idAnagrafica], [Denominazione] FROM [Anagrafica] WHERE [TipoAnagrafica]='AUTISTA'  ORDER BY [Denominazione]"></asp:SqlDataSource>
                                    <asp:DropDownList ID="drpAutisti" CssClass="form-control" runat="server" DataSourceID="SqlAutisti" DataTextField="Denominazione" DataValueField="idAnagrafica"></asp:DropDownList>

                                </div>
                                <div class="form-group col-md-4" style="margin: 0px 0px 0px 0px;">
                                    Città di Arrivo
                                    <asp:TextBox ID="txtCittaArrivo" class="form-control form-control" runat="server"></asp:TextBox>
                                    <cc1:AutoCompleteExtender ServiceMethod="CercaCittaDA" MinimumPrefixLength="2"
                                        CompletionInterval="100" EnableCaching="false" CompletionSetCount="10" TargetControlID="txtCittaArrivo"
                                        ID="AutoCompleteExtender2" runat="server" FirstRowSelected="false" CompletionListCssClass="panel panel-default">
                                    </cc1:AutoCompleteExtender>
                                    <asp:RequiredFieldValidator ID="RequiredFieldValidator6" runat="server" ControlToValidate="txtCittaArrivo" ErrorMessage="Campo Obbligatorio" Font-Bold="False" Font-Size="10px" ForeColor="Red" Display="Dynamic" ValidationGroup="Salva"></asp:RequiredFieldValidator>
                                </div>

                            </div>

                            <div class="form-row">

                                <div class="form-group col-md-1" style="margin: 0px 0px 0px 0px;">
                                    <div class="switch switch switch-danger">
                                        Fatturare 
                                        <input id="inpFatturare" runat="server" type="checkbox" name="switch" data-plugin-ios-switch="" checked="false" onchange="javascript:DoPostBack();" style="display: none;" />
                                    </div>
                                </div>


                                <div class="form-group col-md-2" style="margin: 0px 0px 0px 0px;">
                                    Importo
                                    <asp:TextBox ID="txtImporto" class="form-control form-control" runat="server" Text="0,00"></asp:TextBox>
                                    <cc1:FilteredTextBoxExtender ID="FilteredTextBoxExtender1" runat="server" FilterType="Numbers, Custom"
                                        ValidChars="," TargetControlID="txtImporto" />
                                    <asp:RequiredFieldValidator ID="RequiredFieldValidator2" runat="server" ControlToValidate="txtImporto" ErrorMessage="Campo Obbligatorio" Font-Bold="False" Font-Size="10px" ForeColor="Red" Display="Dynamic" ValidationGroup="Salva"></asp:RequiredFieldValidator>
                                </div>
                                <div class="form-group col-md-1" style="margin: 0px 0px 0px 0px;">

                                    <div class="switch switch switch-info">
                                        Tour Estero 
                                        <input id="inpTourEstero" runat="server" type="checkbox" name="switch" data-plugin-ios-switch="" checked="false" onserverchange="inpTourEstero_ServerChange" onchange="javascript:DoPostBack();" style="display: none;" />
                                    </div>
                                </div>

                                <div class="form-group col-md-2" style="margin: 0px 0px 0px 0px;">
                                    Iva<asp:SqlDataSource ID="SqlAliquotaIva" runat="server" ConnectionString="<%$ ConnectionStrings:db_ncbConnectionString %>" SelectCommand="SELECT [idAliquota], [Nome] FROM [AliquotaIva] ORDER BY [Principale] DESC, [Nome]"></asp:SqlDataSource>
                                    <asp:DropDownList ID="drpAliquotaIva" CssClass="form-control form-control" runat="server" DataSourceID="SqlAliquotaIva" DataTextField="nome" DataValueField="idAliquota" AutoPostBack="true"></asp:DropDownList>
                                </div>

                                <div class="form-group col-md-2" style="margin: 0px 0px 0px 0px;">
                                    <div class="switch switch switch-succes">
                                        Prenotazione Confermata 
                                        <input id="inpConfermata" runat="server" type="checkbox" name="switch" data-plugin-ios-switch="" checked="false" style="display: none;" />
                                    </div>

                                    <script language="javascript" type="text/javascript">
                                        function DoPostBack() {
                                            __doPostBack();
                                        }
                                    </script>

                                </div>

                                <div class="form-group col-md-4" style="margin: 0px 0px 0px 0px;">
                                    Indirizzo di Arrivo
                                <asp:TextBox ID="txtIndirizzoArrivo" class="form-control form-control" runat="server"></asp:TextBox>
                                </div>
                            </div>

                            <div class="form-row">
                                <div class="form-group col-md-1" style="margin: 0px 0px 0px 0px;">
                                    <div class="switch switch-warning">
                                        Serv.Esterno 
                                        <input id="inpFornitore" runat="server" type="checkbox" name="switch" data-plugin-ios-switch="" checked="false" onchange="javascript:DoPostBack();" style="display: none;" />
                                    </div>
                                </div>
                                <div class="form-group col-md-2" style="margin: 0px 0px 0px 0px;">
                                    <asp:Label ID="lblCostoServizio" runat="server" Text="Costo Servizio"></asp:Label>
                                    <asp:TextBox ID="txtCostoServizio" class="form-control" BorderColor="red" runat="server" Text="0,00"></asp:TextBox>
                                    <cc1:FilteredTextBoxExtender ID="FilteredTextBoxExtender2" runat="server" FilterType="Numbers, Custom"
                                        ValidChars="," TargetControlID="txtCostoServizio" />
                                    <asp:RequiredFieldValidator ID="RequiredFieldValidator1" runat="server" ControlToValidate="txtCostoServizio" ErrorMessage="Campo Obbligatorio" Font-Bold="False" Font-Size="10px" ForeColor="Red" Display="Dynamic" ValidationGroup="Salva"></asp:RequiredFieldValidator>
                                </div>
                                <div class="form-group col-md-5" style="margin: 0px 0px 0px 0px;">
                                    <asp:Label ID="lblFornitore" runat="server" Text="Fornitore"></asp:Label>
                                    <asp:SqlDataSource ID="SqlFornitore" runat="server" ConnectionString="<%$ ConnectionStrings:db_ncbConnectionString %>" SelectCommand="SELECT [Denominazione], [idAnagrafica] FROM [Anagrafica] WHERE (([TipoAnagrafica] = @TipoAnagrafica) AND ([Cancellato] = @Cancellato)) ORDER BY [Denominazione]">
                                        <SelectParameters>
                                            <asp:Parameter DefaultValue="FORNITORE" Name="TipoAnagrafica" Type="String" />
                                            <asp:Parameter DefaultValue="FALSE" Name="Cancellato" Type="Boolean" />
                                        </SelectParameters>
                                    </asp:SqlDataSource>
                                    <asp:DropDownList ID="drpFornitore" runat="server" BorderColor="red" CssClass="form form-control" DataSourceID="SqlFornitore" DataTextField="Denominazione" DataValueField="idAnagrafica"></asp:DropDownList>
                                </div>
                                <div class="form-group col-md-4" style="margin: 0px 0px 0px 0px;">
                                    <br />
                                    <asp:Button ID="btnAcquistiCollegati" runat="server" class="btn btn-primary" Text="ACQUISTI ASSOCIATI" OnClick="btnAcquistiCollegati_Click" />
                                </div>
                            </div>

                            <div class="form-row">
                                <div class="form-group col-md-10" style="margin: 0px 0px 0px 0px;">
                                    Note<asp:HiddenField ID="hdfIDFattura" runat="server" />
                                    <asp:TextBox ID="txtNote" class="form-control form-control" runat="server" TextMode="MultiLine" Height="80px"></asp:TextBox>
                                </div>
                                <div class="form-group col-md-2" style="margin: 0px 0px 0px 0px;">
                                    <br />
                                    <asp:Button ID="btnAccessorie" runat="server" class="btn btn-warning" Text="+ ACCESSORI" />
                                </div>
                            </div>



                            <div class="form-row" style="background-color: #f6f6f6; margin-top: 30px;">
                                <hr />

                                <div class="form-group col-md-12">
                                    <asp:GridView ID="grdAccessori" CssClass="table table-bordered table-responsive " runat="server" AllowPaging="True"
                                        AllowSorting="True" AutoGenerateColumns="False" DataKeyNames="idAccessorie" PageSize="100">
                                        <Columns>
                                            <%-- <asp:TemplateField HeaderText="Sel.">
                                                <ItemTemplate>
                                                    <asp:ImageButton ID="imgDettaglio" runat="server" ImageUrl="../img/edit.png" OnClick="DettaglioAnagrafica" />
                                                </ItemTemplate>
                                                <ItemStyle VerticalAlign="Top" Width="1%" />
                                            </asp:TemplateField>--%>
                                            <asp:TemplateField HeaderText="idAccessorie" ItemStyle-VerticalAlign="Top" ItemStyle-Width="8%" Visible="false">
                                                <ItemTemplate>
                                                    <asp:Label ID="lblID" runat="server" Text='<%# Eval("idAccessorie")%>' Visible="true"></asp:Label>
                                                </ItemTemplate>
                                            </asp:TemplateField>
                                            <asp:TemplateField HeaderText="Descrizione" ItemStyle-VerticalAlign="Top" ItemStyle-Width="10%" Visible="true">
                                                <ItemTemplate>
                                                    <asp:Label ID="lblDescrizione" runat="server" Text='<%# Eval("Descrizione")%>' Visible="true"></asp:Label>
                                                </ItemTemplate>
                                            </asp:TemplateField>
                                            <asp:TemplateField HeaderText="Aliquota Iva" ItemStyle-VerticalAlign="Top" ItemStyle-Width="1%" Visible="true">
                                                <ItemTemplate>
                                                    <asp:Label ID="lblaliquotaIva" runat="server" Text='<%# Eval("aliquotaIva")%>' Visible="true"></asp:Label>
                                                </ItemTemplate>
                                            </asp:TemplateField>
                                            <asp:TemplateField HeaderText="Imponibile" ItemStyle-VerticalAlign="Top" ItemStyle-Width="1%" Visible="true">
                                                <ItemTemplate>
                                                    <asp:Label ID="lblImponibile" runat="server" Text='<%# Eval("Imponibile", "{0:N2}")%>' Visible="true"></asp:Label>
                                                </ItemTemplate>
                                            </asp:TemplateField>
                                            <asp:TemplateField HeaderText="Sel.">
                                                <ItemTemplate>
                                                    <asp:ImageButton ID="imgDelete" runat="server" ImageUrl="../img/delete.png" OnClick="DeleteAccessorie" />
                                                </ItemTemplate>
                                                <ItemStyle VerticalAlign="Top" Width="1%" />
                                            </asp:TemplateField>
                                        </Columns>
                                        <EmptyDataTemplate>
                                            <p style="color: red; font-weight: bold;">ACCESSORI NON PRESENTI</p>
                                        </EmptyDataTemplate>
                                        <PagerSettings Mode="NumericFirstLast" PageButtonCount="20" />
                                    </asp:GridView>
                                </div>


                            </div>
                        </div>
                        <div class="card-footer">

                            <asp:Button ID="btnModifica" runat="server" class="btn btn-primary" Text="Modifica" ValidationGroup="Salva" />
                            <asp:Button ID="btnEsci" runat="server" class="btn btn-default" Text="Esci" />
                            <asp:Button ID="btnTornaACalendario" runat="server" class="btn btn-warning right" Text="Torna a Calendario" />
                            <asp:Button ID="btnDuplica" runat="server" class="btn btn-success right pull-right " Text="Duplica Prenotazione" ValidationGroup="Salva" />
                        </div>
                    </section>
                </div>
            </div>

            <div class="row">
                <div class="col-lg-12">
                    <asp:Panel ID="pnlAllegati" runat="server">
                        <section class="card card-featured card-featured-danger mb-6">
                            <header class="card-header">
                                <h2 class="card-title">ALLEGATI</h2>
                            </header>
                            <div class="card-body" style="display: block;">
                                <asp:GridView ID="grdAllegatiManuale" CssClass="table table-bordered table-responsive "
                                    runat="server" AllowPaging="True" AllowSorting="True"
                                    AutoGenerateColumns="False" CellPadding="3" PageSize="100">
                                    <Columns>
                                        <asp:TemplateField HeaderText="Vis." ItemStyle-VerticalAlign="Top" ItemStyle-Width="1%">
                                            <ItemTemplate>
                                                <asp:HyperLink ID="HyperLink1" Target="_blank" runat="server" ImageUrl="~/img/Preview.png" NavigateUrl='<%# Eval("Directory") + Eval("NomeFile") %>'>HyperLink</asp:HyperLink>
                                            </ItemTemplate>
                                        </asp:TemplateField>
                                        <asp:TemplateField HeaderText="idAllegato" ItemStyle-VerticalAlign="Top" ItemStyle-Width="1%">
                                            <ItemTemplate>
                                                <asp:Label ID="lblidAllegato" runat="server" Text='<%# Eval("idAllegato")%>'></asp:Label>
                                            </ItemTemplate>
                                        </asp:TemplateField>
                                        <asp:TemplateField HeaderText="codTabella" ItemStyle-VerticalAlign="Top" ItemStyle-Width="15%" Visible="false">
                                            <ItemTemplate>
                                                <asp:Label ID="lblcodTabella" runat="server" Text='<%# Eval("codTabella")%>'></asp:Label>
                                            </ItemTemplate>
                                        </asp:TemplateField>
                                        <asp:TemplateField HeaderText="TipoTabella" ItemStyle-VerticalAlign="Top" ItemStyle-Width="15%">
                                            <ItemTemplate>
                                                <asp:Label ID="lblTipoTabella" runat="server" Text='<%# Eval("TipoTabella")%>'></asp:Label>
                                            </ItemTemplate>
                                        </asp:TemplateField>
                                        <asp:TemplateField HeaderText="codTipoAllegato" ItemStyle-VerticalAlign="Top" ItemStyle-Width="15%" Visible="false">
                                            <ItemTemplate>
                                                <asp:Label ID="lblcodTipoAllegato" runat="server" Text='<%# Eval("codTipoAllegato")%>'></asp:Label>
                                            </ItemTemplate>
                                        </asp:TemplateField>
                                        <asp:TemplateField HeaderText="Descrizione" ItemStyle-VerticalAlign="Top" ItemStyle-Width="10%">
                                            <ItemTemplate>
                                                <asp:Label ID="lblDescrizione" runat="server" Text='<%# Eval("Descrizione")%>'></asp:Label>
                                            </ItemTemplate>
                                        </asp:TemplateField>
                                        <asp:TemplateField HeaderText="Directory" ItemStyle-VerticalAlign="Top" ItemStyle-Width="10%">
                                            <ItemTemplate>
                                                <asp:Label ID="lblDirectory" runat="server" Text='<%# Eval("Directory")%>'></asp:Label>
                                            </ItemTemplate>
                                        </asp:TemplateField>
                                        <asp:TemplateField HeaderText="NomeFile" ItemStyle-VerticalAlign="Top" ItemStyle-Width="10%">
                                            <ItemTemplate>
                                                <asp:Label ID="lblNomeFile" runat="server" Text='<%# Eval("NomeFile")%>'></asp:Label>
                                            </ItemTemplate>
                                        </asp:TemplateField>
                                        <asp:TemplateField HeaderText="Canc." ItemStyle-VerticalAlign="Top" ItemStyle-Width="1%">
                                            <ItemTemplate>
                                                <asp:ImageButton ID="imgDeleteAllegato" runat="server" ImageUrl="~/img/delete.png" OnClick="deleteAllegato" AlternateText="Cancella Documento" />
                                            </ItemTemplate>
                                        </asp:TemplateField>
                                    </Columns>
                                    <EmptyDataTemplate>
                                        Attenzione: NESSUN ALLEGATO TROVATO
                                    </EmptyDataTemplate>
                                    <PagerSettings FirstPageText="Prima" LastPageText="Ultima" Mode="NumericFirstLast" Position="TopAndBottom" />
                                </asp:GridView>
                            </div>
                            <div class="card-footer">
                                <asp:Button ID="btnFinestaCaricaAllegato" runat="server" class="btn btn-primary" Text="Carica Allegato" />
                            </div>
                        </section>
                    </asp:Panel>
                </div>
            </div>

        </asp:View>
    </asp:MultiView>
</asp:Content>

