﻿<%@ Page Title="" Language="VB" MasterPageFile="~/AR/MasterPage.master" AutoEventWireup="false" CodeFile="Elenconotecredito.aspx.vb" Inherits="AR_Elenconotecredito" %>

<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="cc1" %>


<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="Server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder1" runat="Server">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/1.11.3/jquery.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.5/js/bootstrap.min.js"></script>


    <!-- MODALE MESSAGGIO -->
    <div id="myMessage" class="modal fade" role="dialog">
        <div class="modal-dialog text-left">
            <!-- Modal content-->
            <div class="modal-content">
                <div class='<%= ClassTitoloModal%>'>
                    <h4 class="card-title">
                        <asp:Label ID="lblTitoloModale" runat="server" Text=""></asp:Label>
                    </h4>
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                </div>
                <div class="modal-body">
                    <p>
                        <asp:Label ID="lblCorpoModale" runat="server" Text="Corpo"></asp:Label>
                    </p>
                </div>
                <div class="modal-footer">
                    <button class="btn btn-default" data-dismiss="modal" type="button">Chiudi</button>
                </div>
            </div>
        </div>
    </div>
    <!-- MODALE MESSAGGIO -->

    <div class="row">
        <div class="col-lg-6">
            Cerca per Denominazione / Città / Indirizzo / Referente / Partita Iva / Codice Fiscale / Email
            <div class="input-group mb-md-3 ">
                <input id="inpRicerca" runat="server" type="text" class="form-control" />
                <span class="input-group-btn">
                    <button id="btnRicerca" runat="server" class="btn btn-success" onserverclick="btnRicerca_ServerClick" type="button">Cerca</button>
                </span>
            </div>
        </div>
        <div class="col-lg-3">
            <br />
            <div class="btn-group pull-lg-right">
                <button id="btnEmesse" runat="server" type="button" class="btn btn-danger" onserverclick="ButtonEmesse">EMESSE </button>
                <button id="btnRicevute" runat="server" type="button" class="btn btn-success" onserverclick="ButtonRicevute">RICEVUTE </button>
            </div>
        </div>
        <div class="col-lg-3" style="text-align: right">
            <br />
            <asp:Button ID="btnNuovoInserimentoEmesse"   CssClass="btn btn-danger"  onserverclick="btnOpen" runat="server" />
            <asp:Button ID="btnNuovoInserimentoRicevute" CssClass="btn btn-success" onserverclick="btnOpen" runat="server" />
        </div>
    </div>

    <div id="myModal" class="modal fad hide" role="dialog">
        <div class="modal-dialog modal-lg text-left ">
            <div class="modal-content">
                <div class="card-header">
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                    <h4 class="card-title">
                        <asp:Label ID="TitoloModale" runat="server" Text=""></asp:Label></h4>
                </div>
                <div class="modal-body">
                    <div>
                        <div class="form-row">
                            <div class="form-group col-md-2" style="margin: 0px 0px 0px 0px;">
                                Tipo
                                <asp:Label ID="txtTipo" class="form-control form-control-sm" BackColor="#F6F6F6" runat="server" Text="Label"></asp:Label>
                            </div>
                            <div class="form-group col-md-5" style="margin: 0px 0px 0px 0px;">
                                <asp:Label ID="lblDenominazione" runat="server" Text="Label"></asp:Label>*
                                    <asp:TextBox ID="txtDenominazione" class=" form-control form-control-sm" runat="server"></asp:TextBox>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidator4" runat="server" ControlToValidate="txtDenominazione" ErrorMessage="Campo Obbligatorio" Font-Bold="False" Font-Size="10px" ForeColor="Red" Display="Dynamic" ValidationGroup="Salva"></asp:RequiredFieldValidator>
                            </div>
                            <div class="form-group col-md-5" style="margin: 0px 0px 0px 0px;">
                                Email*
                                    <asp:TextBox ID="txtEmail" class="form-control form-control-sm" runat="server"></asp:TextBox>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidator1" runat="server" ControlToValidate="txtEmail" ErrorMessage="Campo Obbligatorio" Font-Bold="False" Font-Size="10px" ForeColor="Red" Display="Dynamic" ValidationGroup="Salva"></asp:RequiredFieldValidator>
                                <asp:RegularExpressionValidator ID="EmailAddressFormatValidator" runat="server" ControlToValidate="txtEmail" ErrorMessage=" Email non Valida" Font-Bold="False" Font-Size="10px" ForeColor="Red" Display="Dynamic" ValidationExpression="\s*\w+([-+.']\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*\s*" ValidationGroup="Salva">       
                                </asp:RegularExpressionValidator>

                            </div>
                        </div>
                        <div class="form-row">
                            <div class="form-group col-md-6" style="margin: 0px 0px 0px 0px;">
                                Indirizzo*
                                    <asp:TextBox ID="txtIndirizzo" class="form-control form-control-sm" runat="server"></asp:TextBox>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidator2" runat="server" ControlToValidate="txtIndirizzo" ErrorMessage="Campo Obbligatorio" Font-Bold="False" Font-Size="10px" ForeColor="Red" Display="Dynamic" ValidationGroup="Salva"></asp:RequiredFieldValidator>
                            </div>
                            <div class="form-group col-md-6" style="margin: 0px 0px 0px 0px;">
                                Note Extra Indirizzo
                                    <asp:TextBox ID="txtNoteExtraIndirizzo" class="form-control form-control-sm" runat="server"></asp:TextBox>
                            </div>
                        </div>
                        <div class="form-row">
                            <div class="form-group col-md-7" style="margin: 0px 0px 0px 0px;">
                                Città*
                                    <asp:TextBox ID="txtCitta" class="form-control form-control-sm" runat="server"></asp:TextBox>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidator3" runat="server" ControlToValidate="txtCitta" ErrorMessage="Campo Obbligatorio" Font-Bold="False" Font-Size="10px" ForeColor="Red" Display="Dynamic" ValidationGroup="Salva"></asp:RequiredFieldValidator>
                            </div>
                            <div class="form-group col-md-1" style="margin: 0px 0px 0px 0px;">
                                Cap*
                                    <asp:TextBox ID="txtCap" class="form-control form-control-sm" runat="server" MaxLength="5"></asp:TextBox>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidator5" runat="server" ControlToValidate="txtCap" ErrorMessage="Campo Obbligatorio" Font-Bold="False" Font-Size="10px" ForeColor="Red" Display="Dynamic" ValidationGroup="Salva"></asp:RequiredFieldValidator>
                            </div>
                            <div class="form-group col-md-1" style="margin: 0px 0px 0px 0px;">
                                Prov.*
                                    <asp:TextBox ID="txtProvincia" class="form-control form-control-sm" runat="server" MaxLength="2"></asp:TextBox>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidator6" runat="server" ControlToValidate="txtProvincia" ErrorMessage="Campo Obbligatorio" Font-Bold="False" Font-Size="10px" ForeColor="Red" Display="Dynamic" ValidationGroup="Salva"></asp:RequiredFieldValidator>
                            </div>
                            <div class="form-group col-md-3" style="margin: 0px 0px 0px 0px;">
                                Nazione
                                    <asp:SqlDataSource ID="SqlNazione" runat="server" ConnectionString="<%$ ConnectionStrings:db_ncbConnectionString %>" SelectCommand="SELECT [id], [nome] FROM [Stati] ORDER BY [nome]"></asp:SqlDataSource>
                                <asp:DropDownList ID="drpNazione" CssClass="form-control form-control-sm" runat="server" DataSourceID="SqlNazione" DataTextField="nome" DataValueField="nome"></asp:DropDownList>
                            </div>
                        </div>
                        <div class="form-row">
                            <div class="form-group col-md-3" style="margin: 0px 0px 0px 0px;">
                                Referente
                                    <asp:TextBox ID="txtReferente" class="form-control form-control-sm" runat="server"></asp:TextBox>
                            </div>
                            <div class="form-group col-md-3" style="margin: 0px 0px 0px 0px;">
                                Partita Iva
                                    <asp:TextBox ID="txtPI" class="form-control form-control-sm" runat="server"></asp:TextBox>
                            </div>
                            <div class="form-group col-md-3" style="margin: 0px 0px 0px 0px;">
                                Codice Fiscale
                                    <asp:TextBox ID="txtCF" class="form-control form-control-sm" runat="server"></asp:TextBox>
                            </div>
                            <div class="form-group col-md-3" style="margin: 0px 0px 0px 0px;">
                                Iban
                                    <asp:TextBox ID="txtIban" class="form-control form-control-sm" runat="server"></asp:TextBox>
                            </div>
                        </div>
                        <div class="form-row">
                            <div class="form-group col-md-4" style="margin: 0px 0px 0px 0px;">
                                Telefono
                                    <asp:TextBox ID="txtTelefono" class="form-control form-control-sm" runat="server"></asp:TextBox>
                            </div>
                            <div class="form-group col-md-4" style="margin: 0px 0px 0px 0px;">
                                Fax
                                    <asp:TextBox ID="txtFax" class="form-control form-control-sm" runat="server"></asp:TextBox>
                            </div>
                            <div class="form-group col-md-4" style="margin: 0px 0px 0px 0px;">
                                <asp:Label ID="lblPatente" runat="server" Text="Nr. Patente"></asp:Label>
                                <asp:TextBox ID="txtnrPatente" class="form-control form-control-sm" runat="server"></asp:TextBox>
                            </div>
                        </div>

                        <hr />

                        <div class="form-row">
                            <div class="form-group col-md-3" style="margin: 0px 0px 0px 0px;">
                                Termini Pagamento.(gg)
                                    <asp:TextBox ID="txtTerminidiPagamento" class="form-control form-control-sm" runat="server"></asp:TextBox>
                                <cc1:FilteredTextBoxExtender ID="txtTerminidiPagamentoControl" runat="server" FilterType="Numbers" TargetControlID="txtTerminidiPagamento" />

                            </div>
                            <div class="form-group col-md-3" style="margin: 0px 0px 0px 0px;">
                                Iva
                                <asp:SqlDataSource ID="SqlAliquotaIva" runat="server" ConnectionString="<%$ ConnectionStrings:db_ncbConnectionString %>" SelectCommand="SELECT [idAliquota], [Nome] FROM [AliquotaIva] ORDER BY [Principale] DESC, [Nome]"></asp:SqlDataSource>
                                <asp:DropDownList ID="drpAliquotaIva" CssClass="form-control form-control-sm" runat="server" DataSourceID="SqlAliquotaIva" DataTextField="nome" DataValueField="idAliquota"></asp:DropDownList>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <asp:Label ID="lblMessage" CssClass="form" runat="server" Text="Label" ForeColor="Red"></asp:Label>
                    <asp:Button ID="btnSalvaDati" runat="server" class="btn btn-primary" OnClick="btnSalvaDati_Click" Text="Salva" ValidationGroup="Salva" />
                    <button type="button" class="btn btn-default btn-raised" data-dismiss="modal">Chiudi</button>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-lg-12">
            <section class="card">
                <header class="card-header">
                    <h2 class="card-title">
                        <asp:Label ID="lblTitoloGriglia" runat="server" Text="Label"></asp:Label></h2>
                </header>
                <div class="card-body ">
                    <div>
                        <asp:GridView ID="grdAnagrafica" CssClass="table table-bordered table-responsive " runat="server" AllowPaging="True" AllowSorting="True" AutoGenerateColumns="False" DataKeyNames="idAnagrafica" PageSize="100">
                            <Columns>
                                <asp:TemplateField HeaderText="Sel.">
                                    <ItemTemplate>
                                        <asp:ImageButton ID="imgDettaglio" runat="server" ImageUrl="../img/edit.png" OnClick="DettaglioAnagrafica" />
                                    </ItemTemplate>
                                    <ItemStyle VerticalAlign="Top" Width="1%" />
                                </asp:TemplateField>
                                <asp:TemplateField HeaderText="idAnagrafica" ItemStyle-VerticalAlign="Top" ItemStyle-Width="8%" Visible="true">
                                    <ItemTemplate>
                                        <asp:Label ID="lblID" runat="server" Text='<%# Eval("idAnagrafica")%>' Visible="true"></asp:Label>
                                    </ItemTemplate>
                                    <ItemStyle VerticalAlign="Top" Width="8%" />
                                </asp:TemplateField>
                                <asp:TemplateField HeaderText="Denominazione" ItemStyle-VerticalAlign="Top" ItemStyle-Width="8%" Visible="true">
                                    <ItemTemplate>
                                        <asp:Label ID="lblDenominazione" runat="server" Text='<%# Eval("Denominazione")%>' Visible="true"></asp:Label>
                                    </ItemTemplate>
                                    <ItemStyle VerticalAlign="Top" Width="8%" />
                                </asp:TemplateField>
                                <asp:TemplateField HeaderText="Email" ItemStyle-VerticalAlign="Top" ItemStyle-Width="8%" Visible="true">
                                    <ItemTemplate>
                                        <asp:Label ID="lblEmail" runat="server" Text='<%# Eval("Email")%>' Visible="true"></asp:Label>
                                    </ItemTemplate>
                                    <ItemStyle VerticalAlign="Top" Width="8%" />
                                </asp:TemplateField>
                                <asp:TemplateField HeaderText="Telefono" ItemStyle-VerticalAlign="Top" ItemStyle-Width="8%" Visible="true">
                                    <ItemTemplate>
                                        <asp:Label ID="lblTelefono" runat="server" Text='<%# Eval("Telefono")%>' Visible="true"></asp:Label>
                                    </ItemTemplate>
                                    <ItemStyle VerticalAlign="Top" Width="8%" />
                                </asp:TemplateField>
                                <asp:TemplateField HeaderText="Fax" ItemStyle-VerticalAlign="Top" ItemStyle-Width="8%" Visible="true">
                                    <ItemTemplate>
                                        <asp:Label ID="lblFax" runat="server" Text='<%# Eval("Fax")%>' Visible="true"></asp:Label>
                                    </ItemTemplate>
                                    <ItemStyle VerticalAlign="Top" Width="8%" />
                                </asp:TemplateField>

                                <asp:TemplateField HeaderText="TipoAnagrafica" ItemStyle-VerticalAlign="Top" ItemStyle-Width="8%" Visible="false">
                                    <ItemTemplate>
                                        <asp:Label ID="lblTipoAnagrafica" runat="server" Text='<%# Eval("TipoAnagrafica")%>'></asp:Label>
                                    </ItemTemplate>
                                    <ItemStyle VerticalAlign="Top" Width="8%" />
                                </asp:TemplateField>
                                <asp:TemplateField HeaderText="Indirizzo" ItemStyle-VerticalAlign="Top" ItemStyle-Width="8%" Visible="false">
                                    <ItemTemplate>
                                        <asp:Label ID="lblIndirizzo" runat="server" Text='<%# Eval("Indirizzo")%>'></asp:Label>
                                    </ItemTemplate>
                                    <ItemStyle VerticalAlign="Top" Width="8%" />
                                </asp:TemplateField>
                                <asp:TemplateField HeaderText="Citta" ItemStyle-VerticalAlign="Top" ItemStyle-Width="8%" Visible="false">
                                    <ItemTemplate>
                                        <asp:Label ID="lblCitta" runat="server" Text='<%# Eval("Citta")%>'></asp:Label>
                                    </ItemTemplate>
                                    <ItemStyle VerticalAlign="Top" Width="8%" />
                                </asp:TemplateField>
                                <asp:TemplateField HeaderText="Cap" ItemStyle-VerticalAlign="Top" ItemStyle-Width="8%" Visible="false">
                                    <ItemTemplate>
                                        <asp:Label ID="lblCap" runat="server" Text='<%# Eval("Cap")%>'></asp:Label>
                                    </ItemTemplate>
                                    <ItemStyle VerticalAlign="Top" Width="8%" />
                                </asp:TemplateField>
                                <asp:TemplateField HeaderText="Provincia" ItemStyle-VerticalAlign="Top" ItemStyle-Width="8%" Visible="false">
                                    <ItemTemplate>
                                        <asp:Label ID="lblProvincia" runat="server" Text='<%# Eval("Provincia")%>'></asp:Label>
                                    </ItemTemplate>
                                    <ItemStyle VerticalAlign="Top" Width="8%" />
                                </asp:TemplateField>
                                <asp:TemplateField HeaderText="Nazione" ItemStyle-VerticalAlign="Top" ItemStyle-Width="8%" Visible="false">
                                    <ItemTemplate>
                                        <asp:Label ID="lblNazione" runat="server" Text='<%# Eval("Nazione")%>'></asp:Label>
                                    </ItemTemplate>
                                    <ItemStyle VerticalAlign="Top" Width="8%" />
                                </asp:TemplateField>
                                <asp:TemplateField HeaderText="NomeReferente" ItemStyle-VerticalAlign="Top" ItemStyle-Width="8%" Visible="false">
                                    <ItemTemplate>
                                        <asp:Label ID="lblNomeReferente" runat="server" Text='<%# Eval("NomeReferente")%>'></asp:Label>
                                    </ItemTemplate>
                                    <ItemStyle VerticalAlign="Top" Width="8%" />
                                </asp:TemplateField>
                                <asp:TemplateField HeaderText="PartitaIva" ItemStyle-VerticalAlign="Top" ItemStyle-Width="8%" Visible="false">
                                    <ItemTemplate>
                                        <asp:Label ID="lblPartitaIva" runat="server" Text='<%# Eval("PartitaIva")%>'></asp:Label>
                                    </ItemTemplate>
                                    <ItemStyle VerticalAlign="Top" Width="8%" />
                                </asp:TemplateField>
                                <asp:TemplateField HeaderText="CodiceFiscale" ItemStyle-VerticalAlign="Top" ItemStyle-Width="8%" Visible="false">
                                    <ItemTemplate>
                                        <asp:Label ID="lblCodiceFiscale" runat="server" Text='<%# Eval("CodiceFiscale")%>'></asp:Label>
                                    </ItemTemplate>
                                    <ItemStyle VerticalAlign="Top" Width="8%" />
                                </asp:TemplateField>
                                <asp:TemplateField HeaderText="NoteExtraIndirizzo" ItemStyle-VerticalAlign="Top" ItemStyle-Width="8%" Visible="false">
                                    <ItemTemplate>
                                        <asp:Label ID="lblNoteExtraIndirizzo" runat="server" Text='<%# Eval("NoteExtraIndirizzo")%>'></asp:Label>
                                    </ItemTemplate>
                                    <ItemStyle VerticalAlign="Top" Width="8%" />
                                </asp:TemplateField>
                                <asp:TemplateField HeaderText="TerminiDiPagamento" ItemStyle-VerticalAlign="Top" ItemStyle-Width="8%" Visible="false">
                                    <ItemTemplate>
                                        <asp:Label ID="lblTerminiDiPagamento" runat="server" Text='<%# Eval("TerminiDiPagamento")%>'></asp:Label>
                                    </ItemTemplate>
                                    <ItemStyle VerticalAlign="Top" Width="8%" />
                                </asp:TemplateField>
                                <asp:TemplateField HeaderText="IvaDefault" ItemStyle-VerticalAlign="Top" ItemStyle-Width="8%" Visible="false">
                                    <ItemTemplate>
                                        <asp:Label ID="lblIvaDefault" runat="server" Text='<%# Eval("IvaDefault")%>'></asp:Label>
                                    </ItemTemplate>
                                    <ItemStyle VerticalAlign="Top" Width="8%" />
                                </asp:TemplateField>
                                <asp:TemplateField HeaderText="Iban" ItemStyle-VerticalAlign="Top" ItemStyle-Width="8%" Visible="false">
                                    <ItemTemplate>
                                        <asp:Label ID="lblIban" runat="server" Text='<%# Eval("Iban")%>'></asp:Label>
                                    </ItemTemplate>
                                    <ItemStyle VerticalAlign="Top" Width="8%" />
                                </asp:TemplateField>

                                <asp:TemplateField HeaderText="Nr. Patente" ItemStyle-VerticalAlign="Top" ItemStyle-Width="8%" Visible="false">
                                    <ItemTemplate>
                                        <asp:Label ID="lblnrPatente" runat="server" Text='<%# Eval("nrPatente")%>'></asp:Label>
                                    </ItemTemplate>
                                    <ItemStyle VerticalAlign="Top" Width="8%" />
                                </asp:TemplateField>

                                <asp:TemplateField HeaderText="Cancellato" ItemStyle-VerticalAlign="Top" ItemStyle-Width="8%" Visible="false">
                                    <ItemTemplate>
                                        <asp:Label ID="lblCancellato" runat="server" Text='<%# Eval("Cancellato")%>'></asp:Label>
                                    </ItemTemplate>
                                    <ItemStyle VerticalAlign="Top" Width="8%" />
                                </asp:TemplateField>

                            </Columns>
                            <EmptyDataTemplate>
                                NESSUNA NOTA DI CREDITO TROVATA
                            </EmptyDataTemplate>
                            <PagerSettings Mode="NumericFirstLast" PageButtonCount="20" />
                        </asp:GridView>
                    </div>
                </div>
            </section>
        </div>
    </div>

</asp:Content>

