/*
Name: 			Pages / Calendar - Examples
Written by: 	Okler Themes - (http://www.okler.net)
Theme Version: 	2.0.0
*/


(function($) {
 

	'use strict';

	var initCalendarDragNDrop = function() {
		$('#external-events div.external-event').each(function() {

			// create an Event Object (http://arshaw.com/fullcalendar/docs/event_data/Event_Object/)
			// it doesn't need to have a start or end
			var eventObject = {
				title: $.trim($(this).text()) // use the element's text as the event title
			};

			// store the Event Object in the DOM element so we can get to it later
			$(this).data('eventObject', eventObject);

			// make the event draggable using jQuery UI
			$(this).draggable({
				zIndex: 999,
				revert: true,      // will cause the event to go back to its
				revertDuration: 0  //  original position after the drag
			});

		});
	};

	var initCalendar = function() {
		var $calendar = $('#calendar');
		var date = new Date();
		var d = date.getDate();
		var m = date.getMonth();
	    var y = date.getFullYear();
        	
        
	    $calendar.fullCalendar({
		   
		    header: {
		        left: 'title',                
				right: 'prev,today,next,basicDay,basicWeek,month'
			},
            		
            // Aggiunto da Per Personalizzare il Calendario
			defaultView: 'basicWeek',
			allDaySlot: true,
            allDayText:true,
			disableDragging: false,
			editable: false,
            
		    //   ------ Fine ----------
			timeFormat: 'HH:mm',

			themeButtonIcons: {
				prev: 'fa fa-caret-left',
				next: 'fa fa-caret-right',
			},

			//dayClick: function() {
			//    alert('a day has been clicked!');
			//},
            		
            
			droppable: true, // this allows things to be dropped onto the calendar !!!

			//drop: function(date, allDay) { // this function is called when something is dropped
			//	var $externalEvent = $(this);
			//	// retrieve the dropped element's stored Event Object
			//	var originalEventObject = $externalEvent.data('eventObject');

			//	// we need to copy it, so that multiple events don't have a reference to the same object
			//	var copiedEventObject = $.extend({}, originalEventObject);

			//	// assign it the date that was reported
			//	copiedEventObject.start = date;
			//	copiedEventObject.allDay = allDay;
			//	copiedEventObject.className = $externalEvent.attr('data-event-class');

			//	// render the event on the calendar
			//	// the last `true` argument determines if the event "sticks" (http://arshaw.com/fullcalendar/docs/event_rendering/renderEvent/)
			//	$('#calendar').fullCalendar('renderEvent', copiedEventObject, true);

			//	// is the "remove after drop" checkbox checked?
			//	if ($('#RemoveAfterDrop').is(':checked')) {
			//		// if so, remove the element from the "Draggable Events" list
			//		$(this).remove();
			//	}

			//},            		
			




			//events:[{   id: 1,
			//    title: 'User1',
			//    start: '2018-01-16',
			//    end: '2018-01-16',
			//    color:'#E9B33E',
			//    className: 'user-class1'},
			//],
		

            
			events: 'JsonResponse.ashx',

                     
			eventRender: function (event, element) {
			  
			    //element.find('.fc-title').append(' <i class="fa fa-address-card-o"></i> ');
			    element.find('.fc-title').append('<div class="hr-line-solid-no-margin"></div><span style="font-size: 10px">' + event.description + '</span></div>');

			    //if (event.className == 'PrenotazioneInterna') {
			    //    element.css({ 'background-color': '#000000', 'border-color': '#FFFF00' });
			    //}
			    //if (event.className == 'PrenotazioneEsterna') {
			    //    element.css({ 'background-color': '#E9B33E', 'border-color': '#E9B33E', 'color': '#000000' });
			    //}
			    //if (event.className == 'Scadenza') {
                //    element.css({ 'background-color': '#FF0000', 'border-color': '#FF0000' });
			    //}
                //element.find('.fc-title').append("<br/>" + event.description);
			    //var colore = event.className
			   // element.css({ 'background-color': colore, 'border-color': '#FF0000' });
			},		    

            

		});

	             
	    //$calendar.fullCalendar('gotoDate', DATAPASSATA);
        
	    //alert(DATAPASSATA);

	   
	    
		// FIX INPUTS TO BOOTSTRAP VERSIONS
		var $calendarButtons = $calendar.find('.fc-header-right > span');
		$calendarButtons
			.filter('.fc-button-prev, .fc-button-today, .fc-button-next')
				.wrapAll('<div class="btn-group mt-sm mr-md mb-sm ml-sm"></div>')
				.parent()
				.after('<br class="hidden"/>');

		$calendarButtons
			.not('.fc-button-prev, .fc-button-today, .fc-button-next')
				.wrapAll('<div class="btn-group mb-sm mt-sm"></div>');

		$calendarButtons
			.attr({ 'class': 'btn btn-sm btn-default' });
	};

	$(function() {
		initCalendar();
		initCalendarDragNDrop();
	});

}).apply(this, [jQuery]);