﻿<%@ Page Language="C#" AutoEventWireup="true" CodeFile="provaCalendar2.aspx.cs" Inherits="AR_provaCalendar2" %>

<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title></title>

    <script type="text/javascript" src="//cdn.tinymce.com/4/tinymce.min.js"></script>
    <link href="jcalendar/fullcalendar.min.css" rel="stylesheet" type="text/css" />
    <script src="jcalendar/jquery-ui.min.js" type="text/javascript"></script>
    <script src="jcalendar/js/bootstrap.min.js" type="text/javascript"></script>
   
   <script src="http://ajax.googleapis.com/ajax/libs/jquery/1.10.2/jquery.min.js" type="text/javascript"></script>        
    <%--    <script src="../App_Themes/admin/assets/global/plugins/jquery.min.js" type="text/javascript"></script>--%>


</head>
<body>
    <form id="form1" runat="server">
        <div class="col-md-12">
            <div class="portlet light portlet-fit bordered calendar">
                <div class="portlet-title">
                    <div class="caption">
                        <i class=" icon-layers font-green"></i>
                        <span class="caption-subject font-green sbold uppercase">Calendar</span>
                    </div>
                </div>
                <div class="portlet-body">
                    <div class="row">
                        <div class="col-md-3 col-sm-12">
                            <!-- BEGIN DRAGGABLE EVENTS PORTLET-->
                            <h3 class="event-form-title margin-bottom-20">Draggable Events</h3>
                            <div id="external-events">
                                <form class="inline-form">
                                    <input type="text" value="" class="form-control" placeholder="Event Title..." id="event_title" />
                                    <br />
                                    <%--   <asp:Button ID="event_add" runat="server" class="btn green" Text=" Add Event" />--%>
                                    <a href="javascript:;" id="A1" class="btn green">Add Event </a>
                                </form>
                                <hr />
                                <div id="event_box" class="margin-bottom-10"></div>
                                <label for="drop-remove">
                                    <input type="checkbox" id="drop-remove" />remove after drop
                                </label>
                                <hr class="visible-xs" />
                            </div>
                            <!-- END DRAGGABLE EVENTS PORTLET-->
                        </div>
                        <div class="col-md-9 col-sm-12">
                            <%--<asp:Calendar ID="calendar" runat="server" class="has-toolbar"></asp:Calendar>--%>

                            <div id="calendar" class="has-toolbar"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <script src="jcalendar/moment.js" type="text/javascript"></script>
        <script src="jcalendar/fullcalendar.min.js" type="text/javascript"></script>
        <script src="jcalendar/calendar.min.js" type="text/javascript"></script>

        <script type="text/javascript">
            $(document).ready(function () {
                InitializeCalendar();
            });
            function InitializeCalendar() {
                //-- start date and end date criteria.. you can get it from user input.. 
                var startDate = "2017-03-01";
                var endDate = "2017-05-30";
                //-- start date and end date criteria.. you can get it from user input.. 

                //-- ajax call to fetch calendar data from database
                $.ajax({
                    type: "POST",
                    contentType: "application/json",
                    data: "{ 'StartDate': '" + startDate + "', 'EndDate': '" + endDate + "' }",
                    url: "provaCalendar2.aspx/GetCalendarData",
                    dataType: "json",
                    success: function (data) {
                        $('#calendar').empty();
                        $('#calendar').fullCalendar({
                            header: {
                                left: 'prev,next today',
                                center: 'Title',
                                right: 'month,agendaWeek,agendaDay'
                            },
                            weekNumbers: true,
                            height: 600,
                            allDayText: 'Events',
                            selectable: true,
                            overflow: 'auto',
                            editable: true,
                            firstDay: 1,
                            events: $.map(data.d, function (item, i) {
                                //-- here is the event details to show in calendar view.. the data is retrieved via ajax call will be accessed here
                                var eventStartDate = new Date(parseInt(item.EventStartDate.substr(6)));
                                var eventEndDate = new Date(parseInt(item.EventEndDate.substr(6)));

                                var event = new Object();
                                event.id = item.EventId;
                                event.start = new Date(eventStartDate.getFullYear(), eventStartDate.getMonth(), eventStartDate.getDate(), eventStartDate.getHours(), 0, 0, 0);
                                event.end = new Date(eventEndDate.getFullYear(), eventEndDate.getMonth(), eventEndDate.getDate(), eventEndDate.getHours() + 1, 0, 0, 0);
                                event.Title = item.Title;
                                event.Description = item.Description;
                                event.allDay = item.AllDayEvent;
                                return event;
                            })
                        });
                    },
                    error: function (XMLHttpRequest, textStatus, errorThrown) {
                        //-- log error
                    }
                });
            }
        </script>
    </form>
</body>
</html>
