﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.SqlClient;
using System.Configuration;

/// <summary>
/// EventDAO class is the main class which interacts with the database. SQL Server express edition
/// has been used.
/// the event information is stored in a table named 'event' in the database.
///
/// Here is the table format:
/// event(event_id int, title varchar(100), description varchar(200),event_start datetime, event_end datetime)
/// event_id is the primary key
/// </summary>
public class EventDAO
{
    //change the connection string as per your database connection.
    private static string connectionString = ConfigurationManager.ConnectionStrings["db_ncbConnectionString"].ConnectionString;
   
    //this method retrieves all events within range start-end
    public static List<CalendarEvent> getEvents(DateTime start, DateTime end)
    {
        List<CalendarEvent> events = new List<CalendarEvent>();
        SqlConnection con = new SqlConnection(connectionString);
        SqlCommand cmd = new SqlCommand("SELECT IdPrenotazione, Cliente, Mezzo, Autista, DaCitta, ACitta, DataInizio, Datafine, note, ServizioEsterno, Fornitore, colore FROM vw_PrenotazioniPerCalendario", con);
        //cmd.Parameters.Clear();
        //cmd.Parameters.Add("@start", SqlDbType.DateTime).Value = start;
        //cmd.Parameters.Add("@end", SqlDbType.DateTime).Value = end;

        using (con)
        {
            con.Open();

            SqlDataReader reader = cmd.ExecuteReader();
            string Descrizione = System.String.Empty;
            string Colore = System.String.Empty;



            if (ConfigurationManager.AppSettings["FiltroCalendario"] == "Prenotazioni" || ConfigurationManager.AppSettings["FiltroCalendario"] == "ServizioEsterno" || ConfigurationManager.AppSettings["FiltroCalendario"] == "Tutto")
            {            
            
              while (reader.Read())
                 {
                if (ConfigurationManager.AppSettings["FiltroCalendario"] == "ServizioEsterno" || ConfigurationManager.AppSettings["FiltroCalendario"] == "Tutto")
                  {
                      if (Convert.ToBoolean(reader["ServizioEsterno"]) == true)
                   {
                  //Descrizione=  Convert.ToString(reader["DaCitta"]) + " - " + Convert.ToString(reader["ACitta"]) + " <br/> " + Convert.ToString(reader["Fornitore"]) + "<br/>" + Convert.ToString(reader["note"]);
                     Descrizione = Convert.ToString(reader["note"]) + " <br/> " + Convert.ToString(reader["Fornitore"]);
                     Colore = "#FF7F26";

                     events.Add(new CalendarEvent()
                     {
                         id = Convert.ToInt32(reader["IdPrenotazione"]),
                         title = string.Format("{0:d}", Convert.ToString(reader["Cliente"])),
                         description = Descrizione,
                         start = Convert.ToDateTime(reader["DataInizio"]),
                         end = Convert.ToDateTime(reader["Datafine"]),
                         allDay = false,
                         className = "",
                         url = "Prenotazione.aspx?id=" + Convert.ToInt32(reader["IdPrenotazione"]) + "&op=Dett",
                         color = Colore,
                     });
                  
                  
                  
                  }
                }
               
                if (ConfigurationManager.AppSettings["FiltroCalendario"] == "Prenotazioni" || ConfigurationManager.AppSettings["FiltroCalendario"] == "Tutto")
                  {
                     if (Convert.ToBoolean(reader["ServizioEsterno"]) == false)
                   {
                    Descrizione = Convert.ToString(reader["note"]) + " <br/> " + Convert.ToString(reader["Autista"]) + " - " + Convert.ToString(reader["Mezzo"]);
                    Colore = Convert.ToString(reader["colore"]);
                   //Descrizione = Convert.ToString(reader["DaCitta"]) + " - " + Convert.ToString(reader["ACitta"]) + " <br/> " + Convert.ToString(reader["Autista"]) + " - " + Convert.ToString(reader["Mezzo"]) + "<br/>" + Convert.ToString(reader["note"]);

                    events.Add(new CalendarEvent()
                    {
                        id = Convert.ToInt32(reader["IdPrenotazione"]),
                        title = string.Format("{0:d}", Convert.ToString(reader["Cliente"])),
                        description = Descrizione,
                        start = Convert.ToDateTime(reader["DataInizio"]),
                        end = Convert.ToDateTime(reader["Datafine"]),
                        allDay = false,
                        className = "",
                        url = "Prenotazione.aspx?id=" + Convert.ToInt32(reader["IdPrenotazione"]) + "&op=Dett",
                        color = Colore,
                    });

                   }
                }
                 
              
            }

            }

            if (ConfigurationManager.AppSettings["FiltroCalendario"] == "Scadenze" || ConfigurationManager.AppSettings["FiltroCalendario"] == "Tutto")
            { 
            cmd.CommandText = "SELECT idScadenzario, Tipologia, TipoScadenza, DataInizio, DataFine, Riferimento, Promemoria FROM Scadenzario ";

            reader.Close();

            SqlDataReader reader2 = cmd.ExecuteReader();
            while (reader2.Read())
                        

                events.Add(new CalendarEvent()
                {
                    id = Convert.ToInt32(reader2["idScadenzario"]),
                    title = Convert.ToString(reader2["TipoScadenza"]),
                    description = Convert.ToString(reader2["Tipologia"]) + " - " + Convert.ToString(reader2["Riferimento"]) + "<br/>" + Convert.ToString(reader2["DataFine"]) + "<br/>" + Convert.ToString(reader2["Promemoria"]),
                    start = Convert.ToDateTime(reader2["DataInizio"]),
                    end = Convert.ToDateTime(reader2["DataFine"]),
                    allDay = false,
                    className = "Scadenza",
                    url = "Scadenzario.aspx?id=" + Convert.ToInt32(reader2["idScadenzario"]) + "&op=Dett",
                    color = "#FF0000",
                });
            }
        }

       
        //cmd.CommandText = "SELECT idScadenzario, Tipologia, TipoScadenza, DataInizio, DataFine FROM Scadenzario ";
        //cmd.Parameters.Clear();
        //cmd.Parameters.Add("@start", SqlDbType.DateTime).Value = start;
        //cmd.Parameters.Add("@end", SqlDbType.DateTime).Value = end;

        //using (con)
        //{
        //    con.Open();
        //    SqlDataReader reader = cmd.ExecuteReader();
        //    while (reader.Read())
        //    {
        //        events.Add(new CalendarEvent()
        //        {
        //            id = Convert.ToInt32(reader["idScadenzario"]),
        //            title = Convert.ToString(reader["TipoScadenza"]),
        //            description = Convert.ToString(reader["Tipologia"]),
        //            start = Convert.ToDateTime(reader["DataFine"]),
        //            end = Convert.ToDateTime(reader["DataFine"]),
        //            allDay = false,
        //            className = "Scadenza",
        //            url = "",
        //        });
        //    }
        //}

        return events;
        //side note: if you want to show events only related to particular users,
        //if user id of that user is stored in session as Session["userid"]
        //the event table also contains an extra field named 'user_id' to mark the event for that particular user
        //then you can modify the SQL as:
        //SELECT event_id, description, title, event_start, event_end FROM event where user_id=@user_id AND event_start>=@start AND event_end<=@end
        //then add paramter as:cmd.Parameters.AddWithValue("@user_id", HttpContext.Current.Session["userid"]);
    }

    //this method updates the event title and description
    public static void updateEvent(int id, String title, String description)
    {
        //SqlConnection con = new SqlConnection(connectionString);
        //SqlCommand cmd = new SqlCommand("UPDATE Event SET title=@title, description=@description WHERE event_id=@event_id", con);
        //cmd.Parameters.Add("@title", SqlDbType.VarChar).Value = title;
        //cmd.Parameters.Add("@description", SqlDbType.VarChar).Value = description;
        //cmd.Parameters.Add("@event_id", SqlDbType.Int).Value = id;

        //using (con)
        //{
        //    con.Open();
        //    cmd.ExecuteNonQuery();
        //}
    }

    //this method updates the event start and end time ... allDay parameter added for FullCalendar 2.x
    public static void updateEventTime(int id, DateTime start, DateTime end, bool allDay)
    {
        //SqlConnection con = new SqlConnection(connectionString);
        //SqlCommand cmd = new SqlCommand("UPDATE Event SET event_start=@event_start, event_end=@event_end, all_day=@all_day WHERE event_id=@event_id", con);
        //cmd.Parameters.Add("@event_start", SqlDbType.DateTime).Value = start;
        //cmd.Parameters.Add("@event_end", SqlDbType.DateTime).Value = end;
        //cmd.Parameters.Add("@event_id", SqlDbType.Int).Value = id;
        //cmd.Parameters.Add("@all_day", SqlDbType.Bit).Value = allDay;

        //using (con)
        //{
        //    con.Open();
        //    cmd.ExecuteNonQuery();
        //}
    }

    //this mehtod deletes event with the id passed in.
    public static void deleteEvent(int id)
    {
        //SqlConnection con = new SqlConnection(connectionString);
        //SqlCommand cmd = new SqlCommand("DELETE FROM Event WHERE (event_id = @event_id)", con);
        //cmd.Parameters.Add("@event_id", SqlDbType.Int).Value = id;

        //using (con)
        //{
        //    con.Open();
        //    cmd.ExecuteNonQuery();
        //}
    }

    //this method adds events to the database
    public static int addEvent(CalendarEvent cevent)
    {
        //add event to the database and return the primary key of the added event row

        //insert
        SqlConnection con = new SqlConnection(connectionString);
        SqlCommand cmd = new SqlCommand("INSERT INTO Event(title, description, event_start, event_end, all_day) VALUES(@title, @description, @event_start, @event_end, @all_day)", con);
        cmd.Parameters.Add("@title", SqlDbType.VarChar).Value = cevent.title;
        cmd.Parameters.Add("@description", SqlDbType.VarChar).Value = cevent.description;
        cmd.Parameters.Add("@event_start", SqlDbType.DateTime).Value = cevent.start;
        cmd.Parameters.Add("@event_end", SqlDbType.DateTime).Value = cevent.end;
        cmd.Parameters.Add("@all_day", SqlDbType.Bit).Value = cevent.allDay;

        int key = 0;
        using (con)
        {
            con.Open();
            cmd.ExecuteNonQuery();

            //get primary key of inserted row
            cmd = new SqlCommand("SELECT max(event_id) FROM Event where title=@title AND description=@description AND event_start=@event_start AND event_end=@event_end AND all_day=@all_day", con);
            cmd.Parameters.Add("@title", SqlDbType.VarChar).Value = cevent.title;
            cmd.Parameters.Add("@description", SqlDbType.VarChar).Value = cevent.description;
            cmd.Parameters.Add("@event_start", SqlDbType.DateTime).Value = cevent.start;
            cmd.Parameters.Add("@event_end", SqlDbType.DateTime).Value = cevent.end;
            cmd.Parameters.Add("@all_day", SqlDbType.Bit).Value = cevent.allDay;

            key = (int)cmd.ExecuteScalar();
        }

        return key;
    }
}
