Imports Microsoft.VisualBasic
Imports SP_NameSpace
Imports System.Data
Imports System.Data.Common
Imports System.Data.SqlClient
Imports System.Data.Sql
Imports System.Configuration
Imports System.xml
Public Class BD_BindDataMain
    Private mySPDriver As SP_Driver
    Private _strConn As String
    Private _ErrorNumber As Integer
    Private _ErrorSeverity As Integer
    Private _ErrorState As Integer
    Private _ErrorProcedure As String
    Private _ErrorLine As Integer
    Private _ErrorMessage As String
    Private _NumRowsAffected As Integer
    Private _noDB As Boolean
    Public Property ErrorNumber() As Integer
        Get
            Return _ErrorNumber
        End Get
        Set(ByVal value As Integer)
            _ErrorNumber = value
        End Set
    End Property
    Public Property ErrorSeverity() As Integer
        Get
            Return _ErrorSeverity
        End Get
        Set(ByVal value As Integer)
            _ErrorSeverity = value
        End Set
    End Property
    Public Property ErrorState() As Integer
        Get
            Return _ErrorState
        End Get
        Set(ByVal value As Integer)
            _ErrorState = value
        End Set
    End Property
    Public Property ErrorLine() As Integer
        Get
            Return _ErrorLine
        End Get
        Set(ByVal value As Integer)
            _ErrorLine = value
        End Set
    End Property
    Public Property ErrorMessage() As String
        Get
            If _ErrorMessage Is Nothing Then
                Return ""
            End If
            Return _ErrorMessage
        End Get
        Set(ByVal value As String)
            _ErrorMessage = value
        End Set
    End Property
    Public Property ErrorProcedure() As String
        Get
            If _ErrorProcedure Is Nothing Then
                Return ""
            End If
            Return _ErrorProcedure
        End Get
        Set(ByVal value As String)
            _ErrorProcedure = value
        End Set
    End Property
    Public Property strConn() As String
        Get
            Return _strConn
        End Get
        Set(ByVal value As String)
            _strConn = value
        End Set
    End Property
    Public Property NumRowsAffected() As Integer
        Get
            Return _NumRowsAffected
        End Get
        Set(ByVal value As Integer)
            _NumRowsAffected = value
        End Set
    End Property
    Public Sub New(ByVal strConn As String, Optional ByVal noDB As Boolean = False)
        _strConn = strConn
        _noDB = noDB
    End Sub
    Public Function getDataTable(ByVal SPName As String, _
                        ByVal gruppoParamInp As SP_GruppoParametri) As DataTable
        Dim DataTableTemp As New DataTable
        resetError()
        Try


            Dim SPDriver As SP_Driver
            SPDriver = New SP_Driver(SPName, strConn, gruppoParamInp)

            SPDriver.sp_exec()

            setErrorGP(SPDriver)

            If ErrorNumber = 0 Then
                Dim dt As New DataTable
                Dim wdr As New BD_DataReaderWrapper
                Dim nrec As Integer = wdr.FillFromReader(dt, SPDriver.RSOut)

                DataTableTemp = dt

            End If
            SPDriver.closeConnection()
            SPDriver = Nothing
        Catch ex As Exception
            ErrorMessage = ex.Message
            ErrorNumber = -1
        Finally
            getDataTable = DataTableTemp
        End Try

    End Function
    Public Function getSingleValue(ByVal SPName As String, _
                    ByVal gruppoParamInp As SP_GruppoParametri, ByVal nomeColumn As String) As String
        Dim strTemp As String = ""
        resetError()
        Try


            Dim SPDriver As SP_Driver
            SPDriver = New SP_Driver(SPName, strConn, gruppoParamInp)

            SPDriver.sp_exec()

            setErrorGP(SPDriver)

            If ErrorNumber = 0 Then
                Dim dt As New DataTable
                Dim wdr As New BD_DataReaderWrapper
                Dim nrec As Integer = wdr.FillFromReader(dt, SPDriver.RSOut)

                strTemp = dt.Rows(0)(nomeColumn).ToString()

            End If

            SPDriver.closeConnection()
            SPDriver = Nothing
        Catch ex As Exception
            ErrorMessage = ex.Message
            ErrorNumber = -1
        Finally
            getSingleValue = strTemp
        End Try

    End Function
    Public Sub BindDataObj(ByVal myGrid As GridView, _
                        ByVal SPName As String, _
                        ByVal gruppoParamInp As SP_GruppoParametri)
        resetError()
        Try
            If _noDB Then
                BindDataTempXML(myGrid)
            Else
                Dim SPDriver As SP_Driver
                SPDriver = New SP_Driver(SPName, strConn, gruppoParamInp)

                SPDriver.sp_exec()

                setErrorGP(SPDriver)

                If ErrorNumber = 0 Then
                    myGrid.DataSource = SPDriver.RSOut


                    Dim dt As New DataTable
                    Dim wdr As New BD_DataReaderWrapper
                    Dim nrec As Integer = wdr.FillFromReader(dt, myGrid.DataSource)
                    NumRowsAffected = nrec
                    myGrid.DataSource = dt
                    myGrid.DataBind()
                End If

                SPDriver.closeConnection()
                SPDriver = Nothing
            End If

        Catch ex As Exception
            ErrorMessage = ex.Message
            ErrorNumber = -1
        End Try
    End Sub
    Public Sub BindDataObj(ByVal myList As DropDownList, _
                ByVal SPName As String, _
                ByVal idColText As Integer, ByVal idColValue As Integer, _
                ByVal idSelected As Integer, ByVal firstItemNull As Boolean, _
                ByVal gruppoParamInp As SP_GruppoParametri _
                , Optional ByVal idColText2 As Int32 = -1, _
                Optional ByVal itemNullValue As String = "-1", Optional ByVal itemNullText As String = "Seleziona Item")
        resetError()
        Try
            myList.Items.Clear()

            If firstItemNull Then
                myList.Items.Add(New ListItem(itemNullText, itemNullValue))
            End If

            Dim dataTabAppo As DataTable = getDataTable(SPName, gruppoParamInp)

            If ErrorNumber = 0 Then
                If Not IsNothing(dataTabAppo) Then
                    For Each rowDati As DataRow In dataTabAppo.Rows
                        If idColText2 > -1 Then
                            myList.Items.Add(New ListItem(rowDati(idColText) & " (" & rowDati(idColText2) & ")", rowDati(idColValue)))
                        Else
                            myList.Items.Add(New ListItem(rowDati(idColText), rowDati(idColValue)))
                        End If

                    Next
                    myList.SelectedIndex = idSelected
                Else
                    myList.Items.Add(New ListItem(ErrorMessage, ErrorNumber))
                End If
            End If
            dataTabAppo = Nothing
        Catch ex As Exception
            ErrorMessage = ex.Message
            ErrorNumber = -1
            myList.Items.Add(New ListItem(ErrorMessage, ErrorNumber))
        End Try
    End Sub
    Public Sub BindDataObj(ByVal myList As DropDownList, _
                ByVal SPName As String, _
                ByVal idColText As Integer, ByVal idColValue As Integer, _
                ByVal idSelected As Integer, ByVal firstItemNull As Boolean, _
                ByVal gruppoParamInp As SP_GruppoParametri _
                , ByVal idColText2 As Int32, ByVal idColValue2 As Int32, _
                Optional ByVal itemNullValue As String = "-1", Optional ByVal itemNullText As String = "Seleziona Item")
        resetError()
        Try
            myList.Items.Clear()

            If firstItemNull Then
                myList.Items.Add(New ListItem(itemNullText, itemNullValue))
            End If

            Dim dataTabAppo As DataTable = getDataTable(SPName, gruppoParamInp)

            If ErrorNumber = 0 Then
                If Not IsNothing(dataTabAppo) Then
                    For Each rowDati As DataRow In dataTabAppo.Rows
                        If idColText2 > -1 Then
                            myList.Items.Add(New ListItem(rowDati(idColText) & " (" & rowDati(idColText2) & ")", rowDati(idColValue) & "|" & rowDati(idColValue2)))
                        Else
                            myList.Items.Add(New ListItem(rowDati(idColText), rowDati(idColValue)))
                        End If

                    Next
                    myList.SelectedIndex = idSelected
                Else
                    myList.Items.Add(New ListItem(ErrorMessage, ErrorNumber))
                End If
            End If
            dataTabAppo = Nothing
        Catch ex As Exception
            ErrorMessage = ex.Message
            ErrorNumber = -1
            myList.Items.Add(New ListItem(ErrorMessage, ErrorNumber))
        End Try
    End Sub
    Public Sub BindDataObj(ByVal myList As DropDownList, _
                ByVal dtInput As DataTable, _
                ByVal idColText As Integer, ByVal idColValue As Integer, _
                ByVal idSelected As Integer, ByVal firstItemNull As Boolean, _
                Optional ByVal idColText2 As Int32 = -1, Optional ByVal idColValue2 As Int32 = -1, _
                Optional ByVal itemNullValue As String = "-1", Optional ByVal itemNullText As String = "Seleziona Item")
        resetError()
        Try
            myList.Items.Clear()

            If firstItemNull Then
                myList.Items.Add(New ListItem(itemNullText, itemNullValue))
            End If

            Dim dataTabAppo As DataTable = dtInput

            If ErrorNumber = 0 Then
                If Not IsNothing(dataTabAppo) Then
                    For Each rowDati As DataRow In dataTabAppo.Rows
                        If idColText2 > -1 Then
                            myList.Items.Add(New ListItem(rowDati(idColText) & " (" & rowDati(idColText2) & ")", rowDati(idColValue) & "|" & rowDati(idColValue2)))
                        Else
                            myList.Items.Add(New ListItem(rowDati(idColText), rowDati(idColValue)))
                        End If

                    Next
                    myList.SelectedIndex = idSelected
                Else
                    myList.Items.Add(New ListItem(ErrorMessage, ErrorNumber))
                End If
            End If
            dataTabAppo = Nothing
        Catch ex As Exception
            ErrorMessage = ex.Message
            ErrorNumber = -1
            myList.Items.Add(New ListItem(ErrorMessage, ErrorNumber))
        End Try
    End Sub

    Public Sub BindDataObj(ByVal myList As RadioButtonList, _
                ByVal SPName As String, _
                ByVal idColText As Integer, ByVal idColValue As Integer, _
                ByVal idSelected As Integer, ByVal gruppoParamInp As SP_GruppoParametri)
        resetError()
        Try
            myList.Items.Clear()

            Dim dataTabAppo As DataTable = getDataTable(SPName, gruppoParamInp)

            If ErrorNumber = 0 Then
                If Not IsNothing(dataTabAppo) Then
                    For Each rowDati As DataRow In dataTabAppo.Rows
                        myList.Items.Add(New ListItem(rowDati(idColText), rowDati(idColValue)))

                    Next
                    myList.SelectedIndex = idSelected
                Else
                    myList.Items.Add(New ListItem(ErrorMessage, ErrorNumber))
                End If
            End If
            dataTabAppo = Nothing
        Catch ex As Exception
            ErrorMessage = ex.Message
            ErrorNumber = -1
            myList.Items.Add(New ListItem(ErrorMessage, ErrorNumber))
        End Try
    End Sub


    Public Sub BindDataObj(ByVal myDataList As DataList, ByVal SPName As String, _
            ByVal gruppoParamInp As SP_GruppoParametri)

        resetError()
        Try
            Dim SPDriver As SP_Driver
            SPDriver = New SP_Driver(SPName, strConn, gruppoParamInp)

            SPDriver.sp_exec()

            setErrorGP(SPDriver)

            If ErrorNumber = 0 Then
                myDataList.DataSource = SPDriver.RSOut

                Dim dt As New DataTable
                Dim wdr As New BD_DataReaderWrapper
                Dim nrec As Integer = wdr.FillFromReader(dt, myDataList.DataSource)
                NumRowsAffected = nrec
                myDataList.DataSource = dt
                myDataList.DataBind()
            End If

            SPDriver.closeConnection()
            SPDriver = Nothing

        Catch ex As Exception
            ErrorMessage = ex.Message
            ErrorNumber = -1
        End Try
    End Sub
    Public Sub BindDataObj(ByVal myRepeater As Repeater, ByVal SPName As String, _
                ByVal gruppoParamInp As SP_GruppoParametri)

        resetError()
        Try
            Dim SPDriver As SP_Driver
            SPDriver = New SP_Driver(SPName, strConn, gruppoParamInp)

            SPDriver.sp_exec()

            setErrorGP(SPDriver)

            If ErrorNumber = 0 Then
                myRepeater.DataSource = SPDriver.RSOut

                Dim dt As New DataTable
                Dim wdr As New BD_DataReaderWrapper
                Dim nrec As Integer = wdr.FillFromReader(dt, myRepeater.DataSource)
                NumRowsAffected = nrec
                myRepeater.DataSource = dt
                myRepeater.DataBind()
            End If

            SPDriver.closeConnection()
            SPDriver = Nothing

        Catch ex As Exception
            ErrorMessage = ex.Message
            ErrorNumber = -1
        End Try
    End Sub
    Public Sub ExecDispositiva(ByVal SPName As String, _
            ByVal gruppoParamInp As SP_GruppoParametri)

        resetError()
        Try
            Dim SPDriver As SP_Driver
            SPDriver = New SP_Driver(SPName, strConn, gruppoParamInp)

            SPDriver.sp_exec()

            setErrorGP(SPDriver)

            SPDriver.closeConnection()
            SPDriver = Nothing

        Catch ex As Exception
            ErrorMessage = ex.Message
            ErrorNumber = -1
        End Try
    End Sub
    Public Sub resetError()
        ErrorNumber = 0
        ErrorSeverity = 0
        ErrorState = 0
        ErrorProcedure = vbNullString
        ErrorLine = 0
        ErrorMessage = vbNullString
    End Sub
    Public Sub setErrorGP(ByVal SPDriver As SP_Driver)
        ErrorNumber = SPDriver.ErrorNumber
        ErrorSeverity = SPDriver.ErrorSeverity
        ErrorState = SPDriver.ErrorState
        ErrorProcedure = SPDriver.ErrorProcedure
        ErrorLine = SPDriver.ErrorLine
        ErrorMessage = SPDriver.ErrorMessage
        NumRowsAffected = SPDriver.NumRowsAff
    End Sub
    Public Sub BindDataTempXML(ByVal myGrid As GridView)
        Try
            Dim objDS As New DataSet
            objDS.ReadXml(HttpContext.Current.Server.MapPath("datatemp.xml"))
            myGrid.DataSource = New DataView(objDS.Tables(1))
            myGrid.DataBind()
        Catch ex As Exception
            ErrorMessage = ex.Message
            ErrorNumber = -1
        End Try
    End Sub
    Public Sub BindDataTempXML(ByVal myList As DropDownList)
        Try
            Dim objDS As New DataSet
            objDS.ReadXml(HttpContext.Current.Server.MapPath("datatemp.xml"))
            myList.DataSource = New DataView(objDS.Tables(1))
            myList.DataBind()
        Catch ex As Exception
            ErrorMessage = ex.Message
            ErrorNumber = -1
        End Try
    End Sub

End Class

