﻿Imports Microsoft.VisualBasic
Imports System.Data
Imports System.IO
Imports System.Data.SqlClient
Imports System.Collections.Generic
Imports System.Web
Imports System.Web.UI
Imports System.Web.UI.WebControls
Imports SelectPdf

Public Class OptFattura
    Inherits System.Web.UI.Page

    Public Shared Sub FatturaPDF(ByVal _InviaEmail As Boolean, ByVal _IdFattura As Integer, ByVal _NrFattura As String)
        If LayoutFatturaScelto() = "Personalizzata" Then PdfFatturaPersonalizzata(_InviaEmail, _IdFattura, _NrFattura)
        If LayoutFatturaScelto() = "Classica" Then PdfFatturaClassica(_InviaEmail, _IdFattura, _NrFattura)
        If LayoutFatturaScelto() = "Moderna" Then PdfFatturaModerna(_InviaEmail, _IdFattura, _NrFattura)
    End Sub

    Public Shared Function LayoutFatturaScelto() As String

        Dim Layout As String = ""

        Dim conn As SqlConnection = New SqlConnection
        conn.ConnectionString = ConfigurationManager.ConnectionStrings("db_ncbConnectionString").ConnectionString
        Dim cmd As SqlCommand = New SqlCommand
        cmd.CommandText = "SELECT * from " & _
        " LayoutFattura where idLayoutFattura = 1"
        cmd.Connection = conn
        conn.Open()
        Dim sdr As SqlDataReader = cmd.ExecuteReader

        While sdr.Read
            Layout = sdr("TipoFattura")
        End While
        conn.Close()

        Return Layout

    End Function

    Public Shared Sub PdfFatturaPersonalizzata(ByVal InviaEmail As Boolean, ByVal IdFattura As Integer, ByVal NrFattura As String)

        Dim footerUrl As String = "http://gestionalencb.it/_Footer2.aspx?idf=" & IdFattura

        Dim showFooterOnFirstPage As Boolean = True
        Dim showFooterOnOddPages As Boolean = True
        Dim showFooterOnEvenPages As Boolean = True

        Dim footerHeight As Integer = 150

        Dim Converter As New HtmlToPdf

        ' footer settings
        Converter.Options.DisplayFooter = showFooterOnFirstPage OrElse _
        showFooterOnOddPages OrElse showFooterOnEvenPages
        Converter.Footer.DisplayOnFirstPage = showFooterOnFirstPage
        Converter.Footer.DisplayOnOddPages = showFooterOnOddPages
        Converter.Footer.DisplayOnEvenPages = showFooterOnEvenPages
        Converter.Footer.Height = footerHeight

        Dim footerHtml As New PdfHtmlSection(footerUrl)
        footerHtml.AutoFitHeight = HtmlToPdfPageFitMode.AutoFit
        Converter.Footer.Add(footerHtml)

        ' page numbers can be added using a PdfTextSection object
        Dim text As New PdfTextSection(0, 83, "Pag. {page_number} of {total_pages}     ", _
                                              New System.Drawing.Font("Arial", 8))
        text.HorizontalAlign = PdfTextHorizontalAlign.Right
        Converter.Footer.Add(text)

        Dim doc As PdfDocument = Converter.ConvertUrl("http://gestionalencb.it/FatturaPDF2.aspx?idf=" & IdFattura)
        If InviaEmail = False Then
            doc.Save(HttpContext.Current.Response, False, "Fat-" & NrFattura.Trim & ".pdf")
        Else
            doc.Save(HttpContext.Current.Server.MapPath("~/ar/temp/") & "Fat-" & Replace(NrFattura.Trim, "/", "-") & ".pdf")
        End If


        doc.Close()
    End Sub

    Public Shared Sub PdfFatturaClassica(ByVal InviaEmail As Boolean, ByVal IdFattura As Integer, ByVal NrFattura As String)
        ' get parameters
        Dim headerUrl As String = "http://gestionalencb.it/_Header1.aspx"
        Dim footerUrl As String = "http://gestionalencb.it/_Footer1.aspx?idf=" & IdFattura

        Dim showHeaderOnFirstPage As Boolean = True
        Dim showHeaderOnOddPages As Boolean = True
        Dim showHeaderOnEvenPages As Boolean = True

        Dim showFooterOnFirstPage As Boolean = True
        Dim showFooterOnOddPages As Boolean = True
        Dim showFooterOnEvenPages As Boolean = True

        Dim headerHeight As Integer = 80
        Dim footerHeight As Integer = 150

        ' instantiate a html to pdf converter object
        Dim Converter As New HtmlToPdf

        ' header settings
        Converter.Options.DisplayHeader = showHeaderOnFirstPage OrElse showHeaderOnOddPages OrElse showHeaderOnEvenPages
        Converter.Header.DisplayOnFirstPage = showHeaderOnFirstPage
        Converter.Header.DisplayOnOddPages = showHeaderOnOddPages
        Converter.Header.DisplayOnEvenPages = showHeaderOnEvenPages
        Converter.Header.Height = headerHeight

        Dim headerHtml As New PdfHtmlSection(headerUrl)
        headerHtml.AutoFitHeight = HtmlToPdfPageFitMode.AutoFit
        Converter.Header.Add(headerHtml)

        ' footer settings
        Converter.Options.DisplayFooter = showFooterOnFirstPage OrElse _
        showFooterOnOddPages OrElse showFooterOnEvenPages
        Converter.Footer.DisplayOnFirstPage = showFooterOnFirstPage
        Converter.Footer.DisplayOnOddPages = showFooterOnOddPages
        Converter.Footer.DisplayOnEvenPages = showFooterOnEvenPages
        Converter.Footer.Height = footerHeight

        Dim footerHtml As New PdfHtmlSection(footerUrl)
        footerHtml.AutoFitHeight = HtmlToPdfPageFitMode.AutoFit
        Converter.Footer.Add(footerHtml)

        ' page numbers can be added using a PdfTextSection object
        Dim text As New PdfTextSection(0, 83, "Pag. {page_number} of {total_pages}     ", _
                                              New System.Drawing.Font("Arial", 8))
        text.HorizontalAlign = PdfTextHorizontalAlign.Right
        Converter.Footer.Add(text)

        Dim doc As PdfDocument = Converter.ConvertUrl("http://gestionalencb.it/FatturaPDF1.aspx?idf=" & IdFattura)
        If InviaEmail = False Then
            doc.Save(HttpContext.Current.Response, False, "Fat-" & NrFattura.Trim & ".pdf")
        Else
            doc.Save(HttpContext.Current.Server.MapPath("~/ar/temp/") & "Fat-" & Replace(NrFattura.Trim, "/", "-") & ".pdf")
        End If

        doc.Close()
    End Sub


    Public Shared Sub PdfFatturaModerna(ByVal InviaEmail As Boolean, ByVal IdFattura As Integer, ByVal NrFattura As String)

        ' instantiate a html to pdf converter object
        Dim Converter As New HtmlToPdf
        ' page numbers can be added using a PdfTextSection object
        Dim text As New PdfTextSection(0, 83, "Pag. {page_number} of {total_pages}     ", _
                                              New System.Drawing.Font("Arial", 8))
        text.HorizontalAlign = PdfTextHorizontalAlign.Right

        Dim doc As PdfDocument = Converter.ConvertUrl("http://gestionalencb.it/FatturaPDF3.aspx?idf=" & IdFattura)
        If InviaEmail = False Then
            doc.Save(HttpContext.Current.Response, False, "Fat-" & NrFattura.Trim & ".pdf")
        Else
            doc.Save(HttpContext.Current.Server.MapPath("~/ar/temp/") & "Fat-" & Replace(NrFattura.Trim, "/", "-") & ".pdf")
        End If

        doc.Close()
    End Sub

End Class

