Imports Microsoft.VisualBasic
Imports System.Collections.ObjectModel
Imports System.Data
Imports System.Data.Sql
Imports System.Data.SqlClient
Imports System.Configuration
Imports System.xml

Namespace SP_NameSpace
#Region "SP_GruppoParametri"


    Public Class SP_GruppoParametri : Inherits System.Collections.ObjectModel.Collection(Of SP_Parametro)
        Private _GruppoParam As New Collection
        Public Property GruppoParam() As Collection
            Get
                GruppoParam = _GruppoParam
            End Get
            Set(ByVal value As Collection)
                _GruppoParam = value
            End Set
        End Property

        Public Function getGruppoParam() As System.Collections.Generic.IList(Of SP_Parametro)
            getGruppoParam = Me.Items
        End Function
    End Class
#End Region

#Region "SP_Parametro"

    Public Class SP_Parametro

        Private _NomeParametro As String
        Private _DimensioneParametro As String
        Private _ValoreParametro As String
        Private _TipoParametro As DbType
        Private _DirezioneParametro As ParameterDirection
        Public Sub New(ByVal NomeParametro As String, ByVal DimensioneParametro As Integer, ByVal ValoreParametro As String, ByVal TipoParametro As DbType, ByVal DirezioneParametro As ParameterDirection)
            Me.NomeParametro = NomeParametro
            Me.ValoreParametro = ValoreParametro
            Me.TipoParametro = TipoParametro
            Me.DirezioneParametro = DirezioneParametro
            Me.DimensioneParametro = DimensioneParametro
        End Sub
        Public Property DimensioneParametro() As Integer
            Get
                DimensioneParametro = _DimensioneParametro
            End Get
            Set(ByVal value As Integer)
                _DimensioneParametro = value.ToString()
            End Set
        End Property
        Public Property NomeParametro() As String
            Get
                NomeParametro = _NomeParametro
            End Get
            Set(ByVal value As String)
                _NomeParametro = value.ToString()
            End Set
        End Property
        Public Property ValoreParametro() As String
            Get
                ValoreParametro = _ValoreParametro
            End Get
            Set(ByVal value As String)
                _ValoreParametro = value.ToString()
            End Set
        End Property
        Public Property TipoParametro() As DbType
            Get
                TipoParametro = _TipoParametro
            End Get
            Set(ByVal value As DbType)
                _TipoParametro = value
            End Set
        End Property
        Public Property DirezioneParametro() As ParameterDirection
            Get
                DirezioneParametro = _DirezioneParametro
            End Get
            Set(ByVal value As ParameterDirection)
                _DirezioneParametro = value
            End Set
        End Property
    End Class

#End Region

#Region "SP_Driver"

    Public Class SP_Driver
        Private cmd As SqlCommand
        Private _SPName As String
        Private _RSOut As SqlDataReader
        Private _NumRowsAff As Integer
        Private _conn As SqlConnection
        Private _StrConn As String

        Private _ErrorNumber As Integer
        Private _ErrorSeverity As Integer
        Private _ErrorState As Integer
        Private _ErrorProcedure As String
        Private _ErrorLine As Integer
        Private _ErrorMessage As String
        Private _ParamInput As Collection
        Private _GruppoParamInput As SP_GruppoParametri

        Public Property StrConn() As String
            Get
                Return _StrConn
            End Get
            Set(ByVal value As String)
                _StrConn = value
            End Set
        End Property

        Public Property NumRowsAff() As Integer
            Get
                Return _NumRowsAff
            End Get
            Set(ByVal value As Integer)
                _NumRowsAff = value
            End Set
        End Property
        Public Property RSOut() As SqlDataReader
            Get
                Return _RSOut
            End Get
            Set(ByVal value As SqlDataReader)
                _RSOut = value
            End Set
        End Property
        Public Property SPName() As String
            Get
                Return _SPName
            End Get
            Set(ByVal value As String)
                _SPName = value
            End Set
        End Property
        Public Property ErrorNumber() As Integer
            Get
                Return _ErrorNumber
            End Get
            Set(ByVal value As Integer)
                _ErrorNumber = value
            End Set
        End Property
        Public Property ErrorSeverity() As Integer
            Get
                Return _ErrorSeverity
            End Get
            Set(ByVal value As Integer)
                _ErrorSeverity = value
            End Set
        End Property
        Public Property ErrorState() As Integer
            Get
                Return _ErrorState
            End Get
            Set(ByVal value As Integer)
                _ErrorState = value
            End Set
        End Property
        Public Property ErrorLine() As Integer
            Get
                Return _ErrorLine
            End Get
            Set(ByVal value As Integer)
                _ErrorLine = value
            End Set
        End Property
        Public Property ErrorMessage() As String
            Get
                Return _ErrorMessage
            End Get
            Set(ByVal value As String)
                _ErrorMessage = value
            End Set
        End Property
        Public Property ErrorProcedure() As String
            Get
                Return _ErrorProcedure
            End Get
            Set(ByVal value As String)
                _ErrorProcedure = value
            End Set
        End Property
        Public Property ParamInput() As Collection
            'ParamInput  la collection dei dei parametri di input:
            '   ogni ITEM  un array del tipo {nomeparamentro, valoreparametro}
            'etc. etc.
            Get
                Return _ParamInput
            End Get
            Set(ByVal value As Collection)
                _ParamInput = value
            End Set
        End Property
        Public Property GruppoParamInput() As SP_GruppoParametri
            'ParamInput  la collection dei dei parametri di input:
            '   ogni ITEM  un array del tipo {nomeparamentro, valoreparametro}
            'etc. etc.
            Get
                Return _GruppoParamInput
            End Get
            Set(ByVal value As SP_GruppoParametri)
                _GruppoParamInput = value
            End Set
        End Property
        Public Sub New(ByVal SPName As String, ByVal strConn As String, ByVal paramInput As SP_GruppoParametri)
            Me.SPName = SPName
            Me.StrConn = strConn
            Me.GruppoParamInput = paramInput
        End Sub
        Public Sub New(ByVal SPName As String, ByVal strConn As String, Optional ByVal paramInput As Collection = Nothing)
            Me.SPName = SPName
            Me.StrConn = strConn
            Me.ParamInput = paramInput
        End Sub

        Public Sub openConnection()
            Try
                _conn = New SqlConnection(StrConn)
                _conn.Open()
            Catch ex As Exception
                ErrorMessage = ex.Message.ToString
            End Try
        End Sub
        Public Sub closeConnection()
            _conn.Close()
        End Sub


        Public Sub sp_exec()

            ErrorNumber = 0
            ErrorMessage = "Esecuzione effettuata correttamente"

            If _conn Is Nothing Then
                openConnection()
            End If

            cmd = New SqlCommand(getSPName(), _conn)
            cmd.CommandType = CommandType.StoredProcedure

            'Aggiungo i parametri di input propri di ogni SP
            gestInputParam()

            'parametro di Output
            gestOutpuParam()

            'eseguo la query
            Try
                RSOut = cmd.ExecuteReader()
            Catch ex As Exception
                ErrorNumber = -1
                ErrorMessage = ex.Message
                Exit Sub
            End Try

            If Not IsDBNull(cmd.Parameters("@Error_Number").Value) Then
                ErrorNumber = Convert.ToInt32(cmd.Parameters("@Error_Number").Value)
            Else
                ErrorNumber = 0
            End If
            If Not IsDBNull(cmd.Parameters("@Error_Severity").Value) Then
                ErrorSeverity = Convert.ToInt32(cmd.Parameters("@Error_Severity").Value)
            Else
                ErrorSeverity = 0
            End If
            If Not IsDBNull(cmd.Parameters("@Error_State").Value) Then
                ErrorState = Convert.ToInt32(cmd.Parameters("@Error_State").Value)
            Else
                ErrorState = 0
            End If
            If Not IsDBNull(cmd.Parameters("@Error_Procedure").Value) Then
                ErrorProcedure = Convert.ToString(cmd.Parameters("@Error_Procedure").Value)
            Else
                ErrorProcedure = 0
            End If
            If Not IsDBNull(cmd.Parameters("@Error_Line").Value) Then
                ErrorLine = Convert.ToInt32(cmd.Parameters("@Error_Line").Value)
            Else
                ErrorLine = 0
            End If
            If Not IsDBNull(cmd.Parameters("@Error_Message").Value) Then
                ErrorMessage = Convert.ToString(cmd.Parameters("@Error_Message").Value)
            Else
                ErrorMessage = ""
            End If
            If Not IsDBNull(cmd.Parameters("@NumRowsAffected").Value) Then
                NumRowsAff = Convert.ToInt32(cmd.Parameters("@NumRowsAffected").Value)
            Else
                NumRowsAff = 0
            End If

        End Sub
        Public Sub sp_exec_NonQuery()

            ErrorNumber = 0
            ErrorMessage = "Esecuzione effettuata correttamente"

            If _conn Is Nothing Then
                openConnection()
            End If

            cmd = New SqlCommand(getSPName(), _conn)
            cmd.CommandType = CommandType.StoredProcedure

            'Aggiungo i parametri di input propri di ogni SP
            gestInputParam()

            'parametro di Output
            gestOutpuParam()

            'eseguo la query
            Try
                cmd.ExecuteNonQuery()
            Catch ex As Exception
                ErrorNumber = -1
                ErrorMessage = ex.Message
                Exit Sub
            End Try

            If Not IsDBNull(cmd.Parameters("@Error_Number").Value) Then
                ErrorNumber = Convert.ToInt32(cmd.Parameters("@Error_Number").Value)
            Else
                ErrorNumber = 0
            End If
            If Not IsDBNull(cmd.Parameters("@Error_Number").Value) Then
                ErrorSeverity = Convert.ToInt32(cmd.Parameters("@Error_Severity").Value)
            Else
                ErrorSeverity = 0
            End If
            If Not IsDBNull(cmd.Parameters("@Error_State").Value) Then
                ErrorState = Convert.ToInt32(cmd.Parameters("@Error_State").Value)
            Else
                ErrorState = 0
            End If
            If Not IsDBNull(cmd.Parameters("@Error_Procedure").Value) Then
                ErrorProcedure = Convert.ToString(cmd.Parameters("@Error_Procedure").Value)
            Else
                ErrorProcedure = 0
            End If
            If Not IsDBNull(cmd.Parameters("@Error_Line").Value) Then
                ErrorLine = Convert.ToInt32(cmd.Parameters("@Error_Line").Value)
            Else
                ErrorLine = 0
            End If
            If Not IsDBNull(cmd.Parameters("@Error_Message").Value) Then
                ErrorMessage = Convert.ToString(cmd.Parameters("@Error_Message").Value)
            Else
                ErrorMessage = ""
            End If
            If Not IsDBNull(cmd.Parameters("@NumRowsAffected").Value) Then
                NumRowsAff = Convert.ToInt32(cmd.Parameters("@NumRowsAffected").Value)
            Else
                NumRowsAff = 0
            End If

        End Sub
        Private Function getSPName() As String
            getSPName = SPName
        End Function
        Private Sub gestInputParam()
            If Not IsNothing(ParamInput) Then
                addInputParam()
            End If
            If Not IsNothing(GruppoParamInput) Then
                addInputParamFromGruppoParamInput()
            End If
        End Sub
        Private Sub gestOutpuParam()
            addOutputParam()
        End Sub

        Private Sub addInputParamFromGruppoParamInput()
            Dim x As Integer
            For x = 0 To GruppoParamInput.Count - 1
                Dim paramInputAppo As SP_Parametro = GruppoParamInput(x)
                Dim sp_Uno_Inp As SqlParameter = New SqlParameter()

                If paramInputAppo.TipoParametro = DbType.Xml Then
                    cmd.Parameters.AddWithValue(paramInputAppo.NomeParametro, paramInputAppo.ValoreParametro)
                Else
                    sp_Uno_Inp.ParameterName = paramInputAppo.NomeParametro
                    sp_Uno_Inp.Direction = paramInputAppo.DirezioneParametro
                    sp_Uno_Inp.Value = paramInputAppo.ValoreParametro
                    If paramInputAppo.TipoParametro = DbType.Boolean Then
                        If paramInputAppo.ValoreParametro = "0" Then
                            sp_Uno_Inp.Value = False
                        Else
                            sp_Uno_Inp.Value = True
                        End If
                    End If

                    If paramInputAppo.TipoParametro = DbType.Int16 Or paramInputAppo.TipoParametro = DbType.Int32 Or paramInputAppo.TipoParametro = DbType.Int64 Then
                        sp_Uno_Inp.Value = CInt(paramInputAppo.ValoreParametro)
                    End If
                    If paramInputAppo.TipoParametro = DbType.Date Then
                        sp_Uno_Inp.Value = CDate(paramInputAppo.ValoreParametro)
                    End If

                    sp_Uno_Inp.DbType = paramInputAppo.TipoParametro
                    sp_Uno_Inp.Size = paramInputAppo.DimensioneParametro
                    sp_Uno_Inp.IsNullable = True
                    cmd.Parameters.Add(sp_Uno_Inp)
                End If

                sp_Uno_Inp = Nothing
            Next
        End Sub
        Private Sub addInputParam()
            Dim x As Integer
            For x = 1 To ParamInput.Count
                Dim sp_Uno_Inp As SqlParameter = New SqlParameter()
                sp_Uno_Inp.ParameterName = ParamInput.Item(x)(1)
                sp_Uno_Inp.Direction = ParameterDirection.Input
                sp_Uno_Inp.Value = ParamInput.Item(x)(2)
                sp_Uno_Inp.DbType = ParamInput.Item(x)(3)
                sp_Uno_Inp.IsNullable = True
                cmd.Parameters.Add(sp_Uno_Inp)
                sp_Uno_Inp = Nothing
            Next
        End Sub
        Private Sub addOutputParam()
            Dim sp_ErrorNumber_Out As SqlParameter = New SqlParameter()
            sp_ErrorNumber_Out.ParameterName = "@Error_Number"
            sp_ErrorNumber_Out.DbType = DbType.Int64
            sp_ErrorNumber_Out.Direction = ParameterDirection.Output
            sp_ErrorNumber_Out.Value = 0
            cmd.Parameters.Add(sp_ErrorNumber_Out)

            Dim sp_ErrorSeverity_Out As SqlParameter = New SqlParameter()
            sp_ErrorSeverity_Out.ParameterName = "@Error_Severity"
            sp_ErrorSeverity_Out.DbType = DbType.Int64
            sp_ErrorSeverity_Out.Direction = ParameterDirection.Output
            sp_ErrorSeverity_Out.Value = 0
            cmd.Parameters.Add(sp_ErrorSeverity_Out)

            Dim sp_ErrorState_Out As SqlParameter = New SqlParameter()
            sp_ErrorState_Out.ParameterName = "@Error_State"
            sp_ErrorState_Out.DbType = DbType.Int64
            sp_ErrorState_Out.Direction = ParameterDirection.Output
            sp_ErrorState_Out.Value = 0
            cmd.Parameters.Add(sp_ErrorState_Out)

            Dim sp_ErrorProcedure_Out As SqlParameter = New SqlParameter()
            sp_ErrorProcedure_Out.ParameterName = "@Error_Procedure"
            sp_ErrorProcedure_Out.DbType = DbType.String
            sp_ErrorProcedure_Out.Size = 4000
            sp_ErrorProcedure_Out.Direction = ParameterDirection.Output
            sp_ErrorProcedure_Out.Value = ""
            cmd.Parameters.Add(sp_ErrorProcedure_Out)

            Dim sp_ErrorLine_Out As SqlParameter = New SqlParameter()
            sp_ErrorLine_Out.ParameterName = "@Error_Line"
            sp_ErrorLine_Out.DbType = DbType.Int64
            sp_ErrorLine_Out.Direction = ParameterDirection.Output
            sp_ErrorLine_Out.Value = 0
            cmd.Parameters.Add(sp_ErrorLine_Out)

            Dim sp_ErrorMessage_Out As SqlParameter = New SqlParameter()
            sp_ErrorMessage_Out.ParameterName = "@Error_Message"
            sp_ErrorMessage_Out.DbType = DbType.String
            sp_ErrorMessage_Out.Size = 4000
            sp_ErrorMessage_Out.Direction = ParameterDirection.Output
            sp_ErrorMessage_Out.Value = ""
            cmd.Parameters.Add(sp_ErrorMessage_Out)

            Dim sp_NumRowsAff_Out As SqlParameter = New SqlParameter()
            sp_NumRowsAff_Out.ParameterName = "@NumRowsAffected"
            sp_NumRowsAff_Out.DbType = DbType.Int32
            sp_NumRowsAff_Out.Direction = ParameterDirection.Output
            sp_NumRowsAff_Out.Value = 0
            cmd.Parameters.Add(sp_NumRowsAff_Out)
        End Sub


    End Class

#End Region
End Namespace