﻿Imports Microsoft.VisualBasic



Public Class codiceUtile



    Public Shared Function CheckCodiceFiscale(ByVal CodiceFiscale As String) As Boolean

        If CodiceFiscale.Trim() = "" Then
            Return True
        End If
        Dim result As Boolean = False
        Const caratteri As Integer = 16

        If CodiceFiscale Is Nothing Then
            Return result
        End If

        If CodiceFiscale.Length < caratteri Then
            Return result    'PartitaIva.CheckPartitaIva(CodiceFiscale)
        End If

        If Not (CodiceFiscale.Length = caratteri) Then
            Return result
        End If

        Const omocodici As String = "LMNPQRSTUV"
        Const listaControllo As String = "ABCDEFGHIJKLMNOPQRSTUVWXYZ"

        Dim listaPari As Integer() = {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25}
        Dim listaDispari As Integer() = {1, 0, 5, 7, 9, 13, 15, 17, 19, 21, 2, 4, 18, 20, 11, 3, 6, 8, 12, 14, 16, 10, 22, 25, 24, 23}

        CodiceFiscale = CodiceFiscale.ToUpper
        Dim cCodice As Char() = CodiceFiscale.ToCharArray

        Dim k As Integer = 0

        For k = 6 To 14
            If (k = 8) OrElse (k = 11) Then
            Else
                Dim x As Integer = (omocodici.IndexOf(cCodice(k)))
                If Not (x = -1) Then
                    cCodice(k) = x.ToString.ToCharArray()(0)
                End If
            End If
        Next

        'Dim rgx As Regex = New Regex("^[A-Z]{6}[]{2}[A-Z][]{2}[A-Z][]{3}[A-Z]$")
        'Dim m As Match = rgx.Match(New String(cCodice))
        'result = m.Success
        result = True
        If result Then
            Dim somma As Integer = 0
            cCodice = CodiceFiscale.ToCharArray
            Dim i As Integer = 0
            For i = 0 To 14
                Dim c As Char = cCodice(i)
                Dim x As Integer = "0123456789".IndexOf(c)
                If Not (x = -1) Then
                    c = listaControllo.Substring(x, 1)  '.ToCharArray(0)
                End If
                x = listaControllo.IndexOf(c)
                If (i Mod 2) = 0 Then
                    x = listaDispari(x)
                Else
                    x = listaPari(x)
                End If
                somma += x
            Next
            result = (listaControllo.Substring(somma Mod 26, 1) = CodiceFiscale.Substring(15, 1))
        End If
        Return result
    End Function

    ' costanti
    Private Const MOD_NUM As Integer = 97
    Private Const STATI As String = "IT,FR,DE"
    Private Const L_IBAN As Integer = 27
    ' membri privati
    Private Shared mIBAN As String = String.Empty

    Public Shared Function ValidateIBAN(ByVal pIBAN As String) As String
        Dim retValue As String = String.Empty
        ' trasformiamo in maiuscolo il codice depurato degli spazi
        Dim codiceIBAN As String = pIBAN.Trim().ToUpper()
        ' se si ottiene una stringa vuota sono dolori! :)
        If codiceIBAN = String.Empty Then
            Return "IBAN vuoto"
        End If
        ' Controllo lungehzza
        If codiceIBAN.Length <> L_IBAN Then
            Return String.Format("Verificare lunghezza IBAN dovrebbbe essere {0}", L_IBAN)
        End If
        ' test codice paese
        If Not CheckPaese(codiceIBAN.Substring(0, 2)) Then
            Return String.Format("Codice Stato diverso da [{0}]", STATI)
        End If
        Try
            ' trasformazione in stringa numerica
            Dim codiceNumerico As String = CalcolaCodiceNumerico(codiceIBAN)
            Dim i As Integer
            ' applichiamo il modulo 97 su 6 caratteri alla volta
            While codiceNumerico.Length > 6
                i = Integer.Parse(codiceNumerico.Substring(0, 6)) Mod MOD_NUM
                codiceNumerico = i.ToString() + codiceNumerico.Substring(6)
            End While
            ' la stringa restante con lunghezza <= 6 può essere
            ' convertita agevolmente
            i = Integer.Parse(codiceNumerico) Mod MOD_NUM
            ' se il valore modulo 97 non è uno il check digit
            ' dell'IBAN è errato
            If i <> 1 Then
                retValue = "Codice Errato"
            Else
                retValue = ""
            End If
        Catch ex As Exception
            retValue = ex.Message
        End Try
        Return retValue
    End Function

    Private Shared Function CheckPaese(ByVal codicePaese As String) As Boolean
        Return (STATI.IndexOf(codicePaese) <> -1)
    End Function

    Private Shared Function CalcolaCodiceNumerico(ByVal codiceIBAN As String) As String
        Dim sb As New StringBuilder()
        Const lettere As String = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ"
        ' per ogni carattere contenuto nella stringa riformattata per il calcolo
        ' troviamo la posizione relativa nella stringa lettere e
        ' aggiungiamo il valore ottenuto sull'oggetto stringbuilder
        For Each c As Char In codiceIBAN.Substring(4) + codiceIBAN.Substring(0, 4)
            Dim x As Integer = lettere.IndexOf(c)
            If x = -1 Then
                Throw (New Exception("Caratteri non validi nella stringa"))
            End If
            sb.Append(x)
        Next
        Return sb.ToString()
    End Function
End Class
