﻿Imports System.Data
Imports System.IO
Imports System.Net.Mail

Partial Class AR_DatiAzienda
    Inherits System.Web.UI.Page

    '*****************************************************************************************
    'INIZIO CODICE PER FINESTRA MODALE
    '*****************************************************************************************

    Public ClassTitoloModal As String = "modal-header alert alert-success"
    Public Sub showModal(ByVal Classe As String, ByVal corpo As String)
        Select Case Classe
            Case "SALVA"
                ClassTitoloModal = "modal-header alert alert-success"
                lblTitoloModale.Text = "SALVA"
            Case "ATTENZIONE"
                ClassTitoloModal = "modal-header alert alert-danger"
                lblTitoloModale.Text = "ATTENZIONE"
            Case "INFORMAZIONE"
                ClassTitoloModal = "modal-header alert alert-info"
                lblTitoloModale.Text = "INFORMAZIONE"
            Case "ERRORE"
                ClassTitoloModal = "modal-header alert alert-warning"
                lblTitoloModale.Text = "ERRORE"
        End Select

        lblCorpoModale.Text = corpo
        ScriptManager.RegisterStartupScript(Me.Page, Page.GetType, "HideLoginDialog", "<script type=""text/javascript"">$(document).ready(function () { $('#myMessage').modal('show');});</script>", False)

    End Sub

    Protected Sub btnCloseModal_Click(sender As Object, e As EventArgs)
        ScriptManager.RegisterStartupScript(Page, Page.[GetType](), "myModalHide", "$('#myMessage').hide();", True)
        ScriptManager.RegisterStartupScript(Page, Page.[GetType](), "myModalAgainShow", "$('#myMessage').modal();", True)
    End Sub
    '*****************************************************************************************
    'FINE CODICE PER FINESTRA MODALE
    '*****************************************************************************************
    Private Sub TitoloSezione(ByRef Titolo As String)
        Dim varTitoloezione As Label = DirectCast(Master.FindControl("lblTitoloSezione"), Label)
        varTitoloezione.Text = Titolo
    End Sub
    Protected Sub Page_Load(sender As Object, e As EventArgs) Handles Me.Load
        ConfigurationManager.AppSettings("ColoraIconaControllo") = "'icoDatiAzienda'"
        If Not IsPostBack Then
            Session("IDTabella") = 1
            Session("uploadTabella") = "tabDatiAzienda"
            TitoloSezione("INTESTAZIONE SOCIETA'")
            VERIDICADATI()
            VERIDICAEMAIL()
            SezPagamenti.Attributes.Add("class", "card card-featured card-featured-primary card-collapcardsed card-collapsed")
            ' ltrDiv.Text = " <div id=""divChiusura"" runat=""server""  class=""card-actions""><a href=""#"" class=""card-action card-action-toggle"" data-card-toggle></a></div>"
        Else
            ' SezPagamenti.Attributes.Add("class", "card card-featured card-featured-primary card-collapcardsed")
        End If
    End Sub

    Private Sub VERIDICADATI()
        Using ConnLog As New SqlClient.SqlConnection(ConfigurationManager.ConnectionStrings("db_ncbConnectionString").ConnectionString)
            ConnLog.Open()

            Dim CommandLog As SqlClient.SqlCommand = ConnLog.CreateCommand()
            Dim transactionLog As SqlClient.SqlTransaction
            transactionLog = ConnLog.BeginTransaction("Transactionlog")
            CommandLog.Connection = ConnLog
            CommandLog.Transaction = transactionLog

            Try
                CommandLog.Parameters.Clear()
                CommandLog.CommandText = "SELECT COUNT(IdDatiAzienda) FROM DatiAziendali"
                Dim objExecute As Object = CommandLog.ExecuteScalar

                If objExecute = 0 Then
                    CommandLog.Parameters.Clear()
                    CommandLog.CommandText = "INSERT INTO DATIAZIENDALI (RAGIONESOCIALE, INDIRIZZO, CODICEFISCALE, PARTITAIVA, TELEFONO, FAX, CELLULARE, EMAIL, SITOWEB, LOGO) VALUES " & _
                                             "('', '', '', '', '', '','', '', '', '~/allegati/LogoAzienda/logodefault.jpg')"
                    CommandLog.ExecuteNonQuery()
                End If

                CARICA_DETTAGLIO()

                transactionLog.Commit()
                ConnLog.Close()

            Catch ex As Exception
                showModal("ERORE", String.Format("Ripristino Dati, " & vbCrLf & "{0}", ex))
                Try
                    transactionLog.Rollback()
                Catch ex2 As Exception
                    showModal("ERORE", String.Format("Ripristino Dati, " & vbCrLf & "{0}", ex2))
                End Try
            End Try
        End Using
    End Sub

    Private Sub VERIDICAEMAIL()
        Using ConnLog As New SqlClient.SqlConnection(ConfigurationManager.ConnectionStrings("db_ncbConnectionString").ConnectionString)
            ConnLog.Open()

            Dim CommandLog As SqlClient.SqlCommand = ConnLog.CreateCommand()
            Dim transactionLog As SqlClient.SqlTransaction
            transactionLog = ConnLog.BeginTransaction("Transactionlog")
            CommandLog.Connection = ConnLog
            CommandLog.Transaction = transactionLog

            '  Try
            CommandLog.Parameters.Clear()
            CommandLog.CommandText = "SELECT COUNT(idEmail) FROM DatiEmail"
            Dim objExecute As Object = CommandLog.ExecuteScalar

            If objExecute = 0 Then
                CommandLog.Parameters.Clear()
                CommandLog.CommandText = "INSERT INTO DatiEmail (IndirizzoEmail, NomeMittente, Sicurezza, ServerSMTP, Porta, Username, Password) VALUES " & _
                                         "('', '', '', '', '', '', '')"
                CommandLog.ExecuteNonQuery()
            End If

            CARICA_DETTAGLIO_EMAIL()

            transactionLog.Commit()
            ConnLog.Close()

            'Catch ex As Exception
            '    showModal("ERORE", String.Format("Ripristino Dati, " & vbCrLf & "{0}", ex))
            '    Try
            '        transactionLog.Rollback()
            '    Catch ex2 As Exception
            '        showModal("ERORE", String.Format("Ripristino Dati, " & vbCrLf & "{0}", ex2))
            '    End Try
            'End Try
        End Using
    End Sub
    Private Sub CARICA_DETTAGLIO()
        Dim strSQL As String = "SELECT * FROM DATIAZIENDALI WHERE IDDATIAZIENDA=2"
        Dim CompensiAdapter As New SqlClient.SqlDataAdapter
        Dim nwindConn As New SqlClient.SqlConnection(ConfigurationManager.ConnectionStrings("db_ncbConnectionString").ConnectionString)
        Dim selectCMD As New SqlClient.SqlCommand(strSQL, nwindConn)
        CompensiAdapter.SelectCommand = selectCMD

        Dim dsCompensi As New DataSet
        CompensiAdapter.Fill(dsCompensi, "DATIAZIENDALI")
        Dim compensiRow As DataRow

        If dsCompensi.Tables("DATIAZIENDALI").Rows.Count > 0 Then
            Dim conta As Integer = 0
            For Each compensiRow In dsCompensi.Tables("DATIAZIENDALI").Rows
                txtRagioneSociale.Text = compensiRow("RagioneSociale").ToString
                txtIndirizzo.Text = compensiRow("indirizzo").ToString
                txtCodiceFiscale.Text = compensiRow("Codicefiscale").ToString
                txtPartitaIva.Text = compensiRow("PartitaIva").ToString
                txtTelefono.Text = compensiRow("Telefono").ToString
                txtFax.Text = compensiRow("Fax").ToString
                txtCellulare.Text = compensiRow("Cellulare").ToString
                txtEmail.Text = compensiRow("Email").ToString
                txtSitoWeb.Text = compensiRow("SitoWeb").ToString
                imgProfilo.ImageUrl = compensiRow("Logo").ToString
            Next
        End If
    End Sub

    Private Sub CARICA_DETTAGLIO_EMAIL()
        Dim strSQL As String = "SELECT * FROM DatiEmail WHERE idEmail=2"
        Dim CompensiAdapter As New SqlClient.SqlDataAdapter
        Dim nwindConn As New SqlClient.SqlConnection(ConfigurationManager.ConnectionStrings("db_ncbConnectionString").ConnectionString)
        Dim selectCMD As New SqlClient.SqlCommand(strSQL, nwindConn)
        CompensiAdapter.SelectCommand = selectCMD

        Dim dsCompensi As New DataSet
        CompensiAdapter.Fill(dsCompensi, "DatiEmail")
        Dim compensiRow As DataRow

        If dsCompensi.Tables("DatiEmail").Rows.Count > 0 Then
            Dim conta As Integer = 0
            For Each compensiRow In dsCompensi.Tables("DatiEmail").Rows
                txtIndirizzoEmail.Text = compensiRow("IndirizzoEmail").ToString
                txtMittente.Text = compensiRow("NomeMittente").ToString

                Try
                    drpSicurezza.SelectedValue = compensiRow("Sicurezza").ToString
                Catch ex As Exception
                End Try

                txtSmtp.Text = compensiRow("ServerSMTP").ToString
                txtPorta.Text = compensiRow("Porta").ToString
                txtUsername.Text = compensiRow("Username").ToString
                txtPassword.Text = compensiRow("Password").ToString

            Next
        End If
    End Sub

    Protected Sub btnSalva_Click(sender As Object, e As EventArgs) Handles btnSalva.Click
        Using ConnLog As New SqlClient.SqlConnection(ConfigurationManager.ConnectionStrings("db_ncbConnectionString").ConnectionString)
            ConnLog.Open()

            Dim CommandLog As SqlClient.SqlCommand = ConnLog.CreateCommand()
            Dim transactionLog As SqlClient.SqlTransaction
            transactionLog = ConnLog.BeginTransaction("Transactionlog")
            CommandLog.Connection = ConnLog
            CommandLog.Transaction = transactionLog

            Try

                CommandLog.Parameters.Clear()
                CommandLog.CommandText = "UPDATE DATIAZIENDALI SET RAGIONESOCIALE=@RAGIONESOCIALE, INDIRIZZO=@INDIRIZZO, CODICEFISCALE=@CODICEFISCALE, " & _
                                         "PARTITAIVA=@PARTITAIVA, TELEFONO=@TELEFONO, FAX=@FAX, CELLULARE=@CELLULARE, EMAIL=@EMAIL, SITOWEB=@SITOWEB " & _
                                         "WHERE IDDATIAZIENDA=1"

                CommandLog.Parameters.AddWithValue("@RAGIONESOCIALE", txtRagioneSociale.Text)
                CommandLog.Parameters.AddWithValue("@INDIRIZZO", txtIndirizzo.Text)
                CommandLog.Parameters.AddWithValue("@CODICEFISCALE", txtCodiceFiscale.Text)
                CommandLog.Parameters.AddWithValue("@PARTITAIVA", txtPartitaIva.Text)
                CommandLog.Parameters.AddWithValue("@TELEFONO", txtTelefono.Text)
                CommandLog.Parameters.AddWithValue("@FAX", txtFax.Text)
                CommandLog.Parameters.AddWithValue("@CELLULARE", txtCellulare.Text)
                CommandLog.Parameters.AddWithValue("@EMAIL", txtEmail.Text)
                CommandLog.Parameters.AddWithValue("@SITOWEB", txtSitoWeb.Text)

                CommandLog.ExecuteNonQuery()


                transactionLog.Commit()
                ConnLog.Close()


                showModal("SALVA", "DATI SALVATI CORRETTAMENTE")

            Catch ex As Exception
                showModal("ERORE", String.Format("Ripristino Dati, " & vbCrLf & "{0}", ex))
                Try
                    transactionLog.Rollback()
                Catch ex2 As Exception
                    showModal("ERORE", String.Format("Ripristino Dati, " & vbCrLf & "{0}", ex2))
                End Try
            End Try
        End Using
    End Sub

    Protected Sub btnSalvaEmail_Click(sender As Object, e As EventArgs) Handles btnSalvaEmail.Click
        Using ConnLog As New SqlClient.SqlConnection(ConfigurationManager.ConnectionStrings("db_ncbConnectionString").ConnectionString)
            ConnLog.Open()

            Dim CommandLog As SqlClient.SqlCommand = ConnLog.CreateCommand()
            Dim transactionLog As SqlClient.SqlTransaction
            transactionLog = ConnLog.BeginTransaction("Transactionlog")
            CommandLog.Connection = ConnLog
            CommandLog.Transaction = transactionLog

            Try

                CommandLog.Parameters.Clear()
                CommandLog.CommandText = "UPDATE DatiEmail SET IndirizzoEmail=@IndirizzoEmail, NomeMittente=@NomeMittente, Sicurezza=@Sicurezza, " & _
                                         "ServerSMTP=@ServerSMTP, Porta=@Porta, Username=@Username, Password=@Password " & _
                                         "WHERE idEmail=2"

                CommandLog.Parameters.AddWithValue("@IndirizzoEmail", txtIndirizzoEmail.Text.Trim)
                CommandLog.Parameters.AddWithValue("@NomeMittente", txtMittente.Text.Trim)
                CommandLog.Parameters.AddWithValue("@Sicurezza", drpSicurezza.SelectedValue)
                CommandLog.Parameters.AddWithValue("@ServerSMTP", txtSmtp.Text.Trim)
                CommandLog.Parameters.AddWithValue("@Porta", txtPorta.Text.Trim)
                CommandLog.Parameters.AddWithValue("@Username", txtUsername.Text.Trim)
                CommandLog.Parameters.AddWithValue("@Password", txtPassword.Text.Trim)

                CommandLog.ExecuteNonQuery()

                transactionLog.Commit()
                ConnLog.Close()

                CARICA_DETTAGLIO_EMAIL()

                showModal("SALVA", "DATI SALVATI CORRETTAMENTE")

            Catch ex As Exception
                showModal("ERORE", String.Format("Ripristino Dati, " & vbCrLf & "{0}", ex))
                Try
                    transactionLog.Rollback()
                Catch ex2 As Exception
                    showModal("ERORE", String.Format("Ripristino Dati, " & vbCrLf & "{0}", ex2))
                End Try
            End Try
        End Using
    End Sub

    Protected Sub btnEliminaEmail_ServerClick(sender As Object, e As EventArgs)
        Using ConnLog As New SqlClient.SqlConnection(ConfigurationManager.ConnectionStrings("db_ncbConnectionString").ConnectionString)
            ConnLog.Open()

            Dim CommandLog As SqlClient.SqlCommand = ConnLog.CreateCommand()
            Dim transactionLog As SqlClient.SqlTransaction
            transactionLog = ConnLog.BeginTransaction("Transactionlog")
            CommandLog.Connection = ConnLog
            CommandLog.Transaction = transactionLog

            Try

                CommandLog.Parameters.Clear()
                CommandLog.CommandText = "UPDATE DatiEmail SET IndirizzoEmail=@IndirizzoEmail, NomeMittente=@NomeMittente, Sicurezza=@Sicurezza, " & _
                                         "ServerSMTP=@ServerSMTP, Porta=@Porta, Username=@Username, Password=@Password " & _
                                         "WHERE idEmail=2"

                CommandLog.Parameters.AddWithValue("@IndirizzoEmail", "")
                CommandLog.Parameters.AddWithValue("@NomeMittente", "")
                CommandLog.Parameters.AddWithValue("@Sicurezza", "")
                CommandLog.Parameters.AddWithValue("@ServerSMTP", "")
                CommandLog.Parameters.AddWithValue("@Porta", "")
                CommandLog.Parameters.AddWithValue("@Username", "")
                CommandLog.Parameters.AddWithValue("@Password", "")

                CommandLog.ExecuteNonQuery()

                transactionLog.Commit()
                ConnLog.Close()

                CARICA_DETTAGLIO_EMAIL()

                showModal("SALVA", "DATI EMAIL CANCELLATI CORRETTAMENTE")

            Catch ex As Exception
                showModal("ERORE", String.Format("Ripristino Dati, " & vbCrLf & "{0}", ex))
                Try
                    transactionLog.Rollback()
                Catch ex2 As Exception
                    showModal("ERORE", String.Format("Ripristino Dati, " & vbCrLf & "{0}", ex2))
                End Try
            End Try
        End Using
    End Sub
    Protected Sub btnUploadFoto_Click(sender As Object, e As EventArgs) Handles btnUploadFoto.Click
        Dim Errore As Label
        CaricaFoto(txtFotoUrl, imgProfilo, Errore, fuFoto)
    End Sub

    Public Function ComponiNomeImgData(ByVal varNomeImg As String) As String
        ComponiNomeImgData = Now.Date.Year.ToString & _
                             Now.Date.Month.ToString & _
                             Now.Date.Day.ToString & _
                             Now.TimeOfDay.Hours.ToString & _
                             Now.TimeOfDay.Minutes.ToString & _
                             Now.TimeOfDay.Seconds.ToString & _
                             varNomeImg
        Return ComponiNomeImgData
    End Function

    Private Sub CaricaFoto(ByVal NomeTxtUrl As TextBox, ByVal NomeImg As System.Web.UI.WebControls.Image, ByVal NomeErrore As Label, ByVal NomeUpload As FileUpload)
        Dim savePath As String = Server.MapPath("~/ar/allegati/LogoAzienda/")
        '  Try
        If (NomeUpload.HasFile) Then
            Dim fileName As String = NomeUpload.FileName
            Dim extension As String = System.IO.Path.GetExtension(fileName)

            If (extension = ".jpg") Or (extension = ".gif") Or (extension = ".JPG") Or (extension = ".GIF") Or (extension = ".PNG") Or (extension = ".png") Then
                'savePath += fileName
                NomeUpload.SaveAs(savePath & ComponiNomeImgData(fileName))
                NomeImg.ImageUrl = "~/ar/allegati/LogoAzienda/" & ComponiNomeImgData(NomeUpload.FileName)

                NomeTxtUrl.Text = ComponiNomeImgData(NomeUpload.FileName)

                If SalvaFoto() = True Then
                    showModal("SALVA", "FILE CARICATO CON SUCCESSO")
                Else
                    showModal("ERRORE", "IL FILE NON E' STATO CARICATO")
                End If


            Else
                showModal("ERRORE", "Il file NON è stato caricato " + _
                                         "il file NON è un JPG o GIF")
            End If
        Else
            showModal("ATTENZIONE", "NESSUN FILE SELEZIONATO")
        End If
        'Catch ex As Exception
        '    NomeErrore.Text = ex.Message
        'End Try
    End Sub

    Private Function SalvaFoto() As Boolean

        Using connection As New SqlClient.SqlConnection(ConfigurationManager.ConnectionStrings("db_ncbConnectionString").ConnectionString)
            connection.Open()
            Dim command As SqlClient.SqlCommand = connection.CreateCommand()
            Dim transaction As SqlClient.SqlTransaction
            transaction = connection.BeginTransaction("SampleTransaction")
            command.Connection = connection
            command.Transaction = transaction

            Try
                command.Parameters.Clear()
                command.CommandText = " UPDATE DatiAziendali SET Logo=@Logo WHERE idDatiAzienda=@idDatiAzienda"

                command.Parameters.AddWithValue("@Logo", "~/ar/allegati/LogoAzienda/" & txtFotoUrl.Text)
                command.Parameters.AddWithValue("@idDatiAzienda", 1)

                command.ExecuteNonQuery()
                transaction.Commit()
                connection.Close()

                Return True

            Catch ex As Exception
                showModal("ERRORE", "SE IL PROBLEMA PERSISTE CONTATTARE L'AMMINISTRATORE DEL PROGRAMMA")
                Try

                    transaction.Rollback()
                    Return False
                Catch ex2 As Exception
                    showModal("ERRORE", "RIPRISTINO DATI")
                End Try
            End Try

        End Using
    End Function

    Protected Sub btnVerifica_ServerClick(sender As Object, e As EventArgs)
        Dim mail As System.Net.Mail.MailMessage = New System.Net.Mail.MailMessage()
        mail.To.Add("@gmail.com")
        mail.From = New MailAddress("@gmail.com", txtMittente.Text.Trim) ', System.Text.Encoding.UTF8)
        mail.Subject = "Email di Verifica - CapitalBus"
        mail.SubjectEncoding = System.Text.Encoding.UTF8
        mail.Body = "Questa emailè è stata inviata per verificare lesatte impostazioni dell'account"
        mail.BodyEncoding = System.Text.Encoding.UTF8
        mail.IsBodyHtml = True
        'mail.Priority = MailPriority.Normal
        Dim client As SmtpClient = New SmtpClient("smtp.gmail.com", 587)
        client.EnableSsl = True

        client.UseDefaultCredentials = False
        client.Credentials = New System.Net.NetworkCredential("", "")
        client.DeliveryMethod = SmtpDeliveryMethod.Network
        Try
            client.Send(mail)
            showModal("INFORMAZIONE", "L'EMAIL DI VERIFICA E' STATA INVIATA CON SUCCESSO")
        Catch ex As Exception
            showModal("ERRORE", ex.Message)
        End Try
    End Sub
End Class
