﻿Imports System.Data.SqlClient

Partial Class AR_Footer2
    Inherits System.Web.UI.Page

    Protected Sub Page_Load(sender As Object, e As EventArgs) Handles Me.Load
        DatiAzienda()
        DatiFattura()
        DatiImponibili()
    End Sub

    Private Sub DatiAzienda()
        Dim conn As SqlConnection = New SqlConnection
        conn.ConnectionString = ConfigurationManager.ConnectionStrings("db_ncbConnectionString").ConnectionString
        Dim cmd As SqlCommand = New SqlCommand
        cmd.CommandText = "SELECT * from " & _
        " DatiAziendali where idDatiAzienda = 1"
        cmd.Connection = conn
        conn.Open()
        Dim sdr As SqlDataReader = cmd.ExecuteReader
        While sdr.Read
            lblIntestazione.Text = sdr("RagioneSociale")
            lblIndirizzo.Text = sdr("Indirizzo")

            lblTelefono.Text = "Tel: " & sdr("Telefono") & " - " & sdr("Cellulare")
            lblFax.Text = "Fax: " & sdr("Fax")

            lblEmail.Text = "Email: " & sdr("Email")
            lblSito.Text = "Web: " & sdr("sitoweb")

            lblPIva.Text = "P.Iva: " & sdr("PartitaIva")
            lblCF.Text = "C.f.: " & sdr("CodiceFiscale")

        End While
        conn.Close()
    End Sub

    Private Sub DatiFattura()
        Dim conn As SqlConnection = New SqlConnection
        conn.ConnectionString = ConfigurationManager.ConnectionStrings("db_ncbConnectionString").ConnectionString
        Dim cmd As SqlCommand = New SqlCommand
        cmd.CommandText = "SELECT idFattura, Data, Numero, RagioneSociale, Indirizzo, PartitaIva, CodiceFiscale, Imponibile, ImportoIva, ImportoRitenuta, ImportoFattura from " & _
        " FatturaAttiva where idFattura = @ID"
        cmd.Parameters.AddWithValue("@ID", CInt(Request.QueryString("idf")))
        cmd.Connection = conn
        conn.Open()
        Dim sdr As SqlDataReader = cmd.ExecuteReader
        While sdr.Read
            lblImpIva.Text = String.Format(" € {0:N2}", sdr("ImportoIva"))
            lblTotaleImporto.Text = String.Format(" € {0:N2}", sdr("ImportoFattura"))
        End While

        sdr.Close()
        sdr = Nothing

        cmd.Cancel()
        cmd.CommandText = "SELECT ModalitaPagamnto, Descrizione from PagamentiModalita where VisualizzaInFattura = 1"

        ltrModalitaDiPagamento.Text = ""
        Dim IntestazionePagamento As String = "<div style=""font-weight:bold; font-size:16px;"">Modalità di pagamento:</div>"
        Dim CorpoPagamento As String = ""
        Dim sdrP As SqlDataReader = cmd.ExecuteReader
        Dim Presente As Boolean = False
        While sdrP.Read
            Presente = True
            CorpoPagamento &= "<div><b>" & sdrP("ModalitaPagamnto") & ": </b><br/>" & sdrP("Descrizione") & "</div>"
        End While

        If Presente = True Then
            ltrModalitaDiPagamento.Text = IntestazionePagamento & CorpoPagamento
        End If

        conn.Close()
    End Sub

    Private Sub DatiImponibili()
        Dim conn As SqlConnection = New SqlConnection
        conn.ConnectionString = ConfigurationManager.ConnectionStrings("db_ncbConnectionString").ConnectionString
        Dim cmd As SqlCommand = New SqlCommand
        cmd.CommandText = "SELECT Descrizione, Imponibile, Quantita, Iva from FatturaAttivaDettaglio where CodFattura=@ID"
        cmd.Parameters.AddWithValue("@ID", CInt(Request.QueryString("idf")))
        cmd.Connection = conn
        conn.Open()
        Dim sdr As SqlDataReader = cmd.ExecuteReader

        Dim varImportoEsente As Double = 0
        Dim varImportoPREN As Double = 0
        Dim varImportoACC As Double = 0

        While sdr.Read
            If sdr("Descrizione").ToString.ToUpper <> "ACC" Then
                If CDbl(sdr("Iva")) <> 0 Then
                    varImportoPREN += CDbl(sdr("Imponibile")) * CDbl(sdr("Quantita"))
                Else
                    varImportoEsente += CDbl(sdr("Imponibile")) * CDbl(sdr("Quantita"))
                End If
            Else
                varImportoACC += CDbl(sdr("Imponibile")) * CDbl(sdr("Quantita"))
            End If
        End While
        conn.Close()

        lblImportoEsente.Text = String.Format(" € {0:N2}", varImportoEsente)
        lblImponibileAccessori.Text = String.Format(" € {0:N2}", varImportoACC)
        lblImponibilePrenotazione.Text = String.Format(" € {0:N2}", varImportoPREN)

    End Sub


End Class
